/'****************************************************************************
The MIT License

Copyright (c) 2011, Ruchard D. Clark

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

http://www.opensource.org/licenses/mit-license.php
*****************************************************************************'/
#Ifndef _DATAOBJBI_
#Define _DATAOBJBI_ 

Const NULL = 0
Const FALSE = 0
Const TRUE = (Not FALSE)

'Enumeration of allowable types in each cell.
Enum cdatatype
    tNull
    tByte
    tUByte
    tShort
    tUShort
    tInteger
    tUInteger
    tLong
    tUlong
    tLongint
    tUlongint
    tSingle
    tDouble
    tString
End Enum

'dataobj for hash table.
Type dataobj
   Private:
   dtype As cdatatype   'Current type of data, default is null.
   Union
     datbyte As Byte      'Union holds current data.
     datubyte As UByte    
     datshort As Short
     datushort As UShort
     datinteger As Integer
     datuinteger As UInteger
     datlong As Long
     datulong As ULong
     datlongint As LongInt
     datulongint As ULongInt
     datsingle As Single
     datdouble As Double
     datstring As ZString Ptr
   End Union
   Declare Sub Destroy () 
   Public:
   Declare Constructor ()
   Declare Destructor ()
   Declare Property DataType () As cdatatype  'Returns the data type.
   Declare Sub ClearData ()
   Declare Sub SetData (rhs As dataobj)        'Sets data of object.
   Declare Sub GetData (rhs As dataobj)        'Gets data of object.
   Declare Operator Let (rhs As dataobj)       'Sets data using dataobj object.
   Declare Operator Let (rhs As Byte)         'Sets object data using variable.
   Declare Operator Let (rhs As UByte) 
   Declare Operator Let (rhs As Short) 
   Declare Operator Let (rhs As UShort) 
   Declare Operator Let (rhs As Integer) 
   Declare Operator Let (rhs As UInteger) 
   Declare Operator Let (rhs As Long) 
   Declare Operator Let (rhs As ULong) 
   Declare Operator Let (rhs As LongInt)
   Declare Operator Let (rhs As ULongInt)
   Declare Operator Let (rhs As Single)
   Declare Operator Let (rhs As Double)
   Declare Operator Let (rhs As String)
   Declare Operator Cast () As Byte  'Cast to data type.
   Declare Operator Cast () As UByte
   Declare Operator Cast () As Short
   Declare Operator Cast () As UShort
   Declare Operator Cast () As Integer
   Declare Operator Cast () As UInteger
   Declare Operator Cast () As Long
   Declare Operator Cast () As ULong
   Declare Operator Cast () As LongInt
   Declare Operator Cast () As ULongInt
   Declare Operator Cast () As Single
   Declare Operator Cast () As Double
   Declare Operator Cast () As String
End Type

'Clears any data in cell and sets to Null.
Sub dataobj.Destroy()

   'Based on what the type is, clear the data.
   Select Case dtype
   Case tByte
      datbyte = 0
   Case tUByte
      datubyte = 0
   Case tShort
      datshort = 0
   Case tUShort
      datushort = 0
   Case tInteger
      datinteger = 0
   Case tUInteger
      datuinteger = 0
   Case tLong
      datlong = 0
   Case tUlong
      datulong = 0
   Case tLongint
      datlongint = 0
   Case tUlongint
      datlongint = 0
   Case tSingle
      datsingle = 0
   Case tDouble
      datdouble = 0
   Case tString
      'Deallocate string if present and set ptr to null.
      If datstring <> NULL Then
         DeAllocate datstring
         datstring = NULL
      EndIf
   End Select
   'Set data type to tNull.
   dtype = tNull
End Sub

'Cell constructor sets cell to Null.
Constructor dataobj ()
    dtype = tNull
End Constructor

'Calls Destroy to clear contents.
Destructor dataobj ()
    Destroy
End Destructor

'Calls Destroy to clear contents.
Sub dataobj.ClearData ()
    Destroy
End Sub

'Deep copy of object.
Sub dataobj.SetData (rhs As dataobj)
   Destroy
   dtype = rhs.DataType
   Select Case dtype
      Case tByte
         datbyte = rhs
      Case tUByte
         datubyte = rhs
      Case tShort
         datshort = rhs
      Case tUShort
         datushort = rhs
      Case tInteger
         datinteger = rhs
      Case tUInteger
         datuinteger = rhs
      Case tLong
         datlong = rhs
      Case tUlong
         datulong = rhs
      Case tLongint
         datlongint = rhs
      Case tUlongint
         datulongint = rhs
      Case tSingle
         datsingle = rhs
      Case tDouble
         datdouble = rhs
      Case tString
         Dim As String s = rhs
         Dim As Integer l = Len(s)
         If l > 0 Then
             datstring = Allocate(l + 1)
             *datstring = s
         Else
             datstring = NULL
         EndIf
   End Select
End Sub

'Copies data to rhs.
Sub dataobj.GetData(rhs As dataobj)

   rhs.ClearData
   Select Case dtype
      Case tByte
         rhs = datbyte
      Case tUByte
         rhs = datubyte 
      Case tShort
         rhs = datshort 
      Case tUShort
         rhs = datushort 
      Case tInteger
         rhs = datinteger 
      Case tUInteger
         rhs = datuinteger 
      Case tLong
         rhs = datlong 
      Case tUlong
         rhs = datulong 
      Case tLongint
         rhs = datlongint 
      Case tUlongint
         rhs = datulongint 
      Case tSingle
         rhs = datsingle 
      Case tDouble
         rhs = datdouble 
      Case tString
         If datstring <> NULL Then
            rhs = *datstring
         Else
            rhs = ""
         EndIf
   End Select
   
End Sub

'Returns the cell data type.
Property dataobj.DataType () As cdatatype
    Return dtype
End Property


'Comparison: =
Operator = (lhs As dataobj, rhs As dataobj) As Integer
   Dim clbyte As Byte     
   Dim clubyte As UByte   
   Dim clshort As Short
   Dim clushort As UShort
   Dim clinteger As Integer
   Dim cluinteger As UInteger
   Dim cllong As Long
   Dim clulong As ULong
   Dim cllongint As LongInt
   Dim clulongint As ULongInt
   Dim clsingle As Single
   Dim cldouble As Double
   Dim clstring As String
   
   Dim clbyte1 As Byte     
   Dim clubyte1 As UByte   
   Dim clshort1 As Short
   Dim clushort1 As UShort
   Dim clinteger1 As Integer
   Dim cluinteger1 As UInteger
   Dim cllong1 As Long
   Dim clulong1 As ULong
   Dim cllongint1 As LongInt
   Dim clulongint1 As ULongInt
   Dim clsingle1 As Single
   Dim cldouble1 As Double
   Dim clstring1 As String
   
   Dim As Integer ret = FALSE
   
   'If the same types, then check for same value.
   If rhs.DataType = lhs.DataType Then
      'Get the passed value.
      Select Case rhs.DataType
         Case tNull
            If (rhs.DataType = tNull) And (lhs.DataType = tNull) Then
               ret = TRUE
            End If
         Case tByte
            clbyte = rhs
            clbyte1 = lhs
            If clbyte = clbyte1 Then
               ret = TRUE
            EndIf
        Case tUByte
            clubyte = rhs
            clubyte1 = lhs
            If clubyte = clubyte1 Then
               ret = TRUE
            EndIf
         Case tShort
            clshort = rhs
            clshort1 = lhs
            If clshort = clshort1 Then
               ret = TRUE
            EndIf
         Case tUShort
            clushort = rhs
            clushort1 = lhs
            If clushort = clushort1 Then
               ret = TRUE
            EndIf
         Case tInteger
            clinteger = rhs
            clinteger1 = lhs
            If clinteger = clinteger1 Then
               ret = TRUE
            EndIf
         Case tUInteger
            cluinteger = rhs
            cluinteger1 = lhs
            If cluinteger = cluinteger1 Then
               ret = TRUE
            EndIf
         Case tLong
            cllong = rhs
            cllong1 = lhs
            If cllong = cllong1 Then
               ret = TRUE
            EndIf
         Case tUlong
            clulong = rhs
            clulong1 = lhs
            If clulong = clulong1 Then
               ret = TRUE
            EndIf
         Case tLongint
            cllongint = rhs
            cllongint1 = lhs
            If cllongint = cllongint1 Then
               ret = TRUE
            EndIf
         Case tUlongint
            clulongint = rhs
            clulongint1 = lhs
            If clulongint = clulongint1 Then
               ret = TRUE
            EndIf
         Case tSingle
            clsingle = rhs
            clsingle1 = lhs
            If clsingle = clsingle1 Then
               ret = TRUE
            EndIf
         Case tDouble
            cldouble = rhs
            cldouble1 = lhs
            If cldouble = cldouble1 Then
               ret = TRUE
            EndIf
         Case tString
            clstring = rhs
            clstring1 = lhs
            If clstring = clstring1 Then
               ret = TRUE
            EndIf
      End Select
   EndIf
   
   Return ret
End Operator

Operator dataobj.Let (rhs As dataobj)
    
   Destroy
   dtype = rhs.DataType
   Select Case dtype
     Case tByte
         datbyte = rhs
     Case tUByte
         datubyte = rhs
     Case tShort
         datshort = rhs
     Case tUShort
         datushort = rhs
     Case tInteger
         datinteger = rhs
     Case tUInteger
         datuinteger = rhs
     Case tLong
         datlong = rhs
     Case tUlong
         datulong = rhs
     Case tLongint
         datlongint = rhs
     Case tUlongint
         datulongint = rhs
     Case tSingle
         datsingle = rhs
     Case tDouble
         datdouble = rhs
     Case tString
         Dim As String s = rhs
         Dim As Integer l = Len(s)
         If l > 0 Then
             datstring = Allocate(l + 1)
             *datstring = s
         Else
             datstring = NULL
         EndIf
         
   End Select
    
End Operator

'Sets object data using variable.
Operator dataobj.Let (rhs As Byte) 
    
    'Clear any existing data.
    Destroy
    dtype = tByte
    datbyte = rhs
    
End Operator

Operator dataobj.Let (rhs As UByte)
    
    'Clear any existing data.
    Destroy
    dtype = tUByte
    datubyte = rhs

End Operator

Operator dataobj.Let (rhs As Short)
    
    'Clear any existing data.
    Destroy
    dtype = tShort
    datshort = rhs

End Operator

Operator dataobj.Let (rhs As UShort)
    
    'Clear any existing data.
    Destroy
    dtype = tUShort
    datushort = rhs

End Operator

Operator dataobj.Let (rhs As Integer)
    
    'Clear any existing data.
    Destroy
    dtype = tInteger
    datinteger = rhs

End Operator

Operator dataobj.Let (rhs As UInteger)
    
    'Clear any existing data.
    Destroy
    dtype = tUinteger  
    datuinteger = rhs
End Operator

Operator dataobj.Let (rhs As Long)
    
    'Clear any existing data.
    Destroy
    dtype = tLong
    datlong = rhs

End Operator

Operator dataobj.Let (rhs As ULong)
    
    'Clear any existing data.
    Destroy
    dtype = tULong
    datulong = rhs

End Operator

Operator dataobj.Let (rhs As LongInt)
    
    'Clear any existing data.
    Destroy
    dtype = tLongint
    datlongint = rhs

End Operator

Operator dataobj.Let (rhs As ULongInt)
    
    'Clear any existing data.
    Destroy
    dtype = tULongint
    datulongint = rhs

End Operator

Operator dataobj.Let (rhs As Single)
    
    'Clear any existing data.
    Destroy
    dtype = tSingle
    datsingle = rhs

End Operator

Operator dataobj.Let (rhs As Double)
    
    'Clear any existing data.
    Destroy
    dtype = tDouble
    datdouble = rhs
    
End Operator

Operator dataobj.Let (rhs As String)
    Dim As Integer l = Len(rhs)
    
    'Clear any existing data.
    Destroy
    dtype = tString
    If l > 0 Then
        datstring = Allocate(l + 1)
        *datstring = rhs
    Else
        datstring = NULL
    EndIf
    
End Operator

'Cast to data type.
Operator dataobj.Cast () As Byte
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CByte(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As UByte
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CUByte(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As Short
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CShort(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As UShort
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CUShort(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As Integer
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CInt(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As UInteger
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CUInt(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As Long
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CLng(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As ULong
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CULng(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As LongInt
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CLngInt(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As ULongInt
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CULngInt(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As Single
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CSng(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As Double
   Select Case dtype
      Case tNull
         Return NULL
      Case tByte
         Return datByte
      Case tUByte
         Return datUByte
      Case tShort
         Return datShort
      Case tUShort
         Return datUShort
      Case tInteger
         Return datInteger
      Case tUInteger
         Return datUInteger
      Case tLong
         Return datULong
      Case tUlong
         Return datULong
      Case tLongint
         Return datLongInt
      Case tUlongint
         Return datULongInt
      Case tSingle
         Return datSingle
      Case tDouble
         Return datDouble
      Case tString
         If datString <> NULL Then
            Return CDbl(*datString)
         Else
            Return 0
         EndIf
   End Select
End Operator

Operator dataobj.Cast () As String
   
    Select Case dtype
       Case tNull
            Return ""
        Case tByte
            Return Str(datbyte)
       Case tUByte
            Return Str(datubyte)
        Case tShort
            Return Str(datshort)
       Case tUShort
            Return Str(datushort)
       Case tInteger
            Return Str(datinteger)
       Case tUInteger
            Return Str(datuinteger)
       Case tLong
            Return Str(datlong)
       Case tUlong
            Return Str(datulong)
       Case tLongint
            Return Str(datlongint)
       Case tUlongint
            Return Str(datulongint)
       Case tSingle
            Return Str(datsingle)
       Case tDouble
            Return Str(datdouble)
       Case tString
           If datstring <> NULL Then
               Return *datstring
           Else
               Return ""
           EndIf
    End Select
End Operator


#EndIf