/'****************************************************************************
The MIT License

Copyright (c) 2011, Ruchard D. Clark

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

http://www.opensource.org/licenses/mit-license.php
*****************************************************************************'/

#Include "asarray.bi"


Dim myAsarray As fbasarray.asarray
Dim myKey As fbasarray.dataobj
Dim myData As fbasarray.dataobj
Dim As Integer ret

'Make sure table was properly intialized.
If myAsarray.IsInit = fbasarray.FALSE Then
   Print "Could not initialize the asarray object."
   Sleep
   End
EndIf

'Print the current table size.
Print "Table size: "; myAsarray.TableSize

'Insert some data based on integer key.
myKey = 55
myData = "VAR1"
ret = myAsarray.InsertKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not insert data into asarray object."
Else
   Print "Data added to asarray object."
EndIf

'Insert some data based on single key. Use suffix to force single.
myKey = 55.0f
myData = "VAR2"
ret = myAsarray.InsertKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not insert data into asarray object."
Else
   Print "Data added to asarray object."
EndIf

'Insert some data based on double key. Use suffix to force double.
myKey = 55.0#
myData = "VAR3"
ret = myAsarray.InsertKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not insert data into asarray object."
Else
   Print "Data added to asarray object."
EndIf

'Insert some data based on string key. 
myKey = "55"
myData = "VAR4"
ret = myAsarray.InsertKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not insert data into asarray object."
Else
   Print "Data added to asarray object."
EndIf

'Get the data for each key value.
mykey = 55
ret = myAsarray.GetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not find data in asarray object. Key = " & myKey
Else
   Print "Data " & myData & " found in asarray using key " & myKey & " which is type " & myKey.DataType & "."
EndIf

'Get the data for each key value.
mykey = 55.0f
ret = myAsarray.GetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not find data in asarray object. Key = " & myKey
Else
   Print "Data " & myData & " found in asarray using key " & myKey & " which is type " & myKey.DataType & "."
EndIf

'Get the data for each key value.
mykey = 55.0#
ret = myAsarray.GetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not find data in asarray object. Key = " & myKey
Else
   Print "Data " & myData & " found in asarray using key " & myKey & " which is type " & myKey.DataType & "."
EndIf

'Get the data for each key value.
mykey = "55"
ret = myAsarray.GetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not find data in asarray object. Key = " & myKey
Else
   Print "Data " & myData & " found in asarray using key " & myKey & " which is type " & myKey.DataType & "."
EndIf

'Change the integer key data.
myKey = 55
myData = "VarInt"
ret = myAsarray.SetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not change data in asarray object."
Else
   Print "Data changed successfully."
EndIf
'Get the new data.
mykey = 55
ret = myAsarray.GetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not find data in asarray object. Key = " & myKey
Else
   Print "Data " & myData & " found in asarray using key " & myKey & " which is type " & myKey.DataType & "."
EndIf

'Delete the integer key.
myKey = 55
ret = myAsarray.DeleteKeyData(myKey)
If ret = fbasarray.FALSE Then
   Print "Could not delete data in asarray object."
Else
   Print "Key-data deleted."
EndIf
'Try and get the deleted data.
mykey = 55
ret = myAsarray.GetKeyData(myKey, myData)
If ret = fbasarray.FALSE Then
   Print "Could not find data in asarray object. Key = " & myKey
Else
   Print "Data " & myData & " found in asarray using key " & myKey & " which is type " & myKey.DataType & "."
EndIf

'Find the float key.
myKey = 55.0f
ret = myAsarray.FindKey(myKey)
If ret = fbasarray.FALSE Then
   Print "Could not find key " & myKey & "."
Else
   Print "Found key " & myKey & " which is type " & myKey.DataType & "."
EndIf


Sleep
