/'****************************************************************************
*
* Name: testcard.bas
*
* Synopsis: Test program for card object.
*           
*
* Description: This program test the methods of the card object.
*              The card object uses the card graphics posted by D.J. Peters on the 
*              FreeBasic forum (http://www.freebasic.net/forum/viewtopic.php?t=14993)
*              and card backs from http://www.jfitz.com/cards/. 
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
*****************************************************************************'/
#Include "cardobj.bi"

Dim pcards As cards.cardobj
Dim deck(cards.cardid.cClubAce To cards.cardid.cJokerRed) as cards.cardid
Dim As Integer ret, x = 1, y = 1, tw, ky
Dim As String txt

Randomize Timer
Screen 19, 32
Width 100, 75
Color , RGB(38, 127, 0)
Cls 
WindowTitle "Card Object Test v." & pcards.Version
 
'Load cards front and backs.
ret = pcards.LoadCards("cards.bmp")
If ret = TRUE Then

   'Draw all the fronts.   
   For i As cards.cardid = cards.cardid.cClubAce To cards.cardid.cJokerRed
      pcards.DrawCardFront x, y, i
      x += pcards.CardWidth 
      If x + pcards.CardWidth > 800 Then
         x = 1
         y += pcards.CardHeight 
      EndIf
   Next
   y+= pcards.CardHeight
   x = 1
   'Draw the backs.
   pcards.DrawCardBack x, y, cards.cardback.bRed
   x += pcards.CardWidth
   pcards.DrawCardBack x, y, cards.cardback.bBlue
   x += pcards.CardWidth
   pcards.DrawCardBack x, y, cards.cardback.bPink
   'Draw graphic placeholder.
   x+= pcards.CardWidth
   pcards.DrawPlaceHolder x, y, cards.cardplace.pGreen
   x+= pcards.CardWidth
   pcards.DrawPlaceHolder x, y, cards.cardplace.pRed
   'Draw placeholder.
   x+= pcards.CardWidth
   pcards.DrawPlaceHolder x, y
   x+= pcards.CardWidth
   pcards.DrawPlaceHolder x, y, RGB(255, 0, 0), RGB(255, 255, 255)
   Sleep
   Do:loop Until InKey = ""
   'Load deck.
   For i As cards.cardid = cards.cardid.cClubAce To cards.cardid.cJokerRed
      deck(i) = i
   Next
   'Shuffle cards.
   pcards.Shuffle deck()
   'Print out cards.
   Cls
   x = 1
   y = 1
   For i As integer = LBound(deck) To UBound(deck)
      pcards.DrawCardFront x, y, deck(i)
      x += pcards.CardWidth 
      If x + pcards.CardWidth > 800 Then
         x = 1
         y += pcards.CardHeight 
      EndIf
   Next
   y += pcards.CardHeight + 1
   x = 1
   txt = "Deck shuffled."
   Draw String (x, y), txt, RGB(255, 255, 255)
   'Print out some random numbers.
   y += 9
   txt = "Some random numbers between 1 and 52: " 
   For i As Integer = 1 To 4
      txt &= cards.Rand(1, 52)
      If i <> 4 Then txt &= ", "
   Next
   Draw String (x, y), txt, RGB(255, 255, 255)
   Sleep
   Do:loop Until InKey = ""
   'Set the Aces to high.
   pcards.SetCardValue(cards.cardid.cClubAce) = pcards.CRank(cards.cardid.cClubKing) + 1
   pcards.SetCardValue(cards.cardid.cDiamAce) = pcards.CRank(cards.cardid.cDiamKing) + 1
   pcards.SetCardValue(cards.cardid.cHearAce) = pcards.CRank(cards.cardid.cHearKing) + 1
   pcards.SetCardValue(cards.cardid.cSpadAce) = pcards.CRank(cards.cardid.cSpadKing) + 1
   'Print out card information.
   For i As cards.cardid = cards.cardid.cClubAce To cards.cardid.cJokerRed
      Cls
      x = 1: y = 1: tw = pcards.CardHeight + 9
      pcards.DrawCardFront x, y, i
      
      txt = "Card ID: " & i
      Draw String (x, tw), txt, RGB(255, 255, 255)
      
      txt = "Card Suit: " & pcards.CSuit(i)
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)

      txt = "Card Suit: " & pcards.SuitofCard(i)
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)
      
      txt = "Card Face: " & pcards.CFace(i)
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)

      txt = "Card Face: " & pcards.FaceofCard(i)
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)
      
      txt = "Card Rank: " & pcards.CRank(i)
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)

      txt = "Card Value: " & pcards.CValue(i)
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)
      
      txt = "Press a key to advance, Esc to exit"
      tw += 9
      Draw String (x, tw), txt, RGB(255, 255, 255)
      
      ky = GetKey
      If ky = 27 Then Exit For
   Next

End If   
