' Deep Deadly Dungeon
' (C)2005 by Richard Clark rickclark58@yahoo.com
' Compiled using FB version .15b
'
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'
'This file contains all the general utility functions.
'
'draws a box on the screen and clears contents
Sub DrawBox(bcolor As Integer, row As Integer, col As Integer, bwidth As Integer, bheight As Integer)
    Dim i As Integer
    
    Color bcolor, fbBlack
    Locate row, col
    'print the top row
    Print Chr$(201);
    Print String$(col + bwidth - 2, Chr$(205));
    Print Chr$(187)
    'print the sides
    For i = row + 1 To row + bheight - 1
        Locate i, col
        Print Chr$(186);
        Print String$(col + bwidth - 2, Chr$(32));
        Print Chr$(186)
    Next i
    'print bottom row
    Locate row + bheight - 1, col
    Print Chr$(200);
    Print String$(col + bwidth - 2, Chr$(205));
    Print Chr$(188)
End Sub

'print a message to the screen
Sub PrintMessage(mess As String = "")
    Dim tmpmess As String
    Dim i As Integer
    Dim messlen As Integer = 0
    Dim As Integer row, col
    Dim bwidth As Integer = 55
    Dim bheight As Integer = UBound(messages) + 2
    'make sure we have a message
    
    tmpmess = Trim$(mess)
    If Len(tmpmess) > 0 Then
        If Len(tmpmess) > bwidth - 2 Then
            tmpmess = Mid$(tmpmess, 1, bwidth - 2)
        End If
        If tmpmess <> messages(1) Then
            'move all messages down one slot
            For i = UBound(messages) To 2 Step -1
                messages(i) = messages(i - 1)
            Next
            messages(1) = tmpmess
        End If
    End If
    'try top right
    row = 57 - bheight
    col = 2
    'draw the box
    DrawBox fbYellow, row, col, bwidth, bheight
    'top message is current
    Locate row + 1, col + 1
    Print messages(1);
    For i = 2 To UBound(messages)
        Color fbWhite, fbBlack
        Locate row + i, col + 1
        Print messages(i);
    Next i
     
end sub

'get a random number between low and high 
function GetRandom(lowerbound, upperbound as integer) as integer
   GetRandom = Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
end function

'calc a percentage return true if successful false if not
function GetPercentage(chance as integer) as integer
    dim roll as integer
    
    roll = GetRandom(1, 100) 
    if roll <= abs(chance) then
        return True
    else
        return False
    end if
end function

'center text on row
Sub CenterText(row As Integer, mess As String)
    Locate row, 40 - (Len(mess) / 2)
    Print mess;
End Sub

Function CalcDist(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    dim as integer xdiff, ydiff
   
   xdiff = Abs(x1 - x2)
   ydiff = Abs(y1 - y2)
   If xdiff >= ydiff Then Return xdiff
   If ydiff >= xdiff Then Return ydiff
end function 

Function CalcStandardDist(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Dim As Integer xdiff, ydiff
    Dim dist As Integer
   
    xdiff = Abs(x1 - x2)
    ydiff = Abs(y1 - y2)
    dist =  (xdiff + ydiff + imax(xdiff, ydiff)) Shr 1
    Return dist
End Function

Function CalcMHDist(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Return Abs(x1 - x2) + Abs(y1 - y2)
End Function

Function GetDR(modifier As Integer = 0)
    Dim ret As Integer
    
    ret = (GetRandom(1, levels.currlevel * 4)) + levels.lcount(levels.currlevel)
    If player.hasorbs.hascrown = True And levels.currlevel < maxlevels Then
        ret += maxlevels
    End If
    ret += modifier
    
    Return ret
end function

Function GetRoll(stat As Integer, target As Integer = 0) As Integer
    dim roll as integer
    
    If target = 0 Then target = GetDR
    roll = GetRandom(1, target)
    If stat >= roll Then
        return True
    else
        return False
    end if
end function

Function GetCoord(direction As Integer, ccoord As mcoord) As mcoord
    Dim rcoord As mcoord
    
    Select Case direction
        Case north
            rcoord.x = ccoord.x
            rcoord.y = ccoord.y - 1
        Case east
            rcoord.x = ccoord.x + 1
            rcoord.y = ccoord.y
        Case south
            rcoord.x = ccoord.x
            rcoord.y = ccoord.y + 1
        Case west
            rcoord.x = ccoord.x - 1
            rcoord.y = ccoord.y
        Case nwest
            rcoord.x = ccoord.x - 1
            rcoord.y = ccoord.y - 1
        Case neast
            rcoord.x = ccoord.x + 1
            rcoord.y = ccoord.y - 1
        Case swest
            rcoord.x = ccoord.x - 1
            rcoord.y = ccoord.y + 1
        Case seast
            rcoord.x = ccoord.x + 1
            rcoord.y = ccoord.y + 1
    End Select
    Return rcoord    
End Function

