' Deep Deadly Dungeons
' (C)2005 by Richard Clark rickclark58@yahoo.com
'
' Compiled using FB version .15b
'
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'This file contains all the inventory related routines.
'
function GetItemID(inv as invtype) as integer
    with inv
        select case .typeid
            case crown
                return crown
            case redorb
                return redorb
            case blueorb
                return blueorb
            case greenorb
                return greenorb
            case yelloworb
                return yelloworb
            case whiteorb
                return whiteorb
            case supplies
                return .supply.id
            case necklaces
                return .necklace.id
            case potions
                return .potion.id
            case rings
                return .ring.id
            case wands
                return .wand.id
            case weapons
                return .weapon.id
            Case armors
                return .armor.id
            case lights
                return .light.id
            Case ammos
                return .ammo.id
            case shields
                return .shield.id
            case scrolls
                return .scroll.id
            case else
                return 0
        end select
    end with
end function

sub GenSupply(inv as invtype)
    Dim sdesc As String = "Uknown supply"    
    with inv.supply
        select case .id
            Case smeat
                .count = 1
                .eval = True
                .modifier = 25
                .noise = 0
                sdesc = "Hunk of meat"
            Case sbottle
                .count = 1
                .eval = True
                .modifier = 10
                .noise = 2
                sdesc = "Bottle of ale"
            Case sbread
                .count = 1
                .eval = True
                .modifier = 5
                .noise = 0
                sdesc = "Bread"
            Case scoins 
                .count = GetRandom(1, levels.currlevel) * 2
                .eval = False
                .modifier = 0
                .noise = .count 
                sdesc = "Some coins"
            Case sbagocoins 
                .count = GetRandom(1, levels.currlevel) * 5
                .eval = False
                .modifier = 0
                .noise = .count
                sdesc = "Bag of coins"
        End Select
    End With
    inv.desc = sdesc
end sub

Sub GenNecklace(inv As invtype)
    Dim ndesc As String = "Unknown necklace"
    with inv.necklace
        'set the eval difficulty
        .dr = GetDR
        .eval = False
        .magic = False
        .noise = 2
        'Is item cursed?
        .cursed = GetPercentage(10)
        if .cursed then
            .magic = True
            .effect = GetRandom(minrneffect, maxrneffect)
            .modifier = GetRandom(1, .dr) * -1
        else
            'Is item magic?
            if GetPercentage(levels.currlevel * 4) then
                .magic = True
                .effect = GetRandom(minrneffect, maxrneffect)
                .modifier = GetRandom(1, .dr)
            end if
        end if
        select case .id
            case rubynecklace
                .value = GetRandom(1, 50) + .dr
                If .magic Then .value = .value * 10
                ndesc = "Ruby Necklace"
            Case diamondnecklace 
                .value = GetRandom(1, 200) + .dr
                if .magic then .value = .value * 10
                ndesc = "Diamond Necklace"
            Case emeraldnecklace 
                .value = GetRandom(1, 30) + .dr
                if .magic then .value = .value * 10
                ndesc = "Emerald Necklace"
            Case topaznecklace 
                .value = GetRandom(1, 20) + .dr
                if .magic then .value = .value * 10
                ndesc = "Topaz Necklace"
            Case silvernecklace 
                .value = GetRandom(1, 50) + .dr
                if .magic then .value = .value * 10
                ndesc = "Silver Necklace"
            Case goldnecklace 
                .value = GetRandom(1, 100) + .dr
                if .magic then .value = .value * 10
                ndesc = "Gold Necklace"
            Case bronzenecklace 
                .value = GetRandom(1, 10) + .dr
                if .magic then .value = .value * 10
                ndesc = "Bronze Necklace"
            Case coppernecklace 
                .value = GetRandom(1, 5) + .dr
                if .magic then .value = .value * 10
                ndesc = "Copper Necklace"
        End Select
    End With
    inv.desc = ndesc
end sub

Sub GenRing(inv As invtype)
    Dim rdesc As String = "Uknown ring"
    with inv.ring
        'set the eval difficulty
        .dr = GetDR
        .eval = False
        .magic = False
        .noise = 1
        'Is item cursed
        .cursed = GetPercentage(10)        
        if .cursed then
            .magic = True
            .effect = GetRandom(minrneffect, maxrneffect)
            .modifier = GetRandom(1, .dr) * -1
        else
            'Is item magic?
            if GetPercentage(levels.currlevel * 4) then
                .magic = True
                .effect = GetRandom(minrneffect, maxrneffect)
                .modifier = GetRandom(1, .dr)
            end if
        end if
        select case .id
            case rubyring
                .value = GetRandom(1, 60) + .dr
                If .magic Then .value = .value * 10
                rdesc = "Ruby Ring"
            Case diamondring 
                .value = GetRandom(1, 150) + .dr
                if .magic then .value = .value * 10
                rdesc = "Diamond Ring"
            Case emeraldring 
                .value = GetRandom(1, 30) + .dr
                if .magic then .value = .value * 10
                rdesc = "Emerald Ring"
            Case topazring 
                .value = GetRandom(1, 20) + .dr
                if .magic then .value = .value * 10
                rdesc = "Topaz Ring"
            Case silverring 
                .value = GetRandom(1, 50) + .dr
                if .magic then .value = .value * 10
                rdesc = "Silver Ring"
            Case goldring 
                .value = GetRandom(1, 100) + .dr
                if .magic then .value = .value * 10
                rdesc = "Gold Ring"
            Case bronzering 
                .value = GetRandom(1, 10) + .dr
                if .magic then .value = .value * 10
                rdesc = "Bronze Ring"
            Case copperring 
                .value = GetRandom(1, 5) +.dr
                if .magic then .value = .value * 10
                rdesc = "Copper Ring"
        End Select
    End With
    inv.desc = rdesc
end sub

Sub GenPotion(inv As invtype, nocurse As Integer = False)
    Dim pdesc As String = "Uknown potion"
    
    With inv.potion
        If .id < minpotion Or .id > maxpotion Then
            .id = GetRandom(minpotion, maxpotion)
        End If
        .dr = GetDR
        .eval = False
        If nocurse = False Then
            .cursed = GetPercentage(10)
        Else
            .cursed = False
        End If
        .effect = GetRandom(minpotioneffect, maxpotioneffect)
        If .id = ptvision Then
            .modifier = GetRandom(1, 5)
        Else
            .modifier = GetRandom(1, .dr)
        End If
        .noise = 2
        If .cursed Then .modifier *= -1
        Select Case .id
            Case redpotion
                pdesc = "Red Potion"
            Case yellowpotion
                pdesc = "Yellow Potion"
            Case greenpotion
                pdesc = "Green Potion"
            Case bluepotion
                pdesc = "Blue Potion"
            Case magentapotion
                pdesc = "Magenta Potion"
            Case cyanpotion
                pdesc = "Cyan Potion"
            Case whitepotion
                pdesc = "White Potion"
            Case blackpotion
                pdesc = "Black Potion"
       End Select
    End With
    inv.desc = pdesc
end sub

Function GetPotionEffect(inv As invtype) As String
    Dim sname As String
    
    With inv.potion
        Select Case .effect
            Case ptstrength
                If .cursed Then
                    sname = "Decrease Str"
                Else
                    sname = "Improve Str"
                End If
            Case ptendurance
                If .cursed Then
                    sname = "Decrease End"
                Else
                    sname = "Improve End"
                End If
            Case ptdexterity
                If .cursed Then
                    sname = "Decrease Dex"
                Else
                    sname = "Improve Dex"
                End If
            Case ptagility
                If .cursed Then
                    sname = "Decrease Agl"
                Else
                    sname = "Improve Agl"
                End If
            Case ptintelligence
                If .cursed Then
                    sname = "Decrease Int"
                Else
                    sname = "Improve Int"
                End If
            Case ptvision
                If .cursed Then
                    sname = "Decrease Vis"
                Else
                    sname = "Improve Vis"
                End If
            Case pthealth
                If .cursed Then
                    sname = "Damage"
                Else
                    sname = "Health"
                End If
        End Select
    End With
    Return sname
End Function

function GetScrollName(inv as invtype) as string
    dim sname as string
    
    With inv.scroll
        select case .id
            case healscroll
                sname = "Scroll of Healing"
            case meleescroll
                sname = "Scroll of Melee"
            case dodgescroll
                sname = "Scroll of Dodge"
            case scanscroll
                sname = "Scroll of Scan"
            case swordscroll
                sname = "Scroll of Sword"
            case axescroll
                sname = "Scroll of Axe"
            case spearscroll
                sname = "Scroll of Spear"
            case macescroll
                sname = "Scroll of Mace"
            case flailscroll
                sname = "Scroll of Flail"
            case bowscroll
                sname = "Scroll of Bow"
            case crossbowscroll
                sname = "Scroll of Crossbow"
            case shieldscroll
                sname = "Scroll of Shield"
            case combatawarescroll
                sname = "Scroll of Combat Aware"
            case stealthscroll
                sname = "Scroll of Improve Stealth"
            case searchscroll
                sname = "Scroll of Improve Search"
            case disarmtrapscroll
                sname = "Scroll of Improve Disarm"
            case picklockscroll
                sname = "Scroll of Improve Picklock"
            case readancientscroll
                sname = "Scroll of Improve Read Ancient"
            case evalscroll
                sname = "Scroll of Improve Eval"
            case usemagicscroll
                sname = "Scroll of Improve Use Magic"
            Case cursescroll
                 sname = "Scroll of Lift Curse"
            Case teleportscroll
                 sname = "Scroll of Teleport"
        End Select
    end with
    return sname
end function

Sub GenScroll(inv As invtype)
    If inv.typeid <> scrolls Then inv.typeid = scrolls
    With inv.scroll
        If .id < minscroll Or .id > maxscroll Then
            .id = GetRandom(minscroll, maxscroll)
        End If
        .dr = GetDR
        .eval = False
        .modifier = GetRandom(1, .dr) + 10
        .noise = 0
    End With
    inv.desc = "Scroll"
end sub

Sub GenWand(inv As invtype)
    Dim wdesc As String = "Uknown wand"
    
    If inv.typeid <> wands Then inv.typeid = wands
    With inv.wand
        If .id < minwand Or .id > maxwand Then
            .id = GetRandom(minwand, maxwand)
        End If
        'set the eval difficulty
        .dr = GetDR
        .eval = False
        .damage = GetRandom(1, levels.currlevel * 4)
        .count = GetRandom(1, levels.currlevel * 4)
        .noise = 1
        Select Case .id
            Case wwand
                wdesc = "Wand"
        End Select
    End With
    inv.desc = wdesc
end sub

Sub GenLight(inv As invtype)
    Dim ldesc As String = "Unknown light"
    
    If inv.typeid <> lights Then inv.typeid = lights
    With inv.light
        If .id < minlight Or .id > maxlight Then
            .id = GetRandom(minlight, maxlight)
        End If
        Select Case .id
            case lantern
                .count = GetRandom(100, 500) * 10
                .range = 2
                .noise = 2
                ldesc = "Lantern"
            case torch
                .count = GetRandom(100, 500) * 5
                .range = 1
                .noise = 1
                ldesc = "Torch"
        end select
    End With
    inv.desc = ldesc
end sub

Sub GenAmmo(inv As invtype)
    Dim adesc As String = "Unknown ammo"
    
    If inv.typeid <> ammos Then inv.typeid = ammos
    With inv.ammo
        If .id < minammo Or .id > maxammo Then
            .id = GetRandom(minammo, maxammo)
        End If
        .count = GetRandom(10, 20)
        .noise = 1
        Select Case .id
            Case bolts
                adesc = "Bolts"
            Case arrows
                adesc = "Arrows"
            Case pebbles
                adesc = "Pebbles"
        End Select
    End With
    inv.desc = adesc
end sub

Sub GenShield(inv As invtype, cursed As Integer)
    Dim sdesc As String = "Uknown shld"
    
    If inv.typeid <> shields Then inv.typeid = shields
    With inv.shield
        If .id < minshield Or .id > maxshield Then
            .id = GetRandom(minshield, maxshield)
        End If
        'set the eval difficulty
        .dr = GetDR
        .eval = False
        .cursed = cursed
        .defmod = 0
        .defmagic = 0
        .defmagicmod = 0
        If GetPercentage(levels.currlevel * 4) Then
            .defmod = GetRandom(1, levels.currlevel)
        End If
        If GetPercentage(levels.currlevel * 4) Then
            .defmagic = GetRandom(1, levels.currlevel)
        End If
        If GetPercentage(levels.currlevel * 4) Then
            .defmagicmod = GetRandom(1, levels.currlevel)
        End If
        If cursed Then
            .defmod *= -1
            .defmagic *= - 1
            .defmagicmod *= - 1
        End If
        select case .id
            Case leathershld
                .ac = 2
                .strg = 50
                .noise = 1
                sdesc = "Leather shld"
            Case cuirbolishld
                .ac = 3
                .Strg = 80
                .noise = 2
                sdesc = "Cuirboli shld"
            Case ringshld
                .ac = 4
                .strg = 100
                .noise = 3
                sdesc = "Ring shld"
            Case brigantineshld
                .ac = 5
                .strg = 140
                .noise = 4
                sdesc = "Brigantine shld"
            Case chainshld
                .ac = 6
                .strg = 160
                .noise = 5
                sdesc = "Chain shld"
            Case scaleshld
                .ac = 7
                .strg = 200
                .noise = 6
                sdesc = "Scale shld"
            Case plateshld
                .ac = 8
                .strg = 250
                .noise = 7
                sdesc = "Plate shld"
        End Select
        if cursed then
            .ac *= -1
        end if
    End With
    inv.desc = sdesc
end sub

Sub GenArmor(inv As invtype, cursed As Integer)
    Dim adesc As String = "Unknown Armor"
    
    If inv.typeid <> armors Then inv.typeid = armors
    With inv.armor
        If .id < minarm Or .id > maxarm Then
            .id = GetRandom(minarm, maxarm)
        End If
        'set the eval difficulty
        .dr = GetDR
        .eval = False
        .cursed = cursed
        .defmod = 0
        .defmagic = 0
        .defmagicmod = 0
        'is item magic
        if GetPercentage(levels.currlevel * 4) then
            .defmod = GetRandom(1, levels.currlevel) * 10
        End If
        if GetPercentage(levels.currlevel * 4) then
            .defmagic = GetRandom(1, levels.currlevel) * 10
        End If
        if GetPercentage(levels.currlevel * 4) then
            .defmagicmod = GetRandom(1, levels.currlevel) * 10
        End If
        If cursed Then
            .defmod *= -1
            .defmagic *= - 1
            .defmagicmod *= - 1
        End If
        select case .id
            Case leatherarm
                .ac = 2
                .strg = 50
                .noise = 1
                adesc = " Leather Armor"
            Case cuirboliarm
                .ac = 3
                .Strg = 80
                .noise = 2
                adesc = "Cuirboli Armor"
            Case ringarm
                .ac = 4
                .strg = 100
                .noise = 3
                adesc = "Ring Armor"
            Case brigantinearm
                .ac = 5
                .strg = 140
                .noise = 4
                adesc = "Brigantine Armor"
            Case chainarm
                .ac = 6
                .strg = 160
                .noise = 5
                adesc = "Chain Armor"
            Case scalearm
                .ac = 7
                .strg = 200
                .noise = 6
                adesc = "Scale Armor"
            Case platearm
                .ac = 8
                .strg = 250
                .noise = 7
                adesc = "Plate Armor"
        End Select
        If cursed Then
            .ac *= -1
        end if
    End With
    inv.desc = adesc
end sub

Sub GenWeapon(inv As invtype, cursed As Integer)
    Dim wdesc As String
    
    If inv.typeid <> weapons Then inv.typeid = weapons
    With inv.weapon
        If .id < minweapon Or .id > maxweapon Then
            .id = GetRandom(minweapon, maxweapon)
        End If
        'set the eval difficulty
        .dr = GetDR
        .eval = False
        .cursed = cursed
        .tohitmod = 0
        .dammod = 0
        'is this a magic item?
        If GetPercentage(levels.currlevel * 4) Then
            .tohitmod = GetRandom(1, levels.currlevel)
        End If
        If GetPercentage(levels.currlevel * 4) Then
            .dammod = GetRandom(1, levels.currlevel)
        End If
        'cursed items are also magic items
        If cursed Then
            .tohitmod *= -1
            .dammod *= -1
        End If
        Select Case .id
            case club      'melee, 1 hand
                .hands = 1
                .damage = 4
                .strg = 50
                .skill = wmelee
                .noise = 1
                wdesc = "Club"
            Case warclub   'melee comabt, 1 hand
                .hands = 1
                .damage = 8
                .strg = 65
                .skill = wmelee
                .noise = 1
                wdesc = "War Club"
            Case cudgel    'melee combat, 1 hand
                .hands = 1
                .damage = 5
                .strg = 55
                .skill = wmelee
                .noise = 1
                wdesc = "Cudgel"
            Case dagger    'melee combat, 1 hand
                .hands = 1
                .damage = 4
                .strg = 50
                .skill = wmelee
                .noise = 1
                wdesc = "Dagger"
            Case longknife 'melee combat, 1 hand
                .hands = 1
                .damage = 6
                .strg = 60
                .skill = wmelee
                .noise = 1
                wdesc = "Long Knife"
            Case smallsword 'sword, 1 hand
                .hands = 1
                .damage = 4
                .strg = 50
                .skill = wsword
                .noise = 2
                wdesc = "Smal Sword"
            Case shortsword 'sword, 1 hand
                .hands = 1
                .damage = 6
                .strg = 65
                .skill = wsword
                .noise = 2
                wdesc = "Short Sword"
            Case rapier     'sword, 1 hand
                .hands = 1
                .damage = 9
                .strg = 80
                .skill = wsword
                .noise = 3
                wdesc = "Rapier"
            Case scimitar   'sword, 1 hand
                .hands = 1
                .damage = 10
                .strg = 90
                .skill = wsword
                .noise = 3
                wdesc = "Scimitar"
            Case broadsword 'sword, 1 hands
                .hands = 1
                .damage = 10
                .strg = 100
                .skill = wsword
                .noise = 4
                wdesc = "Broadsword"
            Case katana     'sword, 2 hands
                .hands = 2
                .damage = 12
                .strg = 120
                .skill = wsword
                .noise = 4
                wdesc = "Katana"
            Case longsword  'sword, 2 hands
                .hands = 2
                .damage = 14
                .strg = 140
                .skill = wsword
                .noise = 4
                wdesc = "Longsword"
            Case claymore   'sword, 2 hands
                .hands = 2
                .damage = 16
                .strg = 160
                .skill = wsword
                .noise = 5
                wdesc = "Claymore"
            Case greatsword 'sword, 2 hands
                .hands = 2
                .damage = 18
                .strg = 180
                .skill = wsword
                .noise = 5
                wdesc = "Greatsword"
            Case odinsword  'sword 2 hands
                .hands = 2
                .damage = 20
                .strg = 190
                .skill = wsword
                .noise = 6
                wdesc = "Odinsword"
            Case hellguard  'sword, 2 hands
                .hands = 2
                .damage = 30
                .strg = 200
                .skill = wsword
                .noise = 6
                wdesc = "Hellguard"
            Case quarterstaff 'spear, 1 hands
                .hands = 1
                .damage = 4
                .strg = 50
                .skill = wspear
                .noise = 1
                wdesc = "Quarter-staff"
            Case longstaff    'spear, 2 hands
                .hands = 2
                .damage = 6
                .strg = 60
                .skill = wspear
                .noise = 2
                wdesc = "Long Staff"
            Case lightspear   'spear, 2 hands
                .hands = 2
                .damage = 7
                .strg = 70
                .skill = wspear
                .noise = 2
                wdesc = "Light Spear"
            Case polearm      'spear, 2 hands
                .hands = 2
                .damage = 8
                .strg = 80
                .skill = wspear
                .noise = 2
                wdesc = "Polearm"
            Case heavyspear   'spear, 2 hands
                .hands = 2
                .damage = 9
                .strg = 90
                .skill = wspear
                .noise = 2
                wdesc = "Heavy Spear"
            Case trident      'spear, 2 hands
                .hands = 2
                .damage = 10
                .strg = 100
                .skill = wspear
                .noise = 3
                wdesc = "Trident"
            Case glaive       'spear, 2 hands
                .hands = 2
                .damage = 12
                .strg = 110
                .skill = wspear
                .noise = 3
                wdesc = "Glaive"
            Case handaxe      'axe, 1 hand
                .hands = 1
                .damage = 6
                .strg = 50
                .skill = waxe
                .noise = 1
                wdesc = "Hand Axe"
            Case battleaxe    'axe, 1 hand
                .hands = 1
                .damage = 9
                .strg = 80
                .skill = waxe
                .noise = 2
                wdesc = "Battle Axe"
            Case gothicbattleaxe 'axe, 2 hands
                .hands = 2
                .damage = 10
                .strg = 100
                .skill = waxe
                .noise = 3
                wdesc = "Gothic Battle Axe"
            Case waraxe          'axe, 2 hands
                .hands = 2
                .damage = 12
                .strg = 110
                .skill = waxe
                .noise = 3
                wdesc = "War Axe"
            Case halberd         'axe, 2 hands
                .hands = 2
                .damage = 14
                .strg = 120
                .skill = waxe
                .noise = 3
                wdesc = "Halberd"
            Case poleaxe        'axe, 2 hands
                .hands = 2
                .damage = 16
                .strg = 140
                .skill = waxe
                .noise = 3
                wdesc = "Poleaxe"
            Case smallmace      'mace, 1 hand
                .hands = 1
                .damage = 5
                .strg = 50
                .skill = wmace
                .noise = 2
                wdesc = "Small Mace"
            Case battlemace     'mace, 1 hand
                .hands = 1
                .damage = 7
                .strg = 60
                .skill = wmace
                .noise = 2
                wdesc = "Battle Mace"
            Case spikedmace     'mace, 1 hand
                .hands = 1
                .damage = 9
                .strg = 70
                .skill = wmace
                .noise = 3
                wdesc = "Spiked Mace"
            Case doubleballmace 'mace, 1 hand
                .hands = 1
                .damage = 10
                .strg = 80
                .skill = wmace
                .noise = 4
                wdesc = "Double-ball Mace"
            Case warhammer      'mace, 1 hand
                .hands = 1
                .damage = 12
                .strg = 100
                .skill = wmace
                .noise = 2
                wdesc = "War Hammer"
            Case maul           'mace, 2 hands
                .hands = 2                
                .damage = 14
                .strg = 140
                .skill = wmace
                .noise = 1
                wdesc = "Maul"
            Case bullwhip       'flail, 1 hand
                .hands = 1
                .damage = 4
                .strg = 50
                .skill = wflail 
                .noise = 1
                wdesc = "Bull Whip"
            Case ballflail      'flail, 1 hand
                .hands = 1
                .damage = 6
                .strg = 60
                .skill = wflail
                .noise = 3
                wdesc = "Ball Flail"
            Case spikedflail    'flail, 1 hand
                .hands = 1
                .damage = 10
                .strg = 80
                .skill = wflail 
                .noise = 4
                wdesc = "Spiked Flail"
            Case morningstar    'flail, 1 hand
                .hands = 1
                .damage = 12
                .strg = 90
                .skill = wflail 
                .noise = 4
                wdesc = "Morningstar"
            Case battleflail    'flail, 2 hand
                .hands = 2
                .damage = 14
                .strg = 120
                .skill = wflail 
                .noise = 4
                wdesc = "Battle Flail"
            Case bishopsflail   'flail, 2 hand
                .hands = 2
                .damage = 16
                .strg = 140
                .skill = wflail 
                .noise = 5
                wdesc = "Bishop Flail"
            Case sling          'sling 2 hands
                .hands = 2
                .damage = 4
                .strg = 50
                .skill = wbow
                .noise = 1
                wdesc = "Sling"
            Case shortbow       'bow, 2 hands
                .hands = 2
                .damage = 8
                .strg = 80
                .skill = wbow
                .noise = 1
                wdesc = "Short Bow"
            Case longbow        'bow, 2 hands
                .hands = 2
                .damage = 10
                .strg = 120
                .noise = 2
                wdesc = "Long Bow"
                .skill = wbow
            Case bonebow        'bow, 2 hands
                .hands = 2
                .damage = 12
                .strg = 70
                .noise = 3
                wdesc = "Bone Bow"
                .skill = wbow
            Case adaminebow     'bow, 2 hands
                .hands = 2
                .damage = 14
                .strg = 140
                .skill = wbow
                .noise = 4
                wdesc = "Adamine Bow"
            Case lightcrossbow  'crossbow, 2 hands
                .hands = 2
                .damage = 11
                .strg = 100
                .skill = wcrossbow
                .noise = 2
                wdesc = "Light Crossbow"
            Case heavycrossbow  'crossbow, 2 hands
                .hands = 2
                .damage = 14
                .strg = 160
                .skill = wcrossbow
                .noise = 4
                wdesc = "Heavy Crossbow"
            Case barrelcrossbow 'crossbow, 2 hands
                .hands = 2
                .damage = 16
                .strg = 180
                .skill = wcrossbow
                .noise = 6
                wdesc = "Barrel Crossbow"
        End Select
    End With
    inv.desc = wdesc
end sub

'Saves an item in the map's item struct array
sub SetItem(item as integer, inv as invtype)
    dim cursed as integer
    
    cursed = GetPercentage(10)
    with inv
        select case .typeid
            case supplies
                .supply.id = item
                GenSupply inv
            case necklaces
                .necklace.id = item
                GenNecklace inv
            case potions
                .potion.id = item
                GenPotion inv
            case rings
                .ring.id = item
                GenRing inv
            case wands
                .wand.id = item
                GenWand inv
            case weapons
                .weapon.id = item
                GenWeapon inv, cursed
            Case armors
                .armor.id = item
                GenArmor inv, cursed
            case lights
                .light.id = item
                GenLight inv
            Case ammos
                .ammo.id = item
                GenAmmo inv
            case shields
                .shield.id = item
                GenShield inv, cursed
            case scrolls
                .scroll.id = item
                GenSCroll inv
        end select
    end with
end sub

'Returns an item based on the passed item class
function GetItem(itemtype as integer) as integer
    select case itemtype
        case supplies
            return GetRandom(minsupply, maxsupply)
        case necklaces
            return GetRandom(minnecklace, maxnecklace)
        case potions
            return GetRandom(minpotion, maxpotion)
        case rings
            return GetRandom(minring, maxring)
        case wands
            return GetRandom(minwand, maxwand)
        case weapons
            return GetRandom(minweapon, maxweapon)
        Case armors
            return GetRandom(minarm, maxarm)
        case lights
            return GetRandom(minlight, maxlight)
        Case ammos
            return GetRandom(minammo, maxammo)
        case shields
            return GetRandom(minshield, maxshield)
        case scrolls
            return GetRandom(minscroll, maxscroll)
    end select
end function

sub AddAnItem(cx, cy as integer)
    dim as integer itemid, iitem
    
    'This is the item class
    itemid = GetRandom(minitem, maxitem)
    'Save the item class
    levels.item(cx, cy).typeid = itemid
    'Get an item based on the item class
    iitem = GetItem(itemid)
    'Save the item into the item struct
    SetItem iitem, levels.item(cx, cy)
End Sub

function GetInventoryItemDesc(inv as invtype) as string
    dim sret as string
    dim itemcolor as integer
    
    itemcolor = fbWhite
    with inv
        select case .typeid
            case supplies
                if .supply.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                If .supply.id = smeat Or .supply.id = sbread Or .supply.id = sbottle Then
                    sret += " (" + Str$(.supply.modifier) + " health)"
                End If
                itemcolor = GetClassColor(inv.typeid)
            case necklaces
                if .necklace.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                If .necklace.eval = True Then
                    sret += " (" + GetRNEffectDesc(inv)
                    If .necklace.modifier > = -1 Then
                        sret += " +"
                    Else
                        sret += " "
                    End If
                    sret += Str$(.necklace.modifier) + ")" 
                    If .necklace.cursed = True Then
                        sret += " Cursed"
                    End If
                End If
                itemcolor = GetClassColor(inv.typeid)
            case potions
                If .potion.eval = False Then sret = "* "
                sret += Trim$(inv.desc)
                If .potion.eval = True Then
                    sret += " of " + GetPotionEffect(inv)
                    If .potion.modifier > -1 Then
                        sret += " (+" + Str$(.potion.modifier) + ")"
                    Else
                        sret += " (" + Str$(.potion.modifier) + ")"
                    End If
                End If
                itemcolor = GetClassColor(inv.typeid)
            case rings
                if .ring.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                If .ring.eval = True Then
                    sret += " (" + GetRNEffectDesc(inv)
                    If .ring.modifier > = -1 Then
                        sret += " +"
                    Else
                        sret += " "
                    End If
                    sret += Str$(.ring.modifier) + ")" 
                    If .ring.cursed = True Then
                        sret += " Cursed"
                    End If
                end if
                itemcolor = GetClassColor(inv.typeid)
            case wands
                if .wand.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                If .wand.eval = True Then
                    sret += " (Chg: " + Str$(.wand.count) + ", Dam: " + Str$(.wand.damage) + ")"
                end if
                itemcolor = GetClassColor(inv.typeid)
            case scrolls
                if .scroll.eval = False then 
                    sret = "* "
                    sret += Trim$(inv.desc)
                else
                    sret += GetScrollName(inv)
                end if
                itemcolor = GetClassColor(inv.typeid)
            case weapons
                if .weapon.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                if .weapon.eval = True then
                    sret += " (" 
                    if .weapon.tohitmod >= 0 then sret += "+"
                    sret += str$(.weapon.tohitmod)
                    sret += ", " 
                    if .weapon.dammod >= 0 then sret += "+"
                    sret += Str$(.weapon.dammod) + ")"
                    if .weapon.cursed = True then
                        sret += " Cursed"
                    end if
                end if
                itemcolor = GetClassColor(inv.typeid)
            Case armors
                if .armor.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                if .armor.eval = True then
                    sret += " AC: " + Str$(.armor.ac) + " ("
                    If .armor.defmod >= 0 Then sret += "+"
                    sret += Str$(.armor.defmod) + ")"
                end if
                if .armor.eval = True and .armor.cursed = True then
                    sret += " Cursed"
                end if
                itemcolor = GetClassColor(inv.typeid)
            case lights
                sret += Trim$(inv.desc)
                If .light.id = torch Or .light.id = lantern Then
                    sret += " (" + Str$(.light.count) + " turns)"
                End If
                itemcolor = GetClassColor(inv.typeid)
            Case ammos
                sret += Trim$(inv.desc)
                sret += " (" + Str$(.ammo.count) + ")"
            Case shields
                if .shield.eval = False then sret = "* "
                sret += Trim$(inv.desc)
                if .shield.eval = True then
                    sret += " AC: "  + Str$(.shield.ac)
                    If .shield.defmod >= 0 Then sret += " (+"
                    sret += Str$(.shield.defmod) + ")"
                    if .shield.cursed = True then
                        sret += " Cursed"
                    end if
                end if
                itemcolor = GetClassColor(inv.typeid)
        end select
    end with
    if len(sret) > 0 then
        color itemcolor, fbBlack
    end if
    return sret
end function

sub PrintInventory
    dim sinv as string
        
    color fbWhite, fbBlack
    cls
    locate 4, 2
    print "Found Crown:      ";
    if player.hasorbs.hascrown = True then
        print "Yes"
    else
        print "No"
    end if
    locate 6, 2
    print "Found Red Orb:    ";
    if player.hasorbs.hasredorb = True then
        print "Yes"
    else
        print "No"
    end if
    locate 8, 2
    print "Found Blue Orb:   ";
    if player.hasorbs.hasblueorb = True then
        print "Yes"
    else
        print "No"
    end if
    locate 10, 2
    print "Found Green Orb:  ";
    if player.hasorbs.hasgreenorb = True then
        print "Yes"
    else
        print "No"
    end if
    locate 12, 2
    print "Found Yellow Orb: ";
    if player.hasorbs.hasyelloworb = True then
        print "Yes"
    else
        print "No"
    end if
    locate 14, 2
    print "Found White Orb:  ";
    if player.hasorbs.haswhiteorb = True then
        print "Yes"
    else
        print "No"
    end if
    
    locate 4, 40
    color fbWhite, fbBlack
    print "1 Right hand: ";
    sinv = GetInventoryItemDesc(player.righthand)
    print sinv
    locate 6, 40
    color fbWhite, fbBlack
    print "2 Left hand: ";
    sinv = GetInventoryItemDesc(player.lefthand)
    print sinv
    locate 8, 40
    color fbWhite, fbBlack
    print "3 Armor: ";
    sinv = GetInventoryItemDesc(player.parmor)
    print sinv
    locate 10, 40
    color fbWhite, fbBlack
    print "4 Ring Right: ";
    sinv = GetInventoryItemDesc(player.wright)
    print sinv
    locate 12, 40
    color fbWhite, fbBlack
    print "5 Ring Left: ";
    sinv = GetInventoryItemDesc(player.wleft)
    print sinv
    locate 14, 40
    color fbWhite, fbBlack
    print "6 Neck: ";
    sinv = GetInventoryItemDesc(player.wneck)
    print sinv
    locate 16, 40
    color fbWhite, fbBlack
    print "7 Light: ";
    sinv = GetInventoryItemDesc(player.haslight)
    print sinv
    color fbYellow, fbBlack
    locate 17, 2
    print string$(78, "-");
    color fbWhite, fbBlack
    locate 18, 2
    color fbWhite, fbBlack
    print "a: ";
    sinv = GetInventoryItemDesc(player.inventory(0))
    print sinv
    locate 20, 2
    color fbWhite, fbBlack
    print "b: ";
    sinv = GetInventoryItemDesc(player.inventory(1))
    print sinv
    locate 22, 2
    color fbWhite, fbBlack
    print "c: ";
    sinv = GetInventoryItemDesc(player.inventory(2))
    print sinv
    locate 24, 2
    color fbWhite, fbBlack
    print "d: ";
    sinv = GetInventoryItemDesc(player.inventory(3))
    print sinv
    locate 26, 2
    color fbWhite, fbBlack
    print "e: ";
    sinv = GetInventoryItemDesc(player.inventory(4))
    print sinv
    locate 28, 2
    color fbWhite, fbBlack
    print "f: ";
    sinv = GetInventoryItemDesc(player.inventory(5))
    print sinv
    locate 30, 2
    color fbWhite, fbBlack
    print "g: ";
    sinv = GetInventoryItemDesc(player.inventory(6))
    print sinv
    locate 32, 2
    color fbWhite, fbBlack
    print "h: ";
    sinv = GetInventoryItemDesc(player.inventory(7))
    print sinv
    locate 34, 2
    color fbWhite, fbBlack
    print "i: ";
    sinv = GetInventoryItemDesc(player.inventory(8))
    print sinv
    locate 36, 2
    color fbWhite, fbBlack
    print "j: ";
    sinv = GetInventoryItemDesc(player.inventory(9))
    print sinv
    locate 38, 2
    color fbWhite, fbBlack
    print "k: ";
    sinv = GetInventoryItemDesc(player.inventory(10))
    print sinv
    locate 40, 2
    color fbWhite, fbBlack
    print "l: ";
    sinv = GetInventoryItemDesc(player.inventory(11))
    print sinv
    locate 42, 2
    color fbWhite, fbBlack
    print "m: ";
    sinv = GetInventoryItemDesc(player.inventory(12))
    print sinv
    locate 44, 2
    color fbWhite, fbBlack
    print "n: ";
    sinv = GetInventoryItemDesc(player.inventory(13))
    print sinv
    locate 46, 2
    color fbWhite, fbBlack
    print "o: ";
    sinv = GetInventoryItemDesc(player.inventory(14))
    print sinv
    locate 48, 2
    color fbWhite, fbBlack
    print "p: ";
    sinv = GetInventoryItemDesc(player.inventory(15))
    print sinv
    locate 50, 2
    color fbWhite, fbBlack
    print "q: ";
    sinv = GetInventoryItemDesc(player.inventory(16))
    print sinv
    locate 52, 2
    color fbWhite, fbBlack
    print "r: ";
    sinv = GetInventoryItemDesc(player.inventory(17))
    print sinv
    locate 55, 2
    color fbYellow, fbBlack
    print "* denotes item not evaluated."
    color fbWhite, fbBlack
    locate 18, 40
    color fbWhite, fbBlack
    print "s: ";
    sinv = GetInventoryItemDesc(player.inventory(18))
    print sinv
    locate 20, 40
    color fbWhite, fbBlack
    print "t: ";
    sinv = GetInventoryItemDesc(player.inventory(19))
    print sinv
    locate 22, 40
    color fbWhite, fbBlack
    print "u: ";
    sinv = GetInventoryItemDesc(player.inventory(20))
    print sinv
    locate 24, 40
    color fbWhite, fbBlack
    print "v: ";
    sinv = GetInventoryItemDesc(player.inventory(21))
    print sinv
    locate 26, 40
    color fbWhite, fbBlack
    print "w: ";
    sinv = GetInventoryItemDesc(player.inventory(22))
    print sinv
    locate 28, 40
    color fbWhite, fbBlack
    print "x: ";
    sinv = GetInventoryItemDesc(player.inventory(23))
    print sinv
    locate 30, 40
    color fbWhite, fbBlack
    print "y: ";
    sinv = GetInventoryItemDesc(player.inventory(24))
    print sinv
    locate 32, 40
    color fbWhite, fbBlack
    print "z: ";
    sinv = GetInventoryItemDesc(player.inventory(25))
    print sinv
    color fbYellow, fbBlack
    locate 56, 2
    print string$(78, "-");
    
end sub

function GetInvKey(prompt as string) as string
    dim ky as string
    
    color fbYellow, fbBlack
    locate 58, 2
    print space$(78)
    locate 58, 2
    print prompt
    do
        ky = inkey$
    loop until ky <> ""
    locate 58, 2
    print space$(78)
    return ky
end function

sub SetEvalItem(inv as invtype)
    with inv
        select case .typeid
            case necklaces
                .necklace.eval = True
                player.attr.expr += .necklace.value
                player.attr.totexp += .necklace.value
                .necklace.value = 0
            Case potions
                .potion.eval = True
            case rings
                .ring.eval = True
                player.attr.expr += .ring.value
                player.attr.totexp += .ring.value
                .ring.value = 0
            Case wands
                .wand.eval = True
            case weapons
                .weapon.eval = True
            Case armors
                .armor.eval = True
            case shields
                .shield.eval = True
            case scrolls
                .scroll.eval = True
        end select
    end with
end sub

sub PrintInvMenu
    color fbYellow, fbBlack
    CenterText 2, "Inventory for " + ucase$(trim$(player.pname))
    color fbWhite, fbBlack
    locate 58, 2
    print space$(78)
    locate 58, 2
    Print "(e)val, e(x)amine, (w)ield/wear, (r)ead, re(m)ove, (d)rop, (q)uaff/eat, ESC"
end sub

function GetItemDR(inv as invtype) as integer
    with inv
        select case .typeid
            case necklaces
                return .necklace.dr
            case potions
                return .potion.dr
            case rings
                return .ring.dr
            case wands
                return .wand.dr
            case weapons
                return .weapon.dr
            Case armors
                return .armor.dr
            case shields
                return .shield.dr
            case scrolls
                return .scroll.dr
        end select
    end with
end function

sub DisplayItemMenu
    color fbYellow, fbBlack
    locate 58, 2
    print space$(78)
    locate 58, 2
    print "Press any key to continue."
    sleep
    do while inkey$="":loop
    locate 58, 2
    print space$(78)
end sub

Function GetRNEffectDesc(inv As invtype) As String
    dim effectid as integer
    dim sret as string
    dim cursed as integer
    
    with inv
        if .typeid = necklaces then
            effectid = .necklace.effect
            cursed = .necklace.cursed
        else
            effectid = .ring.effect
            cursed = .necklace.cursed
        end if
        select case effectid
            case rnstrength
                if cursed then
                    sret = "Str"
                else
                    sret = "Str"
                end if
            case rnendurance
                if cursed then
                    sret = "End"
                else
                    sret = "End"
                end if
            case rndexterity
                if cursed then
                    sret = "Dex"
                else
                    sret = "Dex"
                end if
            case rnagility
                if cursed then
                    sret = "Agl"
                else
                    sret = "Agl"
                end if
            case rnintelligence
                if cursed then
                    sret = "Int"
                else
                    sret = "Int"
                end if
            case rnvision
                if cursed then
                    sret = "Vision"
                else
                    sret = "Vision"
                end if
            case rnmelee
                if cursed then
                    sret = "Melee"
                else
                    sret = "Melee"
                end if
            case rndodge
                if cursed then
                    sret = "Dodge"
                else
                    sret = "Dodge"
                end if
            case rnscan
                if cursed then
                    sret = "Scan"
                else
                    sret = "Scan"
                end if
            case rnsword
                if cursed then
                    sret = "Sword"
                else
                    sret = "Sword"
                end if
            case rnaxe
                if cursed then
                    sret = "Axe"
                else
                    sret = "Axe"
                end if
            case rnspear
                if cursed then
                    sret = "Spear"
                else
                    sret = "Spear"
                end if
            case rnmace
                if cursed then
                    sret = "Mace"
                else
                    sret = "Mace"
                end if
            case rnflail
                if cursed then
                    sret = "Flail"
                else
                    sret = "Flail"
                end if
            case rnbow
                if cursed then
                    sret = "Bow"
                else
                    sret = "Bow"
                end if
            case rncrossbow
                if cursed then
                    sret = "CBow"
                else
                    sret = "CBow"
                end if
            case rnshield
                if cursed then
                    sret = "Shield"
                else
                    sret = "Shield"
                end if
            case rncombataware
                if cursed then
                    sret = "Cbt Aware"
                else
                    sret = "Cbt Aware"
                end if
            case rnstealth
                if cursed then
                    sret = "Stealth"
                else
                    sret = "Stealth"
                end if
            case rnsearch
                if cursed then
                    sret = "Search"
                else
                    sret = "Search"
                end if
            case rndisarmtrap
                if cursed then
                    sret = "Disarm Trap"
                else
                    sret = "Disarm Trap"
                end if
            case rnpicklock
                if cursed then
                    sret = "Picklock"
                else
                    sret = "Picklock"
                end if
            case rnreadancient
                if cursed then
                    sret = "Rd Ancient"
                else
                    sret = "Rd Ancient"
                end if
            case rneval
                if cursed then
                    sret = "Eval"
                else
                    sret = "Eval"
                end if
            case rnusemagic
                if cursed then
                    sret = "Use Magic"
                else
                    sret = "Use Magic"
                end if
            case rnarmor
                if cursed then
                    sret = "Armor"
                else
                    sret = "Armor"
                end if
            case rndefense
                if cursed then
                    sret = "Defense"
                else
                    sret = "Defense"
                end if
            case rntohit
                if cursed then
                    sret = "To-Hit"
                else
                    sret = "To-Hit"
                end if
            case rnmagicdef
                if cursed then
                    sret = "Magic Def"
                else
                    sret = "Magic Def"
                end if
            case rnmagicattack
                if cursed then
                    sret = "Magic Attack"
                else
                    sret = "Magic Attack"
                end if
            case rndamage
                if cursed then
                    sret = "Damage"
                else
                    sret = "Damage"
                end if
            case else
                sret = "No effect"
        end select
    end with
    
    return sret
end function

Function GetWeaponSkillName(inv As invtype) As String
    Dim skill As Integer
    
    skill = inv.weapon.skill
    Select Case skill
        Case wmelee: Return "Melee"
        Case wsword: Return "Sword"
        Case waxe: Return "Axe"
        Case wspear: Return "Spear"
        Case wmace: Return "Mace"
        Case wflail: Return "Flail"
        Case wbow: Return "Bow"
        Case wcrossbow: Return "Crossbow"
    End Select
End Function

sub DisplayItemInfo(inv as invtype)
    Dim As Integer row, col
    Dim As String idesc = ""
    
    Color fbWhite, fbBlack
    Cls
    DrawBox fbYellow, 2, 2, 76, 58
    Color fbWhite, fbBlack
    CenterText 59, "  Press any Key  "
    col = 4
    row = 4
    With inv
        Select Case .typeid
            Case lights
                idesc = Trim$(inv.desc)
                If .light.id = torch Or .light.id = lantern Then
                    Locate row, col
                    Print "Turns: " + Str$(.light.count)
                End If
            Case ammos
                idesc = Trim$(inv.desc)
                Locate row, col
                Print "Count: " + Str$(.ammo.count)
            Case supplies
                idesc = Trim$(inv.desc)
                If .supply.id = smeat Or .supply.id = sbread Or .supply.id = sbottle Then
                    Locate row, col
                    Print "Health: " + Str$(.supply.modifier)
                End If
            case necklaces
                idesc = Trim$(inv.desc)
                If .necklace.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    if .necklace.cursed = true then
                        print "Cursed"
                    else
                        print "Not cursed"
                    End If
                    row += 2
                    Locate row, col
                    if .necklace.magic = False then
                        print "Not magic"
                    else
                        Print GetRNEffectDesc(inv)
                        row += 2
                        Locate row, col
                        print "Mod: ";str$(.necklace.modifier)
                    end if
                Else
                    Locate row, col
                    print "Not evaluated"
                end if
            case potions
                idesc = Trim$(inv.desc)
                If .potion.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2                    
                    Locate row, col
                    Print "Effect: ";GetPotionEffect(inv)
                    row += 2
                    Locate row, col
                    Print "Mod: ";Str$(.potion.modifier)
                Else
                    Locate row, col
                    print "Not evaluated"
                end if
            case rings
                idesc = Trim$(inv.desc)
                If .ring.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    if .ring.cursed = true then
                        print "Cursed"
                    else
                        print "Not cursed"
                    End If
                    row += 2
                    Locate row, col
                    if .ring.magic = False then
                        print "Not magic"
                    else
                        Print GetRNEffectDesc(inv)
                        row += 2
                        Locate row, col
                        print "Mod: ";str$(.ring.modifier)
                    end if
                Else
                    Locate row, col
                    print "Not evaluated"
                end if
            case wands
                idesc = Trim$(inv.desc)
                If .wand.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    Print "Dam: ";Str$(.wand.damage)
                    row += 2
                    Locate row, col
                    Print "Charges: ";Str$(.wand.count)
                Else
                    Locate row, col
                    print "Not evaluated"
                end if
            case weapons
                idesc = Trim$(inv.desc)
                If .weapon.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    if .weapon.cursed = true then
                        print "Cursed"
                    else
                        print "Not cursed"
                    End If
                    row += 2
                    Locate row, col
                    Print "Hands: ";Str$(.weapon.hands)
                    row += 2
                    Locate row, col
                    Print "Str req: ";Str$(.weapon.strg)
                    row += 2
                    Locate row, col
                    Print "Skill: ";GetWeaponSkillName(inv)
                    row += 2
                    Locate row, col
                    Print "Damage: ";Str$(.weapon.damage)
                    row += 2
                    Locate row, col
                    Print "To hit mod: ";Str$(.weapon.tohitmod)
                    row += 2
                    Locate row, col
                    Print "Damage mod: ";Str$(.weapon.dammod)
                else
                    Locate row, col
                    Print "Not evaluated"
                end if
            Case armors
                idesc = Trim$(inv.desc)
                If .armor.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    If .armor.cursed = true Then
                        print "Cursed"
                    else
                        print "Not cursed"
                    end if
                    row += 2
                    Locate row, col
                    Print "Str req: ";Str$(.armor.strg)
                    row += 2
                    Locate row, col
                    Print "AC: ";Str$(.armor.ac)
                    row += 2
                    Locate row, col
                    Print "Def Mod: ";Str$(.armor.defmod)
                    row += 2
                    Locate row, col
                    Print "Def magic: ";Str$(.armor.defmagic)
                    row += 2
                    Locate row, col
                    Print "Magic mod: ";Str$(.armor.defmagicmod)
                Else
                    Locate row, col
                    Print "Not evaluated"
                end if
            case shields
                idesc = Trim$(inv.desc)
                If .armor.eval = True Then
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    If .shield.cursed = true Then
                        print "Cursed"
                    else
                        print "Not cursed"
                    end if
                    row += 2
                    Locate row, col
                    Print "Str req: ";Str$(.shield.strg)
                    row += 2
                    Locate row, col
                    Print "AC: ";Str$(.shield.ac)
                    row += 2
                    Locate row, col
                    Print "Def Mod: ";Str$(.shield.defmod)
                    row += 2
                    Locate row, col
                    Print "Def magic: ";Str$(.shield.defmagic)
                    row += 2
                    Locate row, col
                    Print "Magic mod: ";Str$(.shield.defmagicmod)
                Else
                    Locate row, col
                    Print "Not evaluated"
                end if
            case scrolls
                idesc = Trim$(inv.desc)
                If .scroll.eval = True Then
                    idesc = GetScrollName(inv)
                    Locate row, col
                    Print "Evaluated"
                    row += 2
                    Locate row, col
                    Print "Mod: ";Str$(.scroll.modifier)
                else
                    Locate row, col
                    Print "Not evaluated"
                end if
        end select
    End With
    CenterText 2, UCase$("  Details for " + idesc + "  ")
    Sleep
    Do:Loop While Inkey$<>""
end sub

function IsEvaluated(inv as invtype) as integer
    with inv
        select case .typeid
            case necklaces
                return .necklace.eval
            case potions
                return .potion.eval
            case rings
                return .ring.eval
            case wands
                return .wand.eval
            case weapons
                return .weapon.eval
            Case armors
                return .armor.eval
            case shields
                return .shield.eval
            case scrolls
                return .scroll.eval
        end select
    end with
end function

sub PrintInvMessage(mess as string)
    color fbYellow, fbBlack
    locate 58, 2
    print space$(78)
    locate 58, 2
    print mess
    sleep
    locate 58, 2
    print space$(78)
    do while inkey$<>"":loop
end sub

Sub ClearInvItem(inv As invtype)
    with inv
        select case .typeid
            case supplies
                .supply.id = 0
                .supply.count = 0
                .supply.eval = False
                .supply.modifier = 0
            case necklaces
                .necklace.id = 0
                .necklace.eval = False
                .necklace.cursed = False
                .necklace.modifier = 0
                .necklace.effect = 0
                .necklace.value = 0
                .necklace.dr = 0
            case potions
                .potion.id = 0
                .potion.eval = False
                .potion.effect = 0
                .potion.dr = 0
            case rings
                .ring.id = 0
                .ring.eval = False
                .ring.cursed = False
                .ring.modifier = 0
                .ring.effect = 0
                .ring.value = 0
                .ring.dr = 0
            case wands
                .wand.id = 0
                .wand.eval = False
                .wand.count = 0
                .wand.damage = 0
                .wand.dr = 0
            case weapons
                .weapon.id = 0
                .weapon.eval = False
                .weapon.hands = 1
                .weapon.strg = 0
                .weapon.tohitmod = 0
                .weapon.damage = 0
                .weapon.dammod = 0
                .weapon.cursed = False
                .weapon.dr = 0
                .weapon.skill = 0
            Case armors
                .armor.id = 0
                .armor.eval = False
                .armor.ac = 0
                .armor.defmod = 0
                .armor.defmagic = 0
                .armor.defmagicmod = 0
                .armor.strg = 0
                .armor.cursed = False
                .armor.dr = 0
            Case lights
                .light.id = 0
                .light.count = 0
                .light.range = 0
            Case ammos
                .ammo.id = 0
                .ammo.count = 0
            case shields
                .shield.id = 0
                .shield.eval = False
                .shield.ac = 0
                .shield.defmod = 0
                .shield.defmagic = 0
                .shield.defmagicmod = 0
                .shield.strg = 0
                .shield.cursed = False
                .shield.dr = 0
            Case scrolls
                .scroll.id = 0
                .scroll.dr = 0
                .scroll.eval = False
                .scroll.modifier = 0
        end select
        .typeid = 0
    end with
end sub

sub SwapInvItem(inv1 as invtype, inv2 as invtype)
    dim tmpinv as invtype
    'save inv1 to tempinv
    tmpinv = inv1
    'clear inv 1
    ClearInvItem inv1
    'load inv2 to inv1
    inv1 = inv2
    'clear inv2
    ClearInvItem inv2
    'move tmp to inv2
    inv2 = tmpinv
end sub

sub ClearItemCurse(inv as invtype)
    with inv
        if .typeid <> 0 then
            select case .typeid
            case necklaces
                if .necklace.cursed = True then
                    .necklace.cursed = False
                    .necklace.modifier *= -1
                end if
            case rings
                if .ring.cursed = True then
                    .ring.cursed = False
                    .ring.modifier *= -1
                end if
            case weapons
                if .weapon.cursed = True then
                    .weapon.tohitmod *= -1
                    .weapon.damage *= -1
                    .weapon.dammod *= -1
                    .weapon.cursed = False
                end if
            Case armors
                if .armor.cursed = True then
                    .armor.ac *= -1
                    .armor.defmod *= -1
                    .armor.defmagic *= -1
                    .armor.defmagicmod *= -1
                    .armor.cursed = False
                End If
            case shields
                If .shield.cursed = True Then
                    .shield.ac *= -1
                    .shield.defmod *= -1
                    .shield.defmagic *= -1
                    .shield.defmagicmod *= -1
                    .shield.cursed = False
                End If
            Case potions
                If .potion.cursed = True Then
                    .potion.cursed = False
                    .potion.modifier *= -1
                End If
            End Select
        end if
    end with
end sub

'clear all curses on carried items
sub ClearCurse
    dim i as integer
    
    'clear inventory curses
    for i = 0 to ubound(player.inventory)
        ClearItemCurse player.inventory(i)
    next i
    'clear worn items
    ClearItemCurse player.righthand
    ClearItemCurse player.lefthand
    ClearItemCurse player.parmor
    ClearItemCurse player.wright
    ClearItemCurse player.wleft
    ClearItemCurse player.wneck
end sub

'adds ring and necklace effects
sub AddRNEffect(inv as invtype)
    dim effectid as integer
    Dim modifier As Integer = 0
    
    with inv
        If .typeid = necklaces Then
            effectid = .necklace.effect
            modifier = .necklace.modifier
        ElseIf .typeid = rings Then
            effectid = .ring.effect
            modifier = .ring.modifier
        End If
        Select Case effectid
            Case rnstrength
                player.attr.modstrg += modifier
                UpdateHP
            Case rnendurance
                player.attr.modendu += modifier
                UpDateHP
            Case rndexterity
                player.attr.moddext += modifier
            Case rnagility
                player.attr.modagl += modifier
            Case rnintelligence
                player.attr.modintl += modifier
            Case rnvision
                player.attr.modvision += modifier
            Case rnmelee
                player.skill.modmelee += modifier
            Case rndodge
                player.skill.moddodge += modifier
            Case rnscan
                player.skill.modscan += modifier
            Case rnsword
                player.skill.modsword += modifier
            Case rnaxe
                player.skill.modaxe += modifier
            Case rnspear
                player.skill.modspear += modifier
            Case rnmace
                player.skill.modmace += modifier
            Case rnflail
                player.skill.modflail += modifier
            Case rnbow
                player.skill.modbow += modifier
            Case rncrossbow
                player.skill.modcrossbow += modifier
            Case rnshield
                player.skill.modshield += modifier
            Case rncombataware
                player.skill.modcaware += modifier
            Case rnstealth
                player.skill.modstealth += modifier
            Case rnsearch
                player.skill.modsearch += modifier
            Case rndisarmtrap
                player.skill.moddisarmtrap += modifier
            Case rnpicklock
                player.skill.modpicklock += modifier
            Case rnreadancient
                player.skill.modreadancient += modifier
            Case rneval
                player.skill.modevalmagic += modifier
            Case rnusemagic
                player.skill.modusemagicitem += modifier
            Case rnarmor
                player.modarmor += modifier
            Case rndefense
                player.moddefense += modifier
            Case rntohit
                player.modtohit += modifier
            Case rnmagicdef
                player.modmagicdef += modifier
            Case rnmagicattack
                player.modmagicattack += modifier
            Case rndamage
                player.moddamage += modifier
        End Select
    end with
end sub

'removes ring and necklace effects
Sub SubRNEffect(inv As invtype)
    Dim modifier As Integer = 0
    Dim effect As Integer
    
    With inv
        If .typeid = rings Then
            modifier = .ring.modifier
            effect = .ring.effect
        ElseIf .typeid = necklaces Then
            modifier = .necklace.modifier
            effect = .necklace.effect 
        End If
        Select Case effect 
            Case rnstrength
                player.attr.modstrg -= modifier
                UpdateHP
            Case rnendurance
                player.attr.modendu -= modifier
                UpdateHP
            Case rndexterity
                player.attr.moddext -= modifier
            Case rnagility
                player.attr.modagl -= modifier
            Case rnintelligence
                player.attr.modintl -= modifier
            Case rnvision
                player.attr.modvision -= modifier
            Case rnmelee
                player.skill.modmelee -= modifier
            Case rndodge
                player.skill.moddodge -= modifier
            Case rnscan
                player.skill.modscan -= modifier
            Case rnsword
                player.skill.modsword -= modifier
            Case rnaxe
                player.skill.modaxe -= modifier
            Case rnspear
                player.skill.modspear -= modifier
            Case rnmace
                player.skill.modmace -= modifier
            Case rnflail
                player.skill.modflail -= modifier
            Case rnbow
                player.skill.modbow -= modifier
            Case rncrossbow
                player.skill.modcrossbow -= modifier
            Case rnshield
                player.skill.modshield -= modifier
            Case rncombataware
                player.skill.modcaware -= modifier
            Case rnstealth
                player.skill.modstealth -= modifier
            Case rnsearch
                player.skill.modsearch -= modifier
            Case rndisarmtrap
                player.skill.moddisarmtrap -= modifier
            Case rnpicklock
                player.skill.modpicklock -= modifier
            Case rnreadancient
                player.skill.modreadancient -= modifier
            Case rneval
                player.skill.modevalmagic -= modifier
            Case rnusemagic
                player.skill.modusemagicitem -= modifier
            Case rnarmor
                player.modarmor -= modifier
            Case rndefense
                player.moddefense -= modifier
            Case rntohit
                player.modtohit -= modifier
            Case rnmagicdef
                player.modmagicdef -= modifier
            Case rnmagicattack
                player.modmagicattack -= modifier
            Case rndamage
                player.moddamage -= modifier
        End Select
    end with
end sub

Function GetFreehand(inv As invtype) As Integer
    Dim As Integer ret, ok
    
    'if carrying a two-handed weapon then no hands
    If player.righthand.typeid > 0 And player.lefthand.typeid > 0  Then
        ret = inone
    Else
        ok = true
        'see if inv item is a two-handed weapon
        If inv.typeid = weapons Then
            If inv.weapon.hands = 2 Then
                If (player.righthand.typeid > 0) Or (player.lefthand.typeid > 0) Then
                    ok = False
                    ret = inone
                End If
            End If
        End If
        'if a freehand check for two-handed weapon
        If ok Then
            'see if player is carrying a two-handed weapon
            If player.righthand.typeid = 0 Then
                If player.lefthand.typeid = weapons Then
                    If player.lefthand.weapon.hands = 2 Then
                        ret = inone
                    Else
                        ret = irighthand
                    End If
                Else
                    ret = irighthand
                End If
            ElseIf player.lefthand.typeid = 0 Then
                If player.righthand.typeid = weapons Then
                    If player.righthand.weapon.hands = 2 Then
                        ret = inone
                    Else
                        ret = ilefthand
                    End If
                Else
                    ret = ilefthand
                End If
            End If
        End If
    End If
    Return ret
End Function

sub WieldItem(inv as invtype)
    dim tmpinv as invtype
    Dim As Integer idx, freehand
    
    with inv
        select case .typeid
            case necklaces
                'nothing in slot now
                if player.wneck.typeid = 0 then
                    player.wneck = inv
                    'clear inv slot
                    ClearInvItem inv
                    'When a cursed item is worn, it takes effect
                    If player.wneck.necklace.cursed = True Then
                        player.wneck.necklace.eval = True
                    End If
                    If player.wneck.necklace.eval = True Then
                        AddRNEffect player.wneck
                    End If
                Else
                    If player.wneck.necklace.cursed = False Then
                        SwapInvItem player.wneck, inv
                        'When a cursed item is worn, it takes effect
                        If player.wneck.necklace.cursed = True Then
                            player.wneck.necklace.eval = True
                        End If
                        If player.wneck.necklace.eval = True Then
                            AddRNEffect player.wneck
                        End If
                    Else
                        PrintInvMessage "Cannot remove cursed necklace."
                    End If
                End If
            case rings
                'look for an empty slot
                if player.wright.typeid = 0 then
                    player.wright = inv
                    ClearInvItem inv
                    'When a cursed item is worn, it takes effect
                    If player.wright.ring.cursed = True Then
                        player.wright.ring.eval = True
                    End If
                    If player.wright.ring.eval = True Then 
                        AddRNEffect player.wright
                    End If
                elseif player.wleft.typeid = 0 then
                    player.wleft = inv
                    ClearInvItem inv
                    'When a cursed item is worn, it takes effect
                    If player.wleft.ring.cursed = True Then
                        player.wleft.ring.eval = True
                    End If
                    If player.wleft.ring.eval = True Then
                        AddRNEffect player.wleft
                    End If
                else
                    PrintInvMessage "No free hands to wear ring."
                end if
            Case wands
                freehand = GetFreehand(inv)
                If freehand = inone Then
                    PrintInvMessage "No free hands to wield wand."
                ElseIf freehand = irighthand Then
                    player.righthand = inv
                    ClearInvItem inv
                ElseIf freehand = ilefthand Then
                    player.lefthand = inv
                    ClearInvItem inv
                Else
                    PrintInvMessage "Error in hands routine."
                End If
            Case weapons
                If player.attr.strg >= .weapon.strg Then
                    freehand = GetFreehand(inv)
                    If freehand = inone Then
                        PrintInvMessage "No free hands to wield weapon."
                    ElseIf freehand = irighthand Then
                        player.righthand = inv
                        If player.righthand.weapon.cursed = True Then
                            player.righthand.weapon.eval = True
                        End If
                        ClearInvItem inv
                    ElseIf freehand = ilefthand Then
                        player.lefthand = inv
                        If player.lefthand.weapon.cursed = True Then
                            player.lefthand.weapon.eval = True
                        End If
                        ClearInvItem inv
                    Else
                        PrintInvMessage "Error in hands routine."
                    End If
                Else
                    PrintInvMessage "Not enough strength to wield weapon."
                End If
            Case armors
                If player.attr.strg >= .armor.strg Then
                    If player.parmor.typeid = 0 Then
                        player.parmor = inv
                        ClearInvItem inv
                        If player.parmor.armor.cursed = True Then
                            player.parmor.armor.eval = True
                        End If
                    Else
                        If player.parmor.armor.cursed = False Then
                            SwapInvItem player.parmor, inv
                            If player.parmor.armor.cursed = True Then
                                player.parmor.armor.eval = True
                            End If
                        Else
                            PrintInvMessage "Cannot remove cursed armor."
                        End If
                    End If
                Else
                    PrintInvMessage "Not enough strength to wield armor."
                End If
            case shields
                If player.attr.strg >= .shield.strg Then
                    freehand = GetFreehand(inv)
                    If freehand = inone Then
                        PrintInvMessage "No free hands to wield shield."
                    ElseIf freehand = irighthand Then
                        player.righthand = inv
                        If player.righthand.shield.cursed = True Then
                            player.righthand.shield.eval = True
                        End If
                        ClearInvItem inv
                    ElseIf freehand = ilefthand Then
                        player.lefthand = inv
                        If player.lefthand.shield.cursed = True Then
                            player.lefthand.shield.eval = True
                        End If
                        ClearInvItem inv
                    Else
                        PrintInvMessage "Error in hands routine."
                    End If
                Else
                    PrintInvMessage "Not enough strength to wield shield."
                End If
            case lights
                'nothing in slot now
                if player.haslight.typeid = 0 then
                    player.haslight = inv
                    ClearInvItem inv
                else
                    SwapInvItem player.haslight, inv
                end if
        end select
    end with
end sub

sub ReadScroll(inv as invtype)
    Dim As Integer dr, stat, cx, cy, done
    
    With inv.scroll
        If .eval = True Then
            dr = .dr
            stat = (player.skill.readancient / 10) + player.skill.modreadancient +  player.attr.modintl
            If GetRoll(stat, dr) Then
                player.attr.expr += dr
                player.attr.totexp += dr
                Select Case .id
                    Case healscroll
                        player.attr.currhp += .modifier
                        If player.attr.currhp > player.attr.maxhp Then
                            player.attr.currhp = player.attr.maxhp
                        End If
                        If player.attr.currhp < 0  Then
                            player.attr.currhp = 0
                            CheckForDead
                        End If
                    Case meleescroll
                        player.skill.melee += .modifier
                        If player.skill.melee < 0 Then
                            player.skill.melee = 1
                        End If
                    Case dodgescroll
                        player.skill.dodge += .modifier
                        If player.skill.dodge < 0 Then
                            player.skill.dodge = 1
                        End If
                    Case scanscroll
                        player.skill.scan += .modifier
                    Case swordscroll
                        player.skill.sword += .modifier
                        If player.skill.sword < 0 Then
                            player.skill.sword = 1
                        End If
                    Case axescroll
                        player.skill.axe += .modifier
                        If player.skill.axe < 0 Then
                            player.skill.axe = 1
                        End If
                    Case spearscroll
                        player.skill.spear += .modifier
                        If player.skill.spear < 0 Then
                            player.skill.spear = 1
                        End If
                    Case macescroll
                        player.skill.mace += .modifier
                        If player.skill.mace < 0 Then
                            player.skill.mace = 1
                        End If
                    Case flailscroll
                        player.skill.flail += .modifier
                        If player.skill.flail < 0 Then
                            player.skill.flail = 1
                        End If
                    Case bowscroll
                        player.skill.bow += .modifier
                        If player.skill.bow < 0 Then
                            player.skill.bow = 1
                        End If
                    Case crossbowscroll
                        player.skill.crossbow += .modifier
                        If player.skill.crossbow < 0 Then
                            player.skill.crossbow = 1
                        End If
                    Case shieldscroll
                        player.skill.shield += .modifier
                        If player.skill.shield < 0 Then
                            player.skill.shield = 1
                        End If
                    Case combatawarescroll
                        player.skill.caware += .modifier
                        If player.skill.caware < 0 Then
                            player.skill.caware = 1
                        End If
                    Case stealthscroll
                        player.skill.stealth += .modifier
                        If player.skill.stealth < 0 Then
                            player.skill.stealth = 1
                        End If
                    Case searchscroll
                        player.skill.search += .modifier
                        If player.skill.search < 0 Then
                            player.skill.search = 1
                        End If
                    Case disarmtrapscroll
                        player.skill.disarmtrap += .modifier
                        If player.skill.disarmtrap < 0 Then
                            player.skill.disarmtrap = 1
                        End If
                    Case picklockscroll
                        player.skill.picklock += .modifier
                        If player.skill.picklock < 0 Then
                            player.skill.picklock = 1
                        End If
                    Case readancientscroll
                        player.skill.readancient += .modifier
                        If player.skill.readancient < 0 Then
                            player.skill.readancient = 1
                        End If
                    Case evalscroll
                        player.skill.evalmagic += .modifier
                        If player.skill.evalmagic < 0 Then
                            player.skill.evalmagic = 1
                        End If
                    Case usemagicscroll
                        player.skill.usemagicitem += .modifier
                        If player.skill.usemagicitem < 0 Then
                            player.skill.usemagicitem = 1
                        End If
                    Case cursescroll
                        ClearCurse 
                    Case teleportscroll
                        Do
                            cx = GetRandom(2, dunw - 2)
                            cy = GetRandom(2, dunh - 2)
                            If levels.map(cx, cy) = mfloor Or levels.map(cx, cy) = water Then
                                If levels.issecret(cx, cy) = False Then
                                    If IsMonsterLoc(cx, cy) = False Then
                                        done = True
                                    End If
                                End If
                            End If
                        Loop Until done
                        player.pcoord.x = cx
                        player.pcoord.y = cy
                End Select
                #IfNDef cnosound
                PlayWavSound sndusei
                #endif
                PrintInvMessage "Read " + GetScrollName(inv) + "."
                ClearInvItem inv
            Else
                PrintInvMessage "Failed to read scroll."
            End If
        Else
            PrintInvMessage "Scroll not evaluated."
        End If
    end with
end sub

Sub QuaffItem(inv As invtype)
    Dim dr As Integer
    Dim stat As Integer
    Dim As Integer cx, cy
    Dim done As Integer = False
    
    If inv.typeid = supplies Then
        With inv.supply
            If .id = smeat Then
                player.attr.currhp += .modifier
                If player.attr.currhp > player.attr.maxhp Then
                    player.attr.currhp = player.attr.maxhp 
                End If
                #IfNDef cnosound
                PlayWavSound sndbite
                #endif
                PrintInvMessage "Ate some meat."
                ClearInvItem inv
            ElseIf .id = sbottle Then
                player.attr.currhp += .modifier
                If player.attr.currhp > player.attr.maxhp Then
                    player.attr.currhp = player.attr.maxhp 
                End If
                #IfNDef cnosound
                PlayWavSound snddrnk
                #endif
                PrintInvMessage "Drank some ale."
                ClearInvItem inv
            ElseIf .id = sbread Then
                player.attr.currhp += .modifier
                If player.attr.currhp > player.attr.maxhp Then
                    player.attr.currhp = player.attr.maxhp 
                End If
                #IfNDef cnosound
                PlayWavSound sndbite
                #endif
                PrintInvMessage "Ate some bread."
                ClearInvItem inv
            Else
               PrintInvMessage "Cannot consume item."
            End If
        End With
    ElseIf inv.typeid = potions Then
        With inv.potion
            dr = .dr
            stat = (player.skill.usemagicitem  / 10 ) + player.skill.modusemagicitem + player.attr.modintl
            If GetRoll(stat, dr) Then
                player.attr.expr += dr
                player.attr.totexp += dr
                Select Case .effect
                    Case pthealth
                        player.attr.currhp += .modifier
                        If player.attr.currhp > player.attr.maxhp Then
                            player.attr.currhp = player.attr.maxhp
                        End If
                        CheckForDead
                    Case ptstrength
                        player.attr.strg += .modifier
                        If player.attr.strg < 1 Then
                            player.attr.strg = 1
                        End If
                        UpdateHP
                    Case ptendurance
                        player.attr.endu += .modifier
                        If player.attr.endu < 1 Then
                            player.attr.endu = 1
                        End If
                         UpdateHP
                    Case ptdexterity
                        player.attr.dext += .modifier
                        If .modifier > 0 Then
                            UpdateDexSkills
                        End If
                        If player.attr.dext < 1 Then
                            player.attr.dext = 1
                        End If
                    Case ptagility
                        player.attr.agl += .modifier
                        If .modifier > 0 Then
                            UpdateAglSkills
                        End If
                        If player.attr.agl < 1 Then
                            player.attr.agl = 1
                        End If
                    Case ptintelligence
                        player.attr.intl += .modifier
                        If .modifier > 0 Then
                            UpdateIntSkills
                        End If
                        If player.attr.intl < 1 Then
                            player.attr.intl = 1
                        End If
                    Case ptvision
                        player.attr.vision += .modifier
                        If player.attr.vision < 1 Then
                            player.attr.vision = 1
                        End If
                        If player.attr.vision > vh Then
                            player.attr.vision = vh
                        End If
                End Select
                #IfNDef cnosound
                PlayWavSound snddrnk
                #endif
                PrintInvMessage "Quaffed potion of " + GetPotionEffect(inv)
                ClearInvItem inv
            Else
                PrintInvMessage "Nothing seemed to happen."
            End If
        End With
    End If
End Sub

function GetEmptyInvSlot() as integer
    dim ret as integer = -1
    dim i as integer
    
    For i = 0 To playerinv - 1
        if player.inventory(i).typeid = 0 then
            ret = i
            exit for
        end if
    next i
    
    return ret
    
end function

sub RemoveItem(invr as invtype, inv as invtype)
    with invr
        select case .typeid
            case necklaces
                if .necklace.cursed = True then
                    PrintInvMessage "Item is cursed and cannot be removed."
                Else
                    If .necklace.eval = True Then
                        SubRNEffect invr
                    End If
                    SwapInvItem invr, inv
                end if
            case rings
                if .ring.cursed = True then
                    PrintInvMessage "Item is cursed and cannot be removed."
                Else
                    If .ring.eval = True Then
                        SubRNEffect invr
                    End If
                    SwapInvItem invr, inv
                end if
            case wands
                SwapInvItem invr, inv
            case weapons
                if .weapon.cursed = True then
                    PrintInvMessage "Item is cursed and cannot be removed."
                else
                    SwapInvItem invr, inv
                end if
            Case armors
                if .armor.cursed = True then
                    PrintInvMessage "Item is cursed and cannot be removed."
                else
                    SwapInvItem invr, inv
                end if
            case shields
                if .shield.cursed = True then
                    PrintInvMessage "Item is cursed and cannot be removed."
                else
                    SwapInvItem invr, inv
                end if
            case lights
                SwapInvItem invr, inv
        end select
    end with
    ClearInvItem invr
end sub

Function OkayToDrop(tcoord As mcoord) As Integer
    If levels.map(tcoord.x, tcoord.y) = mfloor Or levels.map(tcoord.x, tcoord.y) = water Then
        If levels.item(tcoord.x, tcoord.y).typeid = 0 Then
            Return True
        Else
            Return false
        End If
    Else
        Return false
    End If
End Function

Function GetEmptyFloorSpace(ccoord As mcoord) As mcoord
    Dim As mcoord ecoord, tcoord
    Dim As Integer i
    
    ecoord.x = -1 
    ecoord.y = -1
    If OkayToDrop(ccoord) Then
        ecoord = ccoord
    Else
        For i = north To seast
            tcoord = GetCoord(i, ccoord)
            If OkayToDrop(tcoord) Then
                ecoord = tcoord
                Exit For
            End If
        Next
    End If
    Return ecoord
End Function

Sub DropItem(inv As invtype, ix As Integer, iy As Integer, showmessage As Integer = True)
    Dim As mcoord icoord, rcoord
    
    
    'make sure we have something to drop
    If inv.typeid > 0 Then
        icoord.x = ix
        icoord.y = iy
        rcoord = GetEmptyFloorSpace(icoord)
        If rcoord.x > -1 And rcoord.y > -1 Then
            ClearInvItem levels.item(rcoord.x, rcoord.y) 
            SwapInvItem inv, levels.item(rcoord.x, rcoord.y)
            ClearInvItem inv
        Else
            If showmessage Then
                PrintInvMessage "No empty map spots to drop item."
            End If
        end if
    Else
        If showmessage Then
            PrintInvMessage "Nothing to drop."
        End If
    end if
end sub

sub EvalItem(inv as invtype)
    dim dr as integer
    Dim stat As Integer
    
    dr = GetItemDR(inv)
    stat = (player.skill.evalmagic \ 10) + player.skill.modevalmagic + player.attr.modintl
    If GetRoll(stat, dr) Then
        player.attr.expr += dr
        player.attr.totexp += dr
        SetEvalItem inv
    else
        PrintInvMessage "Evaluation failed."
    end if
end sub

sub ShowInventory
    dim ky as string
    dim iky as string
    dim cky as integer
    dim invindex as integer
    dim dr as integer
    dim iseval as integer
    dim idx as integer
        
    Color fbYellow, fbBlack
    PrintInventory
    PrintInvMenu
    Do
        ky = inkey$
        ky = ucase$(ky)
        if ky = "E" then 'evaluate
            iky = GetInvKey("Enter inventory item to evaluate.")
            cky = asc(iky)
            if cky >= 97 and cky <= 122 then
                invindex = cky - 97
                iseval = IsEvaluated(player.inventory(invindex))
                if not iseval then
                    EvalItem player.inventory(invindex)
                end if
            ElseIf cky >= 49 And cky <=55 Then
                select case cky
                    case 49
                        iseval = IsEvaluated(player.righthand)
                        if not iseval then
                            EvalItem player.righthand
                        end if
                    case 50
                        iseval = IsEvaluated(player.lefthand)
                        if not iseval then
                            EvalItem player.lefthand
                        end if
                    case 51
                        iseval = IsEvaluated(player.parmor)
                        if not iseval then
                            EvalItem player.parmor
                        end if
                    case 52
                        iseval = IsEvaluated(player.wright)
                        if not iseval then
                            EvalItem player.wright
                            If player.wright.ring.eval = True Then
                                AddRNEffect player.wright
                            End If
                        end if
                    case 53
                        iseval = IsEvaluated(player.wleft)
                        if not iseval then
                            EvalItem player.wleft
                            If Player.wleft.ring.eval = True Then
                                AddRNEffect player.wleft
                            End If
                        end if
                    case 54
                        iseval = IsEvaluated(player.wneck)
                        if not iseval then
                            EvalItem player.wneck
                            If player.wneck.necklace.eval = True Then
                                AddRNEffect player.wneck
                            End If
                        end if
                    case 55
                        iseval = IsEvaluated(player.haslight)
                        if not iseval then
                            EvalItem player.haslight
                        end if
                end select
            end if
        elseif ky = "X" then 'examine
            iky = GetInvKey("Enter inventory item to examine.")
            cky = asc(iky)
            if cky >= 97 and cky <= 122 then
                invindex = cky - 97
                DisplayItemInfo player.inventory(invindex)
                PrintInventory
                PrintInvMenu
            elseif cky >= 49 and cky <= 55 then
                select case cky
                    case 49
                        DisplayItemInfo player.righthand
                    case 50
                        DisplayItemInfo player.lefthand
                    case 51
                        DisplayItemInfo player.parmor
                    case 52
                        DisplayItemInfo player.wright
                    case 53
                         DisplayItemInfo player.wleft
                    case 54
                        DisplayItemInfo player.wneck
                    case 55
                        DisplayItemInfo player.haslight
                end select
            end if
        elseif ky = "W" then 'wield
            iky = GetInvKey("Enter inventory item to wield/wear.")
            cky = asc(iky)
            if cky >= 97 and cky <= 122 then
                invindex = cky - 97
                WieldItem player.inventory(invindex)
                PrintInventory
                PrintInvMenu
            end if
        elseif ky = "D" then 'drop
            iky = GetInvKey("Enter inventory item to drop.")
            cky = asc(iky)
            if cky >= 97 and cky <= 122 then
                invindex = cky - 97
                DropItem player.inventory(invindex), player.pcoord.x, player.pcoord.y
            elseif cky >= 49 and cky <= 55 then
                select case cky
                    case 49
                        DropItem player.righthand, player.pcoord.x, player.pcoord.y
                    case 50
                        DropItem player.lefthand, player.pcoord.x, player.pcoord.y
                    case 51
                        DropItem player.parmor, player.pcoord.x, player.pcoord.y
                    case 52
                        DropItem player.wright, player.pcoord.x, player.pcoord.y
                    case 53
                         DropItem player.wleft, player.pcoord.x, player.pcoord.y
                    case 54
                        DropItem player.wneck, player.pcoord.x, player.pcoord.y
                    case 55
                        DropItem player.haslight, player.pcoord.x, player.pcoord.y
                end select
            end if
        elseif ky = "R" then 'read scroll
            iky = GetInvKey("Enter inventory item to read.")
            cky = Asc(iky)
            If cky >= 97 And cky <= 122 Then
                invindex = cky - 97
                If player.inventory(invindex).typeid = scrolls Then
                    ReadScroll player.inventory(invindex)
                End If
            End If
        ElseIf ky = "M" Then 'remove
            iky = GetInvKey("Enter inventory item to remove.")
            cky = Asc(iky)
            If cky >= 49 And cky <= 55 Then
                idx = GetEmptyInvSlot()
                if idx > -1 then
                    select case cky
                        case 49
                            RemoveItem player.righthand, player.inventory(idx)
                        case 50
                            RemoveItem player.lefthand, player.inventory(idx)
                        case 51
                            RemoveItem player.parmor, player.inventory(idx)
                        case 52
                            RemoveItem player.wright, player.inventory(idx)
                        case 53
                            RemoveItem player.wleft, player.inventory(idx)
                        case 54
                            RemoveItem player.wneck, player.inventory(idx)
                        case 55
                            RemoveItem player.haslight, player.inventory(idx)
                    end select
                else
                    PrintInvMessage "No empty inventory slots."
                end if
            End If
        ElseIf ky = "Q" Then
            iky = GetInvKey("Enter inventory item to quaff/eat.")
            cky = Asc(iky)
            If cky >= 97 And cky <= 122 Then
                invindex = cky - 97
                If player.inventory(invindex).typeid = potions Or _
                   player.inventory(invindex).typeid = supplies Then
                    QuaffItem player.inventory(invindex)
                End If
            End If
        End If
        If ky <> "" Then
            PrintInventory
            PrintInvMenu
        End If
    Loop Until ky = key_esc
    Cls
end sub

sub GetInvItem
    dim idx as integer
    
    'make sure we have something to get
    if levels.item(player.pcoord.x, player.pcoord.y).typeid > 0 then
        'get empty inv slot
        idx = GetEmptyInvSlot
        if idx > -1 then
            'get the item
            SwapInvItem player.inventory(idx), levels.item(player.pcoord.x, player.pcoord.y)
            ClearInvItem levels.item(player.pcoord.x, player.pcoord.y)
            PrintMessage "Added " + Trim$(player.inventory(idx).desc) + " to pack."
            #IfNDef cnosound
            PlayWavSound sndzipr
            #endif
        else
            PrintMessage "No empty inventory slots."
        end if
    end if
end sub

Function HasAmmo(weap As weapontype) As Integer
    Dim ret As Integer = False
    Dim i As Integer
    Dim ammotype As Integer
    
    With weap
        If .id = sling Then
            ammotype = pebbles
        ElseIf .id = shortbow Then
            ammotype = arrows
        ElseIf .id = longbow Then
            ammotype = arrows
        ElseIf .id = bonebow Then
            ammotype = arrows
        ElseIf .id = adaminebow Then
            ammotype = arrows
        ElseIf .id = lightcrossbow Then
            ammotype = bolts
        ElseIf .id = heavycrossbow Then
            ammotype = bolts
        ElseIf .id = barrelcrossbow Then
            ammotype = bolts
        End If
    End With
    
    For i = 0 To UBound(player.inventory)
        If player.inventory(i).typeid = ammos Then
            If player.inventory(i).ammo.id = ammotype Then
                ret = True
                Exit For
            End If        
        End If
    Next
    Return ret
End Function

Sub DecAmmo(weap As weapontype)
    Dim i As Integer
    Dim ammotype As Integer
    
    With weap
        If .id = sling Then
            ammotype = pebbles
        ElseIf .id = shortbow Then
            ammotype = arrows
        ElseIf .id = longbow Then
            ammotype = arrows
        ElseIf .id = bonebow Then
            ammotype = arrows
        ElseIf .id = adaminebow Then
            ammotype = arrows
        ElseIf .id = lightcrossbow Then
            ammotype = bolts
        ElseIf .id = heavycrossbow Then
            ammotype = bolts
        ElseIf .id = barrelcrossbow Then
            ammotype = bolts
        End If
    End With
    
    For i = 0 To UBound(player.inventory)
        If player.inventory(i).typeid = ammos Then
            If player.inventory(i).ammo.id = ammotype Then
                player.inventory(i).ammo.count -= 1
                If player.inventory(i).ammo.count <= 0 Then
                    ClearInvItem player.inventory(i)
                End If
                Exit For
            End If        
        End If
    Next
End Sub

