' Deep Deadly Dungeons
' (C)2005 by Richard Clark rickclark58@yahoo.com
'
' Compiled using FB version .15b
'
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'This file contains all the stat related routines.
'

sub GetAttributes
    'set the attribute values
    player.attr.strg = GetRandom(50, 100)
    player.attr.endu = GetRandom(50, 100)
    player.attr.dext = GetRandom(50, 100)
    player.attr.agl = GetRandom(50, 100)
    player.attr.intl = GetRandom(50, 100)
    player.attr.vision = GetRandom(1, 5)
    player.attr.recovery = GetRandom(1, 50)
    player.attr.maxhp = player.attr.strg + player.attr.endu
    player.attr.currhp = player.attr.maxhp
    player.attr.expr = GetRandom(1, 100) * 10
    player.attr.totexp = player.attr.expr
    player.attr.modstrg = 0
    player.attr.modendu = 0
    player.attr.moddext = 0
    player.attr.modagl = 0
    player.attr.modintl = 0
    player.attr.modvision = 0
    player.coins = GetRandom(1, 100)
    player.attr.expr += player.coins
    player.attr.totexp += player.coins
    'set the skills
    player.skill.melee = GetRandom(1, player.attr.agl) + 10
    player.skill.dodge = GetRandom(1, player.attr.agl) + 10
    player.skill.scan = GetRandom(1, player.attr.intl) + 10
    player.skill.sword = GetRandom(1, player.attr.dext) + 10
    player.skill.axe = GetRandom(1, player.attr.dext) + 10
    player.skill.spear = GetRandom(1, player.attr.dext) + 10
    player.skill.mace = GetRandom(1, player.attr.dext) + 10
    player.skill.flail = GetRandom(1, player.attr.dext) + 10
    player.skill.bow = GetRandom(1, player.attr.dext) + 10
    player.skill.crossbow = GetRandom(1, player.attr.dext) + 10
    player.skill.shield = GetRandom(1, player.attr.agl) + 10
    player.skill.caware = GetRandom(1, player.attr.intl) + 10
    player.skill.stealth = GetRandom(1, player.attr.agl) + 10
    player.skill.search = GetRandom(1, player.attr.intl) + 10
    player.skill.disarmtrap = GetRandom(1, player.attr.dext) + 10
    player.skill.picklock = GetRandom(1, player.attr.dext) + 10
    player.skill.readancient = GetRandom(1, player.attr.intl) + 10
    player.skill.evalmagic = GetRandom(1, player.attr.intl) + 10
    player.skill.usemagicitem = GetRandom(1, player.attr.intl) + 10
    player.skill.modmelee = 0
    player.skill.moddodge = 0
    player.skill.modscan = 0
    player.skill.modsword = 0
    player.skill.modaxe = 0
    player.skill.modspear = 0
    player.skill.modmace = 0
    player.skill.modflail = 0
    player.skill.modbow = 0
    player.skill.modcrossbow = 0
    player.skill.modshield = 0
    player.skill.modcaware = 0
    player.skill.modstealth = 0
    player.skill.modsearch = 0
    player.skill.moddisarmtrap = 0
    player.skill.modpicklock = 0
    player.skill.modreadancient = 0
    player.skill.modevalmagic = 0
    player.skill.modusemagicitem = 0
    player.moddefense = 0
    player.modtohit = 0
    player.moddamage = 0
    player.modarmor = 0
    player.modmagicattack = 0
    player.modmagicdef = 0
    player.isdodging = False
end sub

Sub PrintAttributes
    Dim As Integer row, col
    
    col = 2
    row = 6
    'display the attribute set
    color fbYellow, fbBlack
    Locate row, col
    print "Attributes (Modifier)"
    Color fbWhite, fbBlack
    row += 2
    Locate row, col
    print "Strength:"; player.attr.strg;
    print " ("; 
    if player.attr.modstrg >= 0 then print "+";
    print str$(player.attr.modstrg);
    print ")"
    row += 2
    Locate row, col
    print "Endurance:"; player.attr.endu;
    print " ("; 
    if player.attr.modendu >= 0 then print "+";
    print str$(player.attr.modendu);
    print ")"
    row += 2
    Locate row, col
    print "Dexterity:"; player.attr.dext;
    print " ("; 
    if player.attr.moddext >= 0 then print "+";
    print str$(player.attr.moddext);
    print ")"
    row += 2
    Locate row, col
    print "Agility:"; player.attr.agl;
    print " ("; 
    if player.attr.modagl >= 0 then print "+";
    print str$(player.attr.modagl);
    print ")"
    row += 2
    Locate row, col
    Print "Intelligence:"; player.attr.intl;
    Print " ("; 
    If player.attr.modintl >= 0 Then Print "+";
    Print Str$(player.attr.modintl);
    Print ")"
    row += 2
    Locate row, col
    print "Vision:"; player.attr.vision;
    print " ("; 
    if player.attr.modvision >= 0 then print "+";
    print str$(player.attr.modvision);
    print ")"
    row += 2
    Locate row, col
    Print "Recovery:"; player.attr.recovery;
    Print " ("; 
    If player.attr.modrecov >= 0 Then Print "+";
    Print Str$(player.attr.modrecov);
    Print ")"
    row += 4
    Locate row, col
    print "To-Hit mod:";
    if player.modtohit >= 0 then print " +";
    print str$(player.modtohit)
    row += 2
    Locate row, col
    print "Damage mod:";
    if player.moddamage >= 0 then print " +";
    print str$(player.moddamage)
    row += 2
    Locate row, col
    print "Defense mod:";
    if player.moddefense >= 0 then print " +";
    print str$(player.moddefense)
    row += 2
    Locate row, col
    print "Armor mod:";
    if player.modarmor >= 0 then print " +";
    print str$(player.modarmor)
    row += 2
    Locate row, col
    print "Magic Att mod:";
    if player.modmagicattack >= 0 then print " +";
    print str$(player.modmagicattack)
    row += 2
    Locate row, col
    print "Magic Def mod:";
    if player.modmagicdef >= 0 then print " +";
    print str$(player.modmagicdef)
    row += 4
    Locate row, col
    print "Max HP:"; player.attr.maxhp
    row += 2
    Locate row, col
    print "Current HP:"; player.attr.currhp
    row += 2
    Locate row, col
    print "Experience:"; player.attr.expr
    row += 2
    Locate row, col
    print "Total Exp:"; player.attr.totexp
    'display the skills
    col = 30
    row = 6
    Color fbYellow, fbBlack
    Locate row, col
    print "Skills (Modifier)"
    color fbWhite, fbBlack
    row += 2
    Locate row, col
    print "Melee Combat:"; player.skill.melee;
    print " ("; 
    if player.skill.modmelee >= 0 then print "+";
    print str$(player.skill.modmelee);
    print ")"
    row += 2
    Locate row, col
    print "Dodge:"; player.skill.dodge;
    print " ("; 
    if player.skill.moddodge >= 0 then print "+";
    print str$(player.skill.moddodge);
    print ")"
    row += 2
    Locate row, col
    print "Scan:"; player.skill.scan;
    print " ("; 
    if player.skill.modscan >= 0 then print "+";
    print str$(player.skill.modscan);
    print ")"
    row += 2
    Locate row, col
    print "Sword:"; player.skill.sword;
    print " ("; 
    if player.skill.modsword >= 0 then print "+";
    print str$(player.skill.modsword);
    print ")"
    row += 2
    Locate row, col
    print "Axe:"; player.skill.axe;
    print " ("; 
    if player.skill.modaxe >= 0 then print "+";
    print str$(player.skill.modaxe);
    print ")"
    row += 2
    Locate row, col
    print "Spear:"; player.skill.spear;
    print " ("; 
    if player.skill.modspear >= 0 then print "+";
    print str$(player.skill.modspear);
    print ")"
    row += 2
    Locate row, col
    print "Mace:"; player.skill.mace;
    print " ("; 
    if player.skill.modmace >= 0 then print "+";
    print str$(player.skill.modmace);
    print ")"
    row += 2
    Locate row, col
    print "Flail:"; player.skill.flail;
    print " ("; 
    if player.skill.modflail >= 0 then print "+";
    print str$(player.skill.modflail);
    print ")"
    row += 2
    Locate row, col
    print "Bow:"; player.skill.bow;
    print " ("; 
    if player.skill.modbow >= 0 then print "+";
    print str$(player.skill.modbow);
    print ")"
    row += 2
    Locate row, col
    print "Crossbow:"; player.skill.crossbow;
    print " ("; 
    if player.skill.modcrossbow >= 0 then print "+";
    print str$(player.skill.modcrossbow);
    print ")"
    row += 2
    Locate row, col
    print "Shield:"; player.skill.shield;
    print " ("; 
    if player.skill.modshield >= 0 then print "+";
    print str$(player.skill.modshield);
    print ")"
    row += 2
    Locate row, col
    print "Combat Awareness:"; player.skill.caware;
    print " ("; 
    if player.skill.modcaware >= 0 then print "+";
    print str$(player.skill.modcaware);
    print ")"
    row += 2
    Locate row, col
    print "Stealth:"; player.skill.stealth;
    print " ("; 
    if player.skill.modstealth >= 0 then print "+";
    print str$(player.skill.modstealth);
    print ")"
    row += 2
    Locate row, col
    print "Search:"; player.skill.search;
    print " ("; 
    if player.skill.modsearch >= 0 then print "+";
    print str$(player.skill.modsearch);
    print ")"
    row += 2
    Locate row, col
    print "Disarm Trap:"; player.skill.disarmtrap;
    print " ("; 
    if player.skill.moddisarmtrap >= 0 then print "+";
    print str$(player.skill.moddisarmtrap);
    print ")"
    row += 2
    Locate row, col
    print "Picklock:"; player.skill.picklock;
    print " ("; 
    if player.skill.modpicklock >= 0 then print "+";
    print str$(player.skill.modpicklock);
    print ")"
    row += 2
    Locate row, col
    print "Read Ancient:"; player.skill.readancient;
    print " ("; 
    if player.skill.modreadancient >= 0 then print "+";
    print str$(player.skill.modreadancient);
    print ")"
    row += 2
    Locate row, col
    print "Evalulate Magic Item:"; player.skill.evalmagic;
    print " ("; 
    if player.skill.modevalmagic >= 0 then print "+";
    print str$(player.skill.modevalmagic);
    print ")"
    row += 2
    Locate row, col
    print "Use Magic Item:"; player.skill.usemagicitem;
    print " ("; 
    if player.skill.modusemagicitem >= 0 then print "+";
    print str$(player.skill.modusemagicitem);
    print ")"
end sub


Sub PrintStats
    Dim As Integer row, col
    
   'display the attribute set
    color fbYellow, fbBlack
    CenterText 2, "Improve Chracter"
    row = 6
    col = 2
    Locate row, col
    Print "Attributes"
    row += 2
    Locate row, col
    Print "1000 xp required"
    color fbWhite, fbBlack
    row += 2
    Locate row, col
    Print "1 Strength:"; player.attr.strg
    row += 2
    Locate row, col
    Print "2 Endurance:"; player.attr.endu
    row += 2
    Locate row, col
    Print "3 Dexterity:"; player.attr.dext
    row += 2
    Locate row, col
    Print "4 Agility:"; player.attr.agl
    row += 2
    Locate row, col
    Print "5 Intelligence:"; player.attr.intl
    row += 2
    Locate row, col
    Print "6 Vision:"; player.attr.vision
    row += 2
    Locate row, col
    Print "7 Recovery:"; player.attr.recovery
    row += 2
    Locate row, col
    Print "Max HP = str + end"
    
   'display the skills
    Color fbYellow, fbBlack
    row = 6
    col = 25
    Locate row, col
    Print "Skills (required xp) (attr base)"
    color fbWhite, fbBlack
    row += 2
    Locate row, col
    Print "8 (30) (agl) Melee Combat:"; player.skill.melee
    row += 2
    Locate row, col
    Print "9 (30) (agl) Dodge:"; player.skill.dodge
    row += 2
    Locate row, col
    Print "10 (40) (intl) Scan:"; player.skill.scan
    row += 2
    Locate row, col
    Print "11 (40) (dext) Sword:"; player.skill.sword
    row += 2
    Locate row, col
    Print "12 (60) (dext) Axe:"; player.skill.axe
    row += 2
    Locate row, col
    Print "13 (40) (dext) Spear:"; player.skill.spear
    row += 2
    Locate row, col
    Print "14 (30) (dext) Mace:"; player.skill.mace
    row += 2
    Locate row, col
    Print "15 (60) (dext) Flail:"; player.skill.flail
    row += 2
    Locate row, col
    Print "16 (50) (dext) Bow:"; player.skill.bow
    row += 2
    Locate row, col
    Print "17 (30) (dext) Crossbow:"; player.skill.crossbow
    row += 2
    Locate row, col
    Print "18 (40) (agl) Shield:"; player.skill.shield
    row += 2
    Locate row, col
    Print "19 (30) (intl) Combat Awareness:"; player.skill.caware
    row += 2
    Locate row, col
    Print "20 (50) (agl) Stealth:"; player.skill.stealth
    row += 2
    Locate row, col
    Print "21 (40) (intl) Search:"; player.skill.search
    row += 2
    Locate row, col
    Print "22 (50) (dext) Disarm Trap:"; player.skill.disarmtrap
    row += 2
    Locate row, col
    Print "23 (40) (dext) Picklock:"; player.skill.picklock
    row += 2
    Locate row, col
    Print "24 (40) (intl) Read Ancient:"; player.skill.readancient
    row += 2
    Locate row, col
    Print "25 (30) (intl) Evalulate Magic Item:"; player.skill.evalmagic
    row += 2
    Locate row, col
    Print "26 (60) (intl) Use Magic Item:"; player.skill.usemagicitem
    color fbYellow, fbBlack
    Centertext 52, "Enter number of stat to improve. Q to quit."
    color fbWhite, fbBlack
    Locate 56, 2
    Print "Available Experience:"; player.attr.expr; Space$(40);
end sub

'returns the amount of improvement for a skill
function ImproveSkill(skillamt as integer) as integer
    If skillamt < 250 Then
        Return GetRandom(1, 30)
    ElseIf skillamt > 249 And skillamt < 500 Then
        Return GetRandom(1, 20)
    ElseIf skillamt > 499 And skillamt < 750 Then
        Return GetRandom(1, 10)
    else
        return 1
    end if
end function

Sub UpdateHP
    player.attr.maxhp = player.attr.strg + player.attr.endu + player.attr.modstrg + player.attr.modendu
End Sub

Sub UpdateDexSkills
    'Update all dexterity based skills
    player.skill.sword += ImproveSkill(player.skill.sword)
    player.skill.axe += ImproveSkill(player.skill.axe)
    player.skill.spear += ImproveSkill(player.skill.spear)
    player.skill.mace += ImproveSkill(player.skill.mace)
    player.skill.flail += ImproveSkill(player.skill.flail)
    player.skill.bow += ImproveSkill(player.skill.bow)
    player.skill.crossbow += ImproveSkill(player.skill.crossbow) 
    player.skill.disarmtrap += ImproveSkill(player.skill.disarmtrap)
    player.skill.picklock += ImproveSkill(player.skill.picklock)
End Sub

Sub UpdateAglSkills
    player.skill.melee += ImproveSkill(player.skill.melee)
    player.skill.dodge += ImproveSkill(player.skill.dodge)
    player.skill.shield += ImproveSkill(player.skill.shield)
    player.skill.stealth += ImproveSkill(player.skill.stealth)
End Sub

Sub UpdateIntSkills
    player.skill.caware += ImproveSkill(player.skill.caware)
    player.skill.search += ImproveSkill(player.skill.search)
    player.skill.readancient += ImproveSkill(player.skill.readancient)
    player.skill.evalmagic += ImproveSkill(player.skill.evalmagic)
    player.skill.usemagicitem += ImproveSkill(player.skill.usemagicitem)
    player.skill.scan += ImproveSkill(player.skill.scan)
End Sub

sub DoImproveCharacter
    Dim ky As String
    Dim As Integer kn, row, col
    
    row = 58
    col = 2
    Cls
    PrintStats
    do
        color fbWhite, fbBlack
        Locate row, col
        input "Enter number of stat to improve";ky
        Locate row, col
        print space$(79);
        If Len(ky) > 0 Then
            If ky = "iamacheater" Then
                If cheater = True Then
                    cheater = False
                Else
                    cheater = True
                    'print cheat codes
                    
                End If
            End If
            If ky = "easteregg" Then
                If easteregg = True Then
                    easteregg = False
                Else
                    easteregg = True
                End If
            End If
            kn = val(ky)
            If kn > 0 And kn < 8 Then 'upgrading attributes
                If player.attr.expr >= 1000 Then
                    If kn = 1 Then
                        'increase the strength
                        player.attr.strg += 1
                        player.attr.expr -= 1000
                        'update the max hp
                        UpdateHp
                        'Update all strength based skills
                        PrintStats
                    ElseIf kn = 2 Then
                        'increase the endurance
                        player.attr.endu += 1
                        player.attr.expr -= 1000
                        'update the max hp
                        UpdateHP
                        PrintStats
                    ElseIf kn = 3 Then
                        'increase the dexterity
                        player.attr.dext += 1
                        player.attr.expr -= 1000
                        UpdateDexSkills
                        PrintStats
                    ElseIf kn = 4 Then
                        'increase the agility
                        player.attr.agl += 1
                        player.attr.expr -= 1000
                        'Update all agility based skills
                        UpdateAglSkills
                        PrintStats
                    ElseIf kn = 5 Then
                        'increase the intellignce
                        player.attr.intl += 1
                        player.attr.expr -= 1000
                        'Update all intelligence based skills
                        UpdateIntSkills
                        PrintStats
                    ElseIf kn = 6 Then
                        If player.attr.vision < vh Then
                            'increase the vision
                            player.attr.vision += 1
                            player.attr.expr -= 1000
                            PrintStats
                        Else
                            Locate row, col
                            Color fbYellow, fbBlack
                            Print "Vision is already at max amount.";
                            Sleep
                            Locate row, col
                            Print Space$(79);
                        End If
                    ElseIf kn = 7 Then
                        If player.attr.recovery < 99 Then 
                            'increase recovery
                            player.attr.recovery += 1
                            player.attr.expr -= 1000
                            PrintStats
                        Else  
                            Locate row, col
                            Color fbYellow, fbBlack
                            Print "Recovery is already at max amount.";
                            Sleep
                            Locate row, col
                            Print Space$(79);
                        End If
                    end if
                else
                    Locate row, col
                    color fbYellow, fbBlack
                    Print "Attributes require at least 1000 xp to upgrade. Press any key.";
                    sleep
                    locate row, col
                    Print Space$(79);
                End If
            ElseIf kn > 7 And kn < 27 Then 'upgrading skills
                If kn = 8 Then
                    If player.attr.expr >= 30 Then
                        player.skill.melee += ImproveSkill(player.skill.melee)
                        player.attr.expr -= 30
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Melee requires 30 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 9 Then
                    If player.attr.expr >= 30 Then
                        player.skill.dodge += ImproveSkill(player.skill.dodge)
                        player.attr.expr -= 30
                        PrintStats
                    else
                        Locate row, col
                        Color fbYellow, fbBlack
                        Print "Dodge requires 30 xp to upgrade. Press any key.";
                        Sleep
                        Locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 10 Then
                    If player.attr.expr >= 40 Then
                        player.skill.scan += ImproveSkill(player.skill.scan)
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Scan requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 11 Then
                    If player.attr.expr >= 40 Then
                        player.skill.sword += ImproveSkill(player.skill.sword) 
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Sword requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 12 Then
                    If player.attr.expr >= 60 Then
                        player.skill.axe += ImproveSkill(player.skill.axe)
                        player.attr.expr -= 60
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Axe requires 60 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 13 Then
                    If player.attr.expr >= 40 Then
                        player.skill.spear += ImproveSkill(player.skill.spear)
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Spear requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 14 Then
                    If player.attr.expr >= 30 Then
                        player.skill.mace += ImproveSkill(player.skill.mace)
                        player.attr.expr -= 30
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Mace requires 30 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 15 Then
                    If player.attr.expr >= 60 Then
                        player.skill.flail += ImproveSkill(player.skill.flail)
                        player.attr.expr -= 60
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Flail requires 60 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 16 Then
                    If player.attr.expr >= 50 Then
                        player.skill.bow += ImproveSkill(player.skill.bow)
                        player.attr.expr -= 50
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Bow requires 50 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 17 Then
                    If player.attr.expr >= 30 Then
                        player.skill.crossbow += ImproveSkill(player.skill.crossbow) 
                        player.attr.expr -= 30
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Crossbow requires 30 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 18 Then
                    If player.attr.expr >= 40 Then
                        player.skill.shield += ImproveSkill(player.skill.shield)
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Shield requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 19 Then
                    If player.attr.expr >= 30 Then
                        player.skill.caware += ImproveSkill(player.skill.caware)
                        player.attr.expr -= 30
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Combat Awareness requires 30 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 20 Then
                    If player.attr.expr >= 50 Then
                        player.skill.stealth += ImproveSkill(player.skill.stealth)
                        player.attr.expr -= 50
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Stealth requires 50 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 21 Then
                    If player.attr.expr >= 40 Then
                        player.skill.search += ImproveSkill(player.skill.search)
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Search requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 22 Then
                    If player.attr.expr >= 50 Then
                        player.skill.disarmtrap += ImproveSkill(player.skill.disarmtrap)
                        player.attr.expr -= 50
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Disarm trap requires 50 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 23 Then
                    If player.attr.expr >= 40 Then
                        player.skill.picklock += ImproveSkill(player.skill.picklock)
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Pick lock requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 24 Then
                    If player.attr.expr >= 40 Then
                        player.skill.readancient += ImproveSkill(player.skill.readancient)
                        player.attr.expr -= 40
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Read ancient requires 40 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 25 Then
                    If player.attr.expr >= 30 Then
                        player.skill.evalmagic += ImproveSkill(player.skill.evalmagic)
                        player.attr.expr -= 30
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Evaluate item requires 30 xp to upgrade. Press any key.";
                        sleep
                        locate row, col
                        Print Space$(79);
                    End If
                ElseIf kn = 26 Then
                    If player.attr.expr >= 60 Then
                        player.skill.usemagicitem += ImproveSkill(player.skill.usemagicitem)
                        player.attr.expr -= 60
                        PrintStats
                    else
                        Locate row, col
                        color fbYellow, fbBlack
                        Print "Use magic item requires 60 xp to upgrade. Press any key.";
                        sleep
                        Locate row, col
                        Print Space$(79);
                    End If
                end if
            end if
        end if
    Loop Until ky = "Q" Or ky = "q"
    Cls
end sub

Function GetBestArmor(adesc As String) As Integer
    Dim strg As Integer
    Dim id As Integer
    
    strg = player.attr.strg
    If strg >= 50 Then
        id = leatherarm
        adesc = "Leather Armor"
    End If
    If strg >= 80 Then
        id = cuirboliarm
        adesc = "Cuirboli Armor"
    End If
    If strg >= 100 Then
        id = ringarm
        adesc = "Ring Armor"
    End If
    
    Return id
End Function

Function GetBestWeapon(wdesc As String) As Integer
    Dim hiskill As Integer
    Dim pskill As Integer
    Dim id As Integer
    Dim strg As Integer
    
    strg = player.attr.strg
    With player.skill
        hiskill = .melee
        pskill = wmelee
        If .sword > hiskill Then
            pskill = wsword
            hiskill = .sword
        End If
        If .axe > hiskill Then
            pskill = waxe
            hiskill = .axe
        End If
        If .spear > hiskill Then
            pskill = wspear
            hiskill = .spear
        End If
        If .mace > hiskill Then
            pskill = wmace
            hiskill = .mace
        End If
        If .flail > hiskill Then
            pskill = wflail
            hiskill = .flail
        End If
    End With
    If pskill = wmelee Then
        If strg >= 50 Then
            id = dagger
            wdesc = "Dagger"
        End If
        If strg >= 60 Then
            id = longknife
            wdesc = "Longknife"
        End If
        If strg >= 65 Then
            id = warclub
            wdesc = "War Club"
        End If
    ElseIf pskill = wsword Then
        If strg >= 50 Then
            id = smallsword
            wdesc = "Small Sword"
        End If
        If strg >= 65 Then
            id = shortsword
            wdesc = "Short Sword"
        End If
        If strg >= 80 Then
            id = rapier
            wdesc = "Rapier"
        End If
        If strg >= 90 Then
            id = scimitar
            wdesc = "Scimitar"
        End If
        If strg >= 100 Then
            id = broadsword
            wdesc = "Broadsword"
        End If
    ElseIf pskill = waxe Then
        If strg >= 50 Then
            id = handaxe
            wdesc = "Hand-axe"
        End If
        If strg >= 80 Then
            id = battleaxe
            wdesc = "Battle Axe"
        End If
        If strg >= 100 Then
            id = gothicbattleaxe
            wdesc = "Gothic Battle Axe"
        End If
    ElseIf pskill = wspear Then
        If strg >= 50 Then
            id = quarterstaff
            wdesc = "Quarter-staff"
        End If
        If strg >= 60 Then
            id = longstaff
            wdesc = "Long Staff"
        End If
        If strg >= 70 Then
            id = lightspear
            wdesc = "Light Spear"
        End If
        If strg >= 80 Then
            id = polearm
            wdesc = "Polearm"
        End If
        If strg >= 90 Then
            id = heavyspear
            wdesc = "Heavy Spear"
        End If
        If strg >= 100 Then
            id = trident
            wdesc = "Trident"
        End If
    ElseIf pskill = wmace Then
        If strg >= 50 Then
            id = smallmace
            wdesc = "Small Mace"
        End If
        If strg >= 60 Then
            id = battlemace
            wdesc = "Battle Mace"
        End If
        If strg >= 70 Then
            id = spikedmace
            wdesc = "Spiked Mace"
        End If
        If strg >= 80 Then
            id = doubleballmace
            wdesc = "Double-ball Mace"
        End If
        If strg >= 100 Then
            id = warhammer
            wdesc = "War Hammer"
        End If
    ElseIf pskill = wflail Then
        If strg >= 50 Then
            id = bullwhip
            wdesc = "Bull Whip"
        End If
        If strg >= 60 Then
            id = ballflail
            wdesc = "Ball Flail"
        End If
        If strg >= 80 Then
            id = spikedflail
            wdesc = "Spiked Flail"
        End If
        If strg >= 90 Then
            id = morningstar
            wdesc = "Morning Star"
        End If
    End If
    Return id
End Function

Sub PrintGenAttr
    Dim As Integer row, col
    Dim id As Integer
    Dim sdesc As String
    Dim wp As invtype
    Dim arm As invtype
        
    col = 31
    row = 10
    'display the attribute set
    Color fbYellow, fbBlack
    Locate row, col
    Print "Current Attributes"
    Color fbWhite, fbBlack
    col = 32
    row += 2
    Locate row, col
    Print "Strength:"; player.attr.strg
    row += 2
    Locate row, col
    Print "Endurance:"; player.attr.endu
    row += 2
    Locate row, col
    Print "Dexterity:"; player.attr.dext
    row += 2
    Locate row, col
    Print "Agility:"; player.attr.agl
    row += 2
    Locate row, col
    Print "Intelligence:"; player.attr.intl
    row += 2
    Locate row, col
    Print "Vision:"; player.attr.vision
    row += 2
    Locate row, col
    Print "Recovery:"; player.attr.recovery
    row += 2
    Locate row, col
    Print "Max HP:"; player.attr.strg + player.attr.endu + player.attr.modstrg + player.attr.modendu 
    row += 2
    Locate row, col
    Print "Xp:"; player.attr.expr
    id = GetBestWeapon(sdesc)
    wp.typeid = weapons
    wp.weapon.id = id
    GenWeapon wp, False
    row += 4
    Locate row, col
    Print "Weapon: "; sdesc; 
    Color fbYellow, fbBlack
    Print " (Dam: ";Str$(wp.weapon.damage); ")"
    Color fbWhite, fbBlack
    id = GetBestArmor(sdesc)
    arm.typeid = armors
    arm.armor.id = id
    GenArmor arm, False
    row += 2
    Locate row, col
    Print "Armor: "; sdesc;
    Color fbYellow, fbBlack 
    Print " (AC: ";Str$(arm.armor.ac); ")"
    
End Sub

sub GenCharacter
    dim row as integer
    dim ky as string
    dim sname as string
    Dim sdesc As String
        
    color fbWhite, fbBlack
    Cls
    #IfNDef cnosound
    PlaySoundTrack "intofray.mid"
    #endif
    CenterText 2, "Generate Character"
    GetAttributes
    PrintGenAttr
    CenterText 55, "Press Enter to Accept, R to roll again."
    do
        ky = inkey$
        if ky = "R" or ky = "r" then
            color fbWhite, fbBlack
            cls
            CenterText 2, "Generate Character"
            GetAttributes
            PrintGenAttr
            CenterText 55, "Press Enter to Accept, R to roll again."
        end if
    loop until ky = key_enter
    do
        color fbWhite, fbBlack
        locate 55, 1
        print space$(79);
        locate 55, 2
        print "Enter character's name (20 chars max): ";
        input sname
    loop until len(sname) > 0
    if len(sname) > 20 then
        player.pname = mid$(sname, 1, 20)
    else
        player.pname = sname
    end if
    'give the player a food ration
    ClearInvItem player.inventory(0) 
    player.inventory(0).typeid = supplies
    player.inventory(0).supply.id = smeat
    GenSupply player.inventory(0)
    player.inventory(0).supply.eval = True
    'give the player a light
    ClearInvItem player.inventory(1) 
    player.inventory(1).typeid = lights
    player.inventory(1).light.id = torch
    GenLight player.inventory(1)
    'give the player a random scroll
    ClearInvItem player.inventory(2) 
    player.inventory(2).typeid = potions
    player.inventory(2).potion.id = GetRandom(minpotion, maxpotion)
    GenPotion player.inventory(2), True
    player.inventory(2).potion.eval = True
    player.inventory(2).potion.cursed = False
    'give the player a teleport potion
    ClearInvItem player.inventory(3) 
    player.inventory(3).typeid = scrolls
    player.inventory(3).scroll.id = teleportscroll
    player.inventory(3).scroll.dr = GetDR
    player.inventory(3).scroll.eval = True
    player.inventory(3).scroll.modifier = 0
    player.inventory(3).scroll.noise = 2
    'give the player some leather armor
    ClearInvItem player.parmor
    player.parmor.typeid = armors
    player.parmor.armor.id = GetBestArmor(sdesc)
    GenArmor player.parmor, False
    player.parmor.armor.eval = True
    'Give the player a dagger
    ClearInvItem player.righthand
    player.righthand.typeid = weapons
    player.righthand.weapon.id = GetBestWeapon(sdesc)
    GenWeapon player.righthand, False
    player.righthand.weapon.eval = True
    ClearInvItem player.lefthand
    #IfNDef cnosound
    StopSoundTrack
    #endif
    Cls
end sub

