' Deep Deadly Dungeon
' (C)2005 by Richard Clark rickclark58@yahoo.com
' Compiled using FB version .15b
'
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'This file contains all the type definitions.
'
'misc defines
#define True 1
#define False 0
#Define imax(a,b) IIf( a > b, a, b )
'number of iterations in dungeon builder
#Define dnumit 5000
#Define droombk 30
'number of iterations in cavern builder
#Define cnumit 9000
#Define croombk 5
'map width and height
#Define dunw 80
#Define dunh 80
'max number of levels
#Define maxlevels 25
'number of items
#define numadditems 10
'view defines
#IfNDef isascii
#Define vw 39
#Define vh 20
#Else
#Define vw 79
#Define vh 43
#endif
'key consts
const xk = chr$(255)
const key_up = xk + "H"
const key_dn = xk + "P"
const key_rt = xk + "M"
const key_lt = xk + "K"
const key_home = xk + "G"
const key_pgup = xk + "I"
const key_end = xk + "O"
const key_pgdn = xk + "Q"
const key_close = xk + "X"
Const key_esc = Chr$(27)
const key_enter = chr$(13)

'hand defines used in GetFreeHand in inv.bi
#Define inone 0
#Define irighthand 1
#Define ilefthand 2

'message line row
#define messline 58

'map types
#Define cavern 1
#Define dungeon 2

'directions
#Define north 1
#Define east 2
#Define south 3
#Define west 4
#Define nwest 5
#Define neast 6
#Define swest 7
#Define seast 8

'main menus ids
#Define mnewgame  1
#Define mloadgame 2
#Define mquit 3

'display ids
#Define wall 1
#Define secretwall 2
#Define mfloor 3
#Define mstart 4
#Define mend 5
#Define doorew 6
#Define doorns 7
#Define dooropns 8
#Define dooropew 9
#Define trap 10
#Define water 11

'item class defines
#define minitem 1
#define maxitem 11
#Define supplies 1
#Define necklaces 2
#Define potions 3
#Define rings 4
#Define wands 5
#Define weapons 6
#Define armors 7
#Define lights 8
#Define ammos 9
#Define shields 10
#Define scrolls 11

#define minlight 51
#define maxlight 52
#Define lantern 51
#Define torch 52

#define minammo 71
#define maxammo 73
#Define bolts 71
#Define arrows 72
#Define pebbles 73

#define minsupply 101
#Define maxsupply 105
#Define smeat  101 
#Define sbottle 102
#Define sbread 103 
#Define scoins 104 
#Define sbagocoins 105

#define minrneffect 1
#Define maxrneffect 31
#Define rnstrength  1
#Define rnendurance 2
#Define rndexterity 3
#Define rnagility 4
#Define rnintelligence 5
#Define rnvision 6
#Define rnmelee 7
#Define rndodge 8
#Define rnscan 9
#Define rnsword 10
#Define rnaxe 11
#Define rnspear 12
#Define rnmace 13
#Define rnflail 14
#Define rnbow 15
#Define rncrossbow 16
#Define rnshield 17
#Define rncombataware 18
#Define rnstealth 19
#Define rnsearch  20
#Define rndisarmtrap 21
#Define rnpicklock 22
#Define rnreadancient 23
#Define rneval 24
#Define rnusemagic 25
#Define rnarmor 26
#Define rndefense 27
#Define rntohit 28
#Define rnmagicdef 29
#Define rnmagicattack 30
#Define rndamage 31

#define minnecklace 201
#define maxnecklace 208
#Define rubynecklace 201 'possible magic item
#Define diamondnecklace 202 
#Define emeraldnecklace 203
#Define topaznecklace 204
#Define silvernecklace 205
#Define goldnecklace 206
#Define bronzenecklace 207
#Define coppernecklace 208

#define minpotion 301
#Define maxpotion 308
#Define redpotion  301   'potions
#Define yellowpotion 302
#Define greenpotion 303
#Define bluepotion 304
#Define magentapotion 305
#Define cyanpotion 306
#Define whitepotion 307
#Define blackpotion 308

#Define minpotioneffect 1
#Define maxpotioneffect 7
#Define ptstrength 1
#Define ptendurance 2
#Define ptdexterity 3
#Define ptagility 4
#Define ptintelligence 5
#Define ptvision 6
#Define pthealth 7

#define minring 401
#define maxring 408
#Define rubyring 401    'possible magic item
#Define diamondring 402
#Define emeraldring 403
#Define topazring 404
#Define silverring 405
#Define goldring 406
#Define bronzering 407
#Define copperring 408

#define minwand 501
#Define maxwand 501
#Define wwand 501  'a wizards wand

'weapon hand
#Define wpRight 1
#Define wpLeft 2
    
#define minweapon 601
#Define maxweapon 649
#Define club  601     'melee, 1 hand
#Define warclub 602       'melee comabt, 1 hand
#Define cudgel 603        'melee combat, 1 hand
#Define dagger 604        'melee combat, 1 hand
#Define longknife 605     'melee combat, 1 hand
#Define smallsword 606    'sword, 1 hand
#Define shortsword 607    'sword, 1 hand
#Define rapier  608       'sword, 1 hand
#Define broadsword 609    'sword, 1 hands
#Define scimitar  610     'sword, 1 hand
#Define katana 611        'sword, 2 hands
#Define longsword 612     'sword, 2 hands
#Define claymore 613      'sword, 2 hands
#Define greatsword 614    'sword, 2 hands
#Define odinsword 615     'sword 2 hands
#Define hellguard 616     'sword, 2 hands
#Define quarterstaff 617  'spear, 2 hands
#Define longstaff  618    'spear, 2 hands
#Define polearm 619       'spear, 2 hands
#Define lightspear 620    'spear, 2 hands
#Define heavyspear 621    'spear, 2 hands
#Define trident 622       'spear, 2 hands
#Define glaive 623        'spear, 2 hands
#Define handaxe 624       'axe, 1 hand
#Define battleaxe 625     'axe, 1 hand
#Define gothicbattleaxe 626 'axe, 2 hands
#Define waraxe 627         'axe, 2 hands
#Define halberd 628        'axe, 2 hands
#Define poleaxe 629       'axe, 2 hands
#Define smallmace 630     'mace, 1 hand
#Define battlemace 631     'mace, 1 hand
#Define spikedmace 632    'mace, 1 hand
#Define doubleballmace 633 'mace, 1 hand
#Define warhammer 634     'mace, 1 hand
#Define maul 635          'mace, 2 hands
#Define ballflail 636     'flail, 1 hand
#Define spikedflail 637   'flail, 1 hand
#Define morningstar 638   'flail, 1 hand
#Define bullwhip 639      'flail, 1 hand
#Define battleflail 640   'flail, 2 hand
#Define bishopsflail 641  'flail, 2 hand
#Define sling 642         'bow, 1 hand
#Define shortbow 643      'bow, 2 hands
#Define longbow 644       'bow, 2 hands
#Define bonebow 645       'bow, 2 hands
#Define adaminebow 646    'bow, 2 hands
#Define lightcrossbow 647 'crossbow, 2 hands
#Define heavycrossbow 648 'crossbow, 2 hands
#Define barrelcrossbow 649 'crossbow, 2 hands

#define minarm 701
#define maxarm 707
#Define leatherarm 701 'body armor
#Define cuirboliarm 702
#Define ringarm 703
#Define brigantinearm 704
#Define chainarm 705
#Define scalearm 706
#Define platearm 707

#Define minshield 801
#define maxshield 807
#Define leathershld 801     'shields
#Define cuirbolishld 802
#Define ringshld 803
#Define brigantineshld 804
#Define chainshld 805
#Define scaleshld 806
#Define plateshld 807

'player orb ids
#Define crown 901
#Define redorb 902
#Define blueorb 903
#Define greenorb 904
#Define yelloworb 905
#Define whiteorb 906

#define minscroll 1001
#Define maxscroll 1022
#Define healscroll 1001
#Define meleescroll 1002
#Define dodgescroll 1003
#Define scanscroll 1004
#Define swordscroll 1005
#Define axescroll 1006
#Define spearscroll 1007
#Define macescroll 1008
#Define flailscroll 1009
#Define bowscroll 1010
#Define crossbowscroll 1011
#Define shieldscroll 1012
#Define combatawarescroll 1013
#Define stealthscroll 1014
#Define searchscroll 1015
#Define disarmtrapscroll 1016
#Define picklockscroll 1017
#Define readancientscroll 1018
#Define evalscroll 1019
#Define usemagicscroll 1020
#Define cursescroll 1021
#Define teleportscroll 1022

'monster enum
#define minmonster 2001
#Define maxmonster 2052
#Define darkangel 2001
#Define giantbat 2002
#Define giantscorpion 2003
#Define dragon 2004
#Define elfwarrior 2005
#Define wisp 2006
#Define giant 2007
#Define harpy 2008
#Define incubus 2009
#Define jadegolem 2010
#Define kraken 2011
#Define lamia 2012
#Define manticore 2013
#Define naga 2014
#Define ogre 2015
#Define phantomfungus 2016
#Define quorn 2017
#Define rockgolem 2018
#Define skeleton 2019
#Define troll 2020
#Define uruk 2021
#Define vampire 2022
#Define wombat 2023
#Define xerth 2024
#Define yeek 2025
#Define zombie 2026
#Define flameangel 2027
#Define werebear 2028
#Define giantcentipede 2029
#Define demonspawn 2030
#Define elemental 2031
#Define flamegolem 2032
#Define golem 2033
#Define hobgoblin 2034
#Define interloper 2035
#Define rovingjelly 2036
#Define kobold 2037
#Define lich 2038
#Define mage 2039
#Define nazgul 2040
#Define orc 2041
#Define pulsingeye 2042
#Define twinhead 2043
#Define rogue 2044
#Define shurik 2045
#Define gianttarantula 2046
#Define giantbeetle 2047
#Define varghoul 2048
#Define wraith 2049
#Define xorn 2050
#Define yekki 2051
#Define griffon 2052

'monster armor types
#Define minmonarmor 3001
#Define maxmonarmor 3013
#Define mleatherarm 3001
#Define mcuirboliarm 3002
#Define mringarm 3003
#Define mbrigantinearm 3004
#Define mchainarm 3005
#Define mscalearm 3006
#Define mplatearm 3007
#Define mhide 3008
#Define mscales 3009
#Define menergy 3010
#Define mfur 3011
#Define mfeathers 3012
#Define mrock 3013

#Define minmonweapon 4001
#Define maxmonweapon 4049
#Define mclub 4001     'melee, 1 hand
#Define mwarclub 4002       'melee comabt, 1 hand
#Define mcudgel 4003        'melee combat, 1 hand
#Define mdagger 4004        'melee combat, 1 hand
#Define mlongknife 4005     'melee combat, 1 hand
#Define msmallsword 4006    'sword, 1 hand
#Define mshortsword 4007    'sword, 1 hand
#Define mrapier 4008        'sword, 1 hand
#Define mbroadsword 4009    'sword, 1 hands
#Define mscimitar 4010      'sword, 1 hand
#Define mkatana 4011        'sword, 2 hands
#Define mlongsword 4012     'sword, 2 hands
#Define mclaymore 4013      'sword, 2 hands
#Define mgreatsword 4014    'sword, 2 hands
#Define modinsword 4015     'sword 2 hands
#Define mhellguard 4016     'sword, 2 hands
#Define mquarterstaff 4017  'spear, 2 hands
#Define mlongstaff 4018     'spear, 2 hands
#Define mpolearm  4019      'spear, 2 hands
#Define mlightspear 4020    'spear, 2 hands
#Define mheavyspear 4021    'spear, 2 hands
#Define mtrident 4022       'spear, 2 hands
#Define mglaive 4023        'spear, 2 hands
#Define mhandaxe 4024       'axe, 1 hand
#Define mbattleaxe 4025     'axe, 1 hand
#Define mgothicbattleaxe 4026 'axe, 2 hands
#Define mwaraxe 4027         'axe, 2 hands
#Define mhalberd 4028        'axe, 2 hands
#Define mpoleaxe 4029       'axe, 2 hands
#Define msmallmace 4030      'mace, 1 hand
#Define mbattlemace 4031    'mace, 1 hand
#Define mspikedmace 4032    'mace, 1 hand
#Define mdoubleballmace 4033 'mace, 1 hand
#Define mwarhammer 4034     'mace, 1 hand
#Define mmaul 4035          'mace, 2 hands
#Define mballflail 4036     'flail, 1 hand
#Define mspikedflail 4037   'flail, 1 hand
#Define mmorningstar 4038   'flail, 1 hand
#Define mbullwhip 4039      'flail, 1 hand
#Define mbattleflail 4040   'flail, 2 hand
#Define mbishopsflail 4041  'flail, 2 hand
#Define msling 4042         'bow, 1 hand
#Define mshortbow 4043      'bow, 2 hands
#Define mlongbow 4044       'bow, 2 hands
#Define mbonebow 4045       'bow, 2 hands
#Define madaminebow 4046    'bow, 2 hands
#Define mlightcrossbow 4047 'crossbow, 2 hands
#Define mheavycrossbow 4048 'crossbow, 2 hands
#Define mbarrelcrossbow 4049 'crossbow, 2 hands
#Define mbite 4050
#Define mclaw 4051
#Define mfist 4052
#Define mspore 4053
#Define mteeth 4054
#Define msting 4055
#Define mflame 4056
#Define mmagic 4057

'skill types for weapons
#Define minwskill 1
#Define maxwskill 8
#Define wmelee 1
#Define wsword 2
#Define waxe 3
#Define wspear 4
#Define wmace 5
#Define wflail 6
#Define wbow 7
#Define wcrossbow 8

'sound ids
#Define minsound 1
#Define maxsound 24
#Define sndarht 1 'arrow hit
#Define sndarms 2 'arrow miss
#Define sndmiss 3 'miss sound
#Define sndmond 4 'monster dead
#Define sndpded 5 'player dead
#Define sndplck 6 'pick lock
#Define sndpunc 7 'punch
#Define sndscrp 8 'scrape
#Define sndsrch 9 'search
#Define sndshit 10 'sword hit
#Define sndthud 11 'thud
#Define sndthun 12 'thunder
#Define sndusei 13 'use item
#Define sndwhit 14 'whip hit
#Define sndzipr 15 'zipper 
#Define sndfbll 16 'fireball
#Define sndbash 17 'bash
#Define sndtrum 18 'trumpets
#Define sndcoin 19 'coin
#Define sndspls 20 'splash
#Define snddrnk 21 'drink
#Define sndbite 22 'bite
#Define snddoor 23 'door
#Define sndtrap 24 'trap
'sound def type
Type sndtype
    channel As Integer
    handle As Integer
End Type

'map coord type
Type mcoord
    x As Integer
    y As Integer
End Type

'these are the individual types
'for the inventory union
type scrolltype
    id as integer
    dr as integer
    eval as integer
    modifier As Integer
    noise As Integer
end type

type ammotype
    id as  integer
    count As Integer
    noise As Integer
end type

type lighttype
    id as integer
    count as integer
    range As Integer
    noise As Integer
end type

type supplytype
    id as integer
    count as integer
    eval as integer
    modifier As Integer
    noise As Integer
end type

type necklacetype
    id as integer
    eval as integer
    cursed as integer
    modifier as integer
    effect as integer
    value as integer
    dr as integer
    magic As Integer
    noise As Integer
end type

type ringtype
    id as integer
    eval as integer
    cursed as integer
    modifier as integer
    effect as integer
    value as integer
    dr as integer
    magic As Integer
    noise As Integer
end type

type potiontype
    id as integer
    eval as integer
    cursed As Integer
    effect As Integer
    modifier As Integer
    dr As Integer
    noise As Integer
end type

type wandtype
    id as integer
    eval as integer
    count as integer
    damage As Integer
    dr As Integer
    noise As Integer
end type

type weapontype
    id as integer
    eval as integer
    hands as integer
    strg As Integer
    tohitmod As Integer
    damage as integer
    dammod as integer
    cursed as integer
    dr As Integer
    skill As Integer
    noise As Integer
End Type

type armortype
    id as integer
    eval As Integer
    ac As Integer
    defmod As Integer
    defmagic As Integer
    defmagicmod As Integer
    strg As Integer
    cursed As Integer
    dr As Integer
    noise As Integer
End Type

type shieldtype
    id as integer
    eval As Integer
    ac As Integer
    defmagic As Integer
    defmod As Integer
    defmagicmod As Integer
    strg As Integer
    cursed As Integer
    dr As Integer
    noise As Integer
End Type

type invtype
    typeid As Integer
    desc As String * 20
    union
        light as lighttype
        supply as supplytype
        ammo As ammotype
        necklace as necklacetype
        ring as ringtype
        wand as wandtype
        potion as potiontype
        scroll as scrolltype
        weapon as weapontype
        armor as armortype
        shield as shieldtype
    end union
end type

'character atributes
type attributetype
    strg as integer 'strength
    endu as integer 'endurance
    dext as integer 'dexterity
    agl as integer  'agility
    intl as integer 'intelligence
    vision As Integer 'vision
    recovery As Integer 'recovery rate
    maxhp as integer  'max hit points= str + end
    currhp as integer 'current hit points
    expr as integer  'current experience
    totexp as integer 'total experience
    modstrg as integer 'strength modifier
    modendu as integer 'endurance modifier
    moddext as integer 'dexterity modifier
    modagl as integer  'agility modifier
    modintl as integer 'intelligence modifier
    modvision As Integer 'vision modifier
    modrecov As Integer 'recovery modifier
end type

'character skill set
type skilltype
    melee as integer
    dodge as integer
    scan as integer
    sword as integer
    axe as integer
    spear as integer
    mace as integer
    flail as integer
    bow as integer
    crossbow as integer
    shield as integer
    caware as integer
    stealth as integer
    search as integer
    disarmtrap as integer
    picklock as integer
    readancient as integer
    evalmagic as integer
    usemagicitem as integer
    modmelee as integer
    moddodge as integer
    modscan as integer
    modsword as integer
    modaxe as integer
    modspear as integer
    modmace as integer
    modflail as integer
    modbow as integer
    modcrossbow as integer
    modshield as integer
    modcaware as integer
    modstealth as integer
    modsearch as integer
    moddisarmtrap as integer
    modpicklock as integer
    modreadancient as integer
    modevalmagic as integer
    modusemagicitem as integer
end type

'orbs are not counted as regular inventory
type porbtype
    hascrown as integer
    hasredorb as integer
    hasblueorb As Integer
    hasgreenorb As Integer
    hasyelloworb As Integer
    haswhiteorb As Integer
End Type

'monster type def
Type montype
  id As Integer
  attr as attributetype
  righthand as invtype
  lefthand as invtype
  marmor as invtype
  defense as integer
  tohit As Integer
  mtohit As Integer
  mdamage As Integer
  attackrange As Integer
  moved as integer
  isscanned As Integer
  stealth As Integer
  psighted As Integer
  mmcoord As mcoord
  lastploc As mcoord
  mpath(dunw, dunh) As Integer
  ldir As Integer
  minv As invtype
  ismagic As Integer
  flee As Integer
  heal As Integer
End Type

#Define playerinv 26

'player character
type playertype
    pname as string * 20  'character name
    attr as attributetype 'attributes
    skill as skilltype    'skills
    coins As Integer      'current coin count
    pcoord As mcoord      'current x,y position
    haslight as invtype    'player is carrying a light
    hasorbs as porbtype    'list of orbs and crown
    inventory(playerinv) As invtype
    righthand as invtype
    lefthand as invtype
    parmor as invtype
    wright as invtype
    wleft as invtype
    wneck as invtype
    moddefense as integer
    modtohit as integer
    moddamage as integer
    modarmor as integer
    modmagicattack as integer
    modmagicdef As Integer
    isdodging As Integer
    issneaking As Integer
end type

'Door type used in map
type doortype
    islocked as integer 'is door locked
    dstr as integer     'strength of door
end type

'traps
Type traptype
    ttype As Integer
    istrap As Integer 'is this a trap location
    isseen as integer 'if trap triggered, then show on map
    damage as integer 'damage to player
    dr as integer 'disarm trap
end type

#Define monarray 15

type maptype
    map(dunw, dunh) As Integer     'map array
    traps(dunw, dunh) as traptype
    item(dunw, dunh) as invtype    'item array
    isseen(dunw, dunh) as integer  'has player seen location
    visited(dunw, dunh) As Integer  'has player seen location
    isdoor(dunw, dunh) As doortype 'list of doors on map
    issecret(dunw, dunh) As Integer 'secret flags
    soundmap(dunw, dunh) As Double
    monster(1 To monarray) As montype 'monsters on map
    isdark as integer              'is level dark
    startx as integer              'stair up location
    starty as integer
    endx as integer                'stair down location
    endy as integer
    lcount(1 To maxlevels) As Integer 'level counter
    tmaptype As Integer               'map type cavern or dungeon
    currlevel As Integer              'current level
    mapscheme As Integer              'graphic map scheme
    showhealth As Integer
end type

Dim Shared levels As maptype 'level info
dim shared player as playertype
Dim Shared messages(1 To 10) As String
Dim Shared finit As Integer
Dim Shared soundon As Integer
Dim Shared cheater As Integer = False
Dim Shared easteregg As Integer = False
Dim Shared isplaying As Integer = False
Dim Shared sndtrack As Integer
Dim Shared sndvol As Integer = 128
'graphics
#IfNDef isascii
Dim Shared As Any Ptr titem, tmap, tmonster, tweapon
Dim Shared As Any Ptr tp
#endif
Dim Shared sndhandles(minsound To maxsound) As sndtype
