' Deep Deadly Dungeons
' (C)2005 by Richard Clark rickclark58@yahoo.com
'
' Compiled using FB version .15b
'
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'This file contains all the map related routines.
'
Function BlockingTile(tx As Integer, ty As Integer) As Integer
    if levels.map(tx, ty) = wall or _
       levels.map(tx, ty) = secretwall or _
       levels.map(tx, ty) = doorns or _
       levels.map(tx, ty) = doorew then
        return True
    else
        return False
    end if

end function

Sub ClearSoundMap
    Dim As Integer i, j
    
    For i = 0 To dunw - 1
        For j = 0 To dunh - 1 
            levels.soundmap(i, j) = 0
        Next j
    Next i
    
End Sub

Sub CalcSoundMap(x As Integer, y As Integer, soundval As Integer)
    Dim csound As Integer
    Dim sdist As Integer
    
    If x < 0 Or x > dunw - 1 Then Exit Sub
    If y < 0 Or y > dunh - 1 Then Exit Sub
    If soundval <= 0 Then Exit Sub
    If BlockingTile(x, y) Then Exit Sub
    If levels.soundmap(x, y) > 0 Then Exit Sub
    sdist = CalcDist(player.pcoord.x, x, player.pcoord.y, y)
    csound = soundval - (sdist * sdist)
    If csound <= 0 Then Exit Sub
    levels.soundmap(x, y) = csound
    CalcSoundMap x+1, y, csound
    CalcSoundMap x, y+1, csound
    CalcSoundMap x-1, y, csound 
    CalcSoundMap x, y-1, csound 
    CalcSoundMap x+1, y+1, csound 
    CalcSoundMap x-1, y+1, csound 
    CalcSoundMap x-1, y-1, csound 
    CalcSoundMap x+1, y-1,  csound
End Sub

Sub GenSoundMap(x As Integer, y As Integer, soundval As Integer)
    ClearSoundMap
    CalcSoundMap x, y, soundval
End Sub

Function LineOfSight(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Dim As Integer i, deltax, deltay, numtiles
    Dim As Integer d, dinc1, dinc2
    Dim As Integer x, xinc1, xinc2
    Dim As Integer y, yinc1, yinc2
    Dim isseen As Integer = True
    
    deltax = Abs(x2 - x1)
    deltay = Abs(y2 - y1)

    If deltax >= deltay Then
        numtiles = deltax + 1
        d = (2 * deltay) - deltax
        dinc1 = deltay Shl 1
        dinc2 = (deltay - deltax) Shl 1
        xinc1 = 1
        xinc2 = 1
        yinc1 = 0
        yinc2 = 1
    Else
        numtiles = deltay + 1
        d = (2 * deltax) - deltay
        dinc1 = deltax Shl 1
        dinc2 = (deltax - deltay) Shl 1
        xinc1 = 0
        xinc2 = 1
        yinc1 = 1
        yinc2 = 1
    End If

    If x1 > x2 Then
        xinc1 = - xinc1
        xinc2 = - xinc2
    End If
    
    If y1 > y2 Then
        yinc1 = - yinc1
        yinc2 = - yinc2
    End If

    x = x1
    y = y1
    
    For i = 2 To numtiles
      'PSet (x, y), pcolor
      If BlockingTile(x, y) Then
        isseen = False
        Exit For
      End If
      If d < 0 Then
          d = d + dinc1
          x = x + xinc1
          y = y + yinc1
      Else
          d = d + dinc2
          x = x + xinc2
          y = y + yinc2
        End If
    Next
    
    Return isseen
End Function

Function PlayerCanSee(tx As Integer, ty As Integer) As Integer
    Dim dist As Integer
    Dim ret As Integer = False
    Dim currvision As Integer
        
    currvision = player.attr.vision + player.attr.modvision
    If player.haslight.typeid = lights Then
        currvision += player.haslight.light.range
    End If
    dist = CalcDist(player.pcoord.x, tx, player.pcoord.y, ty)
    If dist <= currvision Then
        ret = LineOfSight(player.pcoord.x, tx, player.pcoord.y, ty)
    End If
    Return ret
End Function

Function GetCurrvision As Integer
    Dim currvision As Integer
    
    currvision = player.attr.vision + player.attr.modvision
    If player.haslight.typeid = lights Then
        currvision += player.haslight.light.range
    End If
    
    Return currvision
End Function

sub CalcLOS
    dim as integer i, j
    Dim As Integer x1, x2, y1, y2
    Dim currvision As Integer
    
    'clear map seen if dark
    If levels.isdark Then
        For i = 0 To dunw - 1
            For j = 0 To dunh - 1
                levels.isseen(i,j) = False
            Next
        Next
    End If
    'only check within vision range
    currvision = GetCurrvision
    x1 = player.pcoord.x - currvision
    If x1 < 0 Then x1 = 0
    y1 = player.pcoord.y - currvision
    If y1 < 0 Then y1 = 0
    
    x2 = player.pcoord.x + currvision
    If x2 > dunw - 1 Then x2 = dunw - 1
    y2 = player.pcoord.y + currvision
    If y2 > dunh - 1 Then y2 = dunh - 1
    'iterate through vision area
    For i = x1 To x2
        For j = y1 To y2
            'Don't recalc seen tiles
            If levels.isseen(i, j) = False Then
                If PlayerCanSee(i, j) Then
                    levels.isseen(i,j) = True
                    levels.visited(i,j) = True
                End If
            End If
        Next
    Next
    
end sub

'clears map data for new map build
sub ClearMap
    dim as integer i, j
    dim as integer floortex, walltex
    dim sname as string
    
    for i = 0 to dunw - 1
        For j = 0 To dunh - 1 
            'fill map with walls
            levels.map(i, j) = wall
            'not seen or visited
            levels.isseen(i, j) = False
            levels.visited(i, j) = False
            'clear doors
            levels.isdoor(i, j).islocked = False
            levels.isdoor(i, j).dstr = 0
            'reset dark flag
            levels.isdark = False
            'clear traps
            levels.traps(i, j).ttype = 0
            levels.traps(i, j).istrap = False
            levels.traps(i, j).isseen = False
            levels.traps(i, j).damage = 0
            levels.traps(i, j).dr = 0
            'clear secret flag
            levels.issecret(i, j) = False
            'clear any items
            ClearInvItem levels.item(i, j)
        Next j
    Next i
End Sub    

'return ascii symbol for tile
Function GetSymbol(tile As Integer) As String

    Select Case tile
        Case wall: Return Chr$(178)
        Case secretwall: Return Chr$(178)
        Case mfloor: Return Chr$(249)
        Case mstart: Return Chr$(174)
        Case mend: Return Chr$(175)
        Case water: Return Chr%(178)
        Case doorew: Return Chr$(205)
        Case doorns: Return Chr$(186)
        Case dooropns: Return Chr$(96)
        Case dooropew: Return Chr$(96)
        Case crown: Return Chr$(234)
        Case redorb: Return Chr$(233)
        Case blueorb: Return Chr$(233)
        Case greenorb: Return Chr$(233)
        Case yelloworb: Return Chr$(233)
        Case whiteorb: Return Chr$(233)
        Case sbottle: Return Chr$(229)
        Case sbread: Return Chr$(247)
        Case scoins: Return Chr$(147)
        Case sbagocoins: Return Chr$(147)
        Case smeat : Return Chr$(224)
        Case healscroll: Return Chr$(238)
        Case meleescroll: Return Chr$(238)
        Case dodgescroll: Return Chr$(238)
        Case scanscroll: Return Chr$(238)
        Case swordscroll: Return Chr$(238)
        Case axescroll: Return Chr$(238)
        Case spearscroll: Return Chr$(238)
        Case macescroll: Return Chr$(238)
        Case flailscroll: Return Chr$(238)
        Case bowscroll: Return Chr$(238)
        Case crossbowscroll: Return Chr$(238)
        Case shieldscroll: Return Chr$(238)
        Case combatawarescroll: Return Chr$(238)
        Case stealthscroll: Return Chr$(238)
        Case searchscroll: Return Chr$(238)
        Case disarmtrapscroll: Return Chr$(238)
        Case picklockscroll: Return Chr$(238)
        Case readancientscroll: Return Chr$(238)
        Case evalscroll: Return Chr$(238)
        Case usemagicscroll: Return Chr$(238)
        Case torch: Return Chr$(157)
        Case lantern: Return Chr$(232)
        Case redpotion: Return Chr$(235)
        Case yellowpotion: Return Chr$(235)
        Case greenpotion:Return Chr$(235)
        Case bluepotion: Return Chr$(235)
        Case magentapotion: Return Chr$(235)
        Case whitepotion: Return Chr$(235)
        Case blackpotion: Return Chr$(235)
        Case cyanpotion: Return Chr$(235)
        Case rubyring: Return Chr$(148)
        Case diamondring: Return Chr$(148)
        Case emeraldring: Return Chr$(148)
        Case topazring: Return Chr$(148)
        Case silverring: Return Chr$(148)
        Case goldring: Return Chr$(148)
        Case bronzering: Return Chr$(148)
        Case copperring: Return Chr$(148)
        Case rubynecklace: Return Chr$(153)
        Case diamondnecklace: Return Chr$(153)
        Case emeraldnecklace: Return Chr$(153)
        Case topaznecklace: Return Chr$(153)
        Case silvernecklace: Return Chr$(153)
        Case goldnecklace: Return Chr$(153)
        Case bronzenecklace: Return Chr$(153)
        Case coppernecklace: Return Chr$(153)
        Case wwand: Return "l"
        Case bolts: Return Chr$(242)
        Case arrows:Return Chr$(158)
        Case pebbles: Return Chr$(167)
        Case club: Return Chr$(244)
        Case warclub: Return Chr$(244)
        Case cudgel: Return Chr$(244)
        Case dagger: Return Chr$(245)
        Case longknife: Return Chr$(245)
        Case smallsword: Return Chr$(245)
        Case shortsword: Return Chr$(245)
        Case rapier: Return Chr$(245)
        Case broadsword: Return Chr$(245)
        Case scimitar: Return Chr$(245)
        Case katana: Return Chr$(245)
        Case longsword: Return Chr$(245)
        Case claymore: Return Chr$(245)
        Case greatsword: Return Chr$(245)
        Case odinsword: Return Chr$(245)
        Case hellguard: Return Chr$(245)
        Case quarterstaff: Return Chr$(245)
        Case longstaff: Return Chr$(245)
        Case polearm: Return Chr$(159)
        Case lightspear: Return Chr$(159)
        Case heavyspear: Return Chr$(159)
        Case trident: Return Chr$(159)
        Case glaive: Return Chr$(159)
        Case handaxe: Return Chr$(168)
        Case battleaxe: Return Chr$(168)
        Case gothicbattleaxe: Return Chr$(168)
        Case waraxe: Return Chr$(168)
        Case halberd: Return Chr$(168)
        Case poleaxe: Return Chr$(168)
        Case smallmace: Return Chr$(135)
        Case battlemace: Return Chr$(135)
        Case spikedmace: Return Chr$(135)
        Case doubleballmace: Return Chr$(135)
        Case warhammer: Return Chr$(135)
        Case maul: Return Chr$(135)
        Case ballflail: Return Chr$(168)
        Case spikedflail: Return Chr$(168)
        Case morningstar: Return Chr$(168)
        Case bullwhip: Return Chr$(168)
        Case battleflail: Return Chr$(168)
        Case bishopsflail: Return Chr$(168)
        Case sling: Return Chr$(247)
        Case shortbow: Return Chr$(237)
        Case longbow: Return Chr$(237)
        Case bonebow: Return Chr$(237)
        Case adaminebow: Return Chr$(237)
        Case lightcrossbow: Return Chr$(230)
        Case heavycrossbow: Return Chr$(230)
        Case barrelcrossbow: Return Chr$(230)
        Case leatherarm: Return Chr$(225)
        Case cuirboliarm: Return Chr$(225)
        Case ringarm: Return Chr$(225)
        Case brigantinearm: Return Chr$(225)
        Case chainarm: Return Chr$(225)
        Case scalearm: Return Chr$(225)
        Case platearm: Return Chr$(225)
        Case leathershld: Return Chr$(229)
        Case cuirbolishld: Return Chr$(229)
        Case ringshld: Return Chr$(229)
        Case brigantineshld: Return Chr$(229)
        Case chainshld: Return Chr$(229)
        Case scaleshld: Return Chr$(229)
        Case plateshld: Return Chr$(229)
        Case Else
            PrintMessage "Unknown tile: " + Str$(tile)
            Return Chr$(1)
    End Select
End Function

Function GetMonsterColor(id As Integer) As Integer
    Select Case id
        Case darkangel: Return fbWarmGrey
        Case giantbat: Return fbGrey
        Case giantscorpion: Return fbNavajoWhite
        Case dragon: Return fbEmeraldGreen
        Case elfwarrior: Return fbFlesh 
        Case wisp: Return fbWheat 
        Case giant: Return fbFlesh  
        Case harpy: Return fbIndianRed 
        Case incubus: Return fbTan
        Case jadegolem: Return fbLawnGreen
        Case kraken: Return fbGold
        Case lamia: Return fbFlesh 
        Case manticore: Return fbYellowOchre 
        Case naga: Return fbBeige 
        Case ogre: Return  fbFlesh
        Case phantomfungus: Return fbViridianLight
        Case quorn: Return fbTurquoisePale 
        Case rockgolem: Return fbDeepOchre 
        Case skeleton: Return fbOldLace 
        Case troll: Return fbFlesh
        Case uruk: Return fbAquamarine 
        Case vampire: Return fbMarsOrange 
        Case wombat: Return fbNaplesYellowDeep
        Case xerth: Return fbIndigo 
        Case yeek: Return fbBanana 
        Case zombie: Return fbYellowOchre 
        Case flameangel: Return fbYellowLight
        Case werebear: Return fbBrownMadder 
        Case giantcentipede: Return fbGoldenrodDark 
        Case demonspawn: Return fbTomato 
        Case elemental: Return fbCadmiumRedLight 
        Case flamegolem: Return fbNaplesYellowDeep 
        Case golem: Return  fbOlive
        Case hobgoblin: Return fbBurntUmber 
        Case interloper: Return fbFlesh 
        Case rovingjelly: Return fbPlum 
        Case kobold: Return fbVioletRedPale 
        Case lich: Return fbFlesh 
        Case mage: Return fbFlesh 
        Case nazgul: Return fbSlateGreyLight 
        Case orc: Return fbCadmiumOrange 
        Case pulsingeye: Return fbLightSalmon 
        Case twinhead: Return fbFlesh 
        Case rogue: Return fbFlesh 
        Case shurik: Return fbCobaltVioletDeep 
        Case gianttarantula: Return fbColdGrey 
        Case giantbeetle: Return fbKhaki 
        Case varghoul: Return fbAliceBlue 
        Case wraith: Return  fbTerreVerte
        Case xorn: Return fbMarsYellow 
        Case yekki: Return fbLemonChiffon 
        Case griffon: Return fbPermanentGreen
        Case Else
            Return fbRed 
    End Select
End Function

Function GetMonsterSymbol(tile As Integer) As String
    Select Case tile
        Case darkangel: Return "A"
        Case giantbat: Return "B"
        Case giantscorpion: Return "C"
        Case dragon: Return "D"
        Case elfwarrior: Return "E"
        Case wisp: Return "F"
        Case giant: Return "G"
        Case harpy: Return "H"
        Case incubus: Return "I"
        Case jadegolem: Return "J"
        Case kraken: Return "K"
        Case lamia: Return "L"
        Case manticore: Return "M"
        Case naga: Return "N"
        Case ogre: Return "O"
        Case phantomfungus: Return "P"
        Case quorn: Return "Q"
        Case rockgolem: Return "R"
        Case skeleton: Return "S"
        Case troll: Return "T"
        Case uruk: Return "U"
        Case vampire: Return "V"
        Case wombat: Return "W"
        Case xerth: Return "X"
        Case yeek: Return "Y"
        Case zombie: Return "Z"
        Case flameangel: Return "a"
        Case werebear: Return "b"
        Case giantcentipede: Return "c"
        Case demonspawn: Return "d"
        Case elemental: Return "e"
        Case flamegolem: Return "f"
        Case golem: Return "g"
        Case hobgoblin: Return "h"
        Case interloper: Return "i"
        Case rovingjelly: Return "j"
        Case kobold: Return "k"
        Case lich: Return "l"
        Case mage: Return "m"
        Case nazgul: Return "n"
        Case orc: Return "o"
        Case pulsingeye: Return "p"
        Case twinhead: Return "q"
        Case rogue: Return "r"
        Case shurik: Return "s"
        Case gianttarantula: Return "t"
        Case giantbeetle: Return "u"
        Case varghoul: Return "v"
        Case wraith: Return "w"
        Case xorn: Return "x"
        Case yekki: Return "y"
        Case griffon: Return "z"
        Case Else
            PrintMessage "Unknown mon tile: " + Str$(tile)
            Return Chr$(1)
    End Select        
End Function

'returns the color for object
Function GetClassColor(tid As Integer) As Integer
    Select Case tid
        Case supplies
            Return fbSalmon
        Case necklaces
            Return fbTurquoiseBlue
        Case potions
            Return fbMarsYellow
        Case rings
            Return fbTurquoiseDark
        Case wands
            Return fbGrey
        Case weapons
            Return fbGold 
        Case armors
            Return fbEmeraldGreen
        Case lights
            Return fbYellow
        Case ammos
            Return fbRed 
        Case shields
            Return fbSeaGreenLight
        Case scrolls
            Return fbTan
        Case Else
            Return fbWhite
    End Select
End Function

'returns the color for object
Function GetSymbolColor(tile As Integer) As Integer

    Select Case tile
        Case wall: Return fbTan
        Case secretwall: Return fbTan
        Case mfloor: Return fbWhite
        Case mstart: Return fbYellow
        Case mend: Return fbYellow
        Case water: Return fbBlue
        Case doorew: Return fbPeru
        Case doorns: Return fbPeru
        Case dooropns: Return fbPeru
        Case dooropew: Return fbPeru
        Case crown: Return fbGold
        Case redorb: Return fbRed
        Case blueorb: Return fbBlue
        Case greenorb: Return fbGreen
        Case yelloworb: Return fbYellow
        Case whiteorb: Return fbAntiqueWhite
        Case sbottle: Return fbYellowGreen
        Case sbread: Return fbHoneydew
        Case scoins: Return fbGold
        Case sbagocoins: Return fbGold
        Case smeat : Return fbSalmon
        Case healscroll: Return fbMarsOrange
        Case meleescroll: Return fbMarsOrange
        Case dodgescroll: Return fbMarsOrange
        Case scanscroll: Return fbMarsOrange
        Case swordscroll: Return fbMarsOrange
        Case axescroll: Return fbMarsOrange
        Case spearscroll: Return fbMarsOrange
        Case macescroll: Return fbMarsOrange
        Case flailscroll: Return fbMarsOrange
        Case bowscroll: Return fbMarsOrange
        Case crossbowscroll: Return fbMarsOrange
        Case shieldscroll: Return fbMarsOrange
        Case combatawarescroll: Return fbMarsOrange
        Case stealthscroll: Return fbMarsOrange
        Case searchscroll: Return fbMarsOrange
        Case disarmtrapscroll: Return fbMarsOrange
        Case picklockscroll: Return fbMarsOrange
        Case readancientscroll: Return fbMarsOrange
        Case evalscroll: Return fbMarsOrange
        Case usemagicscroll: Return fbMarsOrange
        Case torch: Return fbYellow
        Case lantern: Return fbYellow
        Case redpotion: Return fbRed
        Case yellowpotion: Return fbYellow
        Case greenpotion:Return fbGreen
        Case bluepotion: Return fbBlue
        Case magentapotion: Return fbMagenta
        Case whitepotion: Return fbWhite
        Case blackpotion: Return fbSlateGreyDark
        Case rubyring: Return fbRoseMadder
        Case diamondring: Return fbZincWhite
        Case emeraldring: Return fbEmeraldGreen
        Case topazring: Return fbGoldenrodDark
        Case silverring: Return fbTitaniumWhite
        Case goldring: Return fbGold
        Case bronzering: Return fbNaplesYellowDeep
        Case copperring: Return fbOrangeRed
        Case rubynecklace: Return fbRoseMadder
        Case diamondnecklace: Return fbZincWhite
        Case emeraldnecklace: Return fbEmeraldGreen
        Case topaznecklace: Return fbGoldenrodDark
        Case silvernecklace: Return fbTitaniumWhite
        Case goldnecklace: Return fbGold
        Case bronzenecklace: Return fbNaplesYellowDeep
        Case coppernecklace: Return fbOrangeRed
        Case wwand: Return fbWhite
        Case bolts: Return fbSepia
        Case arrows:Return fbSepia
        Case pebbles:Return fbSandyBrown
        Case club: Return fbGoldenrodDark
        Case warclub: Return fbGoldenrodDark
        Case cudgel: Return fbGoldenrodDark
        Case dagger: Return fbGoldenrodDark
        Case longknife: Return fbGoldenrodDark
        Case smallsword: Return fbGoldenrodDark
        Case shortsword: Return fbGoldenrodDark
        Case rapier: Return fbGoldenrodDark
        Case broadsword: Return fbGoldenrodDark
        Case scimitar: Return fbGoldenrodDark
        Case katana: Return fbGoldenrodDark
        Case longsword: Return fbGoldenrodDark
        Case claymore: Return fbGoldenrodDark
        Case greatsword: Return fbGoldenrodDark
        Case odinsword: Return fbGoldenrodDark
        Case hellguard: Return fbGoldenrodDark
        Case quarterstaff: Return fbGoldenrodDark
        Case longstaff: Return fbGoldenrodDark
        Case polearm: Return fbGoldenrodDark
        Case lightspear: Return fbGoldenrodDark
        Case heavyspear: Return fbGoldenrodDark
        Case trident: Return fbGoldenrodDark
        Case glaive: Return fbGoldenrodDark
        Case handaxe: Return fbGoldenrodDark
        Case battleaxe: Return fbGoldenrodDark
        Case gothicbattleaxe: Return fbGoldenrodDark
        Case waraxe: Return fbGoldenrodDark
        Case halberd: Return fbGoldenrodDark
        Case poleaxe: Return fbGoldenrodDark
        Case smallmace: Return fbGoldenrodDark
        Case battlemace: Return fbGoldenrodDark
        Case spikedmace: Return fbGoldenrodDark
        Case doubleballmace: Return fbGoldenrodDark
        Case warhammer: Return fbGoldenrodDark
        Case maul: Return fbGoldenrodDark
        Case ballflail: Return fbGoldenrodDark
        Case spikedflail: Return fbGoldenrodDark
        Case morningstar: Return fbGoldenrodDark
        Case bullwhip: Return fbGoldenrodDark
        Case battleflail: Return fbGoldenrodDark
        Case bishopsflail: Return fbGoldenrodDark
        Case sling: Return fbGoldenrodDark
        Case shortbow: Return fbGoldenrodDark
        Case longbow: Return fbGoldenrodDark
        Case bonebow: Return fbGoldenrodDark
        Case adaminebow: Return fbGoldenrodDark
        Case lightcrossbow: Return fbGoldenrodDark
        Case heavycrossbow: Return fbGoldenrodDark
        Case barrelcrossbow: Return fbGoldenrodDark
        Case leatherarm: Return fbChromeOxideGreen
        Case cuirboliarm: Return fbChromeOxideGreen
        Case ringarm: Return fbChromeOxideGreen
        Case brigantinearm: Return fbChromeOxideGreen
        Case chainarm: Return fbChromeOxideGreen
        Case scalearm: Return fbChromeOxideGreen
        Case platearm: Return fbChromeOxideGreen
        Case leathershld: Return fbViridianLight
        Case cuirbolishld: Return fbViridianLight
        Case ringshld: Return fbViridianLight
        Case brigantineshld: Return fbViridianLight
        Case chainshld: Return fbViridianLight
        Case scaleshld: Return fbViridianLight
        Case plateshld: Return fbViridianLight
        Case Else: Return fbWhite
    End Select
End Function

'returns the description for object
Sub DrawBlock(x As Integer, y As Integer, fcolor As Integer, size As Integer)
    Line (x - size, y - size) - (x + size, y + size), fcolor, BF
End Sub

Sub DrawMiniMapItem(offset As Integer, i As Integer, j As Integer, x As Integer, y As Integer, size As Integer)
    If levels.visited(i, j) = True Then        
        If levels.map(i, j) = wall Or levels.map(i, j) = secretwall Then
            DrawBlock x + (i * offset), y + (j * offset), fbWhite, size
        ElseIf levels.map(i, j) = doorns Or levels.map(i, j) = doorew Then
            DrawBlock x + (i * offset), y + (j * offset), fbTan, size
        ElseIf levels.map(i, j) = dooropns Or levels.map(i, j) = dooropew Then
            DrawBlock x + (i * offset), y + (j * offset), fbWarmGrey, size
        ElseIf levels.map(i, j) = water Then
            DrawBlock x + (i * offset), y + (j * offset), fbBlue, size
        ElseIf levels.map(i, j) = mfloor Then
            DrawBlock x + (i * offset), y + (j * offset), fbWarmGrey, size
        ElseIf levels.map(i, j) = mend Or levels.map(i, j) = mstart Then
            DrawBlock x + (i * offset), y + (j * offset), fbOrange, size
        End If
        If levels.item(i, j).typeid > 0 Then
            DrawBlock x + (i * offset), y + (j * offset), fbYellow, size
        End If
    Else
        DrawBlock x + (i * offset), y + (j * offset), fbBlack, size
    End If
    'Draw the player
    DrawBlock x + (player.pcoord.x * offset), y + (player.pcoord.y * offset), fbGreen, size
End Sub

Sub ExpandMiniMap
    Dim x As Integer = 165
    Dim y As Integer = 55
    Dim size As Integer = 2
    Dim offset As Integer = size * 2
    Dim As Integer i, j
    
    Color fbYellow, fbUltramarine
    Cls
    Line (x - (offset * 2), y - (offset * 2)) - (x + (dunw * offset) + offset, y + (dunh * offset) + offset), fbMarsOrange, BF
    For i = 0 To dunw - 1
        For j = 0 To dunh - 1
            DrawMiniMapItem offset, i, j, x, y, size
        Next
    Next
    Color fbYellow, fbUltramarine
    CenterText 2, "Current Map of Dungeon Level " + Str$(levels.currlevel)
    Color fbWhite, fbUltramarine 
    CenterText 55, "Map Legend"
    Locate 57, 1
    Color fbWarmGrey, fbUltramarine 
    Print "                   Floor ";
    Color fbBlue, fbUltramarine 
    Print "Water ";
    Color fbWhite, fbUltramarine 
    Print "Wall ";
    Color fbTan, fbUltramarine 
    Print "Door ";
    Color fbOrange, fbUltramarine 
    Print "Stairs ";
    Color fbYellow, fbUltramarine 
    Print "Items ";
    Color fbGreen, fbUltramarine 
    Print "Player ";
    
    Sleep
    Do:Loop While Inkey$<>""
    Color fbYellow, fbBlack
    Cls
    DrawMap
End Sub

Sub DrawMiniMap
    Dim x As Integer = 520
    Dim y As Integer = 358
    Dim size As Integer = 1
    Dim offset As Integer = size 
    
    Dim As Integer i, j
    
    Line (x - 3, y - 3) - (x + dunw + 2, y + dunh + 2), fbMarsOrange, BF
    For i = 0 To dunw - 1
        For j = 0 To dunh - 1
            DrawMiniMapItem offset, i, j, x, y, size
        Next
    Next
End Sub

Sub DrawHealthBar(hx As Integer, hy As Integer, pct As Single)
    Dim As Integer x1, x2, y1, y2
    Dim hcolor As Integer
        
    If levels.showhealth Then
        x1 = hx
        x2 = hx + (16 * pct)
        y1 = hy - 1
        y2 = hy
        If pct > .74 Then
            hcolor = fbGreen
        ElseIf pct < .75 And pct > .5 Then
            hcolor = fbYellow
        Else
            hcolor = fbRed
        End If
        Line (x1, y1) - (x2, y2), hcolor, B
        Line (x1, y1) - (x2, y2), hcolor, BF
    End If    
End Sub

Sub PlayMapSound(tile As Integer)
    #IfNDef cnosound
    Select Case tile
        Case crown
            PlayWavSound sndusei
        Case redorb
            PlayWavSound sndusei
        Case blueorb
            PlayWavSound sndusei
        Case greenorb
            PlayWavSound sndusei
        Case yelloworb
            PlayWavSound sndusei
        Case whiteorb
            PlayWavSound sndusei
        Case scoins
            PlayWavSound sndcoin
        Case sbagocoins
            PlayWavSound sndcoin
    End Select
    #endif
End Sub

Function CheckMapItem As Integer
    Dim tile As Integer
    Dim mess As String
    
    'Is player standing on an item?
    If levels.item(player.pcoord.x, player.pcoord.y).typeid > 0 Then
        tile = GetItemID(levels.item(player.pcoord.x, player.pcoord.y))
        mess = Trim$(levels.item(player.pcoord.x, player.pcoord.y).desc )
        Select Case tile
            Case crown
                player.hasorbs.hascrown = True
                player.attr.expr += 1000
                player.attr.totexp += 1000
                player.modmagicattack += 10
                levels.item(player.pcoord.x, player.pcoord.y).typeid = 0
            Case redorb
                player.hasorbs.hasredorb = True
                player.attr.expr += 1000
                player.attr.totexp += 1000
                player.modtohit += 10
                levels.item(player.pcoord.x, player.pcoord.y).typeid = 0
            Case blueorb
                player.hasorbs.hasblueorb = True
                player.attr.expr += 1000
                player.attr.totexp += 1000
                player.moddamage += 10
                levels.item(player.pcoord.x, player.pcoord.y).typeid = 0
            Case greenorb
                player.hasorbs.hasgreenorb = True
                player.attr.expr += 1000
                player.attr.totexp += 1000
                player.moddefense += 10
                levels.item(player.pcoord.x, player.pcoord.y).typeid = 0
            Case yelloworb
                player.hasorbs.hasyelloworb = True
                player.attr.expr += 1000
                player.attr.totexp += 1000
                player.modarmor += 10
                levels.item(player.pcoord.x, player.pcoord.y).typeid = 0
            Case whiteorb
                player.hasorbs.haswhiteorb = True
                player.attr.expr += 1000
                player.attr.totexp += 1000
                player.modmagicdef += 10
                levels.item(player.pcoord.x, player.pcoord.y).typeid = 0
            Case scoins, sbagocoins
                player.coins += levels.item(player.pcoord.x, player.pcoord.y).supply.count
                player.attr.expr += levels.item(player.pcoord.x, player.pcoord.y).supply.count
                player.attr.totexp += levels.item(player.pcoord.x, player.pcoord.y).supply.count
                ClearInvItem levels.item(player.pcoord.x, player.pcoord.y) 
        End Select        
        PrintMessage mess
    ElseIf levels.map(player.pcoord.x, player.pcoord.y) = mend Then
        mess = "Stairs down"
        PrintMessage mess
    ElseIf levels.map(player.pcoord.x, player.pcoord.y) = mstart Then
        mess = "Stairs up"
        PrintMessage mess
    End If
    Return tile
End Function

'draws the map On Screen
#IfNDef isascii
Sub DrawMap
    Dim As Integer i, j
    Dim w As Integer = vw
    Dim h As Integer = vh
    Dim As Integer x, y, px, py, hx, hy
    Dim iid As Integer
    Dim tile As Integer
    Dim mess As String
    Dim As Integer miid, midx
    Dim pct As Single
    Dim As Integer currvision
    
    ScreenSet 1, 0
    'get currvision range
    currvision = GetCurrvision
    'get the view coords
    i = player.pcoord.x - (w / 2)
    j = player.pcoord.y - (h / 2)
    If i < 0 Then i = 0
    If j < 0 Then j = 0
    If i + w > dunw - 1 Then i = dunw - w - 1
    If j + h > dunh - 1 Then j = dunh - h - 1
    
    For x = 0 To w
        For y = 0 To h
            If levels.isseen(i + x, j + y) = True Then
                If levels.map(i + x, j + y) = mfloor Then
                    If levels.tmaptype = cavern Then
                        Get tmap,(96, 0) - (111, 15), tp
                    ElseIf levels.tmaptype = dungeon Then
                        If levels.mapscheme Then
                            Get tmap,(80, 0) - (95, 15), tp
                        Else
                            Get tmap,(112, 0) - (127, 15), tp
                        End If
                    End If
                    Put (x * 16, y * 16), tp, PSet
                ElseIf levels.map(i + x, j + y) = water Then
                    Get tmap,(16, 0) - (31, 15), tp
                    Put (x * 16, y * 16), tp, PSet
                ElseIf levels.map(i + x, j + y) = wall Or _
                       levels.map(i + x, j + y) = secretwall Then
                    If levels.tmaptype = cavern Then
                        Get tmap,(272, 0) - (287, 15), tp
                    ElseIf levels.tmaptype = dungeon Then
                        If levels.mapscheme Then
                            Get tmap,(256, 0) - (271, 15), tp
                        Else
                            Get tmap,(288, 0) - (303, 15), tp
                        End If
                    End If
                    Put (x * 16, y * 16), tp, PSet
                ElseIf levels.map(i + x, j + y) = doorew Then
                    Get tmap,(32, 0) - (47, 15), tp
                    Put (x * 16, y * 16), tp, PSet
                ElseIf levels.map(i + x, j + y) = doorns Then
                    Get tmap,(304, 0) - (319, 15), tp
                    Put (x * 16, y * 16), tp, PSet
                ElseIf levels.map(i + x, j + y) = dooropew Then
                    If levels.mapscheme Then
                        Get tmap,(80, 0) - (95, 15), tp
                    Else 
                        Get tmap,(112, 0) - (127, 15), tp
                    End If
                    Put (x * 16, y * 16), tp, PSet
                    Get tmap,(64, 0) - (79, 15), tp
                    Put (x * 16, y * 16), tp, Trans
                ElseIf levels.map(i + x, j + y) = dooropns Then
                    If levels.mapscheme Then
                        Get tmap,(80, 0) - (95, 15), tp
                    Else
                        Get tmap,(112, 0) - (127, 15), tp
                    End If
                    Put (x * 16, y * 16), tp, PSet
                    Get tmap,(48, 0) - (63, 15), tp
                    Put (x * 16, y * 16), tp, Trans
                ElseIf levels.map(i + x, j + y) = mstart Then
                    Get tmap,(176, 0) - (191, 15), tp
                    Put (x * 16, y * 16), tp, PSet
                ElseIf levels.map(i + x, j + y) = mend Then
                    Get tmap,(160, 0) - (175, 15), tp
                    Put (x * 16, y * 16), tp, PSet
                End If
                ''Put a trap if found
                If levels.traps(i + x, j + y).istrap And _
                   levels.traps(i + x, j + y).isseen Then
                    If levels.traps(i + x, j + y).ttype = 1 Then
                        Get tmap,(224, 0) - (239, 15), tp
                        Put (x * 16, y * 16), tp, Trans
                    Else
                        Get tmap,(240, 0) - (255, 15), tp
                        Put (x * 16, y * 16), tp, Trans
                    End If
                End If
                ''Put any items
                If levels.item(i + x, j + y).typeid <> 0 Then 
                    If PlayerCanSee(i + x, j + y) Then
                        If levels.item(i + x, j + y).typeid = rings Then
                            Get titem,(336, 0) - (351, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        ElseIf levels.item(i + x, j + y).typeid = wands Then
                            Get titem,(399, 0) - (414, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        ElseIf levels.item(i + x, j + y).typeid = necklaces Then
                            Get titem,(272, 0) - (287, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        ElseIf levels.item(i + x, j + y).typeid = scrolls Then
                            Get titem,(352, 0) - (367, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        ElseIf levels.item(i + x, j + y).typeid = armors Then
                            Get titem,(0, 0) - (15, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        ElseIf levels.item(i + x, j + y).typeid = shields Then
                            Get titem,(369, 0) - (384, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Else
                            iid = GetItemID(levels.item(i + x, j + y))
                            Select Case iid
                                Case arrows
                                    Get titem,(16, 0) - (31, 15), tp
                                    Put (x * 16, y * 16), tp, Trans
                                Case bolts
                                     Get titem,(96, 0) - (111, 15), tp
                                     Put (x * 16, y * 16), tp, Trans
                                Case lantern
                                    Get titem,(224, 0) - (239, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case torch
                                    Get titem,(383, 0) - (398, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case smeat
                                    Get titem,(256, 0) - (271, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case sbottle
                                    Get titem,(111, 0) - (126, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case sbread
                                    Get titem,(127, 0) - (142, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case scoins
                                    Get titem,(144, 0) - (159, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case sbagocoins
                                    Get titem,(464, 0) - (479, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case redpotion
                                    Get titem,(320, 0) - (335, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case yellowpotion
                                    Get titem,(32, 0) - (47, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case greenpotion
                                    Get titem,(208, 0) - (223, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case bluepotion
                                    Get titem,(80, 0) - (95, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case magentapotion
                                    Get titem,(240, 0) - (255, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case cyanpotion
                                    Get titem,(176, 0) - (191, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case whitepotion
                                    Get titem,(432, 0) - (447, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case blackpotion
                                    Get titem,(48, 0) - (63, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case crown
                                    Get titem,(160, 0) - (175, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case redorb
                                    Get titem,(305, 0) - (320, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case blueorb
                                    Get titem,(64, 0) - (79, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case greenorb
                                    Get titem,(192, 0) - (207, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case yelloworb
                                    Get titem,(448, 0) - (463, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case whiteorb
                                    Get titem,(416, 0) - (431, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case club
                                    Get tweapon,(176, 0) - (191, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case warclub
                                    Get tweapon,(752, 0) - (767, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case pebbles
                                    Get titem,(288, 0) - (303, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case cudgel
                                    Get tweapon,(192, 0) - (207, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case dagger
                                    Get tweapon,(208, 0) - (223, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case longknife
                                    Get tweapon,(400, 0) - (415, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case smallsword
                                    Get tweapon,(672, 0) - (687, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case shortsword
                                    Get tweapon,(624, 0) - (639, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case rapier
                                    Get tweapon,(576, 0) - (591, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case broadsword
                                    Get tweapon,(128, 0) - (143, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case scimitar
                                    Get tweapon,(592, 0) - (607, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case katana
                                    Get tweapon,(368, 0) - (383, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case longsword
                                    Get tweapon,(432, 0) - (447, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case claymore
                                    Get tweapon,(160, 0) - (175, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case greatsword
                                    Get tweapon,(272, 0) - (287, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case odinsword
                                    Get tweapon,(512, 0) - (527, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case hellguard
                                    Get tweapon,(320, 0) - (335, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case quarterstaff
                                    Get tweapon,(560, 0) - (575, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case longstaff
                                    Get tweapon,(416, 0) - (431, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case polearm
                                    Get tweapon,(528, 0) - (543, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case lightspear
                                    Get tweapon,(464, 0) - (479, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case heavyspear
                                    Get tweapon,(352, 0) - (367, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case trident
                                    Get tweapon,(720, 0) - (735, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case glaive
                                    Get tweapon,(256, 0) - (271, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case handaxe 
                                    Get tweapon,(304, 0) - (319, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case battleaxe
                                    Get tweapon,(0, 0) - (15, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case gothicbattleaxe
                                    Get tweapon,(240, 0) - (255, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case waraxe
                                    Get tweapon,(736, 0) - (751, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case halberd
                                    Get tweapon,(288, 0) - (303, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case poleaxe
                                    Get tweapon,(544, 0) - (559, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case smallmace
                                    Get tweapon,(656, 0) - (671, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case battlemace
                                    Get tweapon,(80, 0) - (95, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case spikedmace
                                    Get tweapon,(704, 0) - (719, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case doubleballmace
                                    Get tweapon,(224, 0) - (239, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case warhammer
                                    Get tweapon,(768, 0) - (783, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case maul
                                    Get tweapon,(480, 0) - (495, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case ballflail
                                    Get tweapon,(16, 0) - (31, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case spikedflail
                                    Get tweapon,(688, 0) - (703, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case morningstar
                                    Get tweapon,(496, 0) - (511, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case bullwhip
                                    Get tweapon,(144, 0) - (159, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case battleflail
                                    Get tweapon,(48, 0) - (63, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case bishopsflail
                                    Get tweapon,(96, 0) - (111, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case sling
                                    Get tweapon,(640, 0) - (655, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case shortbow
                                    Get tweapon,(608, 0) - (623, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case longbow
                                    Get tweapon,(384, 0) - (399, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case bonebow
                                    Get tweapon,(112, 0) - (127, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case adaminebow
                                    Get tweapon,(64, 0) - (79, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case lightcrossbow
                                    Get tweapon,(448, 0) - (463, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case heavycrossbow
                                    Get tweapon,(336, 0) - (351, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                                Case barrelcrossbow
                                    Get tweapon,(32, 0) - (47, 15), tp
                                    Put (x * 16, y * 16), tp, Trans 
                            End Select
                        End If
                    Else
                        Get tmap,(192, 0) - (207, 15), tp
                        Put (x * 16, y * 16), tp, Trans 
                    End If
                End If
                ''Put any monsters
                If IsMonsterLoc(i + x, j + y) And PlayerCanSee(i + x, j + y) Then
                    midx = GetMonsterIndex(i + x, j + y)
                    miid = levels.monster(midx).id
                    Select Case miid
                        Case darkangel
                            Get tmonster,(0, 0) - (15, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case giantbat
                            Get tmonster,(128, 0) - (143, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case giantscorpion
                            Get tmonster,(176, 0) - (191, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case dragon
                            Get tmonster,(32, 0) - (47, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case elfwarrior
                            Get tmonster,(64, 0) - (79, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case wisp
                            Get tmonster,(704, 0) - (719, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case giant
                            Get tmonster,(112, 0) - (127, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case harpy
                            Get tmonster,(240, 0) - (255, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case incubus
                            Get tmonster,(272, 0) - (287, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case jadegolem
                            Get tmonster,(304, 0) - (319, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case kraken
                            Get tmonster,(336, 0) - (351, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case lamia
                            Get tmonster,(352, 0) - (367, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case manticore
                            Get tmonster,(400, 0) - (415, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case naga
                            Get tmonster,(416, 0) - (431, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case ogre
                            Get tmonster,(448, 0) - (463, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case phantomfungus
                            Get tmonster,(480, 0) - (495, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case quorn
                            Get tmonster,(512, 0) - (527, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case rockgolem
                            Get tmonster,(528, 0) - (543, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case skeleton
                            Get tmonster,(592, 0) - (607, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case troll
                            Get tmonster,(608, 0) - (623, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case uruk
                            Get tmonster,(640, 0) - (655, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case vampire
                            Get tmonster,(656, 0) - (671, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case wombat
                            Get tmonster,(720, 0) - (735, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case xerth
                            Get tmonster,(752, 0) - (767, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case yeek
                            Get tmonster,(784, 0) - (799, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case zombie
                            Get tmonster,(816, 0) - (831, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case flameangel
                            Get tmonster,(80, 0) - (95, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case werebear
                            Get tmonster,(688, 0) - (703, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case giantcentipede
                            Get tmonster,(160, 0) - (175, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case demonspawn
                            Get tmonster,(16, 0) - (31, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case elemental
                            Get tmonster,(48, 0) - (33, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case flamegolem
                            Get tmonster,(96, 0) - (111, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case golem
                            Get tmonster,(208, 0) - (223, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case hobgoblin
                            Get tmonster,(256, 0) - (271, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case interloper
                            Get tmonster,(288, 0) - (303, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case rovingjelly
                            Get tmonster,(560, 0) - (575, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case kobold
                            Get tmonster,(320, 0) - (335, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case lich
                            Get tmonster,(368, 0) - (383, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case mage
                            Get tmonster,(384, 0) - (399, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case nazgul
                            Get tmonster,(432, 0) - (447, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case orc
                            Get tmonster,(464, 0) - (479, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case pulsingeye
                            Get tmonster,(496, 0) - (511, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case twinhead
                            Get tmonster,(624, 0) - (639, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case rogue
                            Get tmonster,(544, 0) - (559, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case shurik
                            Get tmonster,(576, 0) - (591, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case gianttarantula
                            Get tmonster,(192, 0) - (207, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case giantbeetle
                            Get tmonster,(144, 0) - (159, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case varghoul
                            Get tmonster,(352, 0) - (367, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case wraith
                            Get tmonster,(736, 0) - (741, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case xorn
                            Get tmonster,(768, 0) - (783, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case yekki
                            Get tmonster,(800, 0) - (815, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                        Case griffon
                            Get tmonster,(224, 0) - (239, 15), tp
                            Put (x * 16, y * 16), tp, Trans
                    End Select
                    'draw monster health bar
                    hy = y * 16
                    hx = x * 16
                    pct = levels.monster(midx).attr.currhp / levels.monster(midx).attr.maxhp
                    If pct > 0 Then
                        DrawHealthBar hx, hy, pct
                    End If
                End If
                'mask out of range tiles
                If CalcDist(player.pcoord.x, i + x, player.pcoord.y, j + y) > currvision Or PlayerCanSee(i + x, j + y) = False Then
                    Get tmap,(128, 0) - (143, 15), tp
                    Put (x * 16, y * 16), tp, Trans
                End If
            Else
                Get tmap,(0, 0) - (15, 15), tp
                Put (x * 16, y * 16), tp, PSet
            End If
        Next 
    Next
    'draw the player
    px = (player.pcoord.x - i) * 16
    py = (player.pcoord.y - j) * 16 
    Get tmap,(144, 0) - (159, 15), tp
    Put (px, py), tp, Trans
    pct = player.attr.currhp / player.attr.maxhp
    DrawHealthBar px, py, pct
    DrawStats
    DrawMiniMap
    tile = CheckMapItem
    ScreenCopy
    ScreenSet 0
    PlayMapSound tile
End Sub
#Else
'ascii drawing rouine
Sub DrawMap
    Dim As Integer i, j
    Dim w As Integer = vw
    Dim h As Integer = vh
    Dim As Integer x, y, px, py
    Dim As Integer tile, tilecolor, miid, tid
    Dim mtile As String
    Dim As Integer currvision
    Dim pct As Single
    
    ScreenSet 1, 0
    'get currvision range
    currvision = GetCurrvision
    'get the view coords
    i = player.pcoord.x - (w / 2)
    j = player.pcoord.y - (h / 2)
    If i < 0 Then i = 0
    If j < 0 Then j = 0
    If i + w > dunw - 1 Then i = dunw - w - 1
    If j + h > dunh - 1 Then j = dunh - h - 1
    Color fbWhite, fbBlack
    Cls    
    For x = 0 To w
        For y = 0 To h
            If levels.isseen(i + x, j + y) = True Then
                tile = levels.map(i + x, j + y) 
                'print map symbol
                mtile = GetSymbol(tile)
                tilecolor = GetSymbolColor(tile)
                If (tile = mstart) Or (tile = mend) Then
                    Color tilecolor, fbBlack
                    Locate y +1, x + 1
                    Print mtile;
                Else
                    If CalcDist(player.pcoord.x, i + x, player.pcoord.y, j + y) > currvision Or PlayerCanSee(i + x, j + y) = False Then
                        Color fbSlateGreyDark, fbBlack
                        Locate y +1, x + 1
                        Print mtile;
                    Else    
                        Color tilecolor, fbBlack
                        Locate y +1, x + 1
                        Print mtile;
                    End If
                End If
                ''Put a trap if found
                If levels.traps(i + x, j + y).istrap And _
                   levels.traps(i + x, j + y).isseen Then
                   'print trap symbol
                   Color fbRed, fbBlack
                   Locate y +1, x + 1
                   Print Chr$(255)
                End If
                ''Put any items
                If levels.item(i + x, j + y).typeid <> 0 Then 
                    If PlayerCanSee(i + x, j + y) Then
                        'get the id for the item
                        tid = levels.item(i + x, j + y).typeid
                        tilecolor = GetSymbolColor(tid)
                        Select Case tid
                            Case supplies
                                tile = levels.item(i + x, j + y).supply.id 
                            Case necklaces
                                tile = levels.item(i + x, j + y).necklace.id 
                            Case potions
                                tile = levels.item(i + x, j + y).potion.id 
                            Case rings
                                tile = levels.item(i + x, j + y).ring.id 
                            Case wands
                                tile = levels.item(i + x, j + y).wand.id 
                            Case weapons
                                tile = levels.item(i + x, j + y).weapon.id 
                            Case armors
                                tile = levels.item(i + x, j + y).armor.id 
                            Case lights
                                tile = levels.item(i + x, j + y).light.id 
                            Case ammos
                                tile = levels.item(i + x, j + y).ammo.id 
                            Case shields
                                tile = levels.item(i + x, j + y).shield.id 
                            Case scrolls
                                tile = levels.item(i + x, j + y).scroll.id 
                        End Select
                        'print symbol
                        mtile = GetSymbol(tile)
                        Color tilecolor, fbBlack
                        Locate y + 1, x + 1
                        Print mtile;
                    Else
                        'print can't see tile
                        Color fbGrey, fbBlack
                        Locate y +1, x + 1
                        Print "?";
                    End If
                End If
                ''Put any monsters
                If IsMonsterLoc(i + x, j + y) And PlayerCanSee(i + x, j + y) Then
                    miid = GetMonsterIndex(i + x, j + y)
                    tile = levels.monster(miid).id
                    mtile = GetMonsterSymbol(tile)
                    tilecolor = GetMonsterColor(tile)
                    Color tilecolor, fbBlack
                    Locate y +1, x + 1
                    Print mtile;
                End If
            End If
        Next 
    Next
    'Draw the player
    px = (player.pcoord.x - i)
    py = (player.pcoord.y - j)
    pct = player.attr.currhp / player.attr.maxhp
    If pct > .74 Then
        Color fbGreen, fbBlack
    ElseIf pct < .75 And pct > .5 Then
        Color fbYellow, fbBlack
    Else
        Color fbRed, fbBlack
    End If
    Locate py + 1, px + 1
    Print Chr$(1);
    DrawStats
    DrawMiniMap
    tile = CheckMapItem
    ScreenCopy
    ScreenSet 0
    PlayMapSound tile
End Sub
#endif

Sub AddItems
    Dim As Integer i, cx, cy
    Dim As Integer itemid, iitem
    
    For i = 1 To numadditems
        Do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        Loop Until levels.map(cx, cy) = mfloor Or levels.map(cx, cy) = water
        If levels.item(cx, cy).typeid = 0 Then
            AddAnItem cx, cy
        End If
    Next i
End Sub

sub AddDoors
    dim as integer i, j, k 
    
    'add doors to the map
    for i = 1 to dunw - 2
        for j = 1 to dunh - 2
            with levels
            if .map(i,j) = mfloor then
               if .map(i, j - 1) = wall and _
                  .map(i, j + 1) = wall and _
                  .map(i - 1, j - 1) = mfloor and _
                  .map(i - 1, j) = mfloor and _
                  .map(i - 1, j + 1) = mfloor then
                        .map(i, j) = doorns
                        k = GetPercentage(levels.currlevel * 4)
                        if k then
                            .isdoor(i, j).islocked = True
                            .isdoor(i, j).dstr = GetRandom(1, 100) + levels.currlevel
                        end if
               elseif .map(i, j - 1) = wall and _
                  .map(i, j + 1) = wall and _
                  .map(i + 1, j - 1) = mfloor and _
                  .map(i + 1, j) = mfloor and _
                  .map(i + 1, j + 1) = mfloor then
                        .map(i, j) = doorns
                        k = GetPercentage(levels.currlevel * 4)
                        if k then
                            .isdoor(i, j).islocked = True
                            .isdoor(i, j).dstr = GetRandom(1, 100) + levels.currlevel
                        end if
               elseif .map(i - 1, j) = wall and _
                  .map(i + 1, j) = wall and _
                  .map(i - 1, j - 1) = mfloor and _
                  .map(i, j - 1) = mfloor and _
                  .map(i + 1, j - 1) = mfloor then
                        .map(i, j) = doorew
                        k = GetPercentage(levels.currlevel * 4)
                        if k then
                            .isdoor(i, j).islocked = True
                            .isdoor(i, j).dstr = GetRandom(1, 100) + levels.currlevel 
                        end if
               elseif .map(i - 1, j) = wall and _
                  .map(i + 1, j) = wall and _
                  .map(i - 1, j + 1) = mfloor and _
                  .map(i, j + 1) = mfloor and _
                  .map(i + 1, j + 1) = mfloor then
                        .map(i, j) = doorew
                        k = GetPercentage(levels.currlevel * 4)
                        if k then
                            .isdoor(i, j).islocked = True
                            .isdoor(i, j).dstr = GetRandom(1, 100) + levels.currlevel 
                        end if
                end if
            end if
            end with
        next j
    next i
end sub

sub AddSecretRooms
    dim as integer i, j, k, l
    dim as integer x, y, cx, cy
    dim sroomsize as integer
    dim ok as integer
    dim direction as integer
    
    'add in some secret rooms
    for i = 2 to dunw - 3
        for j = 2 to dunh - 3
            'find a spot for the room
            'secret room must have a wall border area
            'so check one tile outside secret room size
            sroomsize = GetRandom(2, 8)
            ok = True
            for k = i - 1 to i + sroomsize + 1
                for l = j - 1 to j + sroomsize + 1
                    if levels.map(k, l) <> wall then
                        ok = False
                    end if
                next l
            next k
            'if we found a spot add a corridor to 
            'nearest floor along a random direction 
            if ok = True then
                'fill in the room
                for k = i to i + sroomsize
                    for l = j to j + sroomsize
                        levels.map(k, l) = mfloor
                        levels.issecret(k, l) = True
                    next l
                next k
                If GetPercentage(levels.currlevel * 2) Then
                    'hide an item in the room
                    cx = GetRandom(i + 1, k - 1)
                    cy = GetRandom(j + 1, l - 1)
                    AddAnItem cx, cy
                end if
                'pick a random direction
                direction = GetRandom(north, west)
                tryagain:
                'get the starting position
                if direction = north then
                    x = i + (sroomsize / 2)
                    y = j - 1
                    'make sure we are not on the edge
                    If y - 1 <= 1 Then 
                        direction += 1
                        If direction > west Then direction = north
                        Goto tryagain
                    End If
                elseif direction = south then
                    x = i + (sroomsize / 2)
                    y = j + sroomsize + 1
                    'make sure we are not on the edge
                    If y + 1 >= dunh - 2 Then 
                        direction += 1
                        If direction > west Then direction = north
                        Goto tryagain
                    End If
                elseif direction = west then
                    x = i - 1
                    y = j + (sroomsize / 2)
                    'make sure we are not on the edge
                    If x - 1 <= 1 Then 
                        direction += 1
                        If direction > west Then direction = north
                        Goto tryagain
                    End If
                else
                    x = i + sroomsize + 1
                    y = j + (sroomsize / 2)
                    'make sure we are not on the edge
                    If x + 1 >= dunw - 2 Then 
                        direction += 1
                        If direction > west Then direction = north
                        Goto tryagain
                    End If
                end if
                'build the path
                do  
                    levels.map(x, y) = mfloor
                    levels.issecret(x, y) = True
                    if direction = north then
                        y = y - 1
                        If y - 1 <= 1 Then 
                            direction += 1
                            If direction > west Then direction = north
                            Goto tryagain
                        End If
                    elseif direction = south then
                        y = y + 1
                        If y + 1 >= dunh - 2 Then 
                            direction += 1
                            If direction > west Then direction = north
                            Goto tryagain
                        End If
                    elseif direction = west then
                        x = x - 1
                        If x - 1 <= 1 Then 
                            direction += 1
                            If direction > west Then direction = north
                            Goto tryagain
                        End If
                    else
                        x = x + 1
                        If x + 1 >= dunw - 2 Then 
                            direction += 1
                            If direction > west Then direction = north
                            Goto tryagain
                        End If
                    end if
                loop until levels.map(x, y) = mfloor
                'add in the secret wall.
                if direction = north then
                    levels.map(x, y + 1) = secretwall
                elseif direction = south then
                    levels.map(x, y - 1) = secretwall
                elseif direction = west then
                    levels.map(x + 1, y) = secretwall
                else
                    levels.map(x - 1, y) = secretwall
                end if
            end if
        next j
    next i
end sub

sub AddOrbs
    dim as integer cx, cy
    
    'add in orbs based on level, crown goes on level 100
    If levels.currlevel = 1 And player.hasorbs.hasredorb = False Then
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until levels.map(cx, cy) = mfloor or levels.map(cx, cy) = water
        levels.item(cx, cy).typeid = redorb
    ElseIf levels.currlevel = 5 And player.hasorbs.hasblueorb = False Then
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until levels.map(cx, cy) = mfloor or levels.map(cx, cy) = water
        levels.item(cx, cy).typeid = blueorb
    ElseIf levels.currlevel = 10 And player.hasorbs.hasgreenorb = False Then
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until levels.map(cx, cy) = mfloor or levels.map(cx, cy) = water
        levels.item(cx, cy).typeid = greenorb
    ElseIf levels.currlevel = 15 And player.hasorbs.hasyelloworb = False Then
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until levels.map(cx, cy) = mfloor or levels.map(cx, cy) = water
        levels.item(cx, cy).typeid = yelloworb
    ElseIf levels.currlevel = 20 And player.hasorbs.haswhiteorb = False Then
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until levels.map(cx, cy) = mfloor or levels.map(cx, cy) = water
        levels.item(cx, cy).typeid = whiteorb
    ElseIf levels.currlevel = 25 And player.hasorbs.hascrown = False Then
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until levels.map(cx, cy) = mfloor or levels.map(cx, cy) = water
        levels.item(cx, cy).typeid = crown
    end if
end sub

sub AddTraps
    dim as integer i, cx, cy
    dim as integer itemid, iitem
    
    'add some traps
    for i = 1 to (levels.currlevel / 10) + 1
        do
            cx = GetRandom(1, dunw - 1)
            cy = GetRandom(1, dunh - 1)
        loop until (levels.map(cx, cy) = mfloor or _
                    levels.map(cx, cy) = water) and _
                    levels.item(cx, cy).typeid = 0
        levels.traps(cx, cy).istrap = True
        levels.traps(cx, cy).isseen = False
        levels.traps(cx, cy).dr = GetDR
        levels.traps(cx, cy).damage = (GetRandom(1, levels.currlevel) / 10) + 1
        levels.traps(cx, cy).ttype = GetRandom(0, 1)
    next i
end sub

sub SetUpLevel(iscavern as integer = False)
    dim as integer cx, cy
    Dim sndval As Integer
    
    'set the start position
    do
        cx = GetRandom(2, dunw - 2)
        cy = GetRandom(2, dunh - 2)
    Loop Until levels.map(cx, cy) = mfloor
    levels.map(cx, cy) = mstart
    player.pcoord.x = cx
    player.pcoord.y = cy
    levels.startx = cx
    levels.starty = cy
    sndval = GetSoundValue
    GenSoundMap cx, cy, sndval
    'set the down stairs
    If levels.currlevel < 25 Then
        Do
            cx = GetRandom(2, dunw - 2)
            cy = GetRandom(2, dunh - 2)
        Loop Until levels.map(cx, cy) = mfloor
        levels.map(cx, cy) = mend
        levels.endx = cx
        levels.endy = cy
    End If
    'is the level dark?
    If GetPercentage(levels.currlevel * 4) Then
        levels.isdark = True
    End If
    if not iscavern then
        'Make some doors
        AddDoors
    End If
    GenLevelMonsters
    'Add in the orbs or crown
    AddOrbs
    'addin some items
    AddItems
    'add in some traps
    AddTraps
    'add in some secet rooms
    AddSecretRooms
End Sub

'adds a roundish room 
Sub AddCavernRoom(circ As Integer, x As Integer, y As Integer)
    Dim As Integer i, j
    Dim dist As Integer
    Dim iswater As Integer
    
    iswater = GetPercentage(10)
    For i = 1 To dunw - 2
        For j = 1 To dunh - 2
            dist = CalcStandardDist(x, i, y, j)
            If dist <= circ Then
                If iswater Then
                    levels.map(i, j) = water
                Else
                    levels.map(i, j) = mfloor
                End If
            End If
        Next j
    Next i
End Sub

'builds a cavern level
Sub BuildCavern
    Dim As Integer x, y
    Dim tdir As Integer
    Dim i As Integer
    Dim As Integer rmsize, numits, roombk
    
    
    numits = cnumit
    roombk = croombk
    x = GetRandom(2, dunw - 3)
    y = GetRandom(2, dunh - 3)
    tdir = GetRandom(north, west)
    For i = 1 To numits
        If GetPercentage(roombk) Then
            rmsize = GetRandom(2, 4)
            AddCavernRoom rmsize, x, y
        else
            levels.map(x, y) = mfloor
        end if
        select case tdir
            case north
                if y > 1 then 
                    y -= 1
                else
                    tdir = GetRandom(north, west)
                end if
            case south
                if y < dunh - 3 then 
                    y += 1
                else
                    tdir = GetRandom(north, west)
                end if
            case west
                if  x > 1 then 
                    x -= 1
                else
                    tdir = GetRandom(north, west)
                end if
            case east
                if x < dunw - 3 then 
                    x += 1
                else
                    tdir = GetRandom(north, west)
                end if
        end select
        if levels.map(x, y) = mfloor or levels.map(x, y) = water then
            tdir = GetRandom(north, west)
        end if
        if GetPercentage(10) then
            tdir = GetRandom(north, west)
        end if
    next i
    SetUpLevel True
end sub

Sub BuildDungeon
    Dim As Integer ok, dist, ndist, done
    Dim As Integer i, j, k, l
    Dim As Integer rmsize, numits
    Dim As mcoord ncoord, ccoord, ocoord, wcoord
    
    
    numits = dnumit
    ocoord.x = -1
    ocoord.y = -1
    
    For i = 1 To numits
        ccoord.x = GetRandom(9, dunw - 10)
        ccoord.y = GetRandom(9, dunh - 10)
        rmsize = GetRandom(2, 8)
        ok = True
        For k = ccoord.x - 1 To ccoord.x + rmsize + 1
            For l = ccoord.y - 1 To ccoord.y + rmsize + 1
                If levels.map(k, l) <> wall Then
                    ok = False
                    Exit For
                End If
            Next l
            If ok = False Then Exit For
        Next k
        'fill in the room
        If ok = True Then
            For k = ccoord.x To ccoord.x + rmsize
                For l = ccoord.y To ccoord.y + rmsize
                    levels.map(k, l) = mfloor
                Next l
            Next k
            'connect to old room if it exists
            If ocoord.x > -1 And ocoord.y > -1 Then
                'find edge closest to old room
                'north side
                wcoord.x = ccoord.x  + (rmsize / 2)
                wcoord.y = ccoord.y
                ndist = CalcMHDist(ocoord.x, wcoord.x, ocoord.y, wcoord.y)
                'south side
                ncoord.x = ccoord.x + (rmsize / 2)
                ncoord.y = ccoord.y + rmsize
                dist = CalcMHDist(ocoord.x, ncoord.x, ocoord.y, ncoord.y)
                If dist < ndist Then
                    wcoord = ncoord
                    ndist = dist
                End If
                'west side
                ncoord.x = ccoord.x
                ncoord.y = ccoord.y + (rmsize / 2)
                dist = CalcMHDist(ocoord.x, ncoord.x, ocoord.y, ncoord.y)
                If dist < ndist Then
                    wcoord = ncoord
                    ndist = dist
                End If
                'east side
                ncoord.x = ccoord.x + rmsize
                ncoord.y = ccoord.y + (rmsize / 2)
                dist = CalcMHDist(ocoord.x, ncoord.x, ocoord.y, ncoord.y)
                If dist < ndist Then
                    wcoord = ncoord
                    ndist = dist
                End If
                'connect rooms
                done = False
                Do
                    dist = CalcMHDist(ocoord.x, wcoord.x, ocoord.y, wcoord.y)
                    For k = north To west
                        ncoord = GetCoord(k, wcoord)
                        ndist = CalcMHDist(ocoord.x, ncoord.x, ocoord.y, ncoord.y)
                        If ndist <= dist Then
                            If levels.map(ncoord.x, ncoord.y) = water Then
                                done = True
                                Exit For 
                            Else
                                levels.map(ncoord.x, ncoord.y) = water
                                wcoord = ncoord
                                If dist <= 1 Then
                                    done = True
                                End If
                                Exit For
                            End If
                        End If
                    Next
                Loop Until done
                ocoord.x = ccoord.x
                ocoord.y = ccoord.y
            Else
                ocoord.x = ccoord.x
                ocoord.y = ccoord.y
            End If
        End If
    Next i
    'fix up map
    For i = 1 To dunw - 2
        For j = 1 To dunh - 2
            If levels.map(i, j) = water Then
                levels.map(i, j) = mfloor
            End If
        Next j
    Next i
    SetupLevel
End Sub
