' Deep Deadly Dungeons
' (C)2005 by Richard Clark rickclark58@yahoo.com
'
' Compiled using FB version .15b
'
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'This file contains all the sound related routines.
'
Sub InitFMod
    Dim i As Integer
    
    finit = FSOUND_Init(44100, 32, 0)
    If finit Then
        soundon = True
    Else
        soundon = False
    End If
    For i = minsound To maxsound
        sndhandles(i).channel = 0
        sndhandles(i).handle = 0
    Next
End Sub

Sub PlayWavSound(sndid As Integer)
    Dim snd As String
   
    If finit And soundon Then
        Select Case sndid
            Case sndarht
                snd = "sounds\arrowhit.wav" 'arrow hit
            Case sndarms
                snd = "sounds\arrowmiss.wav" 'arrow miss
            Case sndmiss
                snd = "sounds\miss.wav" 'miss sound
            Case sndmond
                snd = "sounds\mondead.wav" 'monster dead
            Case sndpded
                snd = "sounds\pdead.wav" 'player dead
            Case sndplck
                snd = "sounds\picklock.wav" 'pick lock
            Case sndpunc
                snd = "sounds\punch.wav" 'punch
            Case sndscrp
                snd = "sounds\scrape.wav" 'scrape
            Case sndsrch
                snd = "sounds\search.wav" 'search
            Case sndshit
                snd = "sounds\swordhit.wav" 'sword hit
            Case sndthud
                snd = "sounds\thud.wav" 'thud
            Case sndthun
                snd = "sounds\thunder.wav" 'thunder
            Case sndusei
                snd = "sounds\useitem.wav" 'use item
            Case sndwhit
                snd = "sounds\whiphit.wav" 'whip hit
            Case sndzipr
                snd = "sounds\zipper.wav" 'zipper 
            Case sndfbll
                snd = "sounds\fireball.wav" 'fireball
            Case sndbash
                snd = "sounds\bash.wav" 'bash
            Case sndtrum
                snd = "sounds\trumpet.wav" 'trumpet
            Case sndcoin
                snd = "sounds\coin.wav" 'coin
            Case sndspls
                snd = "sounds\splash.wav" 'splash
            Case snddrnk
                snd = "sounds\drink.wav"  'drink
            Case sndbite
                snd = "sounds\bite.wav" 'bite
            Case snddoor
                snd = "sounds\door.wav"  'door
            Case sndtrap
                snd = "sounds\trap.wav"  'trap
        End Select
        'make sure we have a sound and load it
        If Len(Dir$(snd)) > 0 Then
            If sndhandles(sndid).handle = 0 Then
                sndhandles(sndid).handle = FSOUND_Sample_Load(FSOUND_FREE, snd, FSOUND_NORMAL, 0, 0)
            End If
            If Not FSOUND_IsPlaying(sndhandles(sndid).channel) Then
                sndhandles(sndid).channel = FSOUND_PlaySound(FSOUND_FREE, sndhandles(sndid).handle)
            End If
        End If
    End If
       
End Sub

Sub PlayTitle
    Dim songhandle As Integer
    Dim playing As Integer = False

    If finit And soundon Then
        PlayWavSound sndthun
        songHandle = FMUSIC_LoadSong("sounds\exorcist.mid")
        playing = FMUSIC_PlaySong(songhandle)
        Do
            Sleep 10
        Loop While Inkey$ = ""
    Else
        Sleep
    End If
    If playing Then
        FMUSIC_StopSong songHandle
        FMUSIC_FreeSong songHandle
    End If

End Sub

Sub PlayDeadTitle
    Dim songhandle As Integer
    Dim playing As Integer = False

    If finit And soundon Then
        songHandle = FMUSIC_LoadSong("sounds\dead.mid")
        playing = FMUSIC_PlaySong(songhandle)
        Do
            Sleep 10
        Loop While Inkey$ = ""
    Else
        Sleep
    End If
    If playing Then
        FMUSIC_StopSong songHandle
        FMUSIC_FreeSong songHandle
    End If

End Sub

Sub PlayWinTitle
    Dim songhandle As Integer
    Dim playing As Integer = False

    If finit And soundon Then
        songHandle = FMUSIC_LoadSong("sounds\win.mid")
        playing = FMUSIC_PlaySong(songhandle)
        Do
            Sleep 10
        Loop While Inkey$ = ""
    Else
        Sleep
    End If
    If playing Then
        FMUSIC_StopSong songHandle
        FMUSIC_FreeSong songHandle
    End If

End Sub

Sub StopSoundTrack
    If isplaying Then
        FMUSIC_StopSong sndtrack
        FMUSIC_FreeSong sndtrack
        isplaying = False
    End If
End Sub

Sub PlaySoundTrack(spec As String = "")
    Dim sng As String
    
    StopSoundTrack
    If spec = "" Then
        sng = "sounds\" + Trim$(Str$(levels.currlevel)) + ".mid"
    Else
        sng = "sounds\" + spec
    End If
    If Len(Dir$(sng)) > 0 Then
        If finit And soundon Then
            sndtrack = FMUSIC_LoadSong(sng)
            FMUSIC_SetMasterVolume sndtrack, sndvol
            isplaying = FMUSIC_PlaySong(sndtrack)
        End If
    End If
End Sub

Sub ClearSounds
    Dim i As Integer
    
    For i = minsound To maxsound
        FSOUND_StopSound sndhandles(i).channel
        FSOUND_Sample_Free sndhandles(i).handle
    Next
End Sub
