/'****************************************************************************
*
* Name: grftest.bas
*
* Synopsis: Test the graphic font object.
*
* Description: This program tests the routines in the graphic font object.
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
*****************************************************************************'/
#Include "grfont.bi"


Dim As grfont.gfont myfont
Dim As Integer x, y

ScreenRes 640, 480, 32

If myfont.Load("aesomatica.bmp") <> grfont.TRUE Then
   Print "Could not load file."
   Sleep
   End   
EndIf

y = 0
x = 0
'Print a string.
myfont.PrintString "Font Object Using aesomatica", x, y

y += myfont.CharHeight * 2
x = 0
myfont.PrintString "Using ASCII codes:", x, y
y += myfont.CharHeight 
'Print using ascii code.
For i As Integer = 0 To 255
   myfont.PrintChar i, x, y
   x += myfont.CharWidth
   If x > (640 - 16) Then
      x = 0
      y += myfont.CharHeight
   EndIf
Next

y += myfont.CharHeight * 2
x = 0
myfont.PrintString "Using ASCII chars:", x, y
y += myfont.CharHeight 

'Print using ascii chars.
For i As Integer = 0 To 255
   myfont.PrintChar Chr(i), x, y
   x += myfont.CharWidth
   If x > (640 - 16) Then
      x = 0
      y += myfont.CharHeight
   EndIf
Next


Sleep
