'============================================
'Richard Clark
'Hunt the Wumpus
'FreeBasic .17
'rickclark58@yahoo.com
'Public Domain: Feel free to use as you want.
'd = Drop detector
't = Throw net. Wumpus has 50% chance of dodging net.
'If Wumpus dodges net, it will run to a random spot
'on the map. Need to be within 2 spaces of Wumpus.
'Esc/Close button: Exit game without showing score.
'Move = arrows keys or numpad w/ numlock off.
'============================================
'Goal: Find the Wumpus and capture it within 5 minutes.
'Giant Bat: The Giant Bat will drop you in a random location
'if it catches you.
'Detectors: Will illuminate Wumpus and show movement.
'Pits (O): Falling into a pit will end game.
'Gold: Collect gold to increase score.
'============================================
'
#Include "vbcompat.bi"
'#include once "windows.bi"


'misc defines
#Define numbugs 3000
#Define False 0
#Define True Not False
#Define sw 80
#define sh 57
#define playervision 5
#define playerhear 8
#define detectdist 10
#define netdist 2
'cave consts
Const rockchar = Chr(178)
Const floorchar = Chr(32)
Const pitchar = "O"
'Colors
'Posted by Keeling on QBasicNews.com forum: http://forum.qbasicnews.com/viewtopic.php?t=8719
'# Found At http://stevehollasch.com/cgindex/color/colors.txt
Const fbWhite = Rgb (255, 255, 255)
Const fbBlack = Rgb (000, 000, 000)
Const fbGrey = Rgb (192, 192, 192)
Const fbSlateGrey = Rgb (112, 128, 144)
Const fbGold = Rgb (255, 215, 000)
Const fbYellow = Rgb (255, 255, 000)
Const fbGreen = Rgb (000, 255, 000)
Const fbGhostWhite = Rgb (248, 248, 255)
Const fbRed = Rgb (255, 000, 000)
Const fbFlesh = Rgb (255, 125, 064)
Const fbTan = Rgb (210, 180, 140)
'key consts
Const xk = Chr$(255)
Const key_up = xk + "H"
Const key_dn = xk + "P"
Const key_rt = xk + "M"
Const key_lt = xk + "K"
Const key_home = xk + "G"
Const key_pgup = xk + "I"
Const key_end = xk + "O"
Const key_pgdn = xk + "Q"
Const key_close = xk + "k"
Const key_esc = Chr$(27)
'Item icons
Const playericon = Chr(2)
Const wumpusicon = "W"
Const baticon = "B"
Const goldicon = Chr(15)
Const detecticon = Chr(127)

'movement directions
'directions
#Define north 1
#Define neast 2
#Define east 3
#Define seast 4
#Define south 5
#Define swest 6
#Define west 7
#Define nwest 8

'Cave
#define rock 1
#define floor 2
#define pit 3

'Items
#define wdetector 1
#define gold 2

'screen coord type
Type coordtype
    x As Integer
    y As Integer
End Type

'bug type
Type bugtype
    bcoord As coordtype
    frozen As Integer
End Type

'Map info
Type maptype
    floorid As Integer 'floor, rock or pit
    item As Integer    'item on map floor
    isseen As Integer
End Type

Type playertype
    pname As String * 25
    micros As Integer
    score As Integer
    pcoord As coordtype
End Type

Type dtype
    dcoord As coordtype
    deployed As Integer
    detect As Integer
End Type

Type wtype
    wcoord As coordtype
    lcoord As coordtype
End Type

Type btype
    bcoord As coordtype
    lcoord As coordtype
End Type

Type gl32type
    pixel As Integer
    clr As Integer
End Type

'main vars
Randomize Timer
Dim Shared bugs(1 To numbugs) As bugtype
Dim Shared map(1 To sh, 1 To sw) As maptype
Dim Shared detectors(1 To 4) As dtype
Dim Shared As Double starttime, curtime, t1
Dim Shared As Integer timediff, tdiff, timeleft
Dim Shared player As playertype
Dim Shared wumpus As wtype
Dim Shared bat As btype
Dim skey As String
Dim npcoord As coordtype

'Dim shared DebugOut As String
'OutputDebugString DebugOut

Sub PrintMessage(txt As String)
    Locate sh + 2, 2
    Print String(78, 32)
    Locate sh + 2, 2
    Color fbWhite, fbBlack
    Print txt;" (Press Any Key)"
    Screencopy
    Sleep
End Sub

'get a random number between low and high
Function Rand(lowerbound As Integer, upperbound As Integer) As Integer
   Return Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
End Function

Function BlockingTile(tx As Integer, ty As Integer) As Integer
    If map(ty, tx).floorid = rock Then
        Return True
    Else
        Return False
    End If
End Function

Function LineOfSight(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Dim As Integer i, deltax, deltay, numtiles
    Dim As Integer d, dinc1, dinc2
    Dim As Integer x, xinc1, xinc2
    Dim As Integer y, yinc1, yinc2
    Dim isseen As Integer = True
   
    deltax = Abs(x2 - x1)
    deltay = Abs(y2 - y1)

    If deltax >= deltay Then
        numtiles = deltax + 1
        d = (2 * deltay) - deltax
        dinc1 = deltay Shl 1
        dinc2 = (deltay - deltax) Shl 1
        xinc1 = 1
        xinc2 = 1
        yinc1 = 0
        yinc2 = 1
    Else
        numtiles = deltay + 1
        d = (2 * deltax) - deltay
        dinc1 = deltax Shl 1
        dinc2 = (deltax - deltay) Shl 1
        xinc1 = 0
        xinc2 = 1
        yinc1 = 1
        yinc2 = 1
    End If

    If x1 > x2 Then
        xinc1 = - xinc1
        xinc2 = - xinc2
    End If
   
    If y1 > y2 Then
        yinc1 = - yinc1
        yinc2 = - yinc2
    End If

    x = x1
    y = y1
   
    For i = 2 To numtiles
      'PSet (x, y), pcolor
      If BlockingTile(x, y) Then
        isseen = False
        Exit For
      End If
      If d < 0 Then
          d = d + dinc1
          x = x + xinc1
          y = y + yinc1
      Else
          d = d + dinc2
          x = x + xinc2
          y = y + yinc2
        End If
    Next
   
    Return isseen
End Function

Function PlayerCanSee(tx As Integer, ty As Integer) As Integer
    Dim ret As Integer = False

    ret = LineOfSight(player.pcoord.x, tx, player.pcoord.y, ty)
   
    Return ret
End Function

Sub CalcLOS
    Dim As Integer i, j
    Dim As Integer x1, x2, y1, y2
   
    'only check within vision range
    x1 = player.pcoord.x - playervision
    If x1 < 1 Then x1 = 1
    y1 = player.pcoord.y - playervision
    If y1 < 1 Then y1 = 1
   
    x2 = player.pcoord.x + playervision
    If x2 > sw Then x2 = sw
    y2 = player.pcoord.y + playervision
    If y2 > sh Then y2 = sh
    'iterate through vision area
    For i = x1 To x2
        For j = y1 To y2
            If map(j, i).isseen = False Then
                If PlayerCanSee(i, j) Then
                    map(j, i).isseen = True
                Else
                    map(j, i).isseen = False
                End If
            End If
        Next
    Next
End Sub

Function GetCoord(direction As Integer, ccoord As coordtype) As coordtype
    Dim rcoord As coordtype
   
    Select Case direction
        Case north
            rcoord.x = ccoord.x
            rcoord.y = ccoord.y - 1
        Case east
            rcoord.x = ccoord.x + 1
            rcoord.y = ccoord.y
        Case south
            rcoord.x = ccoord.x
            rcoord.y = ccoord.y + 1
        Case west
            rcoord.x = ccoord.x - 1
            rcoord.y = ccoord.y
        Case nwest
            rcoord.x = ccoord.x - 1
            rcoord.y = ccoord.y - 1
        Case neast
            rcoord.x = ccoord.x + 1
            rcoord.y = ccoord.y - 1
        Case swest
            rcoord.x = ccoord.x - 1
            rcoord.y = ccoord.y + 1
        Case seast
            rcoord.x = ccoord.x + 1
            rcoord.y = ccoord.y + 1
    End Select
    Return rcoord   
End Function

'checks to see if screen is full
Function CheckBugs() As Integer
    Dim As Integer i, j
    Dim As Integer cnt
    Dim ret As Integer = True
   
    For i = 1 To numbugs
        With bugs(i)
            If .frozen = False Then
                ret = False
                Exit For
            End If
        End With
    Next
    Return ret
End Function

'Creates a area filled with rock
Sub ClearCave
    Dim As Integer i, j
   
    'Fill cave with rock
    For i = 1 To sh
        For j = 1 To sw
            map(i, j).floorid = rock
            map(i, j).item = 0       
            map(i, j).isseen = False
        Next
    Next
    'Add seed value
    map(sh /2, sw / 2).floorid = floor
End Sub

'generate intial bugs
Sub GenBugs
    Dim As Integer x, y, i, bcolor
   
    For i = 1 To numbugs
        With bugs(i)
            'get a random location
            .bcoord.x = Rand(2, sw - 1)
            .bcoord.y = Rand(2, sh - 1)
            .frozen = false
        End With
    Next
    ClearCave
End Sub

'Prints cave to screen
Sub PrintCave
    Dim As Integer i, j
   
    For i = 1 To sh
        For j = 1 To sw
            If map(i, j).floorid = rock Then
                Color fbTan, fbBlack
                Locate i, j
                Print rockchar
            Elseif map(i, j).floorid = floor Then
                Color , fbBlack
                Locate i, j
                Print floorchar
            Elseif map(i, j).floorid = pit Then
                Color fbGrey, fbBlack
                Locate i, j
                Print pitchar
            End If
            If map(i, j).item = gold Then
                Color fbGold, fbBlack
                Locate i, j
                Print goldicon
            End If
        Next
    Next
End Sub

'move bugs
Sub MoveBugs
    Dim As Integer i, j, k
    Dim As Integer cdir, idx
    Dim ccoord As coordtype
    Dim cavedir(1 To 4) As Integer => {1, 3, 5, 7} 
     
    For i = 1 To numbugs
        With bugs(i)
            If .frozen = False Then
                'get a random direction
                idx = Rand(1, 4)
                cdir = cavedir(idx)
                ccoord = GetCoord(cdir, .bcoord)
                'make sure we don't go off edge
                If ccoord.x > 1 And ccoord.x < sw Then
                    If ccoord.y > 1 And ccoord.y < sh Then
                        'if bug next to another bug, then freeze
                        If map(ccoord.y, ccoord.x).floorid = floor Then
                            .frozen = True
                            'Set current location to floor
                            map(.bcoord.y, .bcoord.x).floorid = floor
                        Else
                            'Set bug to current location
                            .bcoord = ccoord
                        End If
                    End If
                End If
            End If
        End With
    Next
End Sub

'Calulates the distance between two points
Function CalcDist(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Dim As Integer xdiff, ydiff
   
   xdiff = Abs(x1 - x2)
   ydiff = Abs(y1 - y2)
   If xdiff >= ydiff Then Return xdiff
   If ydiff >= xdiff Then Return ydiff
End Function

Function HearWumpus() As Integer
    Dim As Integer ret = False, wdist
   
    If CalcDist(player.pcoord.x, wumpus.wcoord.x, player.pcoord.y, wumpus.wcoord.y) <= playerhear Then
        ret = True
    End If
    Return ret
End Function


'Print info box on bottom of screen
Sub PrintInfoBox
    Dim As Integer i
   
    Color fbYellow, fbBlack
    Locate sh + 1, 1
    Print Chr(213);
    Print String(78, 205);
    Print Chr(184);
    For i = sh + 2 To 59
        Locate i, 1
        Print Chr(179);
        Locate i, 80
        Print Chr(179);
    Next
    Locate 60, 1
    Print Chr(212);
    Print String(78, 205);
    Print Chr(190);
    Screencopy
End Sub

Sub CheckBat
    If CalcDist(player.pcoord.x, bat.bcoord.x, player.pcoord.y, bat.bcoord.y) <= playervision Then
        If PlayerCanSee(bat.bcoord.x, bat.bcoord.y) Then
            Color fbGrey, fbBlack
            Locate bat.bcoord.y, bat.bcoord.x
            Print baticon
            Screencopy
        End If   
    End If
End Sub

Sub CheckWumpus
    If CalcDist(player.pcoord.x, wumpus.wcoord.x, player.pcoord.y, wumpus.wcoord.y) <= playervision Then
        If PlayerCanSee(wumpus.wcoord.x, wumpus.wcoord.y) Then
            Color fbSlateGrey, fbBlack
            Locate wumpus.wcoord.y, wumpus.wcoord.x
            Print wumpusicon
            Screencopy
        End If   
    End If
End Sub

Sub CheckDetector
    Dim As Integer i, dist
   
    For i = Lbound(detectors) To Ubound(detectors)
        If detectors(i).deployed = true Then
            dist = CalcDist(wumpus.wcoord.x, detectors(i).dcoord.x, wumpus.wcoord.y, detectors(i).dcoord.y)
            If dist <= detectdist Then
                Color fbGreen, fbBlack
                Locate detectors(i).dcoord.y, detectors(i).dcoord.x
                Print detecticon
                Color fbGhostWhite, fbBlack
                Locate wumpus.wcoord.y, wumpus.wcoord.x
                Print wumpusicon
            Else
                Color fbRed, fbBlack
                Locate detectors(i).dcoord.y, detectors(i).dcoord.x
                Print detecticon
            End If
        End If
    Next
    Screencopy
End Sub

Sub PrintInfo
    Dim As Integer hear
   
    PrintInfoBox
    Locate sh + 2, 2
    Print String(78, 32)
    Locate sh + 2, 2
    Color fbWhite, fbBlack
    Print "Time Left: ";Str(timeleft);"   ";
    Print "WDetector(s): ";Str(player.micros);"   ";
    Print "Score: ";Str(player.score);"   ";
    hear = HearWumpus
    If hear Then
        Color fbGreen, fbBlack
        Print "The Wumpus is nearby."
    End If
    Screencopy
End Sub

Sub UpdateMap
    Dim As Integer i, j
   
    CalcLOS
    For i = 1 To sh
        For j = 1 To sw
            If map(i, j).isseen = True Then
                'Print cave
                If map(i, j).floorid = rock Then
                    Color fbTan, fbBlack
                    Locate i, j
                    Print rockchar
                Elseif map(i, j).floorid = floor Then
                    Color , fbBlack
                    Locate i, j
                    Print floorchar
                Elseif map(i, j).floorid = pit Then
                    Color fbGrey, fbBlack
                    Locate i, j
                    Print pitchar
                End If
                'Print items
                If map(i, j).item = gold Then
                    Color fbGold, fbBlack
                    Locate i, j
                    Print goldicon
                End If               
            End If
            If map(i, j).item = wdetector Then
                Color fbRed, fbBlack
                Locate i, j
                Print detecticon
            End If           
        Next
    Next
    Color fbFlesh, fbBlack
    Locate player.pcoord.y, player.pcoord.x
    Print playericon;
    PrintInfo
    Screencopy
End Sub

Sub MoveWumpus
    Dim As Integer i, ndist, dist, wdir = 0
    Dim As coordtype ncoord
   
    dist = CalcDist(wumpus.wcoord.x, player.pcoord.x, wumpus.wcoord.y, player.pcoord.y)
    For i = north To nwest
        ncoord = GetCoord(i, wumpus.wcoord)
        If map(ncoord.y, ncoord.x).floorid = floor Then
            If (ncoord.x <> player.pcoord.x) And (ncoord.y <> player.pcoord.y) Then
                If (ncoord.x <> wumpus.lcoord.x) And (ncoord.y <> wumpus.lcoord.y) Then
                    ndist = CalcDist(ncoord.x, player.pcoord.x, ncoord.y, player.pcoord.y)
                    If ndist >= dist Then
                        wdir = i
                        dist = ndist
                    End If
                End If
            End If
        End If
    Next
    Locate wumpus.wcoord.y, wumpus.wcoord.x
    Print " "
    If wdir > 0 Then
        ncoord = GetCoord(wdir, wumpus.wcoord)
        wumpus.lcoord = wumpus.wcoord
        wumpus.wcoord = ncoord
    Else
        'no direction so use right hand rule
        For i = north To nwest
            ncoord = GetCoord(i, wumpus.wcoord)
            If map(ncoord.y, ncoord.x).floorid = floor Then
                If ncoord.x <> player.pcoord.x And ncoord.y <> player.pcoord.y Then
                    wumpus.lcoord = wumpus.wcoord
                    wumpus.wcoord = ncoord
                    Exit For
                End If
            End If
        Next
    End If
End Sub

Sub CarryPlayer
    Dim As Integer x, y

    PrintMessage "You were caught by the giant bat!"
   
    Do
        x = Rand(2, sw - 1)
        y = Rand(2, sh - 1)
        If map(y, x).floorid = floor Then
            player.pcoord.x = x
            player.pcoord.y = y
            Exit Do
        End If
    Loop
    UpdateMap
End Sub

Sub MoveBat
    Dim As Integer i, ndist, dist, wdir = 0
    Dim As coordtype ncoord
   
    dist = CalcDist(bat.bcoord.x, player.pcoord.x, bat.bcoord.y, player.pcoord.y)
    For i = north To nwest
        ncoord = GetCoord(i, bat.bcoord)
        If map(ncoord.y, ncoord.x).floorid = floor Then
            If (ncoord.x = player.pcoord.x) And (ncoord.y = player.pcoord.y) Then
                CarryPlayer
                wdir = i
                Exit For
            Else               
                If (ncoord.x <> bat.lcoord.x) And (ncoord.y <> bat.lcoord.y) Then
                    ndist = CalcDist(ncoord.x, player.pcoord.x, ncoord.y, player.pcoord.y)
                    If ndist <= dist Then
                        wdir = i
                        dist = ndist
                    End If
                End If
            End If
        End If
    Next
    Locate bat.bcoord.y, bat.bcoord.x
    Print " "
    If wdir > 0 Then
        ncoord = GetCoord(wdir, bat.bcoord)
        bat.lcoord = bat.bcoord
        bat.bcoord = ncoord
    Else
        'no direction so use right hand rule
        For i = north To nwest
            ncoord = GetCoord(i, bat.bcoord)
            If map(ncoord.y, ncoord.x).floorid = floor Then
                If (ncoord.x = player.pcoord.x) And (ncoord.y = player.pcoord.y) Then
                    CarryPlayer
                End If
                bat.lcoord = bat.bcoord
                bat.bcoord = ncoord
                Exit For
            End If
        Next
    End If
End Sub

Function MovePlayer(ncoord As coordtype) As Integer
           
    If map(ncoord.y, ncoord.x).floorid = pit Then
        Locate player.pcoord.y, player.pcoord.x
        Print " ";
        player.pcoord.x = ncoord.x
        player.pcoord.y = ncoord.y
        PrintMessage "You fell into a pit!"
        Return False
    Elseif map(ncoord.y, ncoord.x).floorid <> rock Then
        Locate player.pcoord.y, player.pcoord.x
        Print " ";
        player.pcoord.x = ncoord.x
        player.pcoord.y = ncoord.y
        If map(player.pcoord.y, player.pcoord.x).item = gold Then
            player.score += Rand(100, 1000)
            map(player.pcoord.y, player.pcoord.x).item = 0
        End If
        UpdateMap
    End If
    MoveWumpus
    CheckWumpus
    CheckDetector
    MoveBat
    CheckBat
    Return True
End Function

Sub AddBat
    Dim As Integer x, y, dist
   
    Do
        x = Rand(2, sw - 1)
        y = Rand(2, sh - 1)
        If map(y, x).floorid = floor Then
            bat.bcoord.x = x
            bat.bcoord.y = y
            dist = CalcDist(player.pcoord.x, bat.bcoord.x, player.pcoord.y, bat.bcoord.y)
            If dist >  playerhear Then
                Exit Do
            End If
        End If
    Loop
End Sub

Sub AddWumpus
    Dim As Integer x, y, dist
   
    Do
        x = Rand(2, sw - 1)
        y = Rand(2, sh - 1)
        If map(y, x).floorid = floor Then
            wumpus.wcoord.x = x
            wumpus.wcoord.y = y
            dist = CalcDist(player.pcoord.x, wumpus.wcoord.x, player.pcoord.y, wumpus.wcoord.y)
            If dist >  playerhear Then
                Exit Do
            End If
        End If
    Loop
   
End Sub

Sub Addgold
    Dim As Integer x, y, i
   
    For i = 1 To 10
        Do
            x = Rand(2, sw - 1)
            y = Rand(2, sh - 1)
            If map(y, x).floorid = floor Then
                map(y, x).item = gold 
                Exit Do
            End If
        Loop
    Next
End Sub

Sub AddPits
    Dim As Integer x, y, i, j, ok
    Dim As coordtype ncoord, pcoord
   
    For i = 1 To 10
        Do
            x = Rand(2, sw - 1)
            y = Rand(2, sh - 1)
            If (player.pcoord.x <> x) And (player.pcoord.y <> y) And _
                map(y, x).floorid = floor Then
                pcoord.x = x
                pcoord.y = y
                ok = True
                For j = north To nwest
                    ncoord = GetCoord(j, pcoord)
                    If map(ncoord.y, ncoord.x).floorid <> floor Then
                        ok = False
                        Exit For
                    End If
                Next
                If ok = True Then
                    map(y, x).floorid = pit
                    Exit Do
                End If
            End If
        Loop
    Next
End Sub

Sub Title
    Dim As Integer row = 28, col = 17
       
    Genbugs
    Do
        MoveBugs
    Loop Until CheckBugs = True
    AddPits
    AddGold
    PrintCave
    Color fbWhite, fbBlack
    Locate row, col
    Print "                                                 "
    Locate row + 1, col
    Print " .  .       ,    , .       .  .                  "                 
    Locate row + 2, col
    Print " |__|. .._ -+-  -+-|_  _   |  |. .._ _ ._ . . __ "
    Locate row + 3, col
    Print " |  |(_|[ ) |    | [ )(/,  |/\|(_|[ | )[_)(_|_)  "
    Locate row + 4, col
    Print "                                       |         "
    Locate row + 5, col
    Print "            Press Any Key to Start               "
    Locate row + 6, col
    Print "                                                 "
    Windowtitle "Hunt the Wumpus"
    Screencopy
    Sleep   
End Sub

Function EndTitle() As String
    Dim As Integer row = 28, col = 17
    Dim As String key, sscore = "Score: " & Format(player.score, "###,###,###")
   
    Cls
    Genbugs
    Do
        MoveBugs
    Loop Until CheckBugs = True
    AddPits
    AddGold
    PrintCave
    Color fbWhite, fbBlack
    Locate row, col
    Print "                                                 "
    Locate row + 1, col
    Print " .  .       ,    , .       .  .                  "                 
    Locate row + 2, col
    Print " |__|. .._ -+-  -+-|_  _   |  |. .._ _ ._ . . __ "
    Locate row + 3, col
    Print " |  |(_|[ ) |    | [ )(/,  |/\|(_|[ | )[_)(_|_)  "
    Locate row + 4, col
    Print "                                       |         "
    Locate row + 5, col
    Print "                                                 "
    Locate row + 6, col
    Print "                                                 "
    Locate row + 6, 40 - Len(sscore) / 2
    Print sscore
    Locate row + 7, col
    Print "                                                 "
    Locate row + 8, col
    Print "                Play Again (Y/N)                 "
    Locate row + 9, col
    Print "                                                 "
    Screencopy
    Do
        key = Ucase(Inkey)
        Sleep 1
     Loop Until key= "Y" Or key = "N"
     Return key       
End Function

'Initializes game
Sub InitGame
    Dim As Integer i
   
    Cls
    Windowtitle "Generating Cave..."
    GenBugs
    Do
        MoveBugs
    Loop Until CheckBugs = True
    Windowtitle "Hunt the Wumpus"
    starttime = Now
    timediff = 0
    timeleft = 6
    'Add player start
    player.pcoord.y = sh / 2
    player.pcoord.x = sw / 2
    player.micros = 4
    player.score = 0
    For i = 1 To 4
        With detectors(i)
            .dcoord.x = 0
            .dcoord.y = 0
            .deployed = False
            .detect = False           
        End With
    Next
    AddPits
    AddWumpus
    AddBat
    AddGold
End Sub

Sub DeployDetector
    Dim i As Integer
   
    For i = 1 To 4
        With detectors(i)
            If .deployed = False Then
                .dcoord.x = player.pcoord.x
                .dcoord.y = player.pcoord.y
                .deployed = True
                player.micros -= 1
                map(player.pcoord.y, player.pcoord.x).item = wdetector
                UpdateMap
                Exit For
            End If           
        End With
    Next
End Sub

Function ThrowNet() As Integer
    Dim As Integer chance, dist, ret = True
   
    If CalcDist(player.pcoord.x, wumpus.wcoord.x, player.pcoord.y, wumpus.wcoord.y) <= netdist Then
        chance = Rand(1, 10)
        If chance <= 5 Then
            PrintMessage "You captured the Wumpus!"
            player.score = player.score + (timeleft * 1000) + 10000
        Else
            PrintMessage "The Wumpus dodged the net!"
            AddWumpus
            UpdateMap
            ret = False
        End If 
    Else
        PrintMessage "Wumpus is not in range."
        PrintInfo
        ret = False
    End If
    PrintInfo
    Return ret
End Function


'Text mode screen
Screen 18, 32, 2
Screenset 1
Width 80, 60

title
doagain:
InitGame
UpdateMap
'main code
Do
    skey = Inkey$
    'see how much time left
    curtime = Now
    tdiff = Abs(Datediff("n", curtime, starttime))
    If tdiff > timediff Then
        timediff = tdiff
        timeleft -= 1
        PrintInfo
        If timeleft <= 0 Then
            PrintMessage "You succumb to the noxious fumes!"
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    End If
   
    If skey = key_up Then 'north
        npcoord = GetCoord(north, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_dn Then 'south
        npcoord = GetCoord(south, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_rt  Then 'east
        npcoord = GetCoord(east, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_lt Then 'west
        npcoord = GetCoord(west, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_home Then 'nw
        npcoord = GetCoord(nwest, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_pgup Then 'ne
        npcoord = GetCoord(neast, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_end Then 'sw
        npcoord = GetCoord(swest, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = key_pgdn Then 'se
        npcoord = GetCoord(seast, player.pcoord)
        If MovePlayer(npcoord) = False Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If
    Elseif skey = "d" Or skey = "D" Then 'deploy detector
        If player.micros > 0 Then
            DeployDetector
        End If
    Elseif skey = "t" Or skey = "T" Then 'throw net
        If ThrowNet Then
            If EndTitle = "Y" Then
                Goto doagain
            Else
                skey = key_esc
            End If
        End If           
    Elseif skey = "?" Then
        PrintMessage "d = Drop Detector, t = Throw Net, esc = Quit"
        PrintInfo
    End If
    Sleep 1
Loop Until (skey = key_esc) Or (skey = key_close)
End
