' Test Program for iniobject.
' Richard D. Clark
' Public domain.
'========================================================================
'Include the inifile object.
#Include Once "inifile.bi"

'Set the ini file namespace.
Using inifobj

'Create working stringlist.
Dim myList As stringlist
Dim As Integer Index, ret
Dim As String sret

'Create a new inifile object.
Dim myIni As iniobj = iniobj("test.ini")

If myIni.InitStatus = FALSE Then
	Print "Error initializing ini object."
	Sleep
	End
EndIf

myIni.WriteString "Section 1", "item1", "This is a new string."
myIni.WriteString "Section 1", "item2", "This is another string."
ret = myIni.UpdateFile()
If ret = FALSE Then
	Print "Could not update file."
Else
	Print "Updated file."
EndIf
Print

Print "Section 1"
sret = myIni.ReadString("section 1", "item1", "No Value")
Print "Return String = "; sret

Print
'Find section name.
If myIni.SectionExists("section 1", index) = TRUE Then
	Print myIni.Strings(index)
EndIf
If myIni.KeyExists("section 1", "item1", index) = TRUE Then
	Print myIni.Strings(index)
EndIf 
Print

myIni.WriteString "Section 2", "item1", "This is another string."
ret = myIni.UpdateFile()
If ret = FALSE Then
	Print "Could not update file."
Else
	Print "Updated file."
EndIf
Print

Print "Section 2"
sret = myIni.ReadString("section 2", "item1", "No Value")
Print "Return String = "; sret

myIni.WriteString "Section 2", "item1", "Updated string."
ret = myIni.UpdateFile()
If ret = FALSE Then
	Print "Could not update file."
Else
	Print "Updated file."
EndIf
Print

Print "Section 2"
sret = myIni.ReadString("section 2", "item1", "No Value")
Print "Return String = "; sret
Print

'Get all the sections.
Print "Reading all section names."
myIni.GetSections(myList)
For index = 0 To myList.count - 1
	Print myList.Strings(index)
Next
Print

'Delete key from section.
ret = myIni.DeleteKey("section 2", "item1")
If ret = TRUE Then
	Print "Deleted key item1 from section 2."
EndIf
ret = myIni.UpdateFile()
If ret = FALSE Then
	Print "Could not update file."
Else
	Print "Updated file."
EndIf
Print

Print "Section 2"
sret = myIni.ReadString("section 2", "item1", "No Value")
Print "Return String = "; sret
Print

'Delete section.
ret = myIni.DeleteSection("section 2")
If ret = TRUE Then
	Print "Deleted section 2."
EndIf
ret = myIni.UpdateFile()
If ret = FALSE Then
	Print "Could not update file."
Else
	Print "Updated file."
EndIf
Print
Print "Section 2 "
sret = myIni.ReadString("section 2", "item1", "No Value")
Print "Return String = "; sret
Print

'Get all keys from section 1.
myIni.GetSectionKeys "section 1", myList
Print "Section 1 Keys"
For index = 0 To myList.count - 1
	Print myList.Strings(index)
Next
Print

'Get all key/values from section 1.
myIni.GetSectionKeyValues "section 1", myList
Print "Section 1 Key/Values"
For index = 0 To myList.count - 1
	Print myList.Strings(index)
Next

Sleep

