' Escape from Lab 42
' Richard D. Clark
' My entry in the 2009 7dRL challenge posted on rec.games.roguelike.development newsgroup.
' Uses my grid-based dungeon generation code. 
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' Main program file.
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#Include "vbcompat.bi"
#Include "zombie.bi"
#Include "corridor.bi"
#Include "42title.bi"
#Include "escape.bi"
#Include "mush.bi"
#Include "backgrnd.bi"
#Include "labdata.bi"
#Include "labutils.bi"
#Include "labmap.bi"
#Include "labchar.bi"

'Initilize
Sub InitProgram
	blankinv.hasitem = FALSE
	
	'Set target zombie target string.
	zt = "abcdefghijklmnopqrsuvwxyz"
	'Set the countdown.
	timeleft = maxtime
	'Init the level info.
	level.levelinfo.mlevel = maxlevel
	'Init the character.
	InitCharacter	
End Sub

'Redraws the map area.
Sub DrawMapDisplay
	Dim As Integer x, y
	Dim As UInteger clr
	
	For x = 1 To vw
		For y = 1 To vh
			clr = backgrnd((x - 1) + (y - 1) * backgrndw)
			PutText Chr(219), y, x, clr
		Next
	Next
	DrawMap
	'Draw border around viewport.
	Line (0, vh * 8)-(vw * 8, vh * 8),fbRed
	Line (vw * 8, 0)-(vw * 8, vh * 8),fbRed
End Sub

'Draws message area
Sub DrawMessageArea
	Dim As Integer x, y, i
	Dim As UInteger clr, bcolor
		
	'Draw the message area.
	For y = (vh + 2) To trows
		For x = 1 To 80
			clr = backgrnd((x - 1) + (y - 1) * backgrndw)
			PutText Chr(219), y, x, clr
			'Alpha blend background
			bcolor = backgrnd((x - 1) + (y - 1) * backgrndw)
			clr = AlphaBlend(128, fbblack, bcolor) 
			PutText Chr(219), y, x, clr
		Next
	Next
	'Draw the messages.
	For i = 1 To 4
		If Len(mess(i)) > 0 Then
			If i = 1 Then
				clr = AlphaBlend(255, fbWhite, bcolor)
			ElseIf i = 2 Then
				clr = AlphaBlend(192, fbWhite, bcolor)
			ElseIf i = 3 Then
				clr = AlphaBlend(129, fbWhite, bcolor)
			Else
				clr = AlphaBlend(66, fbWhite, bcolor)
			EndIf
			PutText mess(i), vh + 2 + (i - 1), 2, clr
		EndIf
	Next
	'Draw border around message area.
	Line (0, ((vh + 1) * 8) - 1)-((vw + 2) * 8, ((vh + 1) * 8) - 1), fbRed 
End Sub

'Draws the status area.
Sub DrawStatusArea
	Dim As UInteger clr, bcolor, hcnt
	Dim As Integer x, y, tt, row, col, mx, my
	Dim As String txt
	Dim As Single pct
		
	col = vw + 2
	'Draw the status area.
	For x = col To tcols
		For y = 1 To trows
			clr = backgrnd((x - 1) + (y - 1) * backgrndw)
			PutText Chr(219), y, x, clr
			'Alpha blend background
			bcolor = backgrnd((x - 1) + (y - 1) * backgrndw)
			clr = AlphaBlend(128, fbblack, bcolor) 
			PutText Chr(219), y, x, clr
		Next
	Next
	
	row = 1
	col += 1
	'Print the current level.
	txt = "Level: " & level.levelinfo.mlevel
	tt = Len(txt)
	PutText txt, row, col, fbWhite
	'Show the current time left.
	txt = "Time Left: " & timeleft
	PutText txt, row, col + tt + 1, fbWhite
	
	'Show the current health.
	If player.currhp > 74 Then
		clr = fbGreen
	ElseIf (player.currhp > 24) And (player.currhp < 75) Then
		clr = fbYellow
	Else
		clr = fbRed
	EndIf
	row += 2
	hcnt = 15
	txt = "Health: " & String(hcnt, Chr(176))
	PutText txt, row, col, fbWhite
	pct = player.currhp / player.maxhp
	hcnt *= pct
	txt = "Health: " & String(hcnt, Chr(219))
	PutText txt, row, col, clr
	
	row += 2
	'Draw the inv info.
	txt = "Access Code: "
	If player.hascode = TRUE Then
		txt &= "Yes"
		PutText txt, row, col, fbGreen
	Else
		txt &= "No"
		PutText txt, row, col, fbWhite
	EndIf
	
	
	row += 2
	txt = "Weapons-Locator"
	PutText txt, row, col, fbYellow
	
	row += 1
	txt = "L Hand: "
	txt &= GetInvDescString(player.wlhand)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "R Hand: "
	txt &= GetInvDescString(player.wrhand)
	PutText txt, row, col, fbWhite
	
	row += 1
	txt = "Armor"
	PutText txt, row, col, fbYellow
	
	row += 1
	txt = "Head:   "
	txt &= GetInvDescString(player.aHead)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "Body:   "
	txt &= GetInvDescString(player.aBody)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "L Arm:  "
	txt &= GetInvDescString(player.aLArm)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "R Arm:  "
	txt &= GetInvDescString(player.aRArm)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "L Hand: "
	txt &= GetInvDescString(player.aLHand)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "R Hand: "
	txt &= GetInvDescString(player.aRHand)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "L Leg:  "
	txt &= GetInvDescString(player.aLLeg)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "R Leg:  "
	txt &= GetInvDescString(player.aRLeg)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "L Foot: "
	txt &= GetInvDescString(player.aLFoot)
	PutText txt, row, col, fbWhite
	row += 1
	txt = "R Foot: "
	txt &= GetInvDescString(player.aRFoot)
	PutText txt, row, col, fbWhite
	
	row += 1
	txt = "Inventory"
	PutText txt, row, col, fbYellow
	
	row += 1
	txt = "F1-F5: "
	txt &= GetInvDescString(player.inventory(1))
	PutText txt, row, col, fbWhite
	row += 1
	txt = "F2-F6: "
	txt &= GetInvDescString(player.inventory(2))
	PutText txt, row, col, fbWhite
	row += 1
	txt = "F3-F7: "
	txt &= GetInvDescString(player.inventory(3))
	PutText txt, row, col, fbWhite
	row += 1
	txt = "F4-F8: "
	txt &= GetInvDescString(player.inventory(4))
	PutText txt, row, col, fbWhite
	'Put up menu strings.
	row += 1
	txt = "Commands"
	PutText txt, row, col, fbYellow
	
	row += 1
	txt = "F1-F4: Equip-Use Item"
	PutText txt, row, col, fbWhite
	row += 1
	txt = "F5-F8: Drop Item"
	PutText txt, row, col, fbWhite
	row += 1
	txt = "c: Close Door"
	PutText txt, row, col, fbWhite
	row += 1
	txt = "g: Get Item"
	PutText txt, row, col, fbWhite
	row += 1
	txt = "t: Target Zombie"
	PutText txt, row, col, fbWhite
	row += 1
	txt = "Arrows-Numpad: Move"
	PutText txt, row, col, fbWhite
	row += 1
	txt = "Esc: Quit"
	PutText txt, row, col, fbWhite
	
	row += 2
	txt = "Targeting "
	If targeton = TRUE Then
		txt &= "On"
		PutText txt, row, col, fbGreen
	Else
		txt &= "Off"
		PutText txt, row, col, fbWhite
	EndIf
		
	
	row += 2
	If player.haslocator = TRUE Then
		txt = "Locator On"
		PutText txt, row, col, fbYellow

		row += 1
		mx = 639 - (mapw - (csize * 2)) - 16
		my = (row * 8) + 8
		 
		'Draw minimap
		For y = csize To maph - csize
			For x = csize To mapw - csize
				If level.lmap(x, y).seen = TRUE Then
					If level.lmap(x, y).terrid = twall Then
						PSet(mx, my), fbGrey
					ElseIf level.lmap(x, y).terrid = tdoorclosed Then
						PSet(mx, my), fbTan
					ElseIf level.lmap(x, y).terrid = tfloor Then
						PSet(mx, my), fbBlack
					ElseIf level.lmap(x, y).terrid = tsup Then
						Line(mx - 1, my - 1)-(mx + 1, my + 1), fbYellow, BF
					End If
				EndIf
				If IsPlayerLoc(x, y) Then
					Line(mx - 1, my - 1)-(mx + 1, my + 1), fbCyan, BF
				EndIf
				mx += 1
			Next
			my += 1
			mx = 639 - (mapw - (csize * 2)) - 16
		Next
	Else
		txt = "No Locator"
		PutText txt, row, col, fbRed
	End If
	
	'Draw border around status area.
	Line ((col - 2) * 8, 0)-((col - 2) * 8, ((vh + 1) * 8) - 1), fbRed
End Sub

'Draws the main game screen.
Sub DrawMainScreen
	'Draw the background
	DrawBackground
	'Draw the map.
	DrawMapDisplay
	'DrawMessage area.
	DrawMessageArea
	'Draw status area
	DrawStatusArea
	Flip
End Sub

'Moves player icon on screen.
Sub Move (newx As Integer, newy As Integer)
	Dim txt As String
	
	'Check for monster location.
	If level.lmap(newx, newy).hasmonster = TRUE Then
		DoMeleeCombat level.lmap(newx, newy).zomidx, newx, newy
		DrawMainScreen
	ElseIf (level.lmap(newx, newy).terrid = tsup) And (player.hascode = TRUE) Then
		player.pcoord.x = newx
		player.pcoord.y = newy
	'Check for blocking tile.
	ElseIf BlockingTile(newx, newy) = FALSE Then
		player.pcoord.x = newx
		player.pcoord.y = newy
		'Check for an item.
		If level.lmap(newx, newy).item.hasitem = TRUE Then
			txt = GetInvDescString(level.lmap(newx, newy).item)
			AddMessage txt
			If level.lmap(newx, newy).item.classid = iCode Then
				player.hascode = TRUE
				level.lmap(newx, newy).item.hasitem = FALSE
			EndIf
			DrawMainScreen
		Else
			DrawMapDisplay
			DrawStatusArea
			Flip
		EndIf
	Else
		'Check for closed door.
		If level.lmap(newx, newy).terrid = tdoorclosed Then
			level.lmap(newx, newy).terrid = tdooropen
			player.pcoord.x = newx
			player.pcoord.y = newy
			'Check for item.
			If level.lmap(newx, newy).item.hasitem = TRUE Then
				If level.lmap(newx, newy).item.classid = iCode Then
					player.hascode = TRUE
					level.lmap(newx, newy).item.hasitem = FALSE
				EndIf
				txt = GetInvDescString(level.lmap(newx, newy).item)
				AddMessage txt
				DrawMainScreen
			Else
				DrawMapDisplay
				DrawStatusArea
				Flip
			EndIf
		EndIf
	EndIf
	Do
		Sleep 1
	Loop Until InKey = ""
End Sub

'---------------------------------------------------------------------
'Main Program Code
'---------------------------------------------------------------------
Randomize Timer
'Set up screen
Screen 18, 32, 2
ScreenSet 1, 0
Width tcols, trows
WindowTitle "Escape from Lab 42 (ver. " & lbversion & ")"
'Initialize program.
InitProgram
'Show the title screen.
DoTitle
DrawIntroText
'Build the first level of dungeon
GenerateDungeonLevel
DrawMainScreen
dnow = Now
Do
	'Get input
	ch = InKey
	If ch <> "" Then
		'Move character
		If (ch = key_lt) Or (ch = "4") Or (ch = "l") Then
			xx = player.pcoord.x - 1
			yy = player.pcoord.y
			Move xx, yy
		EndIf
		If (ch = key_rt) Or (ch = "6") Or (ch = ";") Then
			xx = player.pcoord.x + 1
			yy = player.pcoord.y
			Move xx, yy
		EndIf
		If (ch = key_up) Or (ch = "8") Or (ch = "p") Then
			xx = player.pcoord.x
			yy = player.pcoord.y - 1
			Move xx, yy
		EndIf
		If (ch = key_dn) Or (ch = "2")  Or (ch = ".") Then
			xx = player.pcoord.x
			yy = player.pcoord.y + 1
			Move xx, yy
		EndIf
		If ch = "7"  Or (ch = "o") Then
			xx = player.pcoord.x - 1
			yy = player.pcoord.y - 1
			Move xx, yy
		EndIf
		If ch = "9"  Or (ch = "[") Then
			xx = player.pcoord.x + 1
			yy = player.pcoord.y - 1
			Move xx, yy
		EndIf
		If ch = "3"  Or (ch = "/") Then
			xx = player.pcoord.x + 1
			yy = player.pcoord.y + 1
			Move xx, yy
		EndIf
		If ch = "1"  Or (ch = ",") Then
			xx = player.pcoord.x - 1
			yy = player.pcoord.y + 1
			Move xx, yy
		EndIf
		'Check to see if on the elevator
		If level.lmap(player.pcoord.x, player.pcoord.y).terrid = tsup Then
			If player.hascode = TRUE Then
				level.levelinfo.morgue.lend(level.levelinfo.mlevel) = Now
				'Set level info
				level.levelinfo.mlevel -= 1
				If level.levelinfo.mlevel < 1 Then
					level.levelinfo.mlevel = 1
					didwin = TRUE
					done = TRUE
				Else
					level.levelinfo.morgue.lstart(level.levelinfo.mlevel) = now
					GenerateDungeonLevel
					AddMessage "Entering level " & level.levelinfo.mlevel & "."
					DrawMainScreen
				EndIf
			EndIf
		EndIf
		'Use/equip/unequip  items.
		If ch = key_F1 Then
			EquipItem 1
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		If ch = key_F2 Then
			EquipItem 2
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		If ch = key_F3 Then
			EquipItem 3
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		If ch = key_F4 Then
			EquipItem 4
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		'Drop inv item.
		If ch = key_F5 Then
			DoDropItem 1
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		If ch = key_F6 Then
			DoDropItem 2
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		If ch = key_F7 Then
			DoDropItem 3
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		If ch = key_F8 Then
			DoDropItem 4
			DrawStatusArea
			DrawMessageArea
			Flip
		EndIf
		'If targeting on do projectile combat.
		If targeton = TRUE Then
			If InStr(zt, ch) > 0 Then
				DoProjectileCombat ch
				DrawMainScreen
			EndIf
		EndIf
		'Close door.
		If (ch = "c") And (targeton = FALSE) Then
			DoCloseDoor
			DrawMapDisplay
			Flip
		EndIf
		'Get item.
		If (ch = "g") And (targeton = FALSE) Then
			GetItem player.pcoord.x, player.pcoord.y
			DrawMainScreen
		EndIf
		'Set target mode
		If ch = "t" Then
			If targeton = FALSE Then
				targeton = TRUE
			Else
				targeton = FALSE
			EndIf
			SetZTargets targeton 
			DrawMainScreen
		EndIf
		'Quit game, ask for save.		
		If (ch = key_close) Or (ch = key_esc) Then
			done = TRUE
		EndIf
	End If
	If MoveZombies() = TRUE Then
		DrawMapDisplay
		Flip
		If AttackPlayer() = TRUE Then
			DrawMainScreen
		EndIf
	EndIf
	'Check for dead.
	If player.currhp <= 0 Then
		isdead = TRUE
		done = TRUE
		level.levelinfo.morgue.lend(level.levelinfo.mlevel) = Now
	EndIf
	'Show time remaining.
	tmin = DateDiff("n", dnow, Now)
	If tmin >= 1 Then
		timeleft -= tmin
		dnow = Now
		tmin = 0
		DrawStatusArea
		Flip
	EndIf
	If timeleft <= 0 Then 
		done = TRUE
		isdead = TRUE
		level.levelinfo.morgue.lend(level.levelinfo.mlevel) = Now
	EndIf

	Sleep 1		
Loop Until done = TRUE

'Set morgue values.
level.levelinfo.morgue.win = didwin
level.levelinfo.morgue.dead = isdead
level.levelinfo.morgue.timeleft = timeleft
'Show lose screen.
If isdead = TRUE Then
	Cls
	PutText "You have died...<Press Escape>", 1, 1, fbWhite
	Flip
	Do
		ch = InKey
		Sleep 1
	Loop Until ch = key_esc
	DoDead
	DoFinalZombie
ElseIf didwin = TRUE Then
	Cls
	PutText "You made it out of the lab...<Press Escape>", 1, 1, fbWhite
	Flip
	Do
		ch = InKey
		Sleep 1
	Loop Until ch = key_esc
	DoWin
	DoFinalZombie
EndIf
