' Escape from Lab 42
' Richard D. Clark
' My entry in the 2009 7dRL challenge posted on rec.games.roguelike.development newsgroup.
' Uses my grid-based dungeon generation code. 
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' Character routines.
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'Player attempt roll.
Function GetRollResult(dr As Integer) As boolean
	Dim As Integer pdr, zroll, proll
	
	pdr = player.currhp
	zroll = RandomRange(1, dr)
	proll = RandomRange(1, pdr)
	If proll > zroll Then
		Return TRUE
	Else
		Return FALSE
	EndIf
End Function

'Hits a zombie.
Sub HitZombie(zomid As Integer, damage As integer)
	Dim As Integer x, y
	
	x = zombie(zomid).zomloc.x
	y = zombie(zomid).zomloc.y
	zombie(zomid).zomlevel -= damage
	If zombie(zomid).zomlevel <= 0 Then
		If zombie(zomid).zomchar = "Z" Then
			level.levelinfo.morgue.numguards(level.levelinfo.mlevel) += 1
		Else
			level.levelinfo.morgue.numcivis(level.levelinfo.mlevel) += 1
		EndIf
		zombie(zomid).isdead = TRUE
		zombie(zomid).attack = FALSE
		level.lmap(x, y).hasmonster = FALSE
		level.lmap(x, y).zomidx = 0
		AddMessage "You killed the zombie."
		AddAZombie zomid
	Else
		AddMessage "You hit the zombie for " & damage & "."
		zombie(zomid).ishit = TRUE
	End If
	
End Sub

'Missed a zombie.
Sub MissZombie
	Dim As Integer zloc
	
	zloc = RandomRange(pNone, pRFoot)
	If zloc = pBody Then
		AddMessage "You hit the zombie in the torso."
	ElseIf zloc = pLArm Then
		AddMessage "You hit the zombie in the left arm."
	ElseIf zloc = pRArm Then
		AddMessage "You hit the zombie in the right arm."
	ElseIf zloc = pLHand Then
		AddMessage "You hit the zombie in the left hand."
	ElseIf zloc = pRHand Then
		AddMessage "You hit the zombie in the right hand."
	ElseIf zloc = pLLeg Then
		AddMessage "You hit the zombie in the left leg."
	ElseIf zloc = pRLeg Then
		AddMessage "You hit the zombie in the right leg."
	ElseIf zloc = pLFoot Then
		AddMessage "You hit the zombie in the left foot."
	ElseIf zloc = pRFoot Then
		AddMessage "You hit the zombie in the right foot."
	Else
		AddMessage "You missed the zonbie."
	EndIf
	
End Sub

'Attack the zombie.
Sub DoMeleeCombat(zomid As Integer, x As Integer, y As Integer)
	Dim As Integer dam
	
	'Hit zombie.
	If GetRollResult(zombie(zomid).zomlevel) = TRUE Then
		'Set base damage.
		dam = player.currhp / 4
		If dam < 1 Then dam = 1
		'Check to see if player has weapons
		If player.wlhand.hasitem = TRUE Then
			dam += player.wlhand.weapon.damage
		EndIf
		If player.wrhand.hasitem = TRUE Then
			dam += player.wlhand.weapon.damage
		EndIf
		HitZombie zomid, dam
	Else
		MissZombie
	EndIf
End Sub

'Attack zombie with projectile weapon if player has one.
Sub DoProjectileCombat(zc As String)
	Dim As boolean haspw = FALSE, wr = FALSE, wl = FALSE, isshotgun = FALSE, nozoms = TRUE
	Dim As Integer dam, zomid, i, zx, zy, nx, ny
	
	'Make sure player has projectile weapon and ammo.
	If player.wlhand.hasitem = TRUE Then
		If player.wlhand.weapon.pdamage > 0 Then
			If player.wlhand.weapon.Ammocnt > 0 Then
				haspw = TRUE
				wl = TRUE
				'Check for shotgun
				If player.wlhand.weapon.Item = wShotgun Then
					isshotgun = TRUE
				EndIf
			End If
		EndIf
	EndIf
	
	If player.wrhand.hasitem = TRUE Then
		If player.wrhand.weapon.pdamage > 0  Then
			If player.wrhand.weapon.Ammocnt > 0  Then
				haspw = TRUE
				wr = TRUE
				'Check for shotgun
				If player.wrhand.weapon.Item = wShotgun Then
					isshotgun = TRUE
				EndIf
			End If
		EndIf
	EndIf

	'If no weapon exit.
	If haspw = FALSE Then
		targeton = FALSE
		SetZTargets FALSE
		AddMessage "No weapon or weapon is out of ammo."
		Exit Sub
	EndIf

	'If left hand has weapon.
	If wl = TRUE Then
		dam = player.wlhand.weapon.pdamage
		player.wlhand.weapon.Ammocnt -= 1
	EndIf

	'If right hand has weapon.
	If wr = TRUE Then
		dam += player.wrhand.weapon.pdamage
		player.wrhand.weapon.Ammocnt -= 1
	EndIf
	
	zomid = 0
	'Get the zombie id.
	For i = 1 To numzombies
		If zombie(i).isdead = FALSE Then
			If zombie(i).attchar = zc Then
				zomid = i
				Exit For
			End If
		EndIf
	Next
	
	'If found zombie
	If zomid > 0 Then
		zx = zombie(zomid).zomloc.x
		zy = zombie(zomid).zomloc.y
		'See if in sight
		If level.lmap(zx, zy).visible = TRUE Then  
			'Hit zombie.
			If GetRollResult(zombie(zomid).zomlevel) = TRUE Then
				'Hit main target.
				HitZombie zomid, dam
				'If weapon is a shotgun then hit multiple targets based on quadrant.
				If isshotgun = TRUE Then
					'North/south
					If player.pcoord.x = zx Then
						nx = zx + dirmatrix(west).x
						ny = zy + dirmatrix(west).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
						nx = zx + dirmatrix(east).x
						ny = zy + dirmatrix(east).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
					'East/West
					ElseIf player.pcoord.y = zy Then
						nx = zx + dirmatrix(north).x
						ny = zy + dirmatrix(north).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
						nx = zx + dirmatrix(south).x
						ny = zy + dirmatrix(south).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
					'Nw
					ElseIf (zx < player.pcoord.x) And (zy < player.pcoord.y) Then
						nx = zx + dirmatrix(neast).x
						ny = zy + dirmatrix(neast).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
						nx = zx + dirmatrix(swest).x
						ny = zy + dirmatrix(swest).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
					'Ne
					ElseIf (zx > player.pcoord.x) And (zy < player.pcoord.y) Then
						nx = zx + dirmatrix(nwest).x
						ny = zy + dirmatrix(nwest).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
						nx = zx + dirmatrix(seast).x
						ny = zy + dirmatrix(seast).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
					'Se
					ElseIf (zx < player.pcoord.x) And (zy < player.pcoord.y) Then
						nx = zx + dirmatrix(nwest).x
						ny = zy + dirmatrix(nwest).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
						nx = zx + dirmatrix(seast).x
						ny = zy + dirmatrix(seast).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
					'Sw
					ElseIf (zx < player.pcoord.x) And (zy < player.pcoord.y) Then
						nx = zx + dirmatrix(neast).x
						ny = zy + dirmatrix(neast).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
						nx = zx + dirmatrix(swest).x
						ny = zy + dirmatrix(swest).y
						If level.lmap(nx, ny).hasmonster = TRUE Then
							zomid = level.lmap(nx, ny).zomidx
							HitZombie zomid, (dam \ 4)
						EndIf
					EndIf
				EndIf
			Else
				MissZombie
			EndIf
		Else
			AddMessage "Zombie out of line of sight."
		End If
	End If
	'If no targets turn off targeting.
	For i = 1 To numzombies
		If zombie(i).attchar <> Chr(32) Then
			nozoms = FALSE
			Exit For
		EndIf
	Next
	If nozoms = TRUE Then
		targeton = FALSE
	EndIf
	If HasAmmo() = FALSE Then
		targeton = FALSE
		SetZTargets FALSE
	EndIf
	
End Sub

'Initializes the player character.
Sub InitCharacter
	Dim inv As invtype
	
	level.levelinfo.morgue.lstart(level.levelinfo.mlevel) = Now
	
	'Set the hp.
	player.maxhp = 100
	player.currhp = 100
	player.hascode = FALSE
	player.haslocator = FALSE
		
	'Add pistol.
	inv.hasitem = TRUE
	inv.classid = iWeapon
	inv.weapon.Item = wPistol
	AddItem inv
	player.wrhand = inv
	
	'Add some cloth armor
	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pBody
	AddItem inv
	player.aBody = inv
	
	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pLArm
	AddItem inv
	player.aLArm = inv

	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pRArm
	AddItem inv
	player.aLArm = inv

	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pLLeg
	AddItem inv
	player.aLLeg = inv

	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pRLeg
	AddItem inv
	player.aRLeg = inv

	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pLFoot
	AddItem inv
	player.aLFoot = inv

	inv.hasitem = TRUE
	inv.classid = iArmor
	inv.armor.Item = arCloth
	inv.armor.location = pRFoot
	player.aRFoot = inv
End Sub

'Pick up an item.
Sub GetItem (x As Integer, y As Integer)
	Dim As integer i
	
	If level.lmap(x, y).item.hasitem = TRUE Then
		'Look for an empty inv slot.
		i = GetEmptyInvSlot
		If i > 0 Then
			player.inventory(i) = level.lmap(x, y).item
			level.lmap(x, y).item.hasitem = FALSE
			AddMessage "Item added to your inventory."
		Else
			AddMessage "No empty inventory slot."
		EndIf
	Else
		AddMessage "Nothing to pick up."
	EndIf
End Sub

'Closes an open door if next to it.
Sub DoCloseDoor
	Dim As Integer i, x, y
	
	'Check each direction.
	x = player.pcoord.x + dirmatrix(north).x
	y = player.pcoord.y + dirmatrix(north).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If
	
	x = player.pcoord.x + dirmatrix(east).x
	y = player.pcoord.y + dirmatrix(east).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If

	x = player.pcoord.x + dirmatrix(south).x
	y = player.pcoord.y + dirmatrix(south).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If
	
	x = player.pcoord.x + dirmatrix(west).x
	y = player.pcoord.y + dirmatrix(west).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If
	
End Sub

'Drops an item from inventory.
Sub DoDropItem(islot As Integer)
	Dim As boolean diddrop = FALSE
	Dim As Integer x, y
	Dim As compass i
		
	If player.inventory(islot).hasitem = TRUE Then
		'Drop under player if open.
		x = player.pcoord.x
		y = player.pcoord.y
		If level.lmap(x, y).item.hasitem = FALSE Then
			level.lmap(x, y).item = player.inventory(islot)
			player.inventory(islot) = blankinv
			diddrop = TRUE 
		EndIf
		'Look for adjacent open tile to drop.
		For i = north To nwest
			x = player.pcoord.x + dirmatrix(i).x
			y = player.pcoord.y + dirmatrix(i).y
			If level.lmap(x, y).item.hasitem = FALSE Then
				level.lmap(x, y).item = player.inventory(islot)
				player.inventory(islot) = blankinv
				diddrop = TRUE
				Exit For 
			EndIf
		Next
		
		'Couldn't drop item.
		If diddrop = FALSE then
			AddMessage "No empty tiles to drop item."
		EndIf
	EndIf
	
End Sub
