' Escape from Lab 42
' Richard D. Clark
' My entry in the 2009 7dRL challenge posted on rec.games.roguelike.development newsgroup.
' Uses my grid-based dungeon generation code. 
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' Data definitions
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#Define tcols 80 'screen text cols
#Define trows 60 'screen text rows
#Define twh 8    'size of font
#Define mapw 100 'map width
#Define maph 100 'map height
#Define invtot 4 'total inventory items
#Define imax(a,b) IIf( a > b, a, b ) 'return max of two items
#Define vw 50 'viewport width
#Define vh 55 'viewport height
#Define maxlevel 10
#Define maxtime 30
#Define FPS 60

Const lbversion = "0.2"

const fbWhite = RGB (255, 255, 255)
Const fbGrey = RGB (192, 192, 192)
const fbBlack = RGB (000, 000, 000)
const fbRed = RGB (255, 000, 000)
const fbSlateGreyDark = RGB (047, 079, 079)
const fbCyan = RGB (000, 255, 255)
Const fbYellow = RGB (255, 255, 000)
const fbGreen = RGB (000, 255, 000)
const fbGold = RGB (255, 215, 000)
const fbTan = RGB (210, 180, 140)
const fbOrangeRed = RGB (255, 069, 000)
const fbBlueLight = RGB (173, 216, 230)
const fbOrange = RGB (255, 128, 000)
const fbBlue = RGB (000, 000, 255)

'key consts
const xk = Chr(255)
const key_up = xk + "H"
const key_dn = xk + "P"
const key_rt = xk + "M"
const key_lt = xk + "K"
Const key_F1 = xk + Chr(59)
Const key_F2 = xk + Chr(60)
Const key_F3 = xk + Chr(61)
Const key_F4 = xk + Chr(62)
Const key_F5 = xk + Chr(63)
Const key_F6 = xk + Chr(64)
Const key_F7 = xk + Chr(65)
Const key_F8 = xk + Chr(66)
const key_close = xk + "k"
Const key_esc = Chr(27)
Const key_enter = Chr(13)
Const key_space = Chr(32)


Const FD = 1 / FPS

#Macro Delay(t)
	Scope 
	Dim As Single tdd = Timer
	
	Do While Timer < (tdd + t)
		Sleep 1
	Loop 
	End Scope
#EndMacro

#Macro SetFPS(t)
	Do While (Timer - t) < FD 
		Sleep 1
	Loop
#EndMacro

'Compass directions
Enum compass
	north
	neast
	east
	seast
	south
	swest
	west
	nwest
End Enum

'Define true/false.
Enum bool
	TRUE  = 1
	FALSE  = 0
End Enum
Type boolean As bool

'Zombie types
Enum zombieclass
	guard = 1
	civilian
End Enum

'Terrain ids
Enum terrids
	twall
	tfloor
	tdooropen
	tdoorclosed
	tsup
End Enum

'Inv class type
Enum iclass
	iWeapon = 1
	iAmmo
	iArmor
	iCode
	iHealth
End Enum

'Player body/inv locations
Enum pbloc
	pNone
	pHead
	pBody
	pLArm
	pRArm
	pLHand
	pRHand
	pLLeg
	pRLeg
	pLFoot
	pRFoot
	pInv1
	pInv2
	pInv3
	pInv4
End Enum

Const aPistolmax = 12
Const aShotgunmax = 8

'Weapons
Enum weap
	wLocator = 1
	wPistol
	wShotgun
	wPipe
	wHammer
End Enum

'Armor
Enum arm
	arNone     'no armor
	arCloth    'plain cloth 
	arLeather  'Leather 
	arKevlar   'Kevlar 
	arKevPlate 'Kev + plate (only on body)
End Enum

'Health types.
Enum heal
	hStimpack = 1 '+10
	hMedpack  '+20
End Enum

'Ammunition type
Enum amm
	aNone
	aClip
	aShells
End Enum

'Coordinates.
Type mcoord
	x As Integer
	y As Integer
End Type

'Weapon type
Type weaptype
	Item As weap
	ammotype As amm
	Ammocnt As Integer
	hands As Integer
	damage As Integer
	pdamage As Integer
End Type

'Armor type
Type armtype
	item As arm
	amt As Integer
	location As pbloc
End Type

'Health pack
Type healthtype
	item As heal
	hltamt As Integer
End Type

'Ammo type
Type ammotype
	item As amm
	cnt As Integer
End Type

'Inventory
Type invtype
	hasitem As boolean
	classid As iclass
	iscode As boolean
	Union
		weapon As weaptype
		armor As armtype
		health As healthtype
		ammo As ammotype
	End Union
End Type

Type morguetype
	numguards(1 To maxlevel) As Integer
	numcivis(1 To maxlevel) As Integer
	lstart(1 To maxlevel) As Double
	lend(1 To maxlevel) As Double
	win As boolean
	dead As boolean
	timeleft As Integer
End Type

'Level information
Type levelinfotype
	mlevel As Integer     'Current level of dungeon
	morgue As morguetype	 'morgue file.
End Type

'Map info type
Type mapinfotype
	terrid As terrids     'The floor type
	item As invtype      'Item type if present
	hasmonster As boolean 'Current cell has a zombie.
	zomidx As Integer     'Index into zombie array.
	visible As boolean    'Player can see cell.
	seen As boolean       'Player has seen cell.
	elelocked As boolean
End Type

'Map cell array type.
Type maptype
	levelinfo As levelinfotype
	lmap(1 To mapw, 1 To maph) As mapinfotype
End Type

'Zombie type
Type zombietype
	zomid As zombieclass   'Can be guard or civilan
	zomlevel As Integer    'Attack level of zombie
	zomdam As Integer      'How much damage a zombie inflicts. 
	zomchar As String * 1  'The display char
	dropitem As invtype    'If guard what zombie drops.
	hasitem As boolean     'Zombie item flag.
	zomloc As mcoord       'Zombie location
	isdead As boolean      'Is Zombie still alive
	attack As boolean      'Can zombie attack.
	zomtime As Single      'Time Zombie was last active
	attchar As String * 1  'ID char to use as targeting.
	ishit As boolean       'Zombie was hit ny weapon.
End Type

'Set up the player type
Type playertype
   pcoord As mcoord      'current x,y position
	hascode As boolean    'Does player have access code
	haslocator As boolean 'Does player have locator
   maxhp As Integer       'max hp
   currhp As Integer
   inventory(1 To invtot) As invtype 'character inventory
   wlhand As invtype  'character weapons
   wrhand As invtype
	aHead As invtype 'character armor
	aBody As invtype
	aLArm As invtype
	aRArm As invtype
	aLHand As invtype
	aRHand As invtype
	aLLeg As invtype
	aRLeg As invtype
	aLFoot As invtype
	aRFoot As invtype
End Type

'Working vars.
Dim Shared level As maptype
Dim Shared player As playertype
Dim Shared zombie(1 To 50) As zombietype
Dim Shared As String mess(1 To 4)
Dim Shared As Integer timeleft, numzombies
Dim Shared As boolean fontok = FALSE, targeton = FALSE
Dim Shared blankinv As invtype
Dim Shared dirmatrix(north To nwest) As mcoord = {(0, -1), (1, -1), (1, 0), (1, 1), (0, 1), (-1, 1), (-1, 0), (-1, -1)}
Dim Shared As String zt
  
Dim As String ch 
Dim As Integer xx, yy, tmin  
Dim As boolean isdead = FALSE, didwin = FALSE, done = FALSE
Dim As Double dnow

