' Escape from Lab 42
' Richard D. Clark
' My entry in the 2009 7dRL challenge posted on rec.games.roguelike.development newsgroup.
' Uses my grid-based dungeon generation code. 
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' Map related routines.
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
'Min and max room dimensions
#Define roommax 8 
#Define roommin 4
#Define nroommin 20
#Define nroommax 50 
'Empty cell flag.
#Define emptycell 0
'Grid cell size (width and height)
Const csize = 10
'Grid dimensions.
Const gw = mapw \ csize
Const gh = maph \ csize

'Room dimensions.
Type rmdim
	rwidth As Integer
	rheight As Integer
	rcoord As mcoord
End Type

'Room information
Type roomtype
	roomdim As rmdim  'Room width and height.
	tl As mcoord      'Room rect
	br As mcoord
	secret As Integer         
End Type

'Grid cell structure.
Type celltype
	cellcoord As mcoord 'The cell position.
	Room As Integer     'Room id. This is an index into the room array.
End Type

Dim Shared rooms(1 To nroommax) As roomtype    'Room array.
Dim Shared grid(1 To gw, 1 To gh) As celltype 'Grid of cells.
Dim Shared as Integer numrooms

'Returns True if current tile is blocking tile.
Function BlockingTile(tx As Integer, ty As Integer) As boolean
    if level.lmap(tx, ty).terrid = twall or _
       level.lmap(tx, ty).terrid = tdoorclosed or _
       level.lmap(tx, ty).terrid = tsup or _
       level.lmap(tx, ty).hasmonster = TRUE Then
        return True
    else
        Return False
    end if
end function

'Bresenhams line algo
Function LineOfSight(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As boolean
    Dim As Integer i, deltax, deltay, numtiles
    Dim As Integer d, dinc1, dinc2
    Dim As Integer x, xinc1, xinc2
    Dim As Integer y, yinc1, yinc2
    Dim isseen As boolean = True
    
    deltax = Abs(x2 - x1)
    deltay = Abs(y2 - y1)

    If deltax >= deltay Then
        numtiles = deltax + 1
        d = (2 * deltay) - deltax
        dinc1 = deltay Shl 1
        dinc2 = (deltay - deltax) Shl 1
        xinc1 = 1
        xinc2 = 1
        yinc1 = 0
        yinc2 = 1
    Else
        numtiles = deltay + 1
        d = (2 * deltax) - deltay
        dinc1 = deltax Shl 1
        dinc2 = (deltax - deltay) Shl 1
        xinc1 = 0
        xinc2 = 1
        yinc1 = 1
        yinc2 = 1
    End If

    If x1 > x2 Then
        xinc1 = - xinc1
        xinc2 = - xinc2
    End If
    
    If y1 > y2 Then
        yinc1 = - yinc1
        yinc2 = - yinc2
    End If

    x = x1
    y = y1
    
    For i = 2 To numtiles
      'PSet (x, y), pcolor
      If BlockingTile(x, y) Then
        isseen = False
        Exit For
      End If
      If d < 0 Then
          d = d + dinc1
          x = x + xinc1
          y = y + yinc1
      Else
          d = d + dinc2
          x = x + xinc2
          y = y + yinc2
        End If
    Next
    
    Return isseen
End Function

'Determines if player can see object.
Function PlayerCanSee(tx As Integer, ty As Integer) As Integer
   Dim As Integer ret = FALSE
   Dim As Integer dist
        
	dist = CalcDist(player.pcoord.x, tx, player.pcoord.y, ty)
	If dist <= vh Then
   	ret = LineOfSight(player.pcoord.x, tx, player.pcoord.y, ty)
	End If
    
   Return ret
End Function

'Caclulate los with post processing
sub CalcLOS
	Dim as integer i, j, x, y
	Dim As Integer x1, x2, y1, y2
	
	'Clear the vismap
	For i = 1 To mapw
   	For j = 1 To maph
   		level.lmap(i, j).visible = FALSE
   	Next
	Next
	'Only check within viewport
	x1 = player.pcoord.x - vw
	If x1 < 1 Then x1 = 1
	y1 = player.pcoord.y - vh
	If y1 < 1 Then y1 = 1
	
	x2 = player.pcoord.x + vw
	If x2 > mapw - 1 Then x2 = mapw - 1
	y2 = player.pcoord.y + vh
	If y2 > maph - 1 Then y2 = maph - 1
	'iterate through vision area
	For i = x1 To x2
		For j = y1 To y2
	   	'Don't recalc seen tiles
	      If level.lmap(i, j).visible = False Then
	         If PlayerCanSee(i, j) Then
	         	level.lmap(i, j).visible = TRUE
	         	level.lmap(i, j).seen = TRUE
	         End If
	      End If
	  Next
	Next
	'Post process the map to remove artifacts.
	For i = x1 To x2
		For j = y1 To y2
			If (BlockingTile(i, j) = TRUE) And (level.lmap(i, j).visible = FALSE) Then
				x = i
				y = j - 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 
				
				x = i
				y = j + 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i + 1
				y = j
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i - 1
				y = j
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i - 1
				y = j - 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i + 1
				y = j - 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i + 1
				y = j + 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i - 1
				y = j + 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf
				
			EndIf 
		Next
	Next
End sub

'Return ascii symbol for health
Function GetHealthSymbol(tile As heal) As String
	Dim As String ret
	
   Select Case tile
   	Case hStimpack
   		ret = Chr(232)
   	Case hMedpack
   		ret = Chr(170)
   	Case Else
            'PrintMessage "Unknown tile: " + Str$(tile)
            ret = "?"
   End Select
   
   Return ret
End Function

'Return ascii symbol for tile
Function GetMapSymbol(tile As terrids) As String
	Dim As String ret
	
   Select Case tile
   	Case twall
   		ret = Chr(219)
   	Case tfloor
   		ret = Chr(249)
   	Case tsup
   		ret = Chr(10)
   	Case tdooropen
   		ret = "'"
   	Case tdoorclosed
   		ret = "\"
   	Case Else
            'PrintMessage "Unknown tile: " + Str$(tile)
            ret = "?"
   End Select
   
   Return ret
End Function

'Returns the color for object
Function GetMapSymbolColor(tile As Integer) As UInteger
	Dim ret As UInteger
	
   Select Case tile
   	Case twall
   		ret = fbGrey
   	Case tfloor
   		ret = fbWhite
   	Case tsup
   		ret = fbYellow
   	Case tdooropen
   		ret = fbTan
   	Case tdoorclosed
   		ret = fbTan
   	Case Else
         ret = fbWhite
   End Select
   
   Return ret
End Function

'Returns an item symbol
Sub GetItemInfo(inv As invtype, ByRef iClr As UInteger, ByRef iSymbol As String)

	'Set default.
	iClr = fbCyan
	iSymbol = "?"
		
	Select Case inv.classid
		Case iWeapon
			iClr = fbRed
			If inv.weapon.Item = wPistol Then
				iSymbol = "p"
			EndIf
			If inv.weapon.Item = wShotgun Then
				iSymbol = "s"
			EndIf
			If inv.weapon.Item = wLocator Then
				iClr = fbCyan
				iSymbol = "l"
			EndIf
			If inv.weapon.Item = wPipe Then
				iSymbol = "i"
			EndIf
			If inv.weapon.Item = wHammer Then
				iSymbol = "h"
			EndIf
		Case iAmmo
			iClr = fbOrange
			If inv.ammo.item = aClip Then
				iSymbol = "c" 
			EndIf
			If inv.ammo.item = aShells Then
				iSymbol = "s" 
			EndIf
		Case iArmor
			iClr = fbGreen
			If inv.armor.item = arCloth Then
				iSymbol = "c"
			EndIf
			If inv.armor.item = arLeather Then
				iSymbol = "l"
			EndIf
			If inv.armor.item = arKevlar Then
				iSymbol = "k"
			EndIf
			If inv.armor.item = arKevPlate Then
				iSymbol = "p"
			EndIf
		Case iCode
			iClr = fbGold
			If inv.iscode = TRUE Then
				iSymbol = "c"
			EndIf
		Case iHealth
			iClr = fbBlue
			If inv.health.item = hStimpack Then
				iSymbol = "s"
			EndIf
			If inv.health.item = hMedpack Then
				iSymbol = "m"
			EndIf
	End Select
	
End Sub

'Returns true if player has ammo in weapon.
Function HasAmmo() As boolean
	Dim As boolean ret = FALSE
	
	'Make sure player has projectile weapon and ammo.
	If player.wlhand.hasitem = TRUE Then
		If player.wlhand.weapon.pdamage > 0 Then
			If player.wlhand.weapon.Ammocnt > 0 Then
				ret = TRUE
			End If
		EndIf
	EndIf
	
	If player.wrhand.hasitem = TRUE Then
		If player.wrhand.weapon.pdamage > 0  Then
			If player.wrhand.weapon.Ammocnt > 0  Then
				ret = TRUE
			End If
		EndIf
	EndIf

	Return ret	
End Function

'Set the target display for each visible monster.
Sub SetZTargets(tgon As boolean = FALSE)
	Dim As Integer i, zx, zy, cnt = 1
	
	If HasAmmo() = FALSE Then
		tgon = FALSE
		targeton = FALSE
	EndIf
	
	If tgon = TRUE Then
		'Look at each zombie and see if it is visible.
		For i = 1 To numzombies
			'Make sur zombie is still alive.
			If zombie(i).isdead = FALSE Then
				'Get the zombie loc.
				zx = zombie(i).zomloc.x
				zy = zombie(i).zomloc.y
				'Is zombie visible.
				If level.lmap(zx, zy).visible = TRUE Then
					If zombie(i).attchar = Chr(32) Then
						'Set the zombie target char
						zombie(i).attchar = Mid(zt, cnt, 1)
						'If out of letters then exit.
						cnt += 1
						If cnt > Len(zt) Then Exit For
					End If
				EndIf
			End If
		Next
	Else
		For i = 1 To numzombies
			zombie(i).attchar = Chr(32)
		Next
	End If
End Sub

'ascii drawing rouine
Sub DrawMap
   Dim As Integer i, j, w = vw, h = vh, x, y, px, py
   Dim As Integer miid, tid, monid, dist
   Dim As UInteger tilecolor, bcolor
   Dim As String mtile
   Dim As terrids tile
   Dim As boolean mz = FALSE
   
	CalcLOS
	'get the view coords
	i = player.pcoord.x - (w / 2)
	j = player.pcoord.y - (h / 2)
	If i < 1 Then i = 1
	If j < 1 Then j = 1
	If i + w > mapw Then i = mapw - w
	If j + h > mapw Then j = mapw - h
	 For x = 1 To w
	     For y = 1 To h
	     		tilecolor = fbBlack 
	     		PutText Chr(219), y, x, tilecolor
     			'Get tile id
     			tile = level.lmap(i + x, j + y).terrid
        		'Get the tile symbol
         	mtile = GetMapSymbol(tile)
         	'Get the tile color
         	tilecolor = GetMapSymbolColor(tile)
	     		'Print the tile.
	         If level.lmap(i + x, j + y).visible = True Then
		         'Print the item marker.
		         If level.lmap(i + x, j + y).item.hasitem = True Then
		         	GetItemInfo level.lmap(i + x, j + y).item, tilecolor, mtile
		         	'Draw the item.
		         	PutText mtile, y, x, tilecolor
		         EndIf
	            PutText mtile, y, x, tilecolor
	            
		         'If the current location has a monster print that monster.
		         If level.lmap(i + x, j + y).hasmonster = TRUE Then
		         	monid = level.lmap(i + x, j + y).zomidx
		         	'Is zombie being targeted?
		         	If zombie(monid).attchar <> Chr(32) Then
		         		mz = TRUE
		         		If zombie(monid).ishit = TRUE Then
		         			PutText Chr(219), y, x, fbWhite
		         			PutText zombie(monid).attchar, y, x, fbBlack
		         		Else
		         			PutText Chr(219), y, x, fbBlack
		         			PutText zombie(monid).attchar, y, x, fbYellow	
		         		EndIf
		         	Else
		         		If zombie(monid).ishit = TRUE Then
		         			PutText Chr(219), y, x, fbWhite
		         			PutText zombie(monid).zomchar, y, x, fbBlack
		         		Else
		         			PutText Chr(219), y, x, fbBlack	
								PutText zombie(monid).zomchar, y, x, fbOrangeRed
		         		EndIf
		         	EndIf
		         EndIf
	         Else
	         	If level.lmap(i + x, j + y).seen = TRUE Then
	         		If level.lmap(i + x, j + y).item.hasitem = True Then
	         			GetItemInfo level.lmap(i + x, j + y).item, tilecolor, mtile
	         			tilecolor = fbSlateGreyDark
	         			PutText mtile, y, x, tilecolor 
	         		Else
	            		PutText mtile, y, x, fbSlateGreyDark
	         		End If
	         	End If
	         End If
	     Next 
	 Next
	 'Draw the player
	px = player.pcoord.x - i
	py = player.pcoord.y - j
	If player.currhp > 74 Then
		PutText Chr(219), py, px, fbBlack
		PutText "@", py, px, fbGreen
	ElseIf (player.currhp > 24) And (player.currhp < 75) Then
		PutText Chr(219), py, px, fbBlack
		PutText "@", py, px, fbYellow
	Else
		PutText Chr(219), py, px, fbBlack
		PutText "@", py, px, fbRed
	EndIf
	
	'Check to see if any remaining zombies are in view.
	If mz = false Then
		targeton = FALSE
		SetZTargets FALSE
	EndIf
	
End Sub

'Init the grid and room arrays
Sub InitGrid
   Dim As Integer i, j, x, y, gx = 1, gy = 1
	
	'Clear room array.		
   For i = 1 To nroommax
   	rooms(i).roomdim.rwidth = 0
   	rooms(i).roomdim.rheight = 0
   	rooms(i).roomdim.rcoord.x = 0
   	rooms(i).roomdim.rcoord.y = 0
   	rooms(i).tl.x = 0
   	rooms(i).tl.y = 0
   	rooms(i).br.x = 0
   	rooms(i).br.y = 0
   Next 
   'How many rooms
   numrooms = RandomRange(nroommin, nroommax)
   'Build some rooms
   For i = 1 To numrooms
   	rooms(i).roomdim.rwidth = RandomRange(roommin, roommax)
    	rooms(i).roomdim.rheight = RandomRange(roommin, roommax)
   Next
    'Clear the grid array
   For i = 1 To gw 
   	For j = 1 To gh
    		grid(i, j).cellcoord.x = gx
    		grid(i, j).cellcoord.y = gy
     		grid(i, j).Room = emptycell
     		gy += csize
   	Next
   	gy = 1
   	gx += csize
   Next
	'Add rooms to the grid
   For i = 1 To numrooms
   	'Find an empty spot in the grid
   	Do
   		x = RandomRange(2, gw - 1)
   		y = RandomRange(2, gh - 1)
   	Loop Until grid(x, y).Room = emptycell
   	'Room center
   	rooms(i).roomdim.rcoord.x = grid(x, y).cellcoord.x + (rooms(i).roomdim.rwidth \ 2)   
   	rooms(i).roomdim.rcoord.y = grid(x, y).cellcoord.y + (rooms(i).roomdim.rheight \ 2)
		'Set the room rect
		rooms(i).tl.x = grid(x, y).cellcoord.x 
		rooms(i).tl.y = grid(x, y).cellcoord.y 
		rooms(i).br.x = grid(x, y).cellcoord.x + rooms(i).roomdim.rwidth + 1
		rooms(i).br.y = grid(x, y).cellcoord.y + rooms(i).roomdim.rheight + 1
   	'Save the room index
   	grid(x, y).Room = i
   Next
	'Save the room index
	grid(x, y).Room = i
   
End Sub 

'Connect all the rooms.
Sub ConnectRooms( r1 As Integer, r2 As Integer, secret As Integer = FALSE)
	Dim As Integer idx, x, y
	Dim As mcoord currcell, lastcell
	Dim As Integer wflag
	
	currcell = rooms(r1).roomdim.rcoord
	lastcell = rooms(r2).roomdim.rcoord
		
	x = currcell.x
	If x < lastcell.x Then
		wflag = FALSE
		Do
			x += 1
			If level.lmap(x, currcell.y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, currcell.y).terrid = tfloor) And (wflag = TRUE) Then
				Exit Sub
			EndIf
			level.lmap(x, currcell.y).terrid = tfloor
		Loop Until x = lastcell.x
	End If
	
	If x > lastcell.x Then
		wflag = FALSE
		Do
			x -= 1
			If level.lmap(x, currcell.y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, currcell.y).terrid = tfloor) And (wflag = TRUE) Then 
				Exit Sub
			EndIf
			level.lmap(x, currcell.y).terrid = tfloor
		Loop Until x = lastcell.x
	EndIf
	
	y = currcell.y
	If y < lastcell.y Then
		wflag = FALSE
		Do
			y += 1
			If level.lmap(x, y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, y).terrid = tfloor) And (wflag = TRUE) Then 
				Exit Sub
			EndIf
			level.lmap(x, y).terrid = tfloor
		Loop Until y = lastcell.y
	EndIf
	
	If y > lastcell.y Then
		Do
			y -= 1
			If level.lmap(x, y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, y).terrid = tfloor) And (wflag = TRUE) Then 
				Exit Sub
			EndIf
			level.lmap(x, y).terrid = tfloor
		Loop Until y = lastcell.y
	EndIf
		 
End Sub

'Add doors to a particualr room.
Sub AddDoorsToRoom(i As Integer)
	Dim As Integer row, col, dd1, dd2
	
	'Iterate along top room.
	For col = rooms(i).tl.x To rooms(i).br.x
		dd1 = rooms(i).tl.y
		dd2 = rooms(i).br.y
		'If a floor space in the wall-
		If (level.lmap(col, dd1).terrid = tfloor) Or (level.lmap(col, dd1).terrid = tdoorclosed) Then
			'Add door.
			level.lmap(col, dd1).terrid = tdoorclosed
		EndIf
		'Iterate along bottom of room.
		If (level.lmap(col, dd2).terrid = tfloor) Or (level.lmap(col, dd2).terrid = tdoorclosed) Then
			level.lmap(col, dd2).terrid = tdoorclosed
		End If
	Next
	'Iterate along left side of room.
	For row = rooms(i).tl.y To rooms(i).br.y
		dd1 = rooms(i).tl.x
		dd2 = rooms(i).br.x
		If (level.lmap(dd1, row).terrid = tfloor) Or (level.lmap(dd1, row).terrid = tdoorclosed) Then
			level.lmap(dd1, row).terrid = tdoorclosed
		End If
		'Iterate along right side of room.
		If (level.lmap(dd2, row).terrid = tfloor) Or (level.lmap(dd2, row).terrid = tdoorclosed) Then
			level.lmap(dd2, row).terrid = tdoorclosed
		EndIf
	Next
	
End Sub

'Adds doors to rooms.
Sub AddDoors
	Dim As Integer i
	
	For i = 1 To numrooms
		AddDoorsToRoom i
	Next
End Sub

'Transfer grid data to map array.
Sub DrawMapToArray
	Dim As Integer i, x, y, pr, rr, rl, ru, kr
	
	'Draw the first room to map array
		For x = rooms(1).tl.x + 1 To rooms(1).br.x - 1
			For y = rooms(1).tl.y + 1 To rooms(1).br.y - 1
				level.lmap(x, y).terrid = tfloor
			Next
		Next
	'Draw the rest of the rooms to the map array and connect them.
	For i = 2 To numrooms
		For x = rooms(i).tl.x + 1 To rooms(i).br.x - 1
			For y = rooms(i).tl.y + 1 To rooms(i).br.y - 1
				level.lmap(x, y).terrid = tfloor
			Next
		Next
		ConnectRooms i, i - 1
	Next
	'Add doors to selected rooms.
	AddDoors
	'Set up player location.
	x = rooms(1).roomdim.rcoord.x + (rooms(1).roomdim.rwidth \ 2) 
	y = rooms(1).roomdim.rcoord.y + (rooms(1).roomdim.rheight \ 2)
	player.pcoord.x = x - 1
	player.pcoord.y = y - 1
	'Set up stairs depending on direction.
	x = rooms(numrooms).roomdim.rcoord.x + (rooms(numrooms).roomdim.rwidth \ 2) 
	y = rooms(numrooms).roomdim.rcoord.y + (rooms(numrooms).roomdim.rheight \ 2)
	level.lmap(x - 1, y - 1).terrid = tsup
End Sub

'Returns TRUE if x and y are at character loc.
Function IsPlayerLoc(x As Integer, y As Integer) As boolean
	If (x = player.pcoord.x) And (y = player.pcoord.y) Then
		Return TRUE
	Else
		Return FALSE
	EndIf	
End Function

'Add a zombie to array.
Sub AddAZombie(i As Integer)
	Dim As Integer x, y, mx, id
	
	zombie(i).zomdam = 1
	mx = (maxlevel - level.levelinfo.mlevel) + 5
	zombie(i).zomdam += RandomRange(mx, (mx * 2)) 
	'Generate zombie class.
	zombie(i).zomid = RandomRange(guard, civilian)
	If zombie(i).zomid = guard Then
		zombie(i).zomchar = "Z"
		zombie(i).zomlevel = RandomRange(50, 100)
	Else
		zombie(i).zomchar = "z"
		zombie(i).zomlevel = RandomRange(1, 49)
	End If
	'Set the time for the zombie.
	zombie(i).zomtime = Timer
	'Zombie not dead, of course.
	zombie(i).isdead = FALSE
	'Clear target char.
	zombie(i).attchar = Chr(32)
	Do
		'Pick a location within the map.
		x = RandomRange(1, mapw - 1)
		y = RandomRange(1, maph - 1)
	Loop Until (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).hasmonster = FALSE) And _
	           (IsPlayerLoc(x, y) = FALSE) And (level.lmap(x, y).visible = FALSE)
	'Set the monster location.
	zombie(i).zomloc.x = x
	zombie(i).zomloc.y = y
	'Mark the position within the map.
	level.lmap(x, y).hasmonster = TRUE
	level.lmap(x, y).zomidx = i
	
End Sub

'Adds the zombies o the level.
Sub GenerateZombies
	Dim As Integer i
	
	numzombies = ((maxlevel + 1) - level.levelinfo.mlevel) * 5
	
	'Generate the zombies for the level.
	For i = 1 To numzombies
		AddAZombie i
	Next
End Sub

'Load an inventory item with proper data
Sub AddItem(inv As invtype)
	
	If inv.classid = iWeapon Then
		If inv.weapon.Item = wPistol Then 
			inv.weapon.ammotype = aClip
			inv.weapon.Ammocnt = aPistolmax
			inv.weapon.hands = 1
			inv.weapon.pdamage = 25
			inv.weapon.damage = 5
		ElseIf inv.weapon.Item = wShotgun Then 
			inv.weapon.ammotype = aShells
			inv.weapon.Ammocnt = aShotgunmax
			inv.weapon.hands = 2
			inv.weapon.pdamage = 50
			inv.weapon.damage = 5
		ElseIf inv.weapon.Item = wPipe Then 
			inv.weapon.ammotype = aNone
			inv.weapon.Ammocnt = 0
			inv.weapon.hands = 1
			inv.weapon.pdamage = 0
			inv.weapon.damage = 5
		ElseIf inv.weapon.Item = wHammer Then
			inv.weapon.ammotype = aNone
			inv.weapon.Ammocnt = 0
			inv.weapon.hands = 1
			inv.weapon.pdamage = 0
			inv.weapon.damage = 10
		ElseIf inv.weapon.Item = wLocator Then
			inv.weapon.ammotype = aNone
			inv.weapon.Ammocnt = 0
			inv.weapon.hands = 1
			inv.weapon.pdamage = 0
			inv.weapon.damage = 0
		End If
	EndIf
	
	If inv.classid = iAmmo Then
		If inv.ammo.item = aNone Then
			inv.ammo.cnt = 0
		ElseIf inv.ammo.item = aClip Then
			inv.ammo.cnt = aPistolmax
		ElseIf inv.ammo.item = aShells Then
			inv.ammo.cnt = aShotgunmax
		EndIf
	EndIf
	
	If inv.classid = iArmor Then
		If inv.armor.item = arNone Then
			inv.armor.amt = 0
		ElseIf inv.armor.item = arCloth Then
			inv.armor.amt = 2
		ElseIf inv.armor.item = arLeather Then
			inv.armor.amt = 8
		ElseIf inv.armor.item = arKevlar Then
			inv.armor.amt = 64
		ElseIf inv.armor.item = arKevPlate Then
			inv.armor.amt = 128
		Else
			inv.hasitem = FALSE
		End If		
	End If
	
	If inv.classid = iCode Then
		inv.iscode = TRUE
	EndIf

	If inv.classid = iHealth Then
		If inv.health.item = hStimpack Then
			inv.health.hltamt = 10
		ElseIf inv.health.item = hMedpack Then
			inv.health.hltamt = 40
		End If
	EndIf
	
End Sub


'Fill dungeon with items.
Sub GenerateItems
	Dim As invtype inv
	Dim As Integer x, y, numitems, i, classid, itemid, aloc, mx
	
	'Generate the pass code.
	If player.hascode = FALSE Then
		inv.hasitem = TRUE
		inv.classid = iCode
		AddItem inv
		'Add some where in level.
		Do	
			x = RandomRange(1, mapw)
			y = RandomRange(1, maph)
		Loop Until (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).item.hasitem = FALSE) And (level.lmap(x, y).visible = FALSE)
		level.lmap(x, y).item = inv
	End If
	
	inv = blankinv
	'If player doesn't have locator add one to map.
	If player.haslocator = FALSE Then
		inv.hasitem = TRUE
		inv.classid = iWeapon
		inv.weapon.Item = wLocator
		AddItem inv
		'Add some where in level.
		Do	
			x = RandomRange(1, mapw)
			y = RandomRange(1, maph)
		Loop Until (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).item.hasitem = FALSE) And (level.lmap(x, y).visible = FALSE)
		level.lmap(x, y).item = inv
	EndIf
	
	'Generate some random items.
	mx = (maxlevel  - level.levelinfo.mlevel) + 11
	numitems = RandomRange(1, mx)
	For i = 1 To numitems
		inv = blankinv
		'Generate a random classid
		classid = RandomRange(iWeapon, iHealth)
		inv.classid = classid
		'Generate item based on class id.
		If classid = iWeapon Then
			inv.hasitem = true
			itemid = RandomRange(wPistol, wHammer)
			inv.weapon.Item = itemid
		ElseIf classid = iAmmo Then
			inv.hasitem = true
			itemid = RandomRange(aClip, aShells)
			inv.ammo.item = itemid
		ElseIf classid = iArmor Then
			inv.hasitem = true
			itemid = RandomRange(arNone, arKevlar)
			If itemid = arNone Then
				itemid = arKevPlate
				aloc = pBody
			Else
				aloc = RandomRange(pHead, pRFoot)
			End If
			inv.armor.item = itemid
			inv.armor.location = aloc
		ElseIf classid = iHealth Then
			inv.hasitem = true
			itemid = RandomRange(hStimpack, hMedpack)
			inv.health.item = itemid
		EndIf
		AddItem inv
		'Add some where in level.
		Do	
			x = RandomRange(1, mapw)
			y = RandomRange(1, maph)
		Loop Until (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).item.hasitem = FALSE) And (IsPlayerLoc(x, y) = FALSE)
		level.lmap(x, y).item = inv
	Next
End Sub

'Generate a new dungeon level.
Sub GenerateDungeonLevel
	Dim As Integer x, y

	player.hascode = FALSE
	'Clear level
	For x = 1 To mapw
		For y = 1 To maph
			'Set to wall tile
			level.lmap(x, y).terrid = twall
			level.lmap(x, y).item = blankinv
			level.lmap(x, y).visible = FALSE
			level.lmap(x, y).seen = FALSE
			level.lmap(x, y).hasmonster = FALSE
			level.lmap(x, y).zomidx = 0
			level.lmap(x, y).elelocked = TRUE
		Next
	Next
	InitGrid
	DrawMapToArray
	GenerateZombies
	GenerateItems
End Sub

'Move all the zombies.
function MoveZombies() As boolean
	Dim As Integer i, zx, zy, px, py, newx, newy, dist, rr
	Dim As Single tdiff
	Dim As boolean didmove = FALSE
	
	px = player.pcoord.x
	py = player.pcoord.y
	
	For i = 1 To numzombies
		zombie(i).ishit = FALSE
		zx = zombie(i).zomloc.x
		zy = zombie(i).zomloc.y
		If zombie(i).isdead = FALSE Then
			zombie(i).attack = FALSE
			'Check to see if zombie can move.
			tdiff = Timer - zombie(i).zomtime
			If tdiff > .5 Then
				If level.lmap(zx, zy).visible = TRUE Then
					'Get the new relative position.
					If px < zx Then 
						newx = zx - 1
					ElseIf px > zx Then
						newx = zx + 1
					Else
						newx = zx
					EndIf
					If py < zy Then 
						newy = zy - 1
					ElseIf py > zy Then
						newy = zy + 1
					Else
						newy = zy
					EndIf
					dist = CalcDist(zx, px, zy, py)
					If dist <= 1 Then
						'Set attack flag.
						zombie(i).attack = TRUE
						didmove = TRUE
					Else
						'Make sure zombie can move to location.
						If BlockingTile(newx, newy) = FALSE Then
							level.lmap(zx, zy).hasmonster = FALSE
							level.lmap(zx, zy).zomidx = 0
							zombie(i).zomloc.x = newx
							zombie(i).zomloc.y = newy
							level.lmap(newx, newy).hasmonster = TRUE
							level.lmap(newx, newy).zomidx = i
							didmove = TRUE
						EndIf
					EndIf
				Else
					'Move in a random direction.
					rr = RandomRange(north, nwest)
					newx =  dirmatrix(rr).x + zx
					rr = RandomRange(north, nwest)
					newy = dirmatrix(rr).y + zy
					If BlockingTile(newx, newy) = FALSE Then
						level.lmap(zx, zy).hasmonster = FALSE
						level.lmap(zx, zy).zomidx = 0
						zombie(i).zomloc.x = newx
						zombie(i).zomloc.y = newy
						level.lmap(newx, newy).hasmonster = TRUE
						level.lmap(newx, newy).zomidx = i
					EndIf
				End If
				'Reset time.
				zombie(i).zomtime = Timer
			End If
		EndIf
	Next
	Return didmove
End Function

'Attack player
Function AttackPlayer() As boolean
	Dim As Integer i, zdr, pdr, zroll, proll, dam, zx, zy, nx, ny, zcnt, ploc, armdam
	Dim As boolean ret = FALSE
	Dim As String txt
	
	For i = 1 To numzombies
		If zombie(i).attack = TRUE Then
			dam = RandomRange(1, zombie(i).zomdam)
			zx = zombie(i).zomloc.x
			zy = zombie(i).zomloc.y
			pdr = player.currhp
			zdr = zombie(i).zomlevel
			'If zombies are in a group they are much stronger.
			nx = zx - 1
			ny = zy - 1
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx 
			ny = zy - 1
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx + 1
			ny = zy - 1
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx + 1
			ny = zy
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx + 1
			ny = zy + 1
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx 
			ny = zy + 1
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx - 1
			ny = zy + 1
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			nx = zx - 1
			ny = zy
			If level.lmap(nx, ny).hasmonster = TRUE Then
				zdr += zombie(i).zomlevel
				dam += 1
				zcnt += 1
			EndIf
			'Get the roll
			zroll = RandomRange(1, zdr)
			proll = RandomRange(1, pdr)
			If zroll > proll Then
				'Get damage location.
				ploc = RandomRange(pHead, pRFoot)
				If ploc = pHead Then
					txt = "The zombie bites you on the head "
					'Armor takes damage.
					If player.aHead.hasitem = TRUE Then
						armdam = player.aHead.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aHead.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aHead.hasitem = FALSE
						Else
							dam -= armdam
							player.aHead.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pBody Then
					txt = "The zombie bites you on the body "
					If player.aBody.hasitem = TRUE Then
						armdam = player.aBody.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aBody.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aBody.hasitem = FALSE
						Else
							dam -= armdam
							player.aBody.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pLArm Then
					txt = "The zombie bites you on the left arm "
					If player.aLArm.hasitem = TRUE Then
						armdam = player.aLArm.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aLArm.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aLArm.hasitem = FALSE
						Else
							dam -= armdam
							player.aLArm.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pRArm Then
					txt = "The zombie bites you on the right arm "
					If player.aRArm.hasitem = TRUE Then
						armdam = player.aRArm.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aRArm.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aRArm.hasitem = FALSE
						Else
							dam -= armdam
							player.aRArm.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pLHand Then
					txt = "The zombie bites you on the left hand "
					If player.aLHand.hasitem = TRUE Then
						armdam = player.aLHand.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aLHand.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aLHand.hasitem = FALSE
						Else
							dam -= armdam
							player.aLHand.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pRHand Then
					txt = "The zombie bites you on the right hand "
					If player.aRHand.hasitem = TRUE Then
						armdam = player.aRHand.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aRHand.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aRHand.hasitem = FALSE
						Else
							dam -= armdam
							player.aRHand.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pLLeg Then
					txt = "The zombie bites you on the left leg "
					If player.aLLeg.hasitem = TRUE Then
						armdam = player.aLLeg.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aLLeg.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aLLeg.hasitem = FALSE
						Else
							dam -= armdam
							player.aLLeg.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pRLeg Then
					txt = "The zombie bites you on the right leg "
					If player.aRLeg.hasitem = TRUE Then
						armdam = player.aRLeg.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aRLeg.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aRLeg.hasitem = FALSE
						Else
							dam -= armdam
							player.aRLeg.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pLFoot Then
					txt = "The zombie bites you on the left foot "
					If player.aLFoot.hasitem = TRUE Then
						armdam = player.aLFoot.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aLFoot.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aLFoot.hasitem = FALSE
						Else
							dam -= armdam
							player.aLFoot.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				If ploc = pRFoot Then
					txt = "The zombie bites you on the right foot "
					If player.aRFoot.hasitem = TRUE Then
						armdam = player.aRFoot.armor.amt
						If armdam > dam Then
							armdam -= dam
							player.aRFoot.armor.amt = armdam
							dam = 0
						ElseIf armdam = dam Then
							dam = 0
							player.aRFoot.hasitem = FALSE
						Else
							dam -= armdam
							player.aRFoot.hasitem = FALSE
						EndIf
					EndIf
				EndIf
				'Calc damage
				If dam <= 0 Then
					AddMessage txt & "armor."
				Else
					player.currhp -= dam
					AddMessage txt & "for " & dam & "."
				EndIf
			Else
				AddMessage "You dodge the zombie attack."
			EndIf
			'See if player loses an item to a zombie.
			If zcnt > 1 Then
				
			EndIf
			ret = TRUE
		EndIf
	Next
	Return ret
End Function

'Find an empty inv slot.
Function GetEmptyInvSlot() As Integer
	Dim As Integer i, ret = 0
	
	For i = 1 To 4
		If player.inventory(i).hasitem = FALSE Then
			ret = i
			Exit For
		EndIf
	Next
	Return ret
End Function

'Returns the number of empty inv slots.
Function GetNumberEmptyInvSlot() As Integer
	Dim As Integer i, ret = 0
	
	For i = 1 To 4
		If player.inventory(i).hasitem = FALSE Then
			ret += 1
		EndIf
	Next
	Return ret
End Function

'Get hand if player is holding two handed item.
Function CheckForTwoHanded() as Integer
	Dim As Integer ret = pNone
	
	If player.wlhand.hasitem = TRUE Then
		If player.wlhand.weapon.hands = 2 Then ret = pLHand
	EndIf
	If player.wrhand.hasitem = TRUE Then
		If player.wrhand.weapon.hands = 2 Then ret = pRHand
	EndIf
	
	Return ret
End Function

'Switches a one-handed item for two handed item.
Sub EquipOneForTwo(islot As Integer, whand As Integer)
	Dim As invtype sinv, tinv
	
	'Get the inventory slot item.
	sinv = player.inventory(islot)

	If whand = pLHand Then
		tinv = player.wlhand
		player.wlhand = sinv
		player.inventory(islot) = tinv
	End If

	If whand = pRHand Then
		tinv = player.wrhand
		player.wrhand = sinv
		player.inventory(islot) = tinv
	End If
	
End Sub


'Returns a free hand if any.
Function GetFreeHand() As Integer
	Dim As Integer ret = pNone
	
	If player.wlhand.hasitem = FALSE Then
		ret = pLHand
	Else
		If player.wrhand.hasitem = FALSE Then ret = pRHand
	EndIf
	
	Return ret
End Function

'Equips an empty hand.
sub EquipEmptyHand(islot as Integer, whand as integer)
	Dim As invtype sinv, tinv
	
	'Get the inventory slot item.
	sinv = player.inventory(islot)

	If whand = pLHand Then
		tinv = player.wlhand
		player.wlhand = sinv
		player.inventory(islot) = tinv
	EndIf

	If whand = pRHand Then
		tinv = player.wrhand
		player.wrhand = sinv
		player.inventory(islot) = tinv
	EndIf
	
end Sub

'Get item to unequip.
Sub UnEquipItem(islot As Integer)
	Dim As String resp = "lrn", txt, ch
	Dim As Integer fhand
	
	'If only holding one item then unequip that item.
	fhand = GetFreeHand
	If fhand = pNone Then
		txt = String(Len("Unequip which hand (r)ight (l)eft (n)one? "), Chr(219))
		PutText txt, vh + 2, 2, fbBlack
		txt = "Unequip which hand (r)ight (l)eft (n)one?"
		PutText txt, vh + 2, 2, fbWhite
		Flip
		Do
			ch = InKey
			ch = LCase(ch)
			Sleep 1
		Loop Until InStr(resp, ch)
		
		If ch = "n" Then 
			Exit Sub
		ElseIf ch = "l" Then
			player.inventory(islot) = player.wlhand
			player.wlhand = blankinv
			AddMessage "Item unequipped."
		Else
			player.inventory(islot) = player.wrhand
			player.wrhand = blankinv
			AddMessage "Item unequipped."
		End If
	Else
		If fhand = pLHand Then
			player.inventory(islot) = player.wrhand
			player.wrhand = blankinv
			player.wlhand = blankinv
			AddMessage "Item unequipped."
		EndIf
		
		If fhand = pRHand Then
			player.inventory(islot) = player.wlhand
			player.wlhand = blankinv
			player.wrhand = blankinv
			AddMessage "Item unequipped."
		EndIf
	End If
End Sub


'Handles special case of two handed weapon.
Sub EquipTwoHanded(islot As Integer)
	Dim As invtype sinv, tinv
	Dim As Integer ei, wcnt = 0
	
	'Temporarily remove item from inventory.
	tinv = player.inventory(islot)
	player.inventory(islot) = blankinv
	
	'Count number ot items being held.
	If player.wlhand.hasitem = TRUE Then
		wcnt += 1
	EndIf
	
	If player.wrhand.hasitem = TRUE Then
		wcnt += 1
	EndIf
	
	'Not holding anything.	
	If wcnt = 0 Then
		player.wrhand = tinv
		AddMessage "Weapon equipped."
	EndIf
	
	'Holding 1 item.
	If wcnt = 1 Then
		'In left hand?
		If player.wlhand.hasitem = TRUE Then
			player.inventory(islot) = player.wlhand
			player.wlhand = blankinv
			player.wrhand = tinv
			AddMessage "Weapon equipped."
		EndIf
		'In right hand?
		If player.wrhand.hasitem = TRUE Then
			player.inventory(islot) = player.wrhand
			player.wrhand = tinv
			AddMessage "Weapon equipped."
		EndIf
	EndIf
	
	'Holding 2 items.	
	If wcnt = 2 Then
		'See if player has enough empty inv slots.
		ei = GetNumberEmptyInvSlot
		If ei < 2 Then
			'Return item to previous location.
			player.inventory(islot) = tinv
	 		AddMessage "Not enough inventory slots to unequip items."
	 		Exit Sub
		End If
	 	'Transfer items to inventory.
		ei = GetEmptyInvSlot
		player.inventory(ei) = player.wrhand
		player.wrhand = tinv
		ei = GetEmptyInvSlot
		player.inventory(ei) = player.wlhand
		player.wlhand = blankinv
		AddMessage "Weapon equipped."
	End If		
		
End Sub

'Equips or uses an item.
Sub EquipItem (islot As integer)
	Dim As invtype sinv, tinv
	Dim As String resp = "rln", txt, ch
	Dim As Integer ei, whand
	Dim as boolean hasloc = FALSE
	
	'Get the inventory slot item.
	sinv = player.inventory(islot)
	
	If sinv.hasitem = TRUE Then
		'If armor load it into the proper slot.
		If sinv.classid = iWeapon Then
			'If item is shotgun unequip both hands if available inventory.
			If sinv.weapon.hands = 2 Then
				EquipTwoHanded islot
			Else
				'Check to see if player is holding a 2-handed weapon.
				whand = CheckForTwoHanded
				If whand <> pNone Then
					EquipOneForTwo islot, whand
				Else
					'Not two handed so see if empty hand.
					whand = GetFreeHand
					If whand <> pNone Then
						EquipEmptyHand islot, whand
					Else
						'Get hand to equip item.
						txt = String(Len("Use which hand (r)ight (l)eft (n)one? "), Chr(219))
						PutText txt, vh + 2, 2, fbBlack
						'Find out which hand player wants to use.
						txt = "Use which hand (r)ight (l)eft (n)one?"
						PutText txt, vh + 2, 2, fbWhite
						Flip
						Do
							ch = InKey
							ch = LCase(ch)
							Sleep 1
						Loop Until InStr(resp, ch)
						
						If ch = "n" Then 
							Exit Sub
						ElseIf ch = "l" Then
							tinv = player.wlhand
							player.wlhand = sinv
							player.inventory(islot) = tinv
							AddMessage "Item equipped in left hand."
						Else
							tinv = player.wrhand
							player.wrhand = sinv
							player.inventory(islot) = tinv
							AddMessage "Item equipped in right hand."
						End If
					EndIf
				End If
			EndIf
			
			'Check for locator.
			If player.wlhand.hasitem = TRUE Then
				if player.wlhand.weapon.Item = wLocator Then
					hasloc = TRUE
				EndIf
			EndIf
			If player.wrhand.hasitem = TRUE Then
				if player.wrhand.weapon.Item = wLocator Then
					hasloc = TRUE
				EndIf
			EndIf
			player.haslocator = hasloc
		End If
		
		If sinv.classid = iArmor Then
			If sinv.armor.location = pHead Then
				tinv = player.aHead
				player.aHead = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on head."
			ElseIf sinv.armor.location = pBody Then
				tinv = player.aBody
				player.aBody = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on body."
			ElseIf sinv.armor.location = pLArm Then
				tinv = player.aLArm
				player.aLArm = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on left arm."
			ElseIf sinv.armor.location = pRArm Then
				tinv = player.aRArm
				player.aRArm = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on right arm."
			ElseIf sinv.armor.location = pLHand Then
				tinv = player.aLHand
				player.aLHand = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on left hand."
			ElseIf sinv.armor.location = pRHand Then
				tinv = player.aRHand
				player.aRHand = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on right hand."
			ElseIf sinv.armor.location = pLLeg Then
				tinv = player.aLLeg
				player.aLLeg = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on left leg."
			ElseIf sinv.armor.location = pRLeg Then
				tinv = player.aRLeg
				player.aRLeg = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on right leg."
			ElseIf sinv.armor.location = pLFoot Then
				tinv = player.aLFoot
				player.aLFoot = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on left foot."
			ElseIf sinv.armor.location = pRFoot Then
				tinv = player.aRFoot
				player.aRFoot = sinv
				player.inventory(islot) = tinv
				AddMessage "Item equipped on right foot."
			EndIf
		End If
		
		If sinv.classid = iAmmo Then
			'Get the ammo type
			If sinv.ammo.item = aClip Then
				'Check left hand first.
				If player.wlhand.hasitem = TRUE Then
					'Reload pistol with ammo if needed.
					If player.wlhand.weapon.Item = wPistol Then
						'Check to see if te pistol needs to be reloaded.
						If player.wlhand.weapon.Ammocnt < aPistolmax Then
							player.wlhand.weapon.Ammocnt = sinv.ammo.cnt
							sinv.ammo.cnt = 0
					 		player.inventory(islot) = blankinv
					 		AddMessage "Pistol reloaded."
						End If
					EndIf
				EndIf
				
				'Check right hand.
				If (player.wrhand.hasitem = TRUE) And (sinv.ammo.cnt > 0) Then
					'Reload pistol with ammo if needed.
					If player.wrhand.weapon.Item = wPistol Then
						'Check to see if te pistol needs to be reloaded.
						If player.wrhand.weapon.Ammocnt < aPistolmax Then
							player.wrhand.weapon.Ammocnt = sinv.ammo.cnt
					 		player.inventory(islot) = blankinv
					 		AddMessage "Pistol reloaded."
						End If
					EndIf
				EndIf

			End If
			
			If sinv.ammo.item = aShells Then
				'Check left hand first.
				If player.wlhand.hasitem = TRUE Then
					'Reload pistol with ammo if needed.
					If player.wlhand.weapon.Item = wShotgun Then
						'Check to see if te pistol needs to be reloaded.
						If player.wlhand.weapon.Ammocnt < aShotgunmax Then
							player.wlhand.weapon.Ammocnt = sinv.ammo.cnt
							player.inventory(islot) = blankinv
							AddMessage "Shotgun reloaded."
						End If
					EndIf
				EndIf
				
				'Check right hand.
				If player.wrhand.hasitem = TRUE Then
					'Reload pistol with ammo if needed.
					If player.wrhand.weapon.Item = wShotgun Then
						'Check to see if te pistol needs to be reloaded.
						If player.wrhand.weapon.Ammocnt < aShotgunMax Then
							player.wrhand.weapon.Ammocnt = sinv.ammo.cnt
							player.inventory(islot) = blankinv
							AddMessage "Shotgun reloaded."
						End If
					EndIf
				EndIf
				
			End If
		End If
		
		If sinv.classid = iHealth Then
			'See if playe needs the meds.
			If player.currhp < player.maxhp Then
				player.currhp += sinv.health.hltamt
				If player.currhp > player.maxhp Then
					player.currhp = player.maxhp
					AddMessage sinv.health.hltamt & " health restored."
				EndIf
				player.inventory(islot) = blankinv
			EndIf
		EndIf
	Else
		UnEquipItem islot
	End If
End Sub



