' Escape from Lab 42
' Richard D. Clark
' My entry in the 2009 7dRL challenge posted on rec.games.roguelike.development newsgroup.
' Uses my grid-based dungeon generation code. 
' This program is free software; you can redistribute it and/or modify it
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' Utility routines.
'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

'Pixel types used in alphablend. 
Type Pixel_Color
    B As UByte
    G As Ubyte
    R As Ubyte
    A As Ubyte
End Type

Union Pixel
    Channel As Pixel_Color
    Value   As Uinteger
End Union

'Returns a random number within range.
function RandomRange(lowerbound as integer, upperbound as integer) as integer
	return Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
end Function

'Returns fast distance calc between two points.
Function CalcDist(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Dim As Integer xdiff, ydiff
    Dim dist As Integer
   
    xdiff = Abs(x1 - x2)
    ydiff = Abs(y1 - y2)
    dist =  (xdiff + ydiff + imax(xdiff, ydiff)) Shr 1
    Return dist
End Function

'Writes text as specified row and column.
Sub PutText(txt As String, row As Integer, col As Integer, fcolor As UInteger = fbWhite)
	Dim As Integer x, y
	
	x = (col - 1) * twh
	y = (row - 1) * twh
	Draw String (x, y), txt, fcolor
	 
End Sub

'Returns an alpha blended color.
Function AlphaBlend(alpha As integer, fcolor as uinteger, bcolor as uinteger) as uinteger
    dim as integer invalpha, r, g, b
    dim as Pixel fc, bc
    
    if alpha > 255 then alpha = 255
    if alpha < 0 then alpha = 0    
    invalpha = 255 - alpha
    fc.value = fcolor
    bc.value = bcolor
    r = ((fc.channel.r * alpha) + (bc.channel.r * invalpha)) shr 8
    g = ((fc.channel.g * alpha) + (bc.channel.g * invalpha)) shr 8
    b = ((fc.channel.b * alpha) + (bc.channel.b * invalpha)) shr 8
    
    return RGB(r, g, b)    
end Function

Sub DoTitle
	Dim As Integer row, col, cnt
	Dim As UInteger clrf, clrb, clr
	Dim As Single mt
	
	Cls
	For col = 0 To tcols - 1
		For row = 0 To trows - 1
			'Draw background first.
			clrb = corridor(col + row * corridorw)
			PutText Chr(219), row + 1, col + 1, clrb
		Next
	Next
	Flip
	'Fade in the title.
	For cnt = 0 To 255
		mt = Timer
		For col = 0 To tcols - 1
			For row = 0 To trows - 1
				'Get the background color.
				clrb = corridor(col + row * corridorw)
				'Draw font.
				clrf = title(col + row * titlew)
				If clrf <> &hFF000000 Then
					clr = AlphaBlend(cnt, clrf, clrb)
					PutText Chr(219), row + 1, col + 1, clr
					If InKey <> "" Then Exit Sub
				EndIf
			Next 
		Next
		Flip
		SetFPS(mt)
	Next
	Delay(2)
End Sub

'Draws the image background.
Sub DrawBackground
	Dim As Integer row, col
	Dim As UInteger clr
	
	For col = 0 To tcols - 1
		For row = 0 To trows - 1
			'Draw background first.
			clr = backgrnd(col + row * backgrndw)
			PutText Chr(219), row + 1, col + 1, clr
		Next
	Next
End Sub

'Centers text on the screen.
Sub CenterText (row As Integer, txt As String, fclr As UInteger)
	Dim As Integer col
	

	col = (tcols \ 2) - (Len(txt) \ 2)
	PutText txt, row, col, fclr  
End Sub

'Splits text InS at sLen and returns clipped string.
Function WordWrap(InS As String, sLen As Integer) As String
    dim as integer i = sLen, sl
    dim as Integer BackFlag = False
    dim as string sret, ch
    
    'Make sure we have something to work with here.
    sl = len(InS)
    if sl <= sLen then
        sret = InS
        InS = ""
    Else
    		'Find the break point in the string, backtracking
    		'to find a space to break the line at if not at a space.
        do
            'Break is at space, so done.
            ch = Mid(InS, i, 1)
            if ch = chr(32) then
                exit do
            end If
            'If not backtracking, start backtrack.
            if BackFlag = False then
                If i + 1 <= sl then
                    i+= 1
                end if
                BackFlag = True
            else
                i -= 1
            end if
        loop until i = 0 or ch = chr(32) 'Backtrack to space.
        'Make sure we still have something to work with.
        if i > 0 Then
        		'Return clipped string.
            sret = mid(InS, 1, i)
            'Modify the input string: string less clipped.
            InS = mid(InS, i + 1)
        else
            sret = ""
        end if 
    end if
    return sret
End Function

'Draws the intro text on the screen.
Sub DrawIntroText
	Dim As String txt, ttxt
	Dim As Integer row, col
	Dim As UInteger clr
	
	'Draw the window background.
	DrawBackground
	For col = 0 To tcols - 1
		For row = 0 To trows - 1
			'Draw background first.
			clr = backgrnd(col + row * backgrndw)
			clr = AlphaBlend(128, clr, fbBlack)
			PutText Chr(219), row + 1, col + 1, clr
		Next
	Next
	col = 2
	row = 2
	CenterText row, "Escape from Lab 42", fbWhite 
	txt = "You wake up in the Medlab, wondering for a moment where you are. The muffled sounds of an alarm "
	txt &= "penetrate your isolation room--and slowly you remember..."
	row += 2
	Do
		ttxt = WordWrap(txt, 78)
		PutText ttxt, row, col, fbWhite
		row += 1
	Loop Until Len(txt) = 0
	txt = "You were working on Level " & maxlevel & " of Lab 42, the site of the secret government research project "
	txt &= "to reanimate the dead. The thought still sends shivers down your spine. Reanimate the dead "
	txt &= "and use them as soldiers in the escalating global war. A war going badly for your side. "
	txt &= "A desperate plan, hatched by desperate men searching for a way to solve a desperate situation. "
	txt &= "But something went terribly wrong."
	row += 1
	Do
		ttxt = WordWrap(txt, 78)
		PutText ttxt, row, col, fbWhite
		row += 1
	Loop Until Len(txt) = 0
	txt = "You were moving a new batch of reanimates, (Zombies is what you and others called them) to the "
	txt &= "test lab when one broke free and bit you. You were rushed into the isolation chamber, given "
	txt &= "the antivirus and put under sedation. That is the last you remember, until now. The muffled "
	txt &= "alarm suddenly silences and you hear the sexy voice of the main computer."
	row += 1
	Do
		ttxt = WordWrap(txt, 78)
		PutText ttxt, row, col, fbWhite
		row += 1
	Loop Until Len(txt) = 0
	txt = Chr(34) & "Self-destruct sequence activated. Self-destruct in 60 minutes." & Chr(34) & " "
	txt &= "You are suddenly wide awake. The reanimate virus must have been let loose in the lab. You "
	txt &= "throw on your clothes, grab your .45 pistol and get ready to head for the exit, when you "
	txt &= "stop as the computer continues." 	  
	row += 1
	Do
		ttxt = WordWrap(txt, 78)
		PutText ttxt, row, col, fbWhite
		row += 1
	Loop Until Len(txt) = 0
	txt = Chr(34) & "All level elevators have been locked down to prevent spread of contamination." & Chr(34) & " "
	txt &= "So, things are much more complicated. You need to get the override codes for each elevator "
	txt &= "before you can ascend to the next level. Damn! You take comfort in the fact that at least "
	txt &= "if you are bitten, you won't become a Zombie, although you can still die. Stay here and die, "
	txt &= "or try to escape and possibly die at the hands of some damn Zombie. Hell, you would rather die fighting."
	row += 1
	Do
		ttxt = WordWrap(txt, 78)
		PutText ttxt, row, col, fbWhite
		row += 1
	Loop Until Len(txt) = 0
	txt = "You make sure the safety is off on your .45 and head toward the door. You have " & maxtime & " minutes to "
	txt &= "escape from Lab 42."	 
	row += 1
	Do
		ttxt = WordWrap(txt, 78)
		PutText ttxt, row, col, fbWhite
		row += 1
	Loop Until Len(txt) = 0
	Flip
	Sleep
	Do
		Sleep 1
	Loop Until InKey = ""
End Sub

'Adds a message to the mes variable.
Sub AddMessage (txt As String)
	Dim As Integer i
	
	If Len(txt) > 0 Then
		'Move message down 1 slot.
		For i = 4 To 2 Step -1
			mess(i) = mess(i - 1)
		Next
		'Add new message.
		mess(LBound(mess)) = txt
	End If
End Sub

'Shows dead screen.
Sub DoDead
	Dim As Integer x, y, clr
	
	For x = 0 To tcols - 1
		For y = 0 To trows - 1
			clr = mush(x + y * mushw)
			PutText Chr(219), y + 1, x + 1, clr
		Next
	Next
	CenterText trows - 1, "You didn't make it out, but at least the outbreak was contained...",fbWhite
	Flip
	Sleep		
End Sub

'Shows win screen.
Sub DoWin
	Dim As Integer x, y, clr
	
	For x = 0 To tcols - 1
		For y = 0 To trows - 1
			clr = pescape(x + y * pescapew)
			PutText Chr(219), y + 1, x + 1, clr
		Next
	Next
	CenterText trows - 1, "You made it out! Thank goodness the outbreak was contained...",fbWhite
	Flip
	Sleep		
End Sub

'Returns a description string for an item.
Function GetInvDescString(inv As invtype) As String
	Dim As String txt, atxt
	
	If inv.hasitem = FALSE Then
		txt = "None"
	Else
		If inv.classid = iWeapon Then
			If inv.weapon.Item = wLocator Then
				txt = "Locator"
			EndIf
			If inv.weapon.Item = wPistol Then
				txt = ".45 Pistol (" & inv.weapon.Ammocnt & ")"
			EndIf
			If inv.weapon.Item = wShotgun Then
				txt = "Shotgun(" & inv.weapon.Ammocnt & ")"
			EndIf
			If inv.weapon.Item = wPipe Then
				txt = "Pipe"
			EndIf
			If inv.weapon.Item = wHammer Then
				txt = "2lbs. Sledge"
			EndIf
		ElseIf inv.classid = iAmmo Then
			If inv.ammo.Item = aClip Then
				txt = ".45 clip (" & inv.ammo.cnt & ")" 
			EndIf
			If inv.ammo.Item = aShells Then
				txt = "Shells (" & inv.ammo.cnt & ")" 
			EndIf
		ElseIf inv.classid = iArmor Then
			If inv.armor.item = arCloth Then
				txt = "Cloth (" & inv.armor.amt & ")"
			EndIf
			If inv.armor.item = arLeather Then
				txt = "Leather (" & inv.armor.amt & ")" 
			EndIf
			If inv.armor.item = arKevlar Then
				txt = "Kevlar (" & inv.armor.amt & ")" 
			EndIf
			If inv.armor.item = arKevPlate Then
				txt = "Kev/Plate (" & inv.armor.amt & ")" 
			EndIf
			'Get type of armor.
			If inv.armor.location = pHead Then
				If inv.armor.item = arCloth Then
					txt &= " Cap"
				Else
					txt &= " Helmet"
				EndIf
			ElseIf inv.armor.location = pBody Then
				If inv.armor.item = arCloth Then
					txt &= " Shirt"
				Else
					txt &= " Vest"
				EndIf
			ElseIf inv.armor.location = pLArm Then
				txt &= " L Arm"
			ElseIf inv.armor.location = pRArm Then
				txt &= " R Arm"
			ElseIf inv.armor.location = pLHand Then
				txt &= " L Hand"
			ElseIf inv.armor.location = pRHand Then
				txt &= " R Hand"
			ElseIf inv.armor.location = pLLeg Then
					txt &= " L Leg"
			ElseIf inv.armor.location = pRLeg Then
					txt &= " R Leg"
			ElseIf inv.armor.location = pLFoot Then
					txt &= " L Foot"
			ElseIf inv.armor.location = pRFoot Then
					txt &= " R Foot"
			EndIf
		ElseIf inv.classid = iCode Then
			txt = "Access code" 
		ElseIf inv.classid = iHealth Then
			If inv.health.item = hStimpack Then
				txt = "Stimpack (" & inv.health.hltamt & ")" 
			EndIf
			If inv.health.item = hMedpack Then
				txt = "Medpack (" & inv.health.hltamt & ")" 
			EndIf
		EndIf
	EndIf
	
	Return txt
End Function

'Prints out morgue file.
Sub PrintMorgue
	Dim As Integer i, numguards, numcivs, plevel, row = 1, fh
	Dim As Double stime, etime, ltime
	Dim As String txt, txti, fname = "efl42_" & Format(Now, "mmddyyyy") & "_" & Format(Now, "hhmmss") & ".txt"
	Dim As String resp = "yn", ch
		
	Cls
	PutText "Escape From Lab 42 Version " & lbversion & " (" & Format(Now, "mm-dd-yyyy hh:mm:ss") & ")", row, 1, fbWhite
	row += 2
	If level.levelinfo.morgue.win = TRUE Then
		PutText "You made it out!", row, 1, fbWhite
	EndIf
	If level.levelinfo.morgue.dead = TRUE Then
		PutText "You died on level " & level.levelinfo.mlevel & ".", row, 1, fbWhite
	EndIf
	row += 1
	PutText "Time remaining: " & level.levelinfo.morgue.timeleft, row, 1, fbWhite
	
	row += 2
	PutText "Ending Inventory ", row, 1, fbWhite
	row += 1
	PutText "Left Hand: " & GetInvDescString(player.wlhand), row, 1, fbWhite
	row += 1
	PutText "Right Hand: " & GetInvDescString(player.wrhand), row, 1, fbWhite
	row += 1
	PutText "Head: " & GetInvDescString(player.aHead), row, 1, fbWhite
	row += 1
	PutText "Body: " & GetInvDescString(player.aBody), row, 1, fbWhite
	row += 1
	PutText "Left Arm: " & GetInvDescString(player.aLArm), row, 1, fbWhite
	row += 1
	PutText "Right Arm: " & GetInvDescString(player.aRArm), row, 1, fbWhite
	row += 1
	PutText "Left Hand: " & GetInvDescString(player.aLHand), row, 1, fbWhite
	row += 1
	PutText "Right Hand: " & GetInvDescString(player.aRHand), row, 1, fbWhite
	row += 1
	PutText "Left Leg: " & GetInvDescString(player.aLLeg), row, 1, fbWhite
	row += 1
	PutText "Right Leg: " & GetInvDescString(player.aRLeg), row, 1, fbWhite
	row += 1
	PutText "Left Foot: " & GetInvDescString(player.aLFoot), row, 1, fbWhite
	row += 1
	PutText "Right Foot: " & GetInvDescString(player.aRFoot), row, 1, fbWhite
	row += 1
	PutText "Slot 1: " & GetInvDescString(player.inventory(1)), row, 1, fbWhite
	row += 1
	PutText "Slot 2: " & GetInvDescString(player.inventory(2)), row, 1, fbWhite
	row += 1
	PutText "Slot 3: " & GetInvDescString(player.inventory(3)), row, 1, fbWhite
	row += 1
	PutText "Slot 4: " & GetInvDescString(player.inventory(4)), row, 1, fbWhite
	row += 1
	
	
	row += 2
	txt = "Level" & Space(3) & "Guard Killed" & Space(3) & "Civis Killed" & Space(3) & "Start Time" & Space(3) & "End time" & Space(3) & "Total Time"
	PutText txt, row, 1, fbWhite
	row += 2  
	For i = maxlevel To level.levelinfo.mlevel Step -1
		txti= "" & i
		If Len(txti) < 2 Then
			txti = "0" & txti
		EndIf
		
		txt = txti & Space(9 - Len(txti))
		txti = "" & level.levelinfo.morgue.numguards(i)
		txt &= txti & Space(15 - Len(txti))
		txti = "" & level.levelinfo.morgue.numcivis(i)
		txt &= txti & Space(15 - Len(txti))
		txti = "" & Format(level.levelinfo.morgue.lstart(i), "hh:mm:ss")
		txt &= txti & Space(13 - Len(txti))
		txti = "" & Format(level.levelinfo.morgue.lend(i), "hh:mm:ss")
		txt &= txti & Space(11 - Len(txti))
		stime = level.levelinfo.morgue.lstart(i)
		etime = level.levelinfo.morgue.lend(i)
		ltime = DateDiff("n", stime, etime)
		txti = "" & Format(ltime, "###") & " min" 
		txt & = txti
		PutText txt, row, 1, fbWhite
		row += 1
	Next
	row += 1
	PutText "Save file to " & fname & "? (y/n)", row, 1, fbWhite
	Flip
	Do
		ch = InKey
		ch = LCase(ch)
		Sleep 1
	Loop Until InStr(resp, ch) > 0
	
	If ch = "y" Then
	
		fh = FreeFile
		Open fname For Output As #fh
		Print #fh, "Escape From Lab 42 Version " & lbversion
		If level.levelinfo.morgue.win = TRUE Then
			Print #fh, "You made it out!"
		EndIf
		If level.levelinfo.morgue.dead = TRUE Then
			Print #fh, "You died on level " & level.levelinfo.mlevel & "."
		EndIf
		Print #fh, "Time remaining: " & level.levelinfo.morgue.timeleft
		Print #fh, ""
	
		Print #fh, "Ending Inventory "
		Print #fh, ""
		Print #fh, "Left Hand: " & GetInvDescString(player.wlhand)
		Print #fh, "Right Hand: " & GetInvDescString(player.wrhand)
		Print #fh, "Head: " & GetInvDescString(player.aHead)
		Print #fh, "Body: " & GetInvDescString(player.aBody)
		Print #fh, "Left Arm: " & GetInvDescString(player.aLArm)
		Print #fh, "Right Arm: " & GetInvDescString(player.aRArm)
		Print #fh, "Left Hand: " & GetInvDescString(player.aLHand)
		Print #fh, "Right Hand: " & GetInvDescString(player.aRHand)
		Print #fh, "Left Leg: " & GetInvDescString(player.aLLeg)
		Print #fh, "Right Leg: " & GetInvDescString(player.aRLeg)
		Print #fh, "Left Foot: " & GetInvDescString(player.aLFoot)
		Print #fh, "Right Foot: " & GetInvDescString(player.aRFoot)
		Print #fh, "Slot 1: " & GetInvDescString(player.inventory(1))
		Print #fh, "Slot 2: " & GetInvDescString(player.inventory(2))
		Print #fh, "Slot 3: " & GetInvDescString(player.inventory(3))
		Print #fh, "Slot 4: " & GetInvDescString(player.inventory(4))
	
		Print #fh, ""
		txt = "Level" & Space(3) & "Guard Killed" & Space(3) & "Civis Killed" & Space(3) & "Start Time" & Space(3) & "End time" & Space(3) & "Total Time"
		Print #fh, txt
		Print #fh, ""  
		For i = maxlevel To level.levelinfo.mlevel Step -1
			txti= "" & i
			If Len(txti) < 2 Then
				txti = "0" & txti
			EndIf
			
			txt = txti & Space(9 - Len(txti))
			txti = "" & level.levelinfo.morgue.numguards(i)
			txt &= txti & Space(15 - Len(txti))
			txti = "" & level.levelinfo.morgue.numcivis(i)
			txt &= txti & Space(15 - Len(txti))
			txti = "" & Format(level.levelinfo.morgue.lstart(i), "hh:mm:ss")
			txt &= txti & Space(13 - Len(txti))
			txti = "" & Format(level.levelinfo.morgue.lend(i), "hh:mm:ss")
			txt &= txti & Space(11 - Len(txti))
			stime = level.levelinfo.morgue.lstart(i)
			etime = level.levelinfo.morgue.lend(i)
			ltime = DateDiff("n", stime, etime)
			txti = "" & Format(ltime, "###") & " min" 
			txt & = txti
			Print #fh, txt
		Next
		Close
	End If		
End Sub

'Shows win screen.
Sub DoFinalZombie
	Dim As Integer x, y, clr, clrf, cnt
	Dim As Single mt
	
	Do
		Sleep 1
	Loop While InKey <> ""
	
	For x = 0 To tcols - 1
		For y = 0 To trows - 1
			clr = fzombie(x + y * fzombiew)
			PutText Chr(219), y + 1, x + 1, clr
		Next
	Next
	CenterText trows - 1, "Or was it?",fbWhite
	Flip
	Delay(2)
	
	'Fade out zombie pic	
	For cnt = 255 To 0 Step -1
		mt = Timer
		For x = 0 To tcols - 1
			For y = 0 To trows - 1
				clrf = fzombie(x + y * fzombiew)
				clr = AlphaBlend(cnt, clrf, fbBlack)
				PutText Chr(219), y + 1, x + 1, clr
				If inkey<>"" then GoTo lbTitle 
			Next
		Next
		Flip
		SetFPS(mt)
	Next
lbTitle:
	Do
		Sleep 1
	Loop While InKey <> ""
	Cls
	'fade in title
	For cnt = 0 To 255
		mt = Timer
		For x = 0 To tcols - 1
			For y = 0 To trows - 1
				'Draw font.
				clrf = title(x + y * titlew)
				If clrf <> &hFF000000 Then
					clr = AlphaBlend(cnt, clrf, fbBlack)
					PutText Chr(219), y + 1, x + 1, clr
					If inkey<>"" then GoTo getout
				EndIf
			Next 
		Next
		Flip
		SetFPS(mt)
	Next
	CenterText trows - 2, "7DRL 2009 Competition Entry",fbWhite
	CenterText trows - 1, "Richard D. Clark",fbWhite
	Flip
	Delay(2)
getout:
	PrintMorgue
End Sub

