'Yet another Master Mind clone
'Copyright (c) 2005 Richard D. Clark
'Released under the GPL License
'====================================================================
'The computer will always solve the puzzle in five or less
'attempts. The computer solve table was written by Toby Nelson
'who has a nice website dedicated to MasterMind: www.tnelson.demon.co.uk.
'A black decode marker means you have the right color in the right spot
'A white marker means you have the right color in wrong spot
'N to start a new game. Enter secret code, then enter in guesses.
'You can (Q)uit any time. Press any key during intro to exit.
'====================================================================

option explicit

const TRUE = 1
const FALSE = 0
const Red = RGB(252, 2, 4)
const Green = RGB(4, 254, 4)
const Blue = RGB(4, 2, 252)
const LtBlue = RGB(0, 128, 255)
const Yellow = RGB(252, 254, 4)
const White = RGB(255, 255, 255)
const DkCyan = RGB(143, 165, 163)
const DkGrey = RGB(128, 128, 128)
const LtGrey = RGB(192, 192, 192)
const Black = RGB(0, 0, 0)
const playerturn = 0
const computerturn = not playerturn

'color picks
enum cpicks
   pred = 1
   pblue
   pgreen
   pyellow
   pblack
   pwhite
end enum

'box types
enum boxtype
   singleline = 1
   doubleline
end enum

'row ids
enum rowid
   row1 = 1
   row2 
   row3 
   row4 
   row5 
   row6 
end enum

'this will hold the current color code and next lookup
'in the computer solve table
type solveinfo
   colorinfo as string * 4
   markers as integer
end type

declare sub LoadSolveTable
declare sub Intro
declare sub DrawPeg(pcolor as integer, x as integer, y as integer)
declare sub InitGame
declare sub DrawBox (bcolor as integer, x as integer, y as integer, bwidth as integer, bheight as integer, btype as integer)
declare sub DrawRow(rownum as integer, ccode as string, ptype as integer)
declare sub DrawDecode(rownum as integer, ccode as string, ptype as integer)
declare sub GetSecrets
declare sub CenterText(tRow as integer, txt as string)
declare function GetRandom(low as integer, high as integer) as integer
declare sub GetPlayerMove(secret as integer = false)
declare function GetColorCode(ccn as integer) as string
declare sub DrawCurrent(dcolor as integer)
declare function GetRowY(rownum as integer) as integer
declare sub GetComputerSecret
declare sub GetComputerMove
declare sub PlayerDecode
declare sub ComputerDecode
declare function GetMarkers(scode as string) as integer

dim shared solvetable(5, 1275) as solveinfo 'computer solve table
dim shared csolve(1 to 5) as solveinfo 'computer solve chain
dim shared currow as integer 'the current row being played
dim shared prowcode as string 'the current row code info, ie., BYWG
dim shared crowcode as string
dim shared psecret as string 'player secret code
dim shared csecret as string 'comp secret code
dim shared currentturn as integer 
dim shared inGame as integer
dim shared pwin as integer
dim shared cwin as integer
dim shared showsecret as integer
dim skey as string

'using two buffers so we can save screen
'when user requests help
screen 17, 32
width 80, 25
WindowTitle "Master Code Breaker"
randomize timer

'load the computer solve table
LoadSolveTable
'Show the intro
Intro
'Initializes the board layout
InitGame
'turn on mouse
setmouse ,,1
inGame = False
showsecret = False
'process loop
do
      skey = ucase$(inkey$)
      if skey = chr$(255) + "X" then skey = "Q"
      if skey = chr$(27) then skey = "Q"
      'Shows computer secret code
      if skey = "S" then
         showsecret = True
      end if
      if skey = "N" then
         inGame = True
         InitGame
         GetComputerSecret
         GetPlayerMove True
      end if
      if inGame = True then
         if currentturn = playerturn then
            GetPlayerMove
            currentturn = not currentturn
         else
            GetComputerMove
            'decode guesses
            PlayerDecode
            ComputerDecode
            if cwin = True or pwin = True then
               DrawRow Row6, psecret, playerturn
               DrawRow Row6, csecret, computerturn
               'print out winner or tie
               inGame = False
               color White, LtBlue
               locate 24, 1
               if cwin = True and pwin = False then
                  print "The computer won this game!"
               elseif cwin = False and pwin = True then
                  print "You won this game!"
               else
                  print "This game is a tie!"
               end if
            else
               currentturn = not currentturn
               currow = currow + 1
               if currow > row5 then
                  inGame = False
                  DrawRow Row6, psecret, playerturn
                  DrawRow Row6, csecret, computerturn
                  color White, LtBlue
                  locate 24, 1
                  print "No winners in this game!"
               end if
            end if
         end if
      end if
loop while skey <> "Q" and skey <> chr$(255) + "X" 
end

sub InitGame
   dim y as integer
   dim colorcode as string
   dim i as integer

   'draw the menu
   color White, Black
   cls
   color White, LtBlue
   locate 1, 1
   print space$(80)
   locate 1, 2
   color Yellow, LtBlue
   print "N";
   color White, LtBlue
   print "ew Game  ";
   color Yellow, LtBlue
   print "Q";
   color White, LtBlue
   print "uit Game";
   color Yellow, LtBlue
   locate 1, 79 - len("Master Code Breaker")
   print "Master Code Breaker"
   color White, LtBlue
   locate 24, 1:print space$(80);
   locate 25, 1:print space$(80);
   locate 25, 79 - len("V.1.0")
   print "V.1.0";
   'draw the available color picks
   color White, Black
   locate 3, 3
   print "Colors"
   DrawBox Yellow, 4, 2, 18, 8, doubleline
   y = 5
   color White, Black
   locate y, 3
   print "1 - "
   DrawPeg Red, y, 5
   y = y + 3
   color White, Black
   locate y, 3
   print "2 - "
   DrawPeg Blue, y, 5
   y = y + 3
   color White, Black
   locate y, 3
   print "3 - "
   DrawPeg Green, y, 5
   y = y + 3
   color White, Black
   locate y, 3
   print "4 - "
   DrawPeg Yellow, y, 5
   y = y + 3
   color White, Black
   locate y, 3
   print "5 - "
   DrawPeg DkGrey, y, 5
   y = y + 3
   color White, Black
   locate y, 3
   print "6 - "
   DrawPeg White, y, 5
   'draw the player board
   color White, Black
   locate 3, 15
   print "Player"
   DrawBox Yellow, 4, 12, 3, 13, singleline
   'draw the code slots
   colorcode = "XXXX"
   for i = Row6 to Row1 step -1
      DrawRow i, colorcode, playerturn
   next
   'draw the player decode
   DrawBox Yellow, 7, 27, 15, 13, singleline
   color White, Black
   locate 6, 27: print "Player Intel"
   for i = Row5 to Row1 step -1
      DrawDecode i, colorcode, playerturn
   next
   'draw the computer board
   color White, Black
   locate 3, 46
   print "Computer"
   DrawBox Yellow, 4, 44, 3, 13, singleline
   'draw the code slots
   colorcode = "XXXX"
   for i = Row6 to Row1 step -1
      DrawRow i, colorcode, computerturn
   next
   'draw the computer decode
   DrawBox Yellow, 7, 59, 15, 13, singleline
   color White, Black
   locate 6, 60: print "Comp Intel"
   for i = Row5 to Row1 step -1
      DrawDecode i, colorcode, computerturn
   next
   pwin = False
   cwin = False
   ingame = True
   currow = row1
   currentturn = playerturn 'player starts
end sub

'Computer solve table.
'The format is color attempt, marker result.
'soln means that the puzzle is solved.
solvedata:
'    0          1          2           3          4
DATA "BBCC","0","GGRY","0","WWWW","soln"
DATA "BBCC","0","GGRY","1","WWRW","2","YYYW","soln"
DATA "BBCC","0","GGRY","1","WWRW","3","RRWR","soln"
DATA "BBCC","0","GGRY","1","WWRW","4","YYWW","soln"
DATA "BBCC","0","GGRY","1","WWRW","5","BYBB","1","YWYW","soln"
DATA "BBCC","0","GGRY","1","WWRW","5","BYBB","2","WYYW","soln"
DATA "BBCC","0","GGRY","1","WWRW","7","BRBW","3","RWWR","soln"
DATA "BBCC","0","GGRY","1","WWRW","7","BRBW","4","WRWR","soln"
DATA "BBCC","0","GGRY","1","WWRW","7","BRBW","5","RRWW","soln"
DATA "BBCC","0","GGRY","1","WWRW","8","BYBB","0","WWWG","soln"
DATA "BBCC","0","GGRY","1","WWRW","8","BYBB","1","YWWW","soln"
DATA "BBCC","0","GGRY","1","WWRW","8","BYBB","2","WYWW","soln"
DATA "BBCC","0","GGRY","1","WWRW","9","BBBG","0","WWYW","soln"
DATA "BBCC","0","GGRY","1","WWRW","9","BBBG","1","WWGW","soln"
DATA "BBCC","0","GGRY","1","WWRW","12","BRBW","3","WWWR","soln"
DATA "BBCC","0","GGRY","1","WWRW","12","BRBW","4","RWWW","soln"
DATA "BBCC","0","GGRY","1","WWRW","12","BRBW","5","WRWW","soln"
DATA "BBCC","0","GGRY","2","GWYW","0","RRRR","soln"
DATA "BBCC","0","GGRY","2","GWYW","1","WRRR","soln"
DATA "BBCC","0","GGRY","2","GWYW","2","BBBR","0","YYYY","soln"
DATA "BBCC","0","GGRY","2","GWYW","2","BBBR","1","RRRW","soln"
DATA "BBCC","0","GGRY","2","GWYW","2","BBBR","2","RWRR","soln"
DATA "BBCC","0","GGRY","2","GWYW","3","YYWY","soln"
DATA "BBCC","0","GGRY","2","GWYW","4","BBBR","0","WYYY","soln"
DATA "BBCC","0","GGRY","2","GWYW","4","BBBR","1","WRRW","soln"
DATA "BBCC","0","GGRY","2","GWYW","4","BBBR","2","WWRR","soln"
DATA "BBCC","0","GGRY","2","GWYW","5","BBRR","0","YWYY","soln"
DATA "BBCC","0","GGRY","2","GWYW","5","BBRR","2","WWRW","soln"
DATA "BBCC","0","GGRY","2","GWYW","5","BBRR","4","RWRW","soln"
DATA "BBCC","0","GGRY","2","GWYW","6","WYWY","soln"
DATA "BBCC","0","GGRY","2","GWYW","7","BBYY","0","WGWW","soln"
DATA "BBCC","0","GGRY","2","GWYW","7","BBYY","2","WWWY","soln"
DATA "BBCC","0","GGRY","2","GWYW","7","BBYY","4","YWWY","soln"
DATA "BBCC","0","GGRY","2","GWYW","8","WWYY","soln"
DATA "BBCC","0","GGRY","2","GWYW","9","GWWW","soln"
DATA "BBCC","0","GGRY","3","WWGR","1","YYYG","soln"
DATA "BBCC","0","GGRY","3","WWGR","2","BRRR","2","YYYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","2","BRRR","4","RYYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","2","BRRR","5","YRYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","2","BRRR","8","RRYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","3","BRBR","0","YYWG","soln"
DATA "BBCC","0","GGRY","3","WWGR","3","BRBR","1","RYYW","soln"
DATA "BBCC","0","GGRY","3","WWGR","3","BRBR","2","YRYW","soln"
DATA "BBCC","0","GGRY","3","WWGR","3","BRBR","4","RRYW","soln"
DATA "BBCC","0","GGRY","3","WWGR","4","BYGY","1","YRWR","soln"
DATA "BBCC","0","GGRY","3","WWGR","4","BYGY","2","RYWR","soln"
DATA "BBCC","0","GGRY","3","WWGR","4","BYGY","4","YYWR","soln"
DATA "BBCC","0","GGRY","3","WWGR","4","BYGY","6","YWYG","soln"
DATA "BBCC","0","GGRY","3","WWGR","4","BYGY","7","WYYG","soln"
DATA "BBCC","0","GGRY","3","WWGR","4","BYGY","8","YYGW","soln"
DATA "BBCC","0","GGRY","3","WWGR","5","BWYY","0","RRGR","soln"
DATA "BBCC","0","GGRY","3","WWGR","5","BWYY","4","WRYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","5","BWYY","5","RWYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","5","BWYY","7","WYYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","5","BWYY","8","YWYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","6","BRBG","1","RYWW","soln"
DATA "BBCC","0","GGRY","3","WWGR","6","BRBG","2","YRWW","soln"
DATA "BBCC","0","GGRY","3","WWGR","6","BRBG","5","RRWG","soln"
DATA "BBCC","0","GGRY","3","WWGR","7","BWBG","1","WRYW","soln"
DATA "BBCC","0","GGRY","3","WWGR","7","BWBG","2","RWYW","soln"
DATA "BBCC","0","GGRY","3","WWGR","7","BWBG","3","RRGW","soln"
DATA "BBCC","0","GGRY","3","WWGR","7","BWBG","4","WYWG","soln"
DATA "BBCC","0","GGRY","3","WWGR","7","BWBG","5","YWWG","soln"
DATA "BBCC","0","GGRY","3","WWGR","8","BYGB","1","YWWR","soln"
DATA "BBCC","0","GGRY","3","WWGR","8","BYGB","2","WYWR","soln"
DATA "BBCC","0","GGRY","3","WWGR","8","BYGB","3","WWYG","soln"
DATA "BBCC","0","GGRY","3","WWGR","8","BYGB","4","YWGW","soln"
DATA "BBCC","0","GGRY","3","WWGR","8","BYGB","5","WYGW","soln"
DATA "BBCC","0","GGRY","3","WWGR","9","BRBG","1","WWYR","soln"
DATA "BBCC","0","GGRY","3","WWGR","9","BRBG","2","WWGG","soln"
DATA "BBCC","0","GGRY","3","WWGR","9","BRBG","3","RWGR","soln"
DATA "BBCC","0","GGRY","3","WWGR","9","BRBG","4","WRGR","soln"
DATA "BBCC","0","GGRY","3","WWGR","11","BRBB","1","RWWG","soln"
DATA "BBCC","0","GGRY","3","WWGR","11","BRBB","2","WRWG","soln"
DATA "BBCC","0","GGRY","3","WWGR","12","BRBB","1","RWGW","soln"
DATA "BBCC","0","GGRY","3","WWGR","12","BRBB","2","WRGW","soln"
DATA "BBCC","0","GGRY","4","GGWW","0","BRRR","1","RYYY","soln"
DATA "BBCC","0","GGRY","4","GGWW","0","BRRR","2","YRYY","soln"
DATA "BBCC","0","GGRY","4","GGWW","0","BRRR","4","RRYY","soln"
DATA "BBCC","0","GGRY","4","GGWW","0","BRRR","5","YYRR","soln"
DATA "BBCC","0","GGRY","4","GGWW","0","BRRR","8","RYRR","soln"
DATA "BBCC","0","GGRY","4","GGWW","0","BRRR","9","YRRR","soln"
DATA "BBCC","0","GGRY","4","GGWW","1","GWRR","1","YYGY","soln"
DATA "BBCC","0","GGRY","4","GGWW","1","GWRR","3","WRYY","soln"
DATA "BBCC","0","GGRY","4","GGWW","1","GWRR","4","RWYY","soln"
DATA "BBCC","0","GGRY","4","GGWW","1","GWRR","7","RRRG","soln"
DATA "BBCC","0","GGRY","4","GGWW","1","GWRR","8","WYRR","soln"
DATA "BBCC","0","GGRY","4","GGWW","1","GWRR","9","YWRR","soln"
DATA "BBCC","0","GGRY","4","GGWW","2","BRRW","3","RYWY","soln"
DATA "BBCC","0","GGRY","4","GGWW","2","BRRW","4","YRWY","soln"
DATA "BBCC","0","GGRY","4","GGWW","2","BRRW","5","YYRW","soln"
DATA "BBCC","0","GGRY","4","GGWW","2","BRRW","7","RRWY","soln"
DATA "BBCC","0","GGRY","4","GGWW","2","BRRW","8","RYRW","soln"
DATA "BBCC","0","GGRY","4","GGWW","2","BRRW","9","YRRW","soln"
DATA "BBCC","0","GGRY","4","GGWW","3","BWBR","1","WYGY","soln"
DATA "BBCC","0","GGRY","4","GGWW","3","BWBR","2","YWGY","soln"
DATA "BBCC","0","GGRY","4","GGWW","3","BWBR","3","WRRG","soln"
DATA "BBCC","0","GGRY","4","GGWW","3","BWBR","4","RWRG","soln"
DATA "BBCC","0","GGRY","4","GGWW","4","BWRW","6","WRWY","soln"
DATA "BBCC","0","GGRY","4","GGWW","4","BWRW","7","RWWY","soln"
DATA "BBCC","0","GGRY","4","GGWW","4","BWRW","8","WYRW","soln"
DATA "BBCC","0","GGRY","4","GGWW","4","BWRW","9","YWRW","soln"
DATA "BBCC","0","GGRY","4","GGWW","5","BGBR","1","GYYW","soln"
DATA "BBCC","0","GGRY","4","GGWW","5","BGBR","2","YGYW","soln"
DATA "BBCC","0","GGRY","4","GGWW","5","BGBR","4","GRWR","soln"
DATA "BBCC","0","GGRY","4","GGWW","5","BGBR","5","RGWR","soln"
DATA "BBCC","0","GGRY","4","GGWW","6","BBBG","1","WWGY","soln"
DATA "BBCC","0","GGRY","4","GGWW","6","BBBG","2","WWRG","soln"
DATA "BBCC","0","GGRY","4","GGWW","7","BGBB","1","GWGG","soln"
DATA "BBCC","0","GGRY","4","GGWW","7","BGBB","2","WGGG","soln"
DATA "BBCC","0","GGRY","4","GGWW","8","BGBR","1","GWYW","soln"
DATA "BBCC","0","GGRY","4","GGWW","8","BGBR","2","WGYW","soln"
DATA "BBCC","0","GGRY","4","GGWW","8","BGBR","4","GWWR","soln"
DATA "BBCC","0","GGRY","4","GGWW","8","BGBR","5","WGWR","soln"
DATA "BBCC","0","GGRY","4","GGWW","9","BGBR","1","GYWW","soln"
DATA "BBCC","0","GGRY","4","GGWW","9","BGBR","2","YGWW","soln"
DATA "BBCC","0","GGRY","4","GGWW","9","BGBR","3","GRWW","soln"
DATA "BBCC","0","GGRY","4","GGWW","9","BGBR","4","RGWW","soln"
DATA "BBCC","0","GGRY","4","GGWW","12","BGGW","6","GWWG","soln"
DATA "BBCC","0","GGRY","4","GGWW","12","BGGW","7","WGWG","soln"
DATA "BBCC","0","GGRY","4","GGWW","12","BGGW","8","GWGW","soln"
DATA "BBCC","0","GGRY","4","GGWW","12","BGGW","9","WGGW","soln"
DATA "BBCC","0","GGRY","5","GWGW","0","BRRR","2","YYRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","0","BRRR","4","RYRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","0","BRRR","5","YRRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","0","BRRR","8","RRRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","1","BBRR","0","YGYY","soln"
DATA "BBCC","0","GGRY","5","GWGW","1","BBRR","2","WYRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","1","BBRR","4","WRRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","1","BBRR","5","RGRR","soln"
DATA "BBCC","0","GGRY","5","GWGW","2","BBRR","0","GYYY","soln"
DATA "BBCC","0","GGRY","5","GWGW","2","BBRR","2","YWRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","2","BBRR","4","RWRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","2","BBRR","5","GRRR","soln"
DATA "BBCC","0","GGRY","5","GWGW","3","BBYB","0","WGRR","soln"
DATA "BBCC","0","GGRY","5","GWGW","3","BBYB","1","YGWY","soln"
DATA "BBCC","0","GGRY","5","GWGW","3","BBYB","2","WGYY","soln"
DATA "BBCC","0","GGRY","5","GWGW","4","BBGY","1","RGRW","soln"
DATA "BBCC","0","GGRY","5","GWGW","4","BBGY","2","WWRY","soln"
DATA "BBCC","0","GGRY","5","GWGW","4","BBGY","4","GYWY","soln"
DATA "BBCC","0","GGRY","5","GWGW","5","BBGR","1","GWYY","soln"
DATA "BBCC","0","GGRY","5","GWGW","5","BBGR","2","GGGG","soln"
DATA "BBCC","0","GGRY","5","GWGW","5","BBGR","3","GRRW","soln"
DATA "BBCC","0","GGRY","5","GWGW","5","BBGR","4","GWRR","soln"
DATA "BBCC","0","GGRY","5","GWGW","6","WGWY","soln"
DATA "BBCC","0","GGRY","5","GWGW","7","BBBG","1","WGRW","soln"
DATA "BBCC","0","GGRY","5","GWGW","7","BBBG","2","GGWG","soln"
DATA "BBCC","0","GGRY","5","GWGW","8","GWWY","soln"
DATA "BBCC","0","GGRY","5","GWGW","9","BBBR","0","GGGW","soln"
DATA "BBCC","0","GGRY","5","GWGW","9","BBBR","1","GWRW","soln"
DATA "BBCC","0","GGRY","5","GWGW","12","GGWW","soln"
DATA "BBCC","0","GGRY","6","RWYG","4","YYGG","soln"
DATA "BBCC","0","GGRY","6","RWYG","5","RRGG","soln"
DATA "BBCC","0","GGRY","6","RWYG","6","BBRR","2","YYGR","soln"
DATA "BBCC","0","GGRY","6","RWYG","6","BBRR","4","YRGR","soln"
DATA "BBCC","0","GGRY","6","RWYG","7","BBBR","0","WYGG","soln"
DATA "BBCC","0","GGRY","6","RWYG","7","BBBR","1","WRGG","soln"
DATA "BBCC","0","GGRY","6","RWYG","7","BBBR","2","RYGR","soln"
DATA "BBCC","0","GGRY","6","RWYG","8","BBBR","0","YWGG","soln"
DATA "BBCC","0","GGRY","6","RWYG","8","BBBR","1","YRYG","soln"
DATA "BBCC","0","GGRY","6","RWYG","9","BBYY","0","RWGG","soln"
DATA "BBCC","0","GGRY","6","RWYG","9","BBYY","2","RRYG","soln"
DATA "BBCC","0","GGRY","6","RWYG","9","BBYY","4","RYYG","soln"
DATA "BBCC","0","GGRY","6","RWYG","10","BBBR","1","YRGW","soln"
DATA "BBCC","0","GGRY","6","RWYG","10","BBBR","2","WYGR","soln"
DATA "BBCC","0","GGRY","6","RWYG","11","BBGR","3","YRWG","soln"
DATA "BBCC","0","GGRY","6","RWYG","11","BBGR","4","RYGW","soln"
DATA "BBCC","0","GGRY","6","RWYG","11","BBGR","5","YWGR","soln"
DATA "BBCC","0","GGRY","6","RWYG","12","BBYB","1","RYWG","soln"
DATA "BBCC","0","GGRY","6","RWYG","12","BBYB","2","WRYG","soln"
DATA "BBCC","0","GGRY","7","GRYR","3","BRGW","2","YGGG","soln"
DATA "BBCC","0","GGRY","7","GRYR","3","BRGW","3","YGWG","soln"
DATA "BBCC","0","GGRY","7","GRYR","3","BRGW","4","RGGG","soln"
DATA "BBCC","0","GGRY","7","GRYR","3","BRGW","5","YGGW","soln"
DATA "BBCC","0","GGRY","7","GRYR","3","BRGW","6","RGWG","soln"
DATA "BBCC","0","GGRY","7","GRYR","3","BRGW","8","RGGW","soln"
DATA "BBCC","0","GGRY","7","GRYR","4","BGYW","3","GYGG","soln"
DATA "BBCC","0","GGRY","7","GRYR","4","BGYW","4","WGGR","soln"
DATA "BBCC","0","GGRY","7","GRYR","4","BGYW","5","YGYG","soln"
DATA "BBCC","0","GGRY","7","GRYR","4","BGYW","6","GYWG","soln"
DATA "BBCC","0","GGRY","7","GRYR","4","BGYW","7","GYGW","soln"
DATA "BBCC","0","GGRY","7","GRYR","4","BGYW","8","WGYG","soln"
DATA "BBCC","0","GGRY","7","GRYR","5","BRBW","0","GYYG","soln"
DATA "BBCC","0","GGRY","7","GRYR","5","BRBW","1","GWYG","soln"
DATA "BBCC","0","GGRY","7","GRYR","5","BRBW","2","GRGG","soln"
DATA "BBCC","0","GGRY","7","GRYR","5","BRBW","3","GWGR","soln"
DATA "BBCC","0","GGRY","7","GRYR","5","BRBW","4","GRWG","soln"
DATA "BBCC","0","GGRY","7","GRYR","5","BRBW","5","GRGW","soln"
DATA "BBCC","0","GGRY","7","GRYR","6","BYGY","3","YWRG","soln"
DATA "BBCC","0","GGRY","7","GRYR","6","BYGY","4","WYRG","soln"
DATA "BBCC","0","GGRY","7","GRYR","6","BYGY","5","RWGY","soln"
DATA "BBCC","0","GGRY","7","GRYR","6","BYGY","7","YYRG","soln"
DATA "BBCC","0","GGRY","7","GRYR","6","BYGY","9","RYGY","soln"
DATA "BBCC","0","GGRY","7","GRYR","7","BGBW","1","YRGY","soln"
DATA "BBCC","0","GGRY","7","GRYR","7","BGBW","2","RGGR","soln"
DATA "BBCC","0","GGRY","7","GRYR","7","BGBW","3","WRGY","soln"
DATA "BBCC","0","GGRY","7","GRYR","7","BGBW","4","YGWR","soln"
DATA "BBCC","0","GGRY","7","GRYR","7","BGBW","5","RGYW","soln"
DATA "BBCC","0","GGRY","7","GRYR","8","BBYY","1","GYWR","soln"
DATA "BBCC","0","GGRY","7","GRYR","8","BBYY","2","WGYR","soln"
DATA "BBCC","0","GGRY","7","GRYR","8","BBYY","4","YGYR","soln"
DATA "BBCC","0","GGRY","7","GRYR","9","BBGW","1","GYYR","soln"
DATA "BBCC","0","GGRY","7","GRYR","9","BBGW","2","GRGR","soln"
DATA "BBCC","0","GGRY","7","GRYR","9","BBGW","3","GWYR","soln"
DATA "BBCC","0","GGRY","7","GRYR","9","BBGW","4","GRYW","soln"
DATA "BBCC","0","GGRY","7","GRYR","10","RYRG","soln"
DATA "BBCC","0","GGRY","7","GRYR","11","BBBG","1","RRGY","soln"
DATA "BBCC","0","GGRY","7","GRYR","11","BBBG","2","YRRG","soln"
DATA "BBCC","0","GGRY","7","GRYR","12","RGYR","soln"
DATA "BBCC","0","GGRY","8","BGRR","1","BBBW","0","GYGY","soln"
DATA "BBCC","0","GGRY","8","BGRR","1","BBBW","1","GWGY","soln"
DATA "BBCC","0","GGRY","8","BGRR","2","BBYW","1","YGGY","soln"
DATA "BBCC","0","GGRY","8","BGRR","2","BBYW","2","GGYG","soln"
DATA "BBCC","0","GGRY","8","BGRR","2","BBYW","3","WGGY","soln"
DATA "BBCC","0","GGRY","8","BGRR","2","BBYW","5","GGYW","soln"
DATA "BBCC","0","GGRY","8","BGRR","3","BBBW","0","GRYY","soln"
DATA "BBCC","0","GGRY","8","BGRR","3","BBBW","1","GRWY","soln"
DATA "BBCC","0","GGRY","8","BGRR","4","BBRW","1","RGYY","soln"
DATA "BBCC","0","GGRY","8","BGRR","4","BBRW","3","RGWY","soln"
DATA "BBCC","0","GGRY","8","BGRR","4","BBRW","4","GWRG","soln"
DATA "BBCC","0","GGRY","8","BGRR","4","BBRW","5","GYRW","soln"
DATA "BBCC","0","GGRY","8","BGRR","5","BBRW","1","GGGR","soln"
DATA "BBCC","0","GGRY","8","BGRR","5","BBRW","3","GGWR","soln"
DATA "BBCC","0","GGRY","8","BGRR","5","BBRW","4","WGRG","soln"
DATA "BBCC","0","GGRY","8","BGRR","5","BBRW","5","YGRW","soln"
DATA "BBCC","0","GGRY","8","BGRR","7","GRRG","soln"
DATA "BBCC","0","GGRY","8","BGRR","8","BBBG","1","GYRR","soln"
DATA "BBCC","0","GGRY","8","BGRR","8","BBBG","2","RGRG","soln"
DATA "BBCC","0","GGRY","8","BGRR","9","YGRR","soln"
DATA "BBCC","0","GGRY","9","GRRW","2","BBGB","1","GGYY","soln"
DATA "BBCC","0","GGRY","9","GRRW","2","BBGB","2","GGGY","soln"
DATA "BBCC","0","GGRY","9","GRRW","4","BBBR","0","GGWY","soln"
DATA "BBCC","0","GGRY","9","GRRW","4","BBBR","1","YGRY","soln"
DATA "BBCC","0","GGRY","9","GRRW","5","BBBG","1","GYRY","soln"
DATA "BBCC","0","GGRY","9","GRRW","5","BBBG","2","GGRG","soln"
DATA "BBCC","0","GGRY","9","GRRW","7","BBBW","0","RGRY","soln"
DATA "BBCC","0","GGRY","9","GRRW","7","BBBW","1","WGRY","soln"
DATA "BBCC","0","GGRY","9","GRRW","8","BBBR","1","GWRY","soln"
DATA "BBCC","0","GGRY","9","GRRW","8","BBBR","2","GGRR","soln"
DATA "BBCC","0","GGRY","9","GRRW","9","BBBY","0","GGRW","soln"
DATA "BBCC","0","GGRY","9","GRRW","9","BBBY","2","GRRY","soln"
DATA "BBCC","0","GGRY","10","BRBB","1","RYGG","soln"
DATA "BBCC","0","GGRY","10","BRBB","2","YRGG","soln"
DATA "BBCC","0","GGRY","11","BGGR","6","GRYG","soln"
DATA "BBCC","0","GGRY","11","BGGR","7","RGYG","soln"
DATA "BBCC","0","GGRY","11","BGGR","8","GYGR","soln"
DATA "BBCC","0","GGRY","11","BGGR","9","YGGR","soln"
DATA "BBCC","0","GGRY","12","BGBR","3","BBBG","1","GRGY","soln"
DATA "BBCC","0","GGRY","12","BGBR","3","BBBG","2","GYRG","soln"
DATA "BBCC","0","GGRY","12","BGBR","4","BBBG","1","RGGY","soln"
DATA "BBCC","0","GGRY","12","BGBR","4","BBBG","2","YGRG","soln"
DATA "BBCC","0","GGRY","12","BGBR","5","GGYR","soln"
DATA "BBCC","1","CGRR","0","BYBY","1","WWWB","soln"
DATA "BBCC","1","CGRR","0","BYBY","2","WWBW","soln"
DATA "BBCC","1","CGRR","0","BYBY","3","BBYB","4","YWWB","soln"
DATA "BBCC","1","CGRR","0","BYBY","3","BBYB","5","WWYB","soln"
DATA "BBCC","1","CGRR","0","BYBY","4","BBBC","1","WYWB","soln"
DATA "BBCC","1","CGRR","0","BYBY","4","BBBC","2","YWBW","soln"
DATA "BBCC","1","CGRR","0","BYBY","5","BBBY","4","WYBW","soln"
DATA "BBCC","1","CGRR","0","BYBY","5","BBBY","5","WWBY","soln"
DATA "BBCC","1","CGRR","0","BYBY","6","YWYB","soln"
DATA "BBCC","1","CGRR","0","BYBY","7","BBYW","4","YYYB","soln"
DATA "BBCC","1","CGRR","0","BYBY","7","BBYW","6","YYWB","soln"
DATA "BBCC","1","CGRR","0","BYBY","7","BBYW","7","WYYB","soln"
DATA "BBCC","1","CGRR","0","BYBY","8","BBBY","4","YYBW","soln"
DATA "BBCC","1","CGRR","0","BYBY","8","BBBY","5","YWBY","soln"
DATA "BBCC","1","CGRR","0","BYBY","9","BBBW","2","YYBY","soln"
DATA "BBCC","1","CGRR","0","BYBY","9","BBBW","4","WYBY","soln"
DATA "BBCC","1","CGRR","1","CYBY","1","BRWW","3","GWGB","soln"
DATA "BBCC","1","CGRR","1","CYBY","1","BRWW","5","WCWW","soln"
DATA "BBCC","1","CGRR","1","CYBY","1","BRWW","6","WWGB","soln"
DATA "BBCC","1","CGRR","1","CYBY","1","BRWW","7","GWWB","soln"
DATA "BBCC","1","CGRR","1","CYBY","1","BRWW","11","RWWB","soln"
DATA "BBCC","1","CGRR","1","CYBY","1","BRWW","12","WRWB","soln"
DATA "BBCC","1","CGRR","1","CYBY","2","BRWW","3","GWBG","soln"
DATA "BBCC","1","CGRR","1","CYBY","2","BRWW","6","WWBG","soln"
DATA "BBCC","1","CGRR","1","CYBY","2","BRWW","7","GWBW","soln"
DATA "BBCC","1","CGRR","1","CYBY","2","BRWW","11","RWBW","soln"
DATA "BBCC","1","CGRR","1","CYBY","2","BRWW","12","WRBW","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","3","YCWW","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","4","WCYW","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","6","YRWB","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","7","WRYB","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","8","RWYB","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","11","YWGB","soln"
DATA "BBCC","1","CGRR","1","CYBY","3","BWYG","12","GWYB","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","0","WCWY","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","1","YRBW","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","2","RYWB","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","3","YWBG","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","4","GYWB","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","5","WYGB","soln"
DATA "BBCC","1","CGRR","1","CYBY","4","BGGB","8","GYGB","soln"
DATA "BBCC","1","CGRR","1","CYBY","5","RYBW","5","GYBG","soln"
DATA "BBCC","1","CGRR","1","CYBY","5","RYBW","7","GWBY","soln"
DATA "BBCC","1","CGRR","1","CYBY","5","RYBW","8","WYBG","soln"
DATA "BBCC","1","CGRR","1","CYBY","5","RYBW","9","GYBW","soln"
DATA "BBCC","1","CGRR","1","CYBY","5","RYBW","11","WRBY","soln"
DATA "BBCC","1","CGRR","1","CYBY","5","RYBW","12","RWBY","soln"
DATA "BBCC","1","CGRR","1","CYBY","6","BBBB","0","YCYW","soln"
DATA "BBCC","1","CGRR","1","CYBY","6","BBBB","2","YRYB","soln"
DATA "BBCC","1","CGRR","1","CYBY","7","GBWY","2","YCYY","soln"
DATA "BBCC","1","CGRR","1","CYBY","7","GBWY","3","RYYB","soln"
DATA "BBCC","1","CGRR","1","CYBY","7","GBWY","4","WCYY","soln"
DATA "BBCC","1","CGRR","1","CYBY","7","GBWY","5","YCWY","soln"
DATA "BBCC","1","CGRR","1","CYBY","7","GBWY","6","YYGB","soln"
DATA "BBCC","1","CGRR","1","CYBY","7","GBWY","7","GYYB","soln"
DATA "BBCC","1","CGRR","1","CYBY","8","BBBG","2","YRBY","soln"
DATA "BBCC","1","CGRR","1","CYBY","8","BBBG","5","YYBG","soln"
DATA "BBCC","1","CGRR","1","CYBY","9","BBBG","2","RYBY","soln"
DATA "BBCC","1","CGRR","1","CYBY","9","BBBG","4","GYBY","soln"
DATA "BBCC","1","CGRR","2","BYBG","0","CWWW","soln"
DATA "BBCC","1","CGRR","2","BYBG","1","BCYW","3","WWRB","soln"
DATA "BBCC","1","CGRR","2","BYBG","1","BCYW","6","CWWY","soln"
DATA "BBCC","1","CGRR","2","BYBG","1","BCYW","7","CWYY","soln"
DATA "BBCC","1","CGRR","2","BYBG","1","BCYW","8","CWYW","soln"
DATA "BBCC","1","CGRR","2","BYBG","2","BCYW","3","WWBR","soln"
DATA "BBCC","1","CGRR","2","BYBG","2","BCYW","4","CYYY","soln"
DATA "BBCC","1","CGRR","2","BYBG","2","BCYW","6","CYWY","soln"
DATA "BBCC","1","CGRR","2","BYBG","2","BCYW","7","CYWW","soln"
DATA "BBCC","1","CGRR","2","BYBG","2","BCYW","8","CYYW","soln"
DATA "BBCC","1","CGRR","2","BYBG","3","BGGG","1","YWRB","soln"
DATA "BBCC","1","CGRR","2","BYBG","3","BGGG","4","WGWB","soln"
DATA "BBCC","1","CGRR","2","BYBG","3","BGGG","7","GGWB","soln"
DATA "BBCC","1","CGRR","2","BYBG","3","BGGG","8","WGGB","soln"
DATA "BBCC","1","CGRR","2","BYBG","3","BGGG","12","GGGB","soln"
DATA "BBCC","1","CGRR","2","BYBG","4","BWGG","1","YYRB","soln"
DATA "BBCC","1","CGRR","2","BYBG","4","BWGG","3","WYRB","soln"
DATA "BBCC","1","CGRR","2","BYBG","4","BWGG","4","YWBR","soln"
DATA "BBCC","1","CGRR","2","BYBG","4","BWGG","6","WGBW","soln"
DATA "BBCC","1","CGRR","2","BYBG","4","BWGG","10","GGBW","soln"
DATA "BBCC","1","CGRR","2","BYBG","5","BBWG","1","YYBR","soln"
DATA "BBCC","1","CGRR","2","BYBG","5","BBWG","3","WYBR","soln"
DATA "BBCC","1","CGRR","2","BYBG","5","BBWG","4","GGBG","soln"
DATA "BBCC","1","CGRR","2","BYBG","5","BBWG","7","WGBG","soln"
DATA "BBCC","1","CGRR","2","BYBG","6","GBYW","6","YGGB","soln"
DATA "BBCC","1","CGRR","2","BYBG","6","GBYW","7","YGYB","soln"
DATA "BBCC","1","CGRR","2","BYBG","6","GBYW","8","GGYB","soln"
DATA "BBCC","1","CGRR","2","BYBG","6","GBYW","10","YGWB","soln"
DATA "BBCC","1","CGRR","2","BYBG","6","GBYW","11","WGYB","soln"
DATA "BBCC","1","CGRR","2","BYBG","7","GBBW","4","YGBY","soln"
DATA "BBCC","1","CGRR","2","BYBG","7","GBBW","5","GGBY","soln"
DATA "BBCC","1","CGRR","2","BYBG","7","GBBW","7","WGBY","soln"
DATA "BBCC","1","CGRR","2","BYBG","7","GBBW","8","YGBW","soln"
DATA "BBCC","1","CGRR","2","BYBG","8","YGBG","soln"
DATA "BBCC","1","CGRR","3","GCGY","0","BBBC","1","RRWB","soln"
DATA "BBCC","1","CGRR","3","GCGY","0","BBBC","2","RRBW","soln"
DATA "BBCC","1","CGRR","3","GCGY","1","BRBG","4","RRYB","soln"
DATA "BBCC","1","CGRR","3","GCGY","1","BRBG","8","RWBG","soln"
DATA "BBCC","1","CGRR","3","GCGY","1","BRBG","9","WRBG","soln"
DATA "BBCC","1","CGRR","3","GCGY","2","CWGB","1","RRBY","soln"
DATA "BBCC","1","CGRR","3","GCGY","2","CWGB","3","RCWW","soln"
DATA "BBCC","1","CGRR","3","GCGY","2","CWGB","6","GRBW","soln"
DATA "BBCC","1","CGRR","3","GCGY","2","CWGB","7","GRWB","soln"
DATA "BBCC","1","CGRR","3","GCGY","2","CWGB","8","WRGB","soln"
DATA "BBCC","1","CGRR","3","GCGY","2","CWGB","9","RWGB","soln"
DATA "BBCC","1","CGRR","3","GCGY","3","BRBB","4","RYBG","soln"
DATA "BBCC","1","CGRR","3","GCGY","3","BRBB","5","YRBG","soln"
DATA "BBCC","1","CGRR","3","GCGY","4","BRYG","2","WCWG","soln"
DATA "BBCC","1","CGRR","3","GCGY","4","BRYG","4","RCYW","soln"
DATA "BBCC","1","CGRR","3","GCGY","4","BRYG","8","GRBG","soln"
DATA "BBCC","1","CGRR","3","GCGY","4","BRYG","10","RYGB","soln"
DATA "BBCC","1","CGRR","3","GCGY","4","BRYG","11","YRGB","soln"
DATA "BBCC","1","CGRR","3","GCGY","4","BRYG","12","GRYB","soln"
DATA "BBCC","1","CGRR","3","GCGY","5","BGGW","0","RCYY","soln"
DATA "BBCC","1","CGRR","3","GCGY","5","BGGW","1","RCWY","soln"
DATA "BBCC","1","CGRR","3","GCGY","5","BGGW","3","GRBY","soln"
DATA "BBCC","1","CGRR","3","GCGY","5","BGGW","4","GCWW","soln"
DATA "BBCC","1","CGRR","3","GCGY","5","BGGW","5","WCGW","soln"
DATA "BBCC","1","CGRR","3","GCGY","5","BGGW","7","GRGB","soln"
DATA "BBCC","1","CGRR","3","GCGY","7","BBYY","1","YCWG","soln"
DATA "BBCC","1","CGRR","3","GCGY","7","BBYY","2","WCYG","soln"
DATA "BBCC","1","CGRR","3","GCGY","7","BBYY","4","YCYG","soln"
DATA "BBCC","1","CGRR","3","GCGY","8","BBGG","1","GCYW","soln"
DATA "BBCC","1","CGRR","3","GCGY","8","BBGG","2","YCGW","soln"
DATA "BBCC","1","CGRR","3","GCGY","8","BBGG","4","GCWG","soln"
DATA "BBCC","1","CGRR","3","GCGY","8","BBGG","5","WCGG","soln"
DATA "BBCC","1","CGRR","3","GCGY","9","BYGW","2","GCGG","soln"
DATA "BBCC","1","CGRR","3","GCGY","9","BYGW","3","GCYY","soln"
DATA "BBCC","1","CGRR","3","GCGY","9","BYGW","4","YCGY","soln"
DATA "BBCC","1","CGRR","3","GCGY","9","BYGW","5","GCGW","soln"
DATA "BBCC","1","CGRR","3","GCGY","9","BYGW","6","GCWY","soln"
DATA "BBCC","1","CGRR","3","GCGY","9","BYGW","7","WCGY","soln"
DATA "BBCC","1","CGRR","3","GCGY","12","BBGB","1","GCYG","soln"
DATA "BBCC","1","CGRR","3","GCGY","12","BBGB","2","YCGG","soln"
DATA "BBCC","1","CGRR","4","RRBY","0","BBGW","3","CWWG","soln"
DATA "BBCC","1","CGRR","4","RRBY","0","BBGW","4","CWGG","soln"
DATA "BBCC","1","CGRR","4","RRBY","0","BBGW","5","CWGW","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","1","WCWR","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","2","WCRW","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","4","CYYG","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","5","CYGG","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","6","CWYG","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","7","CYWG","soln"
DATA "BBCC","1","CGRR","4","RRBY","1","BYGW","9","CYGW","soln"
DATA "BBCC","1","CGRR","4","RRBY","2","BBBW","0","CYGY","soln"
DATA "BBCC","1","CGRR","4","RRBY","2","BBBW","1","CWGY","soln"
DATA "BBCC","1","CGRR","4","RRBY","2","BBBW","2","CRWW","soln"
DATA "BBCC","1","CGRR","4","RRBY","3","BBWR","2","YCYR","soln"
DATA "BBCC","1","CGRR","4","RRBY","3","BBWR","3","YCRW","soln"
DATA "BBCC","1","CGRR","4","RRBY","3","BBWR","4","WCYR","soln"
DATA "BBCC","1","CGRR","4","RRBY","3","BBWR","5","YCWR","soln"
DATA "BBCC","1","CGRR","4","RRBY","3","BBWR","6","GWRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","4","BCWY","1","RGGB","soln"
DATA "BBCC","1","CGRR","4","RRBY","4","BCWY","3","GWBR","soln"
DATA "BBCC","1","CGRR","4","RRBY","4","BCWY","4","RGWB","soln"
DATA "BBCC","1","CGRR","4","RRBY","4","BCWY","5","YCRY","soln"
DATA "BBCC","1","CGRR","4","RRBY","4","BCWY","6","CRYW","soln"
DATA "BBCC","1","CGRR","4","RRBY","4","BCWY","8","WCRY","soln"
DATA "BBCC","1","CGRR","4","RRBY","5","BBBW","0","CRYY","soln"
DATA "BBCC","1","CGRR","4","RRBY","5","BBBW","1","CRWY","soln"
DATA "BBCC","1","CGRR","4","RRBY","5","BBBW","2","RGBG","soln"
DATA "BBCC","1","CGRR","4","RRBY","5","BBBW","5","RGBW","soln"
DATA "BBCC","1","CGRR","4","RRBY","6","GYRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","7","BRBG","3","RWRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","7","BRBG","4","WRRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","7","BRBG","6","RGYB","soln"
DATA "BBCC","1","CGRR","4","RRBY","7","BRBG","7","GYBR","soln"
DATA "BBCC","1","CGRR","4","RRBY","8","BRBR","7","RRRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","8","BRBR","8","RWBR","soln"
DATA "BBCC","1","CGRR","4","RRBY","8","BRBR","9","WRBR","soln"
DATA "BBCC","1","CGRR","4","RRBY","9","BBBG","2","RRBR","soln"
DATA "BBCC","1","CGRR","4","RRBY","9","BBBG","4","RGBY","soln"
DATA "BBCC","1","CGRR","4","RRBY","11","BRBB","4","RYRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","11","BRBB","5","YRRB","soln"
DATA "BBCC","1","CGRR","4","RRBY","12","BRBB","4","RYBR","soln"
DATA "BBCC","1","CGRR","4","RRBY","12","BRBB","5","YRBR","soln"
DATA "BBCC","1","CGRR","5","BYRY","0","BBGW","2","CGGG","soln"
DATA "BBCC","1","CGRR","5","BYRY","0","BBGW","3","CGWG","soln"
DATA "BBCC","1","CGRR","5","BYRY","0","BBGW","4","CGWW","soln"
DATA "BBCC","1","CGRR","5","BYRY","0","BBGW","5","CGGW","soln"
DATA "BBCC","1","CGRR","5","BYRY","1","BBBG","0","CWWR","soln"
DATA "BBCC","1","CGRR","5","BYRY","1","BBBG","1","CGYW","soln"
DATA "BBCC","1","CGRR","5","BYRY","1","BBBG","2","CGYG","soln"
DATA "BBCC","1","CGRR","5","BYRY","2","BBBW","0","CGGY","soln"
DATA "BBCC","1","CGRR","5","BYRY","2","BBBW","1","CGWY","soln"
DATA "BBCC","1","CGRR","5","BYRY","2","BBBW","2","CWRW","soln"
DATA "BBCC","1","CGRR","5","BYRY","3","BBBW","1","CWYR","soln"
DATA "BBCC","1","CGRR","5","BYRY","3","BBBW","2","GGBR","soln"
DATA "BBCC","1","CGRR","5","BYRY","3","BBBW","4","WGBR","soln"
DATA "BBCC","1","CGRR","5","BYRY","4","BBGG","0","CYWR","soln"
DATA "BBCC","1","CGRR","5","BYRY","4","BBGG","1","CGYY","soln"
DATA "BBCC","1","CGRR","5","BYRY","4","BBGG","3","WGRB","soln"
DATA "BBCC","1","CGRR","5","BYRY","4","BBGG","6","GGRB","soln"
DATA "BBCC","1","CGRR","5","BYRY","5","BBBY","1","CYRW","soln"
DATA "BBCC","1","CGRR","5","BYRY","5","BBBY","2","CWRY","soln"
DATA "BBCC","1","CGRR","5","BYRY","6","YGBR","soln"
DATA "BBCC","1","CGRR","5","BYRY","7","BBBB","0","CYYR","soln"
DATA "BBCC","1","CGRR","5","BYRY","7","BBBB","2","YGRB","soln"
DATA "BBCC","1","CGRR","5","BYRY","9","CYRY","soln"
DATA "BBCC","1","CGRR","6","CGGY","1","RRBG","soln"
DATA "BBCC","1","CGRR","6","CGGY","2","RRGB","soln"
DATA "BBCC","1","CGRR","6","CGGY","3","RCWG","soln"
DATA "BBCC","1","CGRR","6","CGGY","4","RCGW","soln"
DATA "BBCC","1","CGRR","6","CGGY","6","RCYG","soln"
DATA "BBCC","1","CGRR","6","CGGY","7","RCGG","soln"
DATA "BBCC","1","CGRR","6","CGGY","8","RCGY","soln"
DATA "BBCC","1","CGRR","7","GCRY","4","BBBB","0","RCWR","soln"
DATA "BBCC","1","CGRR","7","GCRY","4","BBBB","2","GRBR","soln"
DATA "BBCC","1","CGRR","7","GCRY","5","BBBB","0","RCRW","soln"
DATA "BBCC","1","CGRR","7","GCRY","5","BBBB","2","GRRB","soln"
DATA "BBCC","1","CGRR","7","GCRY","6","BBBW","0","CRGG","soln"
DATA "BBCC","1","CGRR","7","GCRY","6","BBBW","1","CRWG","soln"
DATA "BBCC","1","CGRR","7","GCRY","6","BBBW","2","CRGW","soln"
DATA "BBCC","1","CGRR","7","GCRY","7","BBBG","0","RCYR","soln"
DATA "BBCC","1","CGRR","7","GCRY","7","BBBG","1","WCGR","soln"
DATA "BBCC","1","CGRR","7","GCRY","8","BBGG","1","GCWR","soln"
DATA "BBCC","1","CGRR","7","GCRY","8","BBGG","2","WCRG","soln"
DATA "BBCC","1","CGRR","7","GCRY","8","BBGG","4","GCGR","soln"
DATA "BBCC","1","CGRR","7","GCRY","9","BBBG","0","RCRY","soln"
DATA "BBCC","1","CGRR","7","GCRY","9","BBBG","1","GCRW","soln"
DATA "BBCC","1","CGRR","7","GCRY","9","BBBG","2","GCRG","soln"
DATA "BBCC","1","CGRR","7","GCRY","10","CRYG","soln"
DATA "BBCC","1","CGRR","7","GCRY","11","BBBR","1","CRGY","soln"
DATA "BBCC","1","CGRR","7","GCRY","11","BBBR","2","YCGR","soln"
DATA "BBCC","1","CGRR","7","GCRY","12","BBBG","1","GCYR","soln"
DATA "BBCC","1","CGRR","7","GCRY","12","BBBG","2","YCRG","soln"
DATA "BBCC","1","CGRR","8","CRCY","1","BBBC","1","RGRB","soln"
DATA "BBCC","1","CGRR","8","CRCY","1","BBBC","2","RGBR","soln"
DATA "BBCC","1","CGRR","8","CRCY","3","BBBW","0","RCRR","soln"
DATA "BBCC","1","CGRR","8","CRCY","3","BBBW","1","WCRR","soln"
DATA "BBCC","1","CGRR","8","CRCY","4","BBBG","1","CWGR","soln"
DATA "BBCC","1","CGRR","8","CRCY","4","BBBG","2","CWRG","soln"
DATA "BBCC","1","CGRR","8","CRCY","5","BBBR","1","CRRW","soln"
DATA "BBCC","1","CGRR","8","CRCY","5","BBBR","2","CRWR","soln"
DATA "BBCC","1","CGRR","8","CRCY","6","YCRR","soln"
DATA "BBCC","1","CGRR","8","CRCY","7","BBBG","1","CYGR","soln"
DATA "BBCC","1","CGRR","8","CRCY","7","BBBG","2","CYRG","soln"
DATA "BBCC","1","CGRR","8","CRCY","8","CRYR","soln"
DATA "BBCC","1","CGRR","8","CRCY","9","CRRY","soln"
DATA "BBCC","1","CGRR","9","BGGY","0","BBBW","0","CRRR","soln"
DATA "BBCC","1","CGRR","9","BGGY","0","BBBW","1","CWRR","soln"
DATA "BBCC","1","CGRR","9","BGGY","1","CYRR","soln"
DATA "BBCC","1","CGRR","9","BGGY","2","BBBR","1","CGRW","soln"
DATA "BBCC","1","CGRR","9","BGGY","2","BBBR","2","CGWR","soln"
DATA "BBCC","1","CGRR","9","BGGY","4","BBBG","1","CGYR","soln"
DATA "BBCC","1","CGRR","9","BGGY","4","BBBG","2","CGRG","soln"
DATA "BBCC","1","CGRR","9","BGGY","5","BBBR","1","CGRY","soln"
DATA "BBCC","1","CGRR","9","BGGY","5","BBBR","2","CGGR","soln"
DATA "BBCC","1","CGRR","11","BBBG","1","RCGR","soln"
DATA "BBCC","1","CGRR","11","BBBG","2","RCRG","soln"
DATA "BBCC","1","CGRR","12","BBGR","3","CRRG","soln"
DATA "BBCC","1","CGRR","12","BBGR","4","GCRR","soln"
DATA "BBCC","1","CGRR","12","BBGR","5","CRGR","soln"
DATA "BBCC","2","BGRR","0","BYCY","1","WWWC","soln"
DATA "BBCC","2","BGRR","0","BYCY","2","WWCW","soln"
DATA "BBCC","2","BGRR","0","BYCY","3","BBYB","1","YWWC","soln"
DATA "BBCC","2","BGRR","0","BYCY","3","BBYB","2","WWYC","soln"
DATA "BBCC","2","BGRR","0","BYCY","4","BBBC","1","YWCW","soln"
DATA "BBCC","2","BGRR","0","BYCY","4","BBBC","2","WYWC","soln"
DATA "BBCC","2","BGRR","0","BYCY","5","BBBY","1","WYCW","soln"
DATA "BBCC","2","BGRR","0","BYCY","5","BBBY","2","WWCY","soln"
DATA "BBCC","2","BGRR","0","BYCY","6","YWYC","soln"
DATA "BBCC","2","BGRR","0","BYCY","7","BBYW","2","YYYC","soln"
DATA "BBCC","2","BGRR","0","BYCY","7","BBYW","3","YYWC","soln"
DATA "BBCC","2","BGRR","0","BYCY","7","BBYW","4","WYYC","soln"
DATA "BBCC","2","BGRR","0","BYCY","8","BBBY","1","YYCW","soln"
DATA "BBCC","2","BGRR","0","BYCY","8","BBBY","2","YWCY","soln"
DATA "BBCC","2","BGRR","0","BYCY","9","BBBW","0","YYCY","soln"
DATA "BBCC","2","BGRR","0","BYCY","9","BBBW","1","WYCY","soln"
DATA "BBCC","2","BGRR","1","BYCY","1","BWGG","1","WRWC","soln"
DATA "BBCC","2","BGRR","1","BYCY","1","BWGG","2","RWWC","soln"
DATA "BBCC","2","BGRR","1","BYCY","1","BWGG","3","WBWW","soln"
DATA "BBCC","2","BGRR","1","BYCY","1","BWGG","4","GWWC","soln"
DATA "BBCC","2","BGRR","1","BYCY","1","BWGG","5","WWGC","soln"
DATA "BBCC","2","BGRR","1","BYCY","1","BWGG","8","GWGC","soln"
DATA "BBCC","2","BGRR","1","BYCY","2","BRWW","1","GWCG","soln"
DATA "BBCC","2","BGRR","1","BYCY","2","BRWW","3","WWCG","soln"
DATA "BBCC","2","BGRR","1","BYCY","2","BRWW","4","GWCW","soln"
DATA "BBCC","2","BGRR","1","BYCY","2","BRWW","7","RWCW","soln"
DATA "BBCC","2","BGRR","1","BYCY","2","BRWW","8","WRCW","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","3","YBWW","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","4","WBYW","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","6","YRWC","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","7","WRYC","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","8","RWYC","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","11","YWGC","soln"
DATA "BBCC","2","BGRR","1","BYCY","3","CWYG","12","GWYC","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","2","GYGC","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","3","YWCG","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","4","WYGC","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","5","GYWC","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","6","YRCW","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","7","WBWY","soln"
DATA "BBCC","2","BGRR","1","BYCY","4","BYWR","8","RYWC","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","2","GYCG","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","3","GWCY","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","4","WYCG","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","5","GYCW","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","6","WRCY","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","7","RWCY","soln"
DATA "BBCC","2","BGRR","1","BYCY","5","RYBW","9","RYCW","soln"
DATA "BBCC","2","BGRR","1","BYCY","6","BBBB","0","YRYC","soln"
DATA "BBCC","2","BGRR","1","BYCY","6","BBBB","2","YBYW","soln"
DATA "BBCC","2","BGRR","1","BYCY","7","GBWY","1","RYYC","soln"
DATA "BBCC","2","BGRR","1","BYCY","7","GBWY","3","YYGC","soln"
DATA "BBCC","2","BGRR","1","BYCY","7","GBWY","4","GYYC","soln"
DATA "BBCC","2","BGRR","1","BYCY","7","GBWY","5","YBYY","soln"
DATA "BBCC","2","BGRR","1","BYCY","7","GBWY","8","WBYY","soln"
DATA "BBCC","2","BGRR","1","BYCY","7","GBWY","9","YBWY","soln"
DATA "BBCC","2","BGRR","1","BYCY","8","BBBG","0","YRCY","soln"
DATA "BBCC","2","BGRR","1","BYCY","8","BBBG","2","YYCG","soln"
DATA "BBCC","2","BGRR","1","BYCY","9","BBBG","0","RYCY","soln"
DATA "BBCC","2","BGRR","1","BYCY","9","BBBG","1","GYCY","soln"
DATA "BBCC","2","BGRR","2","CYCG","0","BWWW","soln"
DATA "BBCC","2","BGRR","2","CYCG","1","BBYW","1","WWRC","soln"
DATA "BBCC","2","BGRR","2","CYCG","1","BBYW","7","BWWY","soln"
DATA "BBCC","2","BGRR","2","CYCG","1","BBYW","8","BWYY","soln"
DATA "BBCC","2","BGRR","2","CYCG","1","BBYW","9","BWYW","soln"
DATA "BBCC","2","BGRR","2","CYCG","2","BBYW","1","WWCR","soln"
DATA "BBCC","2","BGRR","2","CYCG","2","BBYW","5","BYYY","soln"
DATA "BBCC","2","BGRR","2","CYCG","2","BBYW","7","BYWY","soln"
DATA "BBCC","2","BGRR","2","CYCG","2","BBYW","8","BYWW","soln"
DATA "BBCC","2","BGRR","2","CYCG","2","BBYW","9","BYYW","soln"
DATA "BBCC","2","BGRR","2","CYCG","3","BGGG","0","YWRC","soln"
DATA "BBCC","2","BGRR","2","CYCG","3","BGGG","2","WGWC","soln"
DATA "BBCC","2","BGRR","2","CYCG","3","BGGG","4","GGWC","soln"
DATA "BBCC","2","BGRR","2","CYCG","3","BGGG","5","WGGC","soln"
DATA "BBCC","2","BGRR","2","CYCG","3","BGGG","8","GGGC","soln"
DATA "BBCC","2","BGRR","2","CYCG","4","BWGG","0","YYRC","soln"
DATA "BBCC","2","BGRR","2","CYCG","4","BWGG","1","WYRC","soln"
DATA "BBCC","2","BGRR","2","CYCG","4","BWGG","2","YWCR","soln"
DATA "BBCC","2","BGRR","2","CYCG","4","BWGG","3","WGCW","soln"
DATA "BBCC","2","BGRR","2","CYCG","4","BWGG","6","GGCW","soln"
DATA "BBCC","2","BGRR","2","CYCG","5","BBWG","0","YYCR","soln"
DATA "BBCC","2","BGRR","2","CYCG","5","BBWG","1","WYCR","soln"
DATA "BBCC","2","BGRR","2","CYCG","5","BBWG","2","GGCG","soln"
DATA "BBCC","2","BGRR","2","CYCG","5","BBWG","4","WGCG","soln"
DATA "BBCC","2","BGRR","2","CYCG","6","GBYW","3","YGGC","soln"
DATA "BBCC","2","BGRR","2","CYCG","6","GBYW","4","YGYC","soln"
DATA "BBCC","2","BGRR","2","CYCG","6","GBYW","5","GGYC","soln"
DATA "BBCC","2","BGRR","2","CYCG","6","GBYW","6","YGWC","soln"
DATA "BBCC","2","BGRR","2","CYCG","6","GBYW","7","WGYC","soln"
DATA "BBCC","2","BGRR","2","CYCG","7","GBBW","1","YGCY","soln"
DATA "BBCC","2","BGRR","2","CYCG","7","GBBW","2","GGCY","soln"
DATA "BBCC","2","BGRR","2","CYCG","7","GBBW","3","WGCY","soln"
DATA "BBCC","2","BGRR","2","CYCG","7","GBBW","4","YGCW","soln"
DATA "BBCC","2","BGRR","2","CYCG","8","YGCG","soln"
DATA "BBCC","2","BGRR","3","GBGY","0","BBBC","1","RRCW","soln"
DATA "BBCC","2","BGRR","3","GBGY","0","BBBC","2","RRWC","soln"
DATA "BBCC","2","BGRR","3","GBGY","1","BRBC","3","RWCG","soln"
DATA "BBCC","2","BGRR","3","GBGY","1","BRBC","4","WRCG","soln"
DATA "BBCC","2","BGRR","3","GBGY","1","BRBC","5","RRYC","soln"
DATA "BBCC","2","BGRR","3","GBGY","2","BWGC","1","RRCY","soln"
DATA "BBCC","2","BGRR","3","GBGY","2","BWGC","3","RBWW","soln"
DATA "BBCC","2","BGRR","3","GBGY","2","BWGC","6","GRCW","soln"
DATA "BBCC","2","BGRR","3","GBGY","2","BWGC","7","GRWC","soln"
DATA "BBCC","2","BGRR","3","GBGY","2","BWGC","8","WRGC","soln"
DATA "BBCC","2","BGRR","3","GBGY","2","BWGC","9","RWGC","soln"
DATA "BBCC","2","BGRR","3","GBGY","3","BRBB","1","RYCG","soln"
DATA "BBCC","2","BGRR","3","GBGY","3","BRBB","2","YRCG","soln"
DATA "BBCC","2","BGRR","3","GBGY","4","BRYB","1","WBWG","soln"
DATA "BBCC","2","BGRR","3","GBGY","4","BRYB","2","GRCG","soln"
DATA "BBCC","2","BGRR","3","GBGY","4","BRYB","3","RYGC","soln"
DATA "BBCC","2","BGRR","3","GBGY","4","BRYB","4","YRGC","soln"
DATA "BBCC","2","BGRR","3","GBGY","4","BRYB","5","GRYC","soln"
DATA "BBCC","2","BGRR","3","GBGY","4","BRYB","7","RBYW","soln"
DATA "BBCC","2","BGRR","3","GBGY","5","BRGW","3","RBYY","soln"
DATA "BBCC","2","BGRR","3","GBGY","5","BRGW","4","GRCY","soln"
DATA "BBCC","2","BGRR","3","GBGY","5","BRGW","5","GRGC","soln"
DATA "BBCC","2","BGRR","3","GBGY","5","BRGW","6","RBWY","soln"
DATA "BBCC","2","BGRR","3","GBGY","5","BRGW","7","GBWW","soln"
DATA "BBCC","2","BGRR","3","GBGY","5","BRGW","8","WBGW","soln"
DATA "BBCC","2","BGRR","3","GBGY","7","BBYY","4","YBWG","soln"
DATA "BBCC","2","BGRR","3","GBGY","7","BBYY","5","WBYG","soln"
DATA "BBCC","2","BGRR","3","GBGY","7","BBYY","8","YBYG","soln"
DATA "BBCC","2","BGRR","3","GBGY","8","BBGG","4","GBYW","soln"
DATA "BBCC","2","BGRR","3","GBGY","8","BBGG","5","YBGW","soln"
DATA "BBCC","2","BGRR","3","GBGY","8","BBGG","8","GBWG","soln"
DATA "BBCC","2","BGRR","3","GBGY","8","BBGG","9","WBGG","soln"
DATA "BBCC","2","BGRR","3","GBGY","9","BYGW","4","GBGG","soln"
DATA "BBCC","2","BGRR","3","GBGY","9","BYGW","6","GBYY","soln"
DATA "BBCC","2","BGRR","3","GBGY","9","BYGW","7","YBGY","soln"
DATA "BBCC","2","BGRR","3","GBGY","9","BYGW","8","GBGW","soln"
DATA "BBCC","2","BGRR","3","GBGY","9","BYGW","10","GBWY","soln"
DATA "BBCC","2","BGRR","3","GBGY","9","BYGW","11","WBGY","soln"
DATA "BBCC","2","BGRR","3","GBGY","12","BBGB","4","GBYG","soln"
DATA "BBCC","2","BGRR","3","GBGY","12","BBGB","5","YBGG","soln"
DATA "BBCC","2","BGRR","4","RRCY","0","BBGW","7","BWWG","soln"
DATA "BBCC","2","BGRR","4","RRCY","0","BBGW","8","BWGG","soln"
DATA "BBCC","2","BGRR","4","RRCY","0","BBGW","9","BWGW","soln"
DATA "BBCC","2","BGRR","4","RRCY","1","BYGW","3","WBWR","soln"
DATA "BBCC","2","BGRR","4","RRCY","1","BYGW","4","WBRW","soln"
DATA "BBCC","2","BGRR","4","RRCY","1","BYGW","8","BYYG","soln"
DATA "BBCC","2","BGRR","4","RRCY","1","BYGW","9","BYGG","soln"
DATA "BBCC","2","BGRR","4","RRCY","1","BYGW","11","BWYG","soln"
DATA "BBCC","2","BGRR","4","RRCY","1","BYGW","12","BYWG","soln"
DATA "BBCC","2","BGRR","4","RRCY","2","BBBW","2","BYGY","soln"
DATA "BBCC","2","BGRR","4","RRCY","2","BBBW","4","BWGY","soln"
DATA "BBCC","2","BGRR","4","RRCY","2","BBBW","5","BRWW","soln"
DATA "BBCC","2","BGRR","4","RRCY","3","BBWR","3","GWRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","3","BBWR","5","YBYR","soln"
DATA "BBCC","2","BGRR","4","RRCY","3","BBWR","7","YBRW","soln"
DATA "BBCC","2","BGRR","4","RRCY","3","BBWR","8","WBYR","soln"
DATA "BBCC","2","BGRR","4","RRCY","3","BBWR","9","YBWR","soln"
DATA "BBCC","2","BGRR","4","RRCY","4","BBWY","0","RGGC","soln"
DATA "BBCC","2","BGRR","4","RRCY","4","BBWY","1","GWCR","soln"
DATA "BBCC","2","BGRR","4","RRCY","4","BBWY","2","RGWC","soln"
DATA "BBCC","2","BGRR","4","RRCY","4","BBWY","5","YBRY","soln"
DATA "BBCC","2","BGRR","4","RRCY","4","BBWY","7","BRYW","soln"
DATA "BBCC","2","BGRR","4","RRCY","4","BBWY","8","WBRY","soln"
DATA "BBCC","2","BGRR","4","RRCY","5","BBYG","1","RGCW","soln"
DATA "BBCC","2","BGRR","4","RRCY","5","BBYG","2","RGCG","soln"
DATA "BBCC","2","BGRR","4","RRCY","5","BBYG","4","BRWY","soln"
DATA "BBCC","2","BGRR","4","RRCY","5","BBYG","5","BRYY","soln"
DATA "BBCC","2","BGRR","4","RRCY","6","GYRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","7","BRBR","1","RGYC","soln"
DATA "BBCC","2","BGRR","4","RRCY","7","BRBR","2","GYCR","soln"
DATA "BBCC","2","BGRR","4","RRCY","7","BRBR","3","RWRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","7","BRBR","4","WRRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","8","BRBC","3","RWCR","soln"
DATA "BBCC","2","BGRR","4","RRCY","8","BRBC","4","WRCR","soln"
DATA "BBCC","2","BGRR","4","RRCY","8","BRBC","5","RRRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","9","BBBG","0","RRCR","soln"
DATA "BBCC","2","BGRR","4","RRCY","9","BBBG","1","RGCY","soln"
DATA "BBCC","2","BGRR","4","RRCY","11","BRBB","1","RYRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","11","BRBB","2","YRRC","soln"
DATA "BBCC","2","BGRR","4","RRCY","12","BRBB","1","RYCR","soln"
DATA "BBCC","2","BGRR","4","RRCY","12","BRBB","2","YRCR","soln"
DATA "BBCC","2","BGRR","5","BRBY","1","BBCW","1","GGRC","soln"
DATA "BBCC","2","BGRR","5","BRBY","1","BBCW","2","GGCR","soln"
DATA "BBCC","2","BGRR","5","BRBY","1","BBCW","3","WGRC","soln"
DATA "BBCC","2","BGRR","5","BRBY","1","BBCW","4","WGCR","soln"
DATA "BBCC","2","BGRR","5","BRBY","2","BBGW","5","BGGG","soln"
DATA "BBCC","2","BGRR","5","BRBY","2","BBGW","7","BGWG","soln"
DATA "BBCC","2","BGRR","5","BRBY","2","BBGW","8","BGWW","soln"
DATA "BBCC","2","BGRR","5","BRBY","2","BBGW","9","BGGW","soln"
DATA "BBCC","2","BGRR","5","BRBY","3","BBBC","1","YGCR","soln"
DATA "BBCC","2","BGRR","5","BRBY","3","BBBC","2","YGRC","soln"
DATA "BBCC","2","BGRR","5","BRBY","4","BBRW","2","BGYG","soln"
DATA "BBCC","2","BGRR","5","BRBY","4","BBRW","5","BGYW","soln"
DATA "BBCC","2","BGRR","5","BRBY","4","BBRW","7","BWWR","soln"
DATA "BBCC","2","BGRR","5","BRBY","4","BBRW","9","BWRW","soln"
DATA "BBCC","2","BGRR","5","BRBY","5","BBGW","4","BGYY","soln"
DATA "BBCC","2","BGRR","5","BRBY","5","BBGW","5","BGGY","soln"
DATA "BBCC","2","BGRR","5","BRBY","5","BBGW","7","BGWY","soln"
DATA "BBCC","2","BGRR","5","BRBY","7","BBWR","5","BYYR","soln"
DATA "BBCC","2","BGRR","5","BRBY","7","BBWR","7","BYRW","soln"
DATA "BBCC","2","BGRR","5","BRBY","7","BBWR","8","BWYR","soln"
DATA "BBCC","2","BGRR","5","BRBY","7","BBWR","9","BYWR","soln"
DATA "BBCC","2","BGRR","5","BRBY","8","BBBW","2","BYRY","soln"
DATA "BBCC","2","BGRR","5","BRBY","8","BBBW","4","BWRY","soln"
DATA "BBCC","2","BGRR","6","BGGY","1","RRCG","soln"
DATA "BBCC","2","BGRR","6","BGGY","2","RRGC","soln"
DATA "BBCC","2","BGRR","6","BGGY","3","RBWG","soln"
DATA "BBCC","2","BGRR","6","BGGY","4","RBGW","soln"
DATA "BBCC","2","BGRR","6","BGGY","6","RBYG","soln"
DATA "BBCC","2","BGRR","6","BGGY","7","RBGG","soln"
DATA "BBCC","2","BGRR","6","BGGY","8","RBGY","soln"
DATA "BBCC","2","BGRR","7","GBRY","4","BBBB","0","GRCR","soln"
DATA "BBCC","2","BGRR","7","GBRY","4","BBBB","2","RBWR","soln"
DATA "BBCC","2","BGRR","7","GBRY","5","BBBB","0","GRRC","soln"
DATA "BBCC","2","BGRR","7","GBRY","5","BBBB","2","RBRW","soln"
DATA "BBCC","2","BGRR","7","GBRY","6","BBBW","2","BRGG","soln"
DATA "BBCC","2","BGRR","7","GBRY","6","BBBW","4","BRWG","soln"
DATA "BBCC","2","BGRR","7","GBRY","6","BBBW","5","BRGW","soln"
DATA "BBCC","2","BGRR","7","GBRY","7","BBBG","2","RBYR","soln"
DATA "BBCC","2","BGRR","7","GBRY","7","BBBG","4","WBGR","soln"
DATA "BBCC","2","BGRR","7","GBRY","8","BBGG","4","GBWR","soln"
DATA "BBCC","2","BGRR","7","GBRY","8","BBGG","5","WBRG","soln"
DATA "BBCC","2","BGRR","7","GBRY","8","BBGG","8","GBGR","soln"
DATA "BBCC","2","BGRR","7","GBRY","9","BBBG","2","RBRY","soln"
DATA "BBCC","2","BGRR","7","GBRY","9","BBBG","4","GBRW","soln"
DATA "BBCC","2","BGRR","7","GBRY","9","BBBG","5","GBRG","soln"
DATA "BBCC","2","BGRR","7","GBRY","10","BRYG","soln"
DATA "BBCC","2","BGRR","7","GBRY","11","BBBR","4","BRGY","soln"
DATA "BBCC","2","BGRR","7","GBRY","11","BBBR","5","YBGR","soln"
DATA "BBCC","2","BGRR","7","GBRY","12","BBBG","4","GBYR","soln"
DATA "BBCC","2","BGRR","7","GBRY","12","BBBG","5","YBRG","soln"
DATA "BBCC","2","BGRR","8","BRBY","1","BBBC","1","RGCR","soln"
DATA "BBCC","2","BGRR","8","BRBY","1","BBBC","2","RGRC","soln"
DATA "BBCC","2","BGRR","8","BRBY","3","BBBW","2","RBRR","soln"
DATA "BBCC","2","BGRR","8","BRBY","3","BBBW","4","WBRR","soln"
DATA "BBCC","2","BGRR","8","BRBY","4","BBBG","4","BWGR","soln"
DATA "BBCC","2","BGRR","8","BRBY","4","BBBG","5","BWRG","soln"
DATA "BBCC","2","BGRR","8","BRBY","5","BBBR","4","BRRW","soln"
DATA "BBCC","2","BGRR","8","BRBY","5","BBBR","5","BRWR","soln"
DATA "BBCC","2","BGRR","8","BRBY","6","YBRR","soln"
DATA "BBCC","2","BGRR","8","BRBY","7","BBBG","4","BYGR","soln"
DATA "BBCC","2","BGRR","8","BRBY","7","BBBG","5","BYRG","soln"
DATA "BBCC","2","BGRR","8","BRBY","8","BRYR","soln"
DATA "BBCC","2","BGRR","8","BRBY","9","BRRY","soln"
DATA "BBCC","2","BGRR","9","BGGY","2","BBBW","2","BRRR","soln"
DATA "BBCC","2","BGRR","9","BGGY","2","BBBW","4","BWRR","soln"
DATA "BBCC","2","BGRR","9","BGGY","4","BYRR","soln"
DATA "BBCC","2","BGRR","9","BGGY","5","BBBR","4","BGRW","soln"
DATA "BBCC","2","BGRR","9","BGGY","5","BBBR","5","BGWR","soln"
DATA "BBCC","2","BGRR","9","BGGY","8","BBBG","4","BGYR","soln"
DATA "BBCC","2","BGRR","9","BGGY","8","BBBG","5","BGRG","soln"
DATA "BBCC","2","BGRR","9","BGGY","9","BBBR","4","BGRY","soln"
DATA "BBCC","2","BGRR","9","BGGY","9","BBBR","5","BGGR","soln"
DATA "BBCC","2","BGRR","11","BBBG","4","RBGR","soln"
DATA "BBCC","2","BGRR","11","BBBG","5","RBRG","soln"
DATA "BBCC","2","BGRR","12","BBGR","7","BRRG","soln"
DATA "BBCC","2","BGRR","12","BBGR","8","GBRR","soln"
DATA "BBCC","2","BGRR","12","BBGR","9","BRGR","soln"
DATA "BBCC","3","CGRR","0","BYBY","4","WWBB","soln"
DATA "BBCC","3","CGRR","0","BYBY","7","YWBB","soln"
DATA "BBCC","3","CGRR","0","BYBY","8","WYBB","soln"
DATA "BBCC","3","CGRR","0","BYBY","12","YYBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","1","BRBB","5","GWBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","1","BRBB","8","RWBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","1","BRBB","9","WRBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","3","BRBB","5","GYBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","3","BRBB","8","RYBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","3","BRBB","9","YRBB","soln"
DATA "BBCC","3","CGRR","1","BCYY","4","BBBC","3","WCWB","soln"
DATA "BBCC","3","CGRR","1","BCYY","4","BBBC","4","WCBW","soln"
DATA "BBCC","3","CGRR","1","BCYY","7","BBBC","3","YCWB","soln"
DATA "BBCC","3","CGRR","1","BCYY","7","BBBC","4","YCBW","soln"
DATA "BBCC","3","CGRR","1","BCYY","8","BBBC","3","WCYB","soln"
DATA "BBCC","3","CGRR","1","BCYY","8","BBBC","4","WCBY","soln"
DATA "BBCC","3","CGRR","1","BCYY","12","BBBC","3","YCYB","soln"
DATA "BBCC","3","CGRR","1","BCYY","12","BBBC","4","YCBY","soln"
DATA "BBCC","3","CGRR","2","CBYY","1","BBBW","4","GGBB","soln"
DATA "BBCC","3","CGRR","2","CBYY","1","BBBW","7","WGBB","soln"
DATA "BBCC","3","CGRR","2","CBYY","2","CCWW","soln"
DATA "BBCC","3","CGRR","2","CBYY","3","YGBB","soln"
DATA "BBCC","3","CGRR","2","CBYY","4","BBBC","3","CWWB","soln"
DATA "BBCC","3","CGRR","2","CBYY","4","BBBC","4","CWBW","soln"
DATA "BBCC","3","CGRR","2","CBYY","5","BBBY","1","CCYW","soln"
DATA "BBCC","3","CGRR","2","CBYY","5","BBBY","2","CCWY","soln"
DATA "BBCC","3","CGRR","2","CBYY","7","BBBC","3","CYWB","soln"
DATA "BBCC","3","CGRR","2","CBYY","7","BBBC","4","CYBW","soln"
DATA "BBCC","3","CGRR","2","CBYY","8","BBBC","3","CWYB","soln"
DATA "BBCC","3","CGRR","2","CBYY","8","BBBC","4","CWBY","soln"
DATA "BBCC","3","CGRR","2","CBYY","9","CCYY","soln"
DATA "BBCC","3","CGRR","2","CBYY","12","BBBC","3","CYYB","soln"
DATA "BBCC","3","CGRR","2","CBYY","12","BBBC","4","CYBY","soln"
DATA "BBCC","3","CGRR","3","BRBY","1","BBGG","3","GCWB","soln"
DATA "BBCC","3","CGRR","3","BRBY","1","BBGG","4","WCGB","soln"
DATA "BBCC","3","CGRR","3","BRBY","1","BBGG","7","GCGB","soln"
DATA "BBCC","3","CGRR","3","BRBY","2","BBBW","2","GCBG","soln"
DATA "BBCC","3","CGRR","3","BRBY","2","BBBW","4","WCBG","soln"
DATA "BBCC","3","CGRR","3","BRBY","2","BBBW","5","GCBW","soln"
DATA "BBCC","3","CGRR","3","BRBY","3","BBGB","2","RCWB","soln"
DATA "BBCC","3","CGRR","3","BRBY","3","BBGB","4","GCYB","soln"
DATA "BBCC","3","CGRR","3","BRBY","3","BBGB","5","YCGB","soln"
DATA "BBCC","3","CGRR","3","BRBY","4","BBBG","2","RCBW","soln"
DATA "BBCC","3","CGRR","3","BRBY","4","BBBG","5","YCBG","soln"
DATA "BBCC","3","CGRR","3","BRBY","5","GCBY","soln"
DATA "BBCC","3","CGRR","3","BRBY","6","RCYB","soln"
DATA "BBCC","3","CGRR","3","BRBY","8","BBBG","2","RCBY","soln"
DATA "BBCC","3","CGRR","3","BRBY","8","BBBG","4","RRBB","soln"
DATA "BBCC","3","CGRR","3","BRBY","8","BBBG","7","GRBB","soln"
DATA "BBCC","3","CGRR","4","BRBY","0","BBBW","0","CCGG","soln"
DATA "BBCC","3","CGRR","4","BRBY","0","BBBW","1","CCWG","soln"
DATA "BBCC","3","CGRR","4","BRBY","0","BBBW","2","CCGW","soln"
DATA "BBCC","3","CGRR","4","BRBY","1","BBBB","0","CCYG","soln"
DATA "BBCC","3","CGRR","4","BRBY","1","BBBB","2","CWGB","soln"
DATA "BBCC","3","CGRR","4","BRBY","2","BBBB","0","CCGY","soln"
DATA "BBCC","3","CGRR","4","BRBY","2","BBBB","2","CWBG","soln"
DATA "BBCC","3","CGRR","4","BRBY","3","BBBG","1","WCRB","soln"
DATA "BBCC","3","CGRR","4","BRBY","3","BBBG","3","CYGB","soln"
DATA "BBCC","3","CGRR","4","BRBY","4","BBBG","1","CRWB","soln"
DATA "BBCC","3","CGRR","4","BRBY","4","BBBG","2","WCBR","soln"
DATA "BBCC","3","CGRR","4","BRBY","4","BBBG","5","CYBG","soln"
DATA "BBCC","3","CGRR","4","BRBY","5","CRBW","soln"
DATA "BBCC","3","CGRR","4","BRBY","6","YCRB","soln"
DATA "BBCC","3","CGRR","4","BRBY","7","BBBG","1","CRYB","soln"
DATA "BBCC","3","CGRR","4","BRBY","7","BBBG","2","YCBR","soln"
DATA "BBCC","3","CGRR","4","BRBY","7","BBBG","7","RGBB","soln"
DATA "BBCC","3","CGRR","4","BRBY","9","CRBY","soln"
DATA "BBCC","3","CGRR","5","GGBY","0","BBBR","1","CCRW","soln"
DATA "BBCC","3","CGRR","5","GGBY","0","BBBR","2","CCWR","soln"
DATA "BBCC","3","CGRR","5","GGBY","1","BBBB","0","CCYR","soln"
DATA "BBCC","3","CGRR","5","GGBY","1","BBBB","2","CWRB","soln"
DATA "BBCC","3","CGRR","5","GGBY","2","BBBB","0","CCRY","soln"
DATA "BBCC","3","CGRR","5","GGBY","2","BBBB","2","CWBR","soln"
DATA "BBCC","3","CGRR","5","GGBY","3","CYRB","soln"
DATA "BBCC","3","CGRR","5","GGBY","4","BBBC","3","CGWB","soln"
DATA "BBCC","3","CGRR","5","GGBY","4","BBBC","4","CYBR","soln"
DATA "BBCC","3","CGRR","5","GGBY","5","CGBW","soln"
DATA "BBCC","3","CGRR","5","GGBY","7","BBBY","1","CGGB","soln"
DATA "BBCC","3","CGRR","5","GGBY","7","BBBY","3","CGYB","soln"
DATA "BBCC","3","CGRR","5","GGBY","8","CGBG","soln"
DATA "BBCC","3","CGRR","5","GGBY","9","CGBY","soln"
DATA "BBCC","3","CGRR","6","BBBC","3","RCGB","soln"
DATA "BBCC","3","CGRR","6","BBBC","4","RCBG","soln"
DATA "BBCC","3","CGRR","7","CRBG","6","RCRB","soln"
DATA "BBCC","3","CGRR","7","CRBG","7","RCBR","soln"
DATA "BBCC","3","CGRR","7","CRBG","10","GCRB","soln"
DATA "BBCC","3","CGRR","7","CRBG","11","GCBR","soln"
DATA "BBCC","3","CGRR","7","CRBG","12","CRGB","soln"
DATA "BBCC","3","CGRR","8","BBBR","1","CCRG","soln"
DATA "BBCC","3","CGRR","8","BBBR","2","CCGR","soln"
DATA "BBCC","3","CGRR","8","BBBR","3","CRRB","soln"
DATA "BBCC","3","CGRR","8","BBBR","5","CRBR","soln"
DATA "BBCC","3","CGRR","9","BBBC","1","CCRR","soln"
DATA "BBCC","3","CGRR","9","BBBC","3","CGRB","soln"
DATA "BBCC","3","CGRR","9","BBBC","4","CGBR","soln"
DATA "BBCC","4","BBGR","0","CYCY","3","WCWC","soln"
DATA "BBCC","4","BBGR","0","CYCY","4","BCBW","3","CWWC","soln"
DATA "BBCC","4","BBGR","0","CYCY","4","BCBW","4","CCWC","soln"
DATA "BBCC","4","BBGR","0","CYCY","4","BCBW","5","WCCW","soln"
DATA "BBCC","4","BBGR","0","CYCY","5","BBWW","2","CCCW","soln"
DATA "BBCC","4","BBGR","0","CYCY","5","BBWW","4","CWCW","soln"
DATA "BBCC","4","BBGR","0","CYCY","6","BBYB","1","YCWC","soln"
DATA "BBCC","4","BBGR","0","CYCY","6","BBYB","2","WCYC","soln"
DATA "BBCC","4","BBGR","0","CYCY","7","BBBW","0","CCYC","soln"
DATA "BBCC","4","BBGR","0","CYCY","7","BBBW","1","CWYC","soln"
DATA "BBCC","4","BBGR","0","CYCY","7","BBBW","2","YCCW","soln"
DATA "BBCC","4","BBGR","0","CYCY","8","BBBC","1","WCCY","soln"
DATA "BBCC","4","BBGR","0","CYCY","8","BBBC","2","CYWC","soln"
DATA "BBCC","4","BBGR","0","CYCY","9","BBBW","0","CCCY","soln"
DATA "BBCC","4","BBGR","0","CYCY","9","BBBW","1","CWCY","soln"
DATA "BBCC","4","BBGR","0","CYCY","9","BBBW","2","CYCW","soln"
DATA "BBCC","4","BBGR","0","CYCY","10","YCYC","soln"
DATA "BBCC","4","BBGR","0","CYCY","12","BBBC","1","YCCY","soln"
DATA "BBCC","4","BBGR","0","CYCY","12","BBBC","2","CYYC","soln"
DATA "BBCC","4","BBGR","1","BCRY","1","BBCW","2","CGCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","1","BBCW","3","CGWC","soln"
DATA "BBCC","4","BBGR","1","BCRY","1","BBCW","4","CWCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","1","BBCW","5","CGCW","soln"
DATA "BBCC","4","BBGR","1","BCRY","2","CBCW","4","GCCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","2","CBCW","5","CCCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","2","CBCW","6","GCWC","soln"
DATA "BBCC","4","BBGR","1","BCRY","2","CBCW","7","WCCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","2","CBCW","8","GCCW","soln"
DATA "BBCC","4","BBGR","1","BCRY","3","BBCW","1","CGYC","soln"
DATA "BBCC","4","BBGR","1","BCRY","3","BBCW","2","CYCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","3","BBCW","3","CRWC","soln"
DATA "BBCC","4","BBGR","1","BCRY","3","BBCW","5","CRCW","soln"
DATA "BBCC","4","BBGR","1","BCRY","3","BBCW","6","WWBC","soln"
DATA "BBCC","4","BBGR","1","BCRY","3","BBCW","7","WWCB","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","3","GCYC","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","4","YCCG","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","5","CGCY","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","8","CRRC","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","10","RCWC","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","11","CWRC","soln"
DATA "BBCC","4","BBGR","1","BCRY","4","CRCW","12","RCCW","soln"
DATA "BBCC","4","BBGR","1","BCRY","5","CBRR","1","GCCY","soln"
DATA "BBCC","4","BBGR","1","BCRY","5","CBRR","4","WCRC","soln"
DATA "BBCC","4","BBGR","1","BCRY","5","CBRR","5","CCRC","soln"
DATA "BBCC","4","BBGR","1","BCRY","5","CBRR","7","RCRC","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","2","CRYC","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","3","YYCB","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","5","YYBC","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","6","WYCB","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","7","YWCB","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","8","WYBC","soln"
DATA "BBCC","4","BBGR","1","BCRY","6","BWBC","9","YWBC","soln"
DATA "BBCC","4","BBGR","1","BCRY","7","BBRC","3","CRCY","soln"
DATA "BBCC","4","BBGR","1","BCRY","7","BBRC","4","RCYC","soln"
DATA "BBCC","4","BBGR","1","BCRY","7","BBRC","5","CYRC","soln"
DATA "BBCC","4","BBGR","1","BCRY","8","BBBC","1","RCCY","soln"
DATA "BBCC","4","BBGR","1","BCRY","8","BBBC","2","YCRC","soln"
DATA "BBCC","4","BBGR","2","BCGY","1","BBBW","0","CRCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","1","BBBW","1","CWCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","2","CBBW","1","RCCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","2","CBBW","2","CCCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","2","CBBW","3","WCCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","3","BBBB","0","CYCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","3","BBBB","2","CBWW","soln"
DATA "BBCC","4","BBGR","2","BCGY","4","BBCW","1","CGGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","4","BBCW","2","YCCR","soln"
DATA "BBCC","4","BBGR","2","BCGY","4","BBCW","3","CWGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","5","CBBW","1","GCGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","5","CBBW","2","CCGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","5","CBBW","3","WCGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","5","CBBW","7","BCWW","soln"
DATA "BBCC","4","BBGR","2","BCGY","6","CBYW","soln"
DATA "BBCC","4","BBGR","2","BCGY","7","BBBW","0","CYGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","7","BBBW","2","CBYY","soln"
DATA "BBCC","4","BBGR","2","BCGY","7","BBBW","4","CBWY","soln"
DATA "BBCC","4","BBGR","2","BCGY","8","BBBB","0","YCGC","soln"
DATA "BBCC","4","BBGR","2","BCGY","8","BBBB","2","BCYW","soln"
DATA "BBCC","4","BBGR","2","BCGY","9","BBBW","2","BCYY","soln"
DATA "BBCC","4","BBGR","2","BCGY","9","BBBW","4","BCWY","soln"
DATA "BBCC","4","BBGR","3","GGYC","1","BRBR","3","RWCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","1","BRBR","4","WRCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","1","BRBR","7","RRCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","2","BRBR","4","RWBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","2","BRBR","5","WRBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","2","BRBR","8","RRBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","3","BRBB","1","RCCG","soln"
DATA "BBCC","4","BBGR","3","GGYC","3","BRBB","2","CRCG","soln"
DATA "BBCC","4","BBGR","3","GGYC","3","BRBB","4","RYCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","3","BRBB","5","YRCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","4","GRBC","6","WGCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","4","GRBC","7","GWCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","4","GRBC","8","RYBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","4","GRBC","9","YRBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","5","BGBB","1","GCRC","soln"
DATA "BBCC","4","BBGR","3","GGYC","5","BGBB","2","CGRC","soln"
DATA "BBCC","4","BBGR","3","GGYC","5","BGBB","4","GWBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","5","BGBB","5","WGBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","7","BGBB","4","GYCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","7","BGBB","5","YGCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","8","BGBC","7","GGCB","soln"
DATA "BBCC","4","BBGR","3","GGYC","8","BGBC","8","GYBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","8","BGBC","9","YGBC","soln"
DATA "BBCC","4","BBGR","3","GGYC","9","GGBC","soln"
DATA "BBCC","4","BBGR","4","BYBW","0","BCCR","6","CRGC","soln"
DATA "BBCC","4","BBGR","4","BYBW","0","BCCR","7","RCGC","soln"
DATA "BBCC","4","BBGR","4","BYBW","0","BCCR","8","CGCR","soln"
DATA "BBCC","4","BBGR","4","BYBW","0","BCCR","9","GCCR","soln"
DATA "BBCC","4","BBGR","4","BYBW","3","BBBY","2","CBWG","soln"
DATA "BBCC","4","BBGR","4","BYBW","3","BBBY","4","CBYG","soln"
DATA "BBCC","4","BBGR","4","BYBW","3","BBBY","5","CBRY","soln"
DATA "BBCC","4","BBGR","4","BYBW","4","BBGY","2","CBRW","soln"
DATA "BBCC","4","BBGR","4","BYBW","4","BBGY","4","BCWG","soln"
DATA "BBCC","4","BBGR","4","BYBW","4","BBGY","5","BCRY","soln"
DATA "BBCC","4","BBGR","4","BYBW","4","BBGY","7","BCYG","soln"
DATA "BBCC","4","BBGR","4","BYBW","5","BCRW","soln"
DATA "BBCC","4","BBGR","4","BYBW","6","BBBY","4","WBWB","soln"
DATA "BBCC","4","BBGR","4","BYBW","6","BBBY","7","YBYB","soln"
DATA "BBCC","4","BBGR","4","BYBW","7","BBBY","4","BWWB","soln"
DATA "BBCC","4","BBGR","4","BYBW","7","BBBY","8","WBBB","soln"
DATA "BBCC","4","BBGR","4","BYBW","7","BBBY","9","YBBY","soln"
DATA "BBCC","4","BBGR","4","BYBW","7","BBBY","12","YBBB","soln"
DATA "BBCC","4","BBGR","4","BYBW","8","BBBC","4","BYYB","soln"
DATA "BBCC","4","BBGR","4","BYBW","8","BBBC","5","WBBW","soln"
DATA "BBCC","4","BBGR","4","BYBW","8","BBBC","8","BWBB","soln"
DATA "BBCC","4","BBGR","4","BYBW","9","BBBY","5","BWBW","soln"
DATA "BBCC","4","BBGR","4","BYBW","9","BBBY","9","BYBY","soln"
DATA "BBCC","4","BBGR","4","BYBW","9","BBBY","12","BYBB","soln"
DATA "BBCC","4","BBGR","4","BYBW","10","BBYB","8","YBWB","soln"
DATA "BBCC","4","BBGR","4","BYBW","10","BBYB","9","WBYB","soln"
DATA "BBCC","4","BBGR","4","BYBW","11","BBBC","4","BWYB","soln"
DATA "BBCC","4","BBGR","4","BYBW","11","BBBC","5","WBBY","soln"
DATA "BBCC","4","BBGR","4","BYBW","12","BBBY","7","BYWB","soln"
DATA "BBCC","4","BBGR","4","BYBW","12","BBBY","8","YBBW","soln"
DATA "BBCC","4","BBGR","4","BYBW","12","BBBY","9","BWBY","soln"
DATA "BBCC","4","BBGR","5","BCGY","3","BBBW","2","CBRR","soln"
DATA "BBCC","4","BBGR","5","BCGY","3","BBBW","4","CBWR","soln"
DATA "BBCC","4","BBGR","5","BCGY","5","BBBW","2","BCRR","soln"
DATA "BBCC","4","BBGR","5","BCGY","5","BBBW","4","BCWR","soln"
DATA "BBCC","4","BBGR","5","BCGY","6","CBYR","soln"
DATA "BBCC","4","BBGR","5","BCGY","7","BBBG","4","CBGW","soln"
DATA "BBCC","4","BBGR","5","BCGY","7","BBBG","5","CBGG","soln"
DATA "BBCC","4","BBGR","5","BCGY","8","BCYR","soln"
DATA "BBCC","4","BBGR","5","BCGY","9","BBBG","4","BCGW","soln"
DATA "BBCC","4","BBGR","5","BCGY","9","BBBG","5","BCGG","soln"
DATA "BBCC","4","BBGR","5","BCGY","12","CBGY","soln"
DATA "BBCC","4","BBGR","6","BGBC","6","GRCB","soln"
DATA "BBCC","4","BBGR","6","BGBC","7","RGCB","soln"
DATA "BBCC","4","BBGR","6","BGBC","8","GRBC","soln"
DATA "BBCC","4","BBGR","6","BGBC","9","RGBC","soln"
DATA "BBCC","4","BBGR","7","BGBY","3","BBRR","5","CBRG","soln"
DATA "BBCC","4","BBGR","7","BGBY","3","BBRR","7","RBWB","soln"
DATA "BBCC","4","BBGR","7","BGBY","3","BBRR","8","WBRB","soln"
DATA "BBCC","4","BBGR","7","BGBY","3","BBRR","12","RBRB","soln"
DATA "BBCC","4","BBGR","7","BGBY","4","BCWG","1","RBBB","soln"
DATA "BBCC","4","BBGR","7","BGBY","4","BCWG","2","BRRB","soln"
DATA "BBCC","4","BBGR","7","BGBY","4","BCWG","3","RBBW","soln"
DATA "BBCC","4","BBGR","7","BGBY","4","BCWG","4","BWRB","soln"
DATA "BBCC","4","BBGR","7","BGBY","4","BCWG","5","BRWB","soln"
DATA "BBCC","4","BBGR","7","BGBY","4","BCWG","9","BCRG","soln"
DATA "BBCC","4","BBGR","7","BGBY","5","BBBB","5","BRBW","soln"
DATA "BBCC","4","BBGR","7","BGBY","5","BBBB","9","BRBB","soln"
DATA "BBCC","4","BBGR","7","BGBY","6","BBRB","5","GBWB","soln"
DATA "BBCC","4","BBGR","7","BGBY","6","BBRB","8","RBYB","soln"
DATA "BBCC","4","BBGR","7","BGBY","6","BBRB","9","YBRB","soln"
DATA "BBCC","4","BBGR","7","BGBY","7","WRYB","1","GBBG","soln"
DATA "BBCC","4","BBGR","7","BGBY","7","WRYB","2","GBBB","soln"
DATA "BBCC","4","BBGR","7","BGBY","7","WRYB","3","GBBW","soln"
DATA "BBCC","4","BBGR","7","BGBY","7","WRYB","4","WBBG","soln"
DATA "BBCC","4","BBGR","7","BGBY","7","WRYB","7","BYRB","soln"
DATA "BBCC","4","BBGR","7","BGBY","7","WRYB","9","BRYB","soln"
DATA "BBCC","4","BBGR","7","BGBY","8","BBBG","5","RBBY","soln"
DATA "BBCC","4","BBGR","7","BGBY","8","BBBG","7","BGWB","soln"
DATA "BBCC","4","BBGR","7","BGBY","8","BBBG","9","BWBG","soln"
DATA "BBCC","4","BBGR","7","BGBY","9","BBBG","5","BRBY","soln"
DATA "BBCC","4","BBGR","7","BGBY","9","BBBG","8","BGBW","soln"
DATA "BBCC","4","BBGR","7","BGBY","9","BBBG","9","BGBG","soln"
DATA "BBCC","4","BBGR","7","BGBY","9","BBBG","12","BGBB","soln"
DATA "BBCC","4","BBGR","7","BGBY","10","GBYB","soln"
DATA "BBCC","4","BBGR","7","BGBY","11","YBBG","soln"
DATA "BBCC","4","BBGR","7","BGBY","12","BBBG","7","BGYB","soln"
DATA "BBCC","4","BBGR","7","BGBY","12","BBBG","8","GBBY","soln"
DATA "BBCC","4","BBGR","7","BGBY","12","BBBG","9","BYBG","soln"
DATA "BBCC","4","BBGR","8","BGBY","4","BBBW","5","RBBR","soln"
DATA "BBCC","4","BBGR","8","BGBY","4","BBBW","8","WBBR","soln"
DATA "BBCC","4","BBGR","8","BGBY","5","BBBW","5","BRBR","soln"
DATA "BBCC","4","BBGR","8","BGBY","5","BBBW","8","BWBR","soln"
DATA "BBCC","4","BBGR","8","BGBY","6","BBBW","4","GBGB","soln"
DATA "BBCC","4","BBGR","8","BGBY","6","BBBW","7","WBGB","soln"
DATA "BBCC","4","BBGR","8","BGBY","7","BBBC","4","BWGB","soln"
DATA "BBCC","4","BBGR","8","BGBY","7","BBBC","5","YBBR","soln"
DATA "BBCC","4","BBGR","8","BGBY","8","BBBC","4","BGGB","soln"
DATA "BBCC","4","BBGR","8","BGBY","8","BBBC","5","BYBR","soln"
DATA "BBCC","4","BBGR","8","BGBY","10","YBGB","soln"
DATA "BBCC","4","BBGR","8","BGBY","11","BYGB","soln"
DATA "BBCC","4","BBGR","9","BCBB","3","CBGR","soln"
DATA "BBCC","4","BBGR","9","BCBB","5","BCGR","soln"
DATA "BBCC","4","BBGR","11","BCBG","6","GBRB","soln"
DATA "BBCC","4","BBGR","11","BCBG","7","BGRB","soln"
DATA "BBCC","4","BBGR","11","BCBG","8","RBBG","soln"
DATA "BBCC","4","BBGR","11","BCBG","9","BRBG","soln"
DATA "BBCC","4","BBGR","12","BCBR","6","RBGB","soln"
DATA "BBCC","4","BBGR","12","BCBR","7","BRGB","soln"
DATA "BBCC","4","BBGR","12","BCBR","8","GBBR","soln"
DATA "BBCC","4","BBGR","12","BCBR","9","BGBR","soln"
DATA "BBCC","5","BCGR","1","CYBY","1","WWCC","soln"
DATA "BBCC","5","BCGR","1","CYBY","2","CWCC","soln"
DATA "BBCC","5","BCGR","1","CYBY","3","YWCC","soln"
DATA "BBCC","5","BCGR","1","CYBY","4","WYCC","soln"
DATA "BBCC","5","BCGR","1","CYBY","5","CYCC","soln"
DATA "BBCC","5","BCGR","1","CYBY","7","YYCC","soln"
DATA "BBCC","5","BCGR","2","BGBY","0","BBBW","0","CCCC","soln"
DATA "BBCC","5","BCGR","2","BGBY","0","BBBW","1","WCCC","soln"
DATA "BBCC","5","BCGR","2","BGBY","1","YCCC","soln"
DATA "BBCC","5","BCGR","2","BGBY","4","BBBB","5","BBWW","soln"
DATA "BBCC","5","BCGR","2","BGBY","4","BBBB","9","BBWB","soln"
DATA "BBCC","5","BCGR","2","BGBY","5","BBBB","9","BBBW","soln"
DATA "BBCC","5","BCGR","2","BGBY","7","BBBB","5","BBYW","soln"
DATA "BBCC","5","BCGR","2","BGBY","7","BBBB","9","BBYB","soln"
DATA "BBCC","5","BCGR","2","BGBY","8","BBBW","5","BBYY","soln"
DATA "BBCC","5","BCGR","2","BGBY","8","BBBW","8","BBWY","soln"
DATA "BBCC","5","BCGR","2","BGBY","9","BBBY","soln"
DATA "BBCC","5","BCGR","3","BGCY","2","CRBR","3","RWCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","2","CRBR","4","WRCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","2","CRBR","5","CRCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","2","CRBR","7","RRCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","3","WBWC","soln"
DATA "BBCC","5","BCGR","3","BGCY","4","BRBC","2","GWCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","4","BRBC","3","WBCW","soln"
DATA "BBCC","5","BCGR","3","BGCY","4","BRBC","4","RYCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","4","BRBC","5","YRCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","5","CBBW","1","GGCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","5","CBBW","2","CGCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","5","CBBW","3","WGCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","6","BBYY","4","YBWC","soln"
DATA "BBCC","5","BCGR","3","BGCY","6","BBYY","5","WBYC","soln"
DATA "BBCC","5","BCGR","3","BGCY","6","BBYY","8","YBYC","soln"
DATA "BBCC","5","BCGR","3","BGCY","7","BBBB","0","GYCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","7","BBBB","2","YBCW","soln"
DATA "BBCC","5","BCGR","3","BGCY","8","BBBW","0","YGCC","soln"
DATA "BBCC","5","BCGR","3","BGCY","8","BBBW","2","YBCY","soln"
DATA "BBCC","5","BCGR","3","BGCY","8","BBBW","4","WBCY","soln"
DATA "BBCC","5","BCGR","4","CBYW","1","BBBG","0","RCCC","soln"
DATA "BBCC","5","BCGR","4","CBYW","1","BBBG","1","GCCC","soln"
DATA "BBCC","5","BCGR","4","CBYW","2","BBBC","8","BBRB","soln"
DATA "BBCC","5","BCGR","4","CBYW","2","BBBC","9","BBBG","soln"
DATA "BBCC","5","BCGR","4","CBYW","4","BBBG","5","BBRY","soln"
DATA "BBCC","5","BCGR","4","CBYW","4","BBBG","9","BBWG","soln"
DATA "BBCC","5","BCGR","4","CBYW","5","BBBG","5","BBRW","soln"
DATA "BBCC","5","BCGR","4","CBYW","5","BBBG","9","BBYG","soln"
DATA "BBCC","5","BCGR","4","CBYW","6","BBBC","4","BYCY","soln"
DATA "BBCC","5","BCGR","4","CBYW","6","BBBC","5","BWWC","soln"
DATA "BBCC","5","BCGR","4","CBYW","7","BBBC","4","BWCW","soln"
DATA "BBCC","5","BCGR","4","CBYW","7","BBBC","5","BYYC","soln"
DATA "BBCC","5","BCGR","4","CBYW","10","BBBC","4","BWCY","soln"
DATA "BBCC","5","BCGR","4","CBYW","10","BBBC","5","BYWC","soln"
DATA "BBCC","5","BCGR","4","CBYW","11","BBBC","4","BYCW","soln"
DATA "BBCC","5","BCGR","4","CBYW","11","BBBC","5","BWYC","soln"
DATA "BBCC","5","BCGR","5","BYGW","2","BBBB","5","BBRR","soln"
DATA "BBCC","5","BCGR","5","BYGW","2","BBBB","9","BBBR","soln"
DATA "BBCC","5","BCGR","5","BYGW","4","BBBY","5","BBWR","soln"
DATA "BBCC","5","BCGR","5","BYGW","4","BBBY","8","BBYR","soln"
DATA "BBCC","5","BCGR","5","BYGW","5","BBBB","5","BBGG","soln"
DATA "BBCC","5","BCGR","5","BYGW","5","BBBB","9","BBGB","soln"
DATA "BBCC","5","BCGR","5","BYGW","8","BBGY","soln"
DATA "BBCC","5","BCGR","5","BYGW","9","BBGW","soln"
DATA "BBCC","5","BCGR","6","BGCY","3","BBRR","4","RBWC","soln"
DATA "BBCC","5","BCGR","6","BGCY","3","BBRR","5","WBRC","soln"
DATA "BBCC","5","BCGR","6","BGCY","3","BBRR","8","RBRC","soln"
DATA "BBCC","5","BCGR","6","BGCY","4","BBBB","0","GRCC","soln"
DATA "BBCC","5","BCGR","6","BGCY","4","BBBB","2","RBCW","soln"
DATA "BBCC","5","BCGR","6","BGCY","5","RGCC","soln"
DATA "BBCC","5","BCGR","6","BGCY","6","BBRB","2","GBWC","soln"
DATA "BBCC","5","BCGR","6","BGCY","6","BBRB","4","RBYC","soln"
DATA "BBCC","5","BCGR","6","BGCY","6","BBRB","5","YBRC","soln"
DATA "BBCC","5","BCGR","6","BGCY","7","BBBW","2","GBCG","soln"
DATA "BBCC","5","BCGR","6","BGCY","7","BBBW","4","WBCG","soln"
DATA "BBCC","5","BCGR","6","BGCY","7","BBBW","5","GBCW","soln"
DATA "BBCC","5","BCGR","6","BGCY","8","RBCY","soln"
DATA "BBCC","5","BCGR","6","BGCY","10","GBYC","soln"
DATA "BBCC","5","BCGR","6","BGCY","11","YBCG","soln"
DATA "BBCC","5","BCGR","6","BGCY","12","GBCY","soln"
DATA "BBCC","5","BCGR","7","BCRY","3","BBBW","2","GBGC","soln"
DATA "BBCC","5","BCGR","7","BCRY","3","BBBW","4","WBGC","soln"
DATA "BBCC","5","BCGR","7","BCRY","4","BBCW","5","BGCG","soln"
DATA "BBCC","5","BCGR","7","BCRY","4","BBCW","7","BGWC","soln"
DATA "BBCC","5","BCGR","7","BCRY","4","BBCW","8","BWCG","soln"
DATA "BBCC","5","BCGR","7","BCRY","4","BBCW","9","BGCW","soln"
DATA "BBCC","5","BCGR","7","BCRY","5","BBRG","soln"
DATA "BBCC","5","BCGR","7","BCRY","6","BBCW","4","YBGC","soln"
DATA "BBCC","5","BCGR","7","BCRY","6","BBCW","5","RBCR","soln"
DATA "BBCC","5","BCGR","7","BCRY","6","BBCW","8","WBCR","soln"
DATA "BBCC","5","BCGR","7","BCRY","7","BBCG","4","BRWC","soln"
DATA "BBCC","5","BCGR","7","BCRY","7","BBCG","5","BRCW","soln"
DATA "BBCC","5","BCGR","7","BCRY","7","BBCG","7","BGYC","soln"
DATA "BBCC","5","BCGR","7","BCRY","7","BBCG","9","BYCG","soln"
DATA "BBCC","5","BCGR","7","BCRY","8","BBCW","4","BRRC","soln"
DATA "BBCC","5","BCGR","7","BCRY","8","BBCW","5","BGCY","soln"
DATA "BBCC","5","BCGR","7","BCRY","8","BBCW","7","BWRC","soln"
DATA "BBCC","5","BCGR","7","BCRY","10","YBCR","soln"
DATA "BBCC","5","BCGR","7","BCRY","11","BRYC","soln"
DATA "BBCC","5","BCGR","7","BCRY","12","BBBC","4","BRCY","soln"
DATA "BBCC","5","BCGR","7","BCRY","12","BBBC","5","BYRC","soln"
DATA "BBCC","5","BCGR","8","GYCW","2","BRCR","soln"
DATA "BBCC","5","BCGR","8","GYCW","3","BGGC","soln"
DATA "BBCC","5","BCGR","8","GYCW","4","BWCR","soln"
DATA "BBCC","5","BCGR","8","GYCW","5","BYCR","soln"
DATA "BBCC","5","BCGR","8","GYCW","6","BWGC","soln"
DATA "BBCC","5","BCGR","8","GYCW","7","BYGC","soln"
DATA "BBCC","5","BCGR","9","BBGR","soln"
DATA "BBCC","5","BCGR","10","BBBC","4","RBCG","soln"
DATA "BBCC","5","BCGR","10","BBBC","5","GBRC","soln"
DATA "BBCC","5","BCGR","11","BGCG","6","RBGC","soln"
DATA "BBCC","5","BCGR","11","BGCG","7","GBCR","soln"
DATA "BBCC","5","BCGR","11","BGCG","8","BGRC","soln"
DATA "BBCC","5","BCGR","11","BGCG","9","BRCG","soln"
DATA "BBCC","5","BCGR","12","BBBC","4","BGCR","soln"
DATA "BBCC","5","BCGR","12","BBBC","5","BRGC","soln"
DATA "BBCC","6","BCBG","4","BBRY","1","CCWB","soln"
DATA "BBCC","6","BCBG","4","BBRY","3","CCYB","soln"
DATA "BBCC","6","BCBG","4","BBRY","4","CCRB","soln"
DATA "BBCC","6","BCBG","5","BBRY","1","CCBW","soln"
DATA "BBCC","6","BCBG","5","BBRY","3","CCBR","soln"
DATA "BBCC","6","BCBG","5","BBRY","4","CCBY","soln"
DATA "BBCC","6","BCBG","7","BRBY","1","CCGB","soln"
DATA "BBCC","6","BCBG","7","BRBY","4","CWBB","soln"
DATA "BBCC","6","BCBG","7","BRBY","7","CYBB","soln"
DATA "BBCC","6","BCBG","7","BRBY","8","CRBB","soln"
DATA "BBCC","6","BCBG","8","RBBY","4","WCBB","soln"
DATA "BBCC","6","BCBG","8","RBBY","7","YCBB","soln"
DATA "BBCC","6","BCBG","8","RBBY","8","RCBB","soln"
DATA "BBCC","6","BCBG","9","CCBG","soln"
DATA "BBCC","6","BCBG","11","CGBB","soln"
DATA "BBCC","6","BCBG","12","GCBB","soln"
DATA "BBCC","7","BCBG","3","BRBY","1","CWCB","soln"
DATA "BBCC","7","BCBG","3","BRBY","3","CYCB","soln"
DATA "BBCC","7","BCBG","3","BRBY","4","CRCB","soln"
DATA "BBCC","7","BCBG","4","BCRY","3","CWBC","soln"
DATA "BBCC","7","BCBG","4","BCRY","4","BBBW","1","CCCB","soln"
DATA "BBCC","7","BCBG","4","BCRY","4","BBBW","3","WCCB","soln"
DATA "BBCC","7","BCBG","4","BCRY","6","BBBR","2","CYBC","soln"
DATA "BBCC","7","BCBG","4","BCRY","6","BBBR","4","CRBC","soln"
DATA "BBCC","7","BCBG","4","BCRY","7","BBBR","1","YCCB","soln"
DATA "BBCC","7","BCBG","4","BCRY","7","BBBR","3","RCCB","soln"
DATA "BBCC","7","BCBG","5","BBRY","1","BBBW","2","CCBC","soln"
DATA "BBCC","7","BCBG","5","BBRY","1","BBBW","4","WCBC","soln"
DATA "BBCC","7","BCBG","5","BBRY","3","BBBR","2","YCBC","soln"
DATA "BBCC","7","BCBG","5","BBRY","3","BBBR","4","RCBC","soln"
DATA "BBCC","7","BCBG","6","BBRY","1","CGCB","soln"
DATA "BBCC","7","BCBG","6","BBRY","4","CBWB","soln"
DATA "BBCC","7","BCBG","6","BBRY","7","CBYB","soln"
DATA "BBCC","7","BCBG","6","BBRY","8","CBRB","soln"
DATA "BBCC","7","BCBG","7","BBBR","1","GCCB","soln"
DATA "BBCC","7","BCBG","7","BBBR","2","CGBC","soln"
DATA "BBCC","7","BCBG","7","BBBR","5","BBBY","5","CBBW","soln"
DATA "BBCC","7","BCBG","7","BBBR","5","BBBY","9","CBBY","soln"
DATA "BBCC","7","BCBG","7","BBBR","8","CBBB","soln"
DATA "BBCC","7","BCBG","7","BBBR","9","CBBR","soln"
DATA "BBCC","7","BCBG","8","BBRY","1","GCBC","soln"
DATA "BBCC","7","BCBG","8","BBRY","4","BCWB","soln"
DATA "BBCC","7","BCBG","8","BBRY","7","BCYB","soln"
DATA "BBCC","7","BCBG","8","BBRY","8","BCRB","soln"
DATA "BBCC","7","BCBG","9","BBBR","5","BBBY","5","BCBW","soln"
DATA "BBCC","7","BCBG","9","BBBR","5","BBBY","9","BCBY","soln"
DATA "BBCC","7","BCBG","9","BBBR","8","BCBB","soln"
DATA "BBCC","7","BCBG","9","BBBR","9","BCBR","soln"
DATA "BBCC","7","BCBG","10","CBGB","soln"
DATA "BBCC","7","BCBG","12","BBBC","7","BCGB","soln"
DATA "BBCC","7","BCBG","12","BBBC","8","CBBG","soln"
DATA "BBCC","8","BCCG","3","RBBY","5","WBBC","soln"
DATA "BBCC","8","BCCG","3","RBBY","8","YBBC","soln"
DATA "BBCC","8","BCCG","3","RBBY","9","RBBC","soln"
DATA "BBCC","8","BCCG","4","RYBC","3","WBCB","soln"
DATA "BBCC","8","BCCG","4","RYBC","5","BWBC","soln"
DATA "BBCC","8","BCCG","4","RYBC","6","YBCB","soln"
DATA "BBCC","8","BCCG","4","RYBC","7","RBCB","soln"
DATA "BBCC","8","BCCG","4","RYBC","8","BRBC","soln"
DATA "BBCC","8","BCCG","4","RYBC","9","BYBC","soln"
DATA "BBCC","8","BCCG","5","BRBY","4","BWCB","soln"
DATA "BBCC","8","BCCG","5","BRBY","7","BYCB","soln"
DATA "BBCC","8","BCCG","5","BRBY","8","BRCB","soln"
DATA "BBCC","8","BCCG","6","CBRY","4","GBBC","soln"
DATA "BBCC","8","BCCG","6","CBRY","5","CBWC","soln"
DATA "BBCC","8","BCCG","6","CBRY","8","CBYC","soln"
DATA "BBCC","8","BCCG","6","CBRY","9","CBRC","soln"
DATA "BBCC","8","BCCG","7","CBRY","3","BGBC","soln"
DATA "BBCC","8","BCCG","7","CBRY","4","GBCB","soln"
DATA "BBCC","8","BCCG","7","CBRY","5","CBCW","soln"
DATA "BBCC","8","BCCG","7","CBRY","8","CBCR","soln"
DATA "BBCC","8","BCCG","7","CBRY","9","CBCY","soln"
DATA "BBCC","8","BCCG","8","BCRY","4","BGCB","soln"
DATA "BBCC","8","BCCG","8","BCRY","5","BCWC","soln"
DATA "BBCC","8","BCCG","8","BCRY","8","BCYC","soln"
DATA "BBCC","8","BCCG","8","BCRY","9","BCRC","soln"
DATA "BBCC","8","BCCG","9","BBRY","2","BCCW","soln"
DATA "BBCC","8","BCCG","9","BBRY","4","BCCR","soln"
DATA "BBCC","8","BCCG","9","BBRY","5","BCCY","soln"
DATA "BBCC","8","BCCG","10","CBGC","soln"
DATA "BBCC","8","BCCG","12","BBBC","4","CBCG","soln"
DATA "BBCC","8","BCCG","12","BBBC","5","BCGC","soln"
DATA "BBCC","9","BCCG","4","BBBR","5","BBBY","5","BBWC","soln"
DATA "BBCC","9","BCCG","4","BBBR","5","BBBY","8","BBYC","soln"
DATA "BBCC","9","BCCG","4","BBBR","8","BBRC","soln"
DATA "BBCC","9","BCCG","4","BBBR","9","BBBC","soln"
DATA "BBCC","9","BCCG","5","BBBR","5","BBBY","5","BBCW","soln"
DATA "BBCC","9","BCCG","5","BBBR","5","BBBY","9","BBCY","soln"
DATA "BBCC","9","BCCG","5","BBBR","8","BBCB","soln"
DATA "BBCC","9","BCCG","5","BBBR","9","BBCR","soln"
DATA "BBCC","9","BCCG","7","BBRY","2","BBBW","2","CBCC","soln"
DATA "BBCC","9","BCCG","7","BBRY","2","BBBW","4","WBCC","soln"
DATA "BBCC","9","BCCG","7","BBRY","4","BBBR","2","YBCC","soln"
DATA "BBCC","9","BCCG","7","BBRY","4","BBBR","4","RBCC","soln"
DATA "BBCC","9","BCCG","7","BBRY","5","BBGC","soln"
DATA "BBCC","9","BCCG","8","BRBY","2","BWCC","soln"
DATA "BBCC","9","BCCG","8","BRBY","4","BYCC","soln"
DATA "BBCC","9","BCCG","8","BRBY","5","BRCC","soln"
DATA "BBCC","9","BCCG","9","BBBB","2","BCCC","soln"
DATA "BBCC","9","BCCG","9","BBBB","5","BBCG","soln"
DATA "BBCC","9","BCCG","11","GBCC","soln"
DATA "BBCC","9","BCCG","12","BGCC","soln"
DATA "BBCC","10","CCBB","soln"
DATA "BBCC","12","BCBG","6","CBCB","soln"
DATA "BBCC","12","BCBG","7","CBBC","soln"
DATA "BBCC","12","BCBG","8","BCCB","soln"
DATA "BBCC","12","BCBG","9","BCBC","soln"

sub LoadSolveTable
   dim i, j as integer
   dim colorcode as string
   dim cresult as string
   
   restore solvedata
   
   for i = 0 to 1274
      for j = 0 to 4
         read colorcode
         read cresult
         if cresult <> "soln" then
            solvetable(j, i).colorinfo = colorcode
            solvetable(j, i).markers = val(cresult)
            'print j, i, solvetable(j, i).colorinfo, solvetable(j, i).markers
         else
            solvetable(j, i).colorinfo = colorcode
            solvetable(j, i).markers = -1
            exit for
            'print j, i, solvetable(j, i).colorinfo, solvetable(j, i).markers
         end if
      next
   next
end sub

sub Intro
   dim txt as string
   dim i as integer
   dim x, y as integer

   'Turn off the mouse
   setmouse ,,0
   'print the title
   color White, Black
   txt = "MASTER CODE BREAKER"
   CenterText 2, txt
   'show a little animation on the screen
   y = 12
   x = 75
   for i = 1 to 28
      DrawPeg Red, y, x
      sleep 100
      DrawPeg Black, y, x
      x = x - 2
      if inkey$<>"" then exit sub
   next i
   DrawPeg Red, y, x
   x = 75
   for i = 1 to 24
      DrawPeg Blue, y, x
      sleep 100
      DrawPeg Black, y, x
      x = x - 2
      if inkey$<>"" then exit sub
   next i
   DrawPeg Blue, y, x
   x = 75
   for i = 1 to 20
      DrawPeg Green, y, x
      sleep 100
      DrawPeg Black, y, x
      x = x - 2
      if inkey$<>"" then exit sub
   next i
   DrawPeg Green, y, x
   x = 75
   for i = 1 to 16
      DrawPeg Yellow, y, x
      sleep 100
      DrawPeg Black, y, x
      x = x - 2
      if inkey$<>"" then exit sub
   next i
   DrawPeg Yellow, y, x
   x = 75
   for i = 1 to 12
      DrawPeg DkGrey, y, x
      sleep 100
      DrawPeg Black, y, x
      x = x - 2
      if inkey$<>"" then exit sub
   next i
   DrawPeg DkGrey, y, x
   x = 75
   for i = 1 to 8
      DrawPeg White, y, x
      sleep 100
      DrawPeg Black, y, x
      x = x - 2
      if inkey$<>"" then exit sub
   next i
   DrawPeg White, y, x

   'let user marvel at the ascii :)
   color Yellow, Black
   txt = "Press Any Key"
   CenterText 23, txt
   sleep
end sub

'draws a peg in the specified color and x, y
sub DrawPeg(pcolor as integer, y as integer, x as integer)
   color pcolor, Black
   'x, y describes the upper left coord of the peg
   locate y, x
   'draw the top border
   print string$(2, chr$(178))
   locate y + 1, x
   print string$(2, chr$(178))
end sub

'draws a box on the screen with color, at x, y, with width, height
'boxtype = 1 , single line, boxtype = 2, double line
sub DrawBox (bcolor as integer, y as integer, x as integer, bheight as integer, bwidth as integer, btype as integer)
   dim i as integer
   
   'draw the top 
   color bcolor, Black
   locate y, x
   if btype = singleline then
      print chr$(218);
      print string$(bwidth - 2, chr$(196));
      print chr$(191);
   else
      print chr$(201);
      print string$(bwidth - 2, chr$(205));
      print chr$(187);
   end if
   'draw the middle 
   for i = y + 1 to y + (bheight - 1)
      'draw left side
      locate i, x
      if btype = singleline then
         print chr$(179)
      else
         print chr$(186)
      end if
      'draw right side
      locate i, x + (bwidth - 1)
      if btype = singleline then
         print chr$(179)
      else
         print chr$(186)
      end if
   next i
   'draw the bottom 
   locate y + bheight, x
   if btype = singleline then
      print chr$(192);
      print string$(bwidth - 2, chr$(196));
      print chr$(217);
   else
      print chr$(200);
      print string$(bwidth - 2, chr$(205));
      print chr$(188);
   end if
end sub

sub DrawRow(rownum as integer, ccode as string, ptype as integer)
   dim y, x as integer
   dim i as integer
   dim ch as string
   dim pcolor as integer
   
   'set the row coord
   if ptype = playerturn then
      x = 13
   else
      x = 45
   end if
   y = GetRowY(rownum)
   'print out the pegs
   for i = 1 to len(ccode)
      ch = mid$(ccode, i, 1)
      if ch = "X" then
         pcolor = DkCyan
      elseif ch = "R" then
         pcolor = Red
      elseif ch = "C" then
         pcolor = Blue
      elseif ch = "G" then
         pcolor = Green
      elseif ch = "Y" then
         pcolor = Yellow
      elseif ch = "B" then
         pcolor = DkGrey
      elseif ch = "W" then
         pcolor = White
      elseif ch = "Q" then
         pcolor = LtGrey
      end if
      DrawPeg pcolor, y, x
      x = x + 3
   next i

end sub

sub DrawDecode(rownum as integer, ccode as string, ptype as integer)
   dim y, x as integer
   dim i as integer
   dim ch as string
   dim pcolor as integer
   
   'set the row coord
   if ptype = playerturn then
      x = 28
   else
      x = 60
   end if
   select case rownum
      case row6
         y = 5
      case row5
         y = 8
      case row4
         y = 11
      case row3
         y = 14
      case row2
         y = 17
      case row1
         y = 20
   end select
   'print out the pegs
   for i = 1 to len(ccode)
      ch = mid$(ccode, i, 1)
      if ch = "X" then
         pcolor = DkCyan
      elseif ch = "B" then
         pcolor = DkGrey
      elseif ch = "W" then
         pcolor = White
      end if
      DrawPeg pcolor, y, x
      x = x + 3
   next i

end sub

sub CenterText(tRow as integer, txt as string)
   locate trow, 40 - (len(txt) / 2)
   print txt
end sub 

function GetRandom(lowerbound as integer, upperbound as integer) as integer
   GetRandom = Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
end function

sub GetComputerSecret
   dim i, sel as integer

   'generate computer secrets
   csecret=""
   for i = 1 to 4
      sel = GetRandom(pred, pwhite)
      select case sel
         case pred
            csecret = csecret + "R"
         case pblue
            csecret = csecret + "C"
         case pgreen
            csecret = csecret + "G"
         case pyellow
            csecret = csecret + "Y"
         case pblack
            csecret = csecret + "B"
         case pwhite
            csecret = csecret + "W"
      end select
   next i
   if showsecret = False then
      DrawRow Row6, "QQQQ", computerturn
   else
      DrawRow Row6, csecret, computerturn
   end if
end sub

sub GetPlayerMove(secret as integer = false)
   dim i, sel as integer
   dim ch as string
   dim coln as integer
   dim tcode as string
   
   if not secret then
      DrawCurrent Yellow
   end if
   tcode = "XXXX"
   i = 1
   do
      'get the player code
      color Yellow, LtBlue
      locate 24, 1
      if secret then
         print "(Secret) ";
      else
         print " ";
      end if
      print "Enter color code for position ";str$(i);" or C to clear last color.";
      ch = inkey$
      ch = ucase$(ch)
      if ch = "Q" then end
      if ch = "C" then
         i = i - 1
         if i < 1 then i = 1
         mid$(tcode, i) = "X"
      else
         coln = val(ch)
         if coln >= 1 and coln <= 6 then
            mid$(tcode, i) = GetColorCode(coln)
            i = i + 1
         end if
         if secret then
            DrawRow Row6, tcode, playerturn
         else
            DrawRow currow, tcode, playerturn
         end if
         if i = 5 then
            color Yellow, LtBlue
            locate 24, 1
            print space$(75)
            locate 24, 1
            print "Accept Code? (Y/N)";
            do
               ch = inkey$
               ch = ucase$(ch)
               if ch = "N" or ch = "Y" then
                  if ch = "N" then
                     i = i - 1
                     mid$(tcode, i) = "X"
                     if secret then
                        DrawRow Row6, tcode, playerturn
                     else
                        DrawRow currow, tcode, playerturn
                     end if
                  end if
               end if
            loop until ch <> ""
         end if
      end if
   loop until i = 5
   if secret then
      psecret = tcode
      if showsecret = False then
         DrawRow Row6, "QQQQ", playerturn
      else
         DrawRow Row6, psecret, playerturn
      end if
   else
      DrawCurrent Black
      prowcode = tcode
   end if
   color Yellow, LtBlue
   locate 24, 1
   print space$(75)
end sub

function GetColorCode(ccn as integer) as string
   dim sret as string

   select case ccn
      case pred
         sret = "R"
      case pblue
         sret = "C"
      case pgreen
         sret = "G"
      case pyellow
         sret = "Y"
      case pblack
         sret = "B"
      case pwhite
         sret = "W"
   end select

   GetColorCode = sret
end function

function GetRowY(rownum as integer) as integer
   dim iret as integer

   select case rownum
      case row6
         iret = 5
      case row5
         iret = 8
      case row4
         iret = 11
      case row3
         iret = 14
      case row2
         iret = 17
      case row1
         iret = 20
   end select
   GetRowY = iret
end function

sub DrawCurrent(dcolor as integer)
   dim x, y as integer
   
   x = 12
   y = GetRowY(currow)
   y = y - 1
   DrawBox dcolor, y, x, 3, 13, singleline
end sub

sub GetComputerMove
   dim i as integer
   
   'standard first move
   if currow = row1 then
      crowcode = "BBCC"
   else
      'match current move list to solve table and get next move
      for i = 0 to 1274
         'taking the lazy way here.
         select case currow
            case row2
               if csolve(1).colorinfo = solvetable(0, i).colorinfo and _
                  csolve(1).markers = solvetable(0, i).markers then
                  crowcode = solvetable(1, i).colorinfo
                  exit for
               end if
            case row3
               if csolve(1).colorinfo = solvetable(0, i).colorinfo and _
                  csolve(1).markers = solvetable(0, i).markers and _
                  csolve(2).colorinfo = solvetable(1, i).colorinfo and _
                  csolve(2).markers = solvetable(1, i).markers then
                  crowcode = solvetable(2, i).colorinfo
                  exit for
               end if
            case row4
               if csolve(1).colorinfo = solvetable(0, i).colorinfo and _
                  csolve(1).markers = solvetable(0, i).markers and _
                  csolve(2).colorinfo = solvetable(1, i).colorinfo and _
                  csolve(2).markers = solvetable(1, i).markers and _
                  csolve(3).colorinfo = solvetable(2, i).colorinfo and _
                  csolve(3).markers = solvetable(2, i).markers then
                  crowcode = solvetable(3, i).colorinfo
                  exit for
               end if
            case row5
               if csolve(1).colorinfo = solvetable(0, i).colorinfo and _
                  csolve(1).markers = solvetable(0, i).markers and _
                  csolve(2).colorinfo = solvetable(1, i).colorinfo and _
                  csolve(2).markers = solvetable(1, i).markers and _
                  csolve(3).colorinfo = solvetable(2, i).colorinfo and _
                  csolve(3).markers = solvetable(2, i).markers and _
                  csolve(4).colorinfo = solvetable(3, i).colorinfo and _
                  csolve(4).markers = solvetable(3, i).markers then
                  crowcode = solvetable(4, i).colorinfo
                  locate 1,1: print crowcode
                  exit for
               end if
         end select
      next i
   end if
   'save the guess
   with csolve(currow)
      .colorinfo = crowcode
      .markers = 0
   end with
   DrawRow currow, crowcode, computerturn
end sub

sub PlayerDecode
   dim i, j as integer
   dim pc(1 to 4) as string 'current guess
   dim ps(1 to 4) as string 'match code
   dim secretchecked(1 to 4) as integer 'check flag for secret
   dim decode as string = "XXXX"
   dim temp as string
   dim tcode as string
   dim cnt as integer
   
   'load guess/secret values into arrays
   for i = 1 to 4
      pc(i) = mid$(prowcode, i, 1)
      ps(i) = mid$(csecret, i, 1)
      secretchecked(i) = False
   next i
   cnt = 0
   'check for winning code
   for i = 1 to 4
      if pc(i) = ps(i) then
         cnt = cnt + 1
         mid$(decode, i) = "B"
         secretchecked(i) = True
      end if
   next i
   'if all matched then exit
   if cnt = 4 then
      pwin = True
      DrawDecode currow, decode, playerturn
      exit sub
   end if
   'check for player white markers
   for i = 1 to 4
      'guess position didn't match 
      if mid$(decode, i, 1) = "X" then
         'search for a match in secret
         for j = 1 to 4
            if secretchecked(j) = False then
               if pc(i) = ps(j) then
                  mid$(decode, i) = "W"
                  secretchecked(j) = True
               end if
            end if
         next j
      end if
   next i
   'mix up the player decode
   for i = 1 to 4
      cnt = GetRandom(1,4)
      temp = mid$(decode, i, 1)
      mid$(decode, i) = mid$(decode, cnt, 1)
      mid$(decode, cnt) = temp
   next i
   'format the values
   for i = 1 to 4
      if mid$(decode, i, 1) = "W" or mid$(decode, i, 1) = "B" then
         tcode = tcode + mid$(decode, i, 1)
      end if
   next i
   if len(tcode) < 4 then
      tcode = tcode + string$(4 - len(tcode), "X")
   end if
   'show the player decode
   DrawDecode currow, tcode, playerturn
   if currow = row5 then
      DrawBox Yellow, 4, 12, 3, 13, singleline
   end if
end sub

sub ComputerDecode
   dim i, j as integer
   dim cc(1 to 4) as string 'current computer guess
   dim cs(1 to 4) as string 'computer match code
   dim secretchecked(1 to 4) as integer 'check flag for secret
   dim decode as string = "XXXX"
   dim temp as string
   dim tcode as string
   dim cnt as integer
   
   'load guess/secret values into arrays
   for i = 1 to 4
      cc(i) = mid$(crowcode, i, 1)
      cs(i) = mid$(psecret, i, 1)
      secretchecked(i) = False
   next i
   'check for winning code
   cnt = 0
   for i = 1 to 4
      if cc(i) = cs(i) then
         cnt = cnt + 1
         mid$(decode, i) = "B"
         secretchecked(i) = True
      end if
   next i
   'if all matched then exit
   if cnt = 4 then
      cwin = True
      DrawDecode currow, decode, playerturn
      exit sub
   end if
   'check for computer white markers
   for i = 1 to 4
      'guess position didn't match 
      if mid$(decode, i, 1) = "X" then
         'search for a match in secret
         for j = 1 to 4
            if secretchecked(j) = False then
               if cc(i) = cs(j) then
                  mid$(decode, i) = "W"
                  secretchecked(j) = True
               end if
            end if
         next j
      end if
   next i
   'mix up the computer decode
   for i = 1 to 4
      cnt = GetRandom(1,4)
      temp = mid$(decode, i, 1)
      mid$(decode, i) = mid$(decode, cnt, 1)
      mid$(decode, cnt) = temp
   next i
   'format the values
   for i = 1 to 4
      if mid$(decode, i, 1) = "W" or mid$(decode, i, 1) = "B" then
         tcode = tcode + mid$(decode, i, 1)
      end if
   next i
   if len(tcode) < 4 then
      tcode = tcode + string$(4 - len(tcode), "X")
   end if
   'show the player decode
   DrawDecode currow, tcode, computerturn
   if currow = row5 then
      DrawBox Yellow, 4, 12, 3, 13, singleline
   end if
   'get the marker code and load into solve chain
   csolve(currow).markers = GetMarkers(decode)
end sub

function GetMarkers(scode as string) as integer
   dim mblack, mwhite as integer
   dim i as integer
   dim ret as integer

   mblack = 0: mwhite = 0
   for i = 1 to len(scode)
      if mid$(scode, i, 1) = "B" then mblack = mblack + 1
      if mid$(scode, i, 1) = "W" then mwhite = mwhite + 1
   next i

   'Get the marker code
   if mblack = 0 and mwhite = 0 then ret = 0
   if mblack = 0 and mwhite = 1 then ret = 1
   if mblack = 1 and mwhite = 0 then ret = 2
   if mblack = 0 and mwhite = 2 then ret = 3
   if mblack = 1 and mwhite = 1 then ret = 4
   if mblack = 2 and mwhite = 0 then ret = 5
   if mblack = 0 and mwhite = 3 then ret = 6
   if mblack = 1 and mwhite = 2 then ret = 7
   if mblack = 2 and mwhite = 1 then ret = 8
   if mblack = 3 and mwhite = 0 then ret = 9
   if mblack = 0 and mwhite = 4 then ret = 10
   if mblack = 1 and mwhite = 3 then ret = 11
   if mblack = 2 and mwhite = 2 then ret = 12
   if mblack = 4 and mwhite = 0 then ret = 13

   GetMarkers = ret
end function
