'===========================================================================================
'Module: rldata.bi
'Author: Richard D. Clark
'Version: 0.1
'Desc: These are the data objects used in the program.
'===========================================================================================

'---------------------------------------------------------------------
'Program Defines
'---------------------------------------------------------------------
#Define sw 640   'Screen width
#Define sh 480   'Screen height
#Define tcols 80 'screen text cols
#Define trows 60 'screen text rows
#Define twh 8    'size of font
#Define mapw 100 'map width
#Define maph 100 'map height
#Define vw 50 'viewport width
#Define vh 55 'viewport height
#Define maxlevel 26 'number of levels
#Define imax(a,b) IIf( a > b, a, b ) 'return max of two items
'Min and max room dimensions
#Define roommax 8 
#Define roommin 4
#Define nroommin 20
#Define nroommax 50 
'Empty cell flag.
#Define emptycell 0
'Number of main menu utems.
#Define NumMainMenuItems 5

'---------------------------------------------------------------------
'Program Const Values
'---------------------------------------------------------------------
'Grid cell size (width and height)
Const csize = 10
'Grid dimensions.
Const gw = mapw \ csize
Const gh = maph \ csize

Const lbversion = "0.1" 'Program version 
const xk = Chr(255)     'Key consts
const key_up = xk + "H"
const key_dn = xk + "P"
const key_rt = xk + "M"
const key_lt = xk + "K"
Const key_F1 = xk + Chr(59)
Const key_F2 = xk + Chr(60)
Const key_F3 = xk + Chr(61)
Const key_F4 = xk + Chr(62)
Const key_F5 = xk + Chr(63)
Const key_F6 = xk + Chr(64)
Const key_F7 = xk + Chr(65)
Const key_F8 = xk + Chr(66)
const key_close = xk + "k" 'Window x close
Const key_esc = Chr(27)
Const key_enter = Chr(13)
Const key_space = Chr(32)

'---------------------------------------------------------------------
'Program Enum Values
'---------------------------------------------------------------------

'Menu returns
Enum mainmenuid
	mNewGame
	mLoadGame
	mCredits
	mGameInfo
	mQuit
	mClose
End Enum

'Compass directions
Enum compass
	north
	neast
	east
	seast
	south
	swest
	west
	nwest
End Enum

'Define true/false.
Enum boolean
	FALSE = 0
	TRUE = Not FALSE
End Enum

'Terrain ids. Add any terrain ids here.
Enum terrids
	twall = 1    'wall
	tfloor       'floor
	tdooropen    'open door
	tdoorclosed  'codes door
	tsup         'stairs up
	tsdn         'stairs down
End Enum

'---------------------------------------------------------------------
'Program Type Defs
'---------------------------------------------------------------------

'Coordinates.
Type mcoord
	x As Integer
	y As Integer
End Type

'Room dimensions.
Type rmdim
	rwidth As Integer
	rheight As Integer
	rcoord As mcoord
End Type

'Room information
Type roomtype
	roomdim As rmdim  'Room width and height.
	tl As mcoord      'Room rect
	br As mcoord
End Type

'Grid cell structure.
Type celltype
	cellcoord As mcoord 'The cell position.
	room As Integer     'Room id. This is an index into the room array.
End Type

'Level information. Add general level info here.
Type levelinfotype
	mlevel As Integer     'Current level of dungeon
End Type

'Map info type. Add specific cell info here.
Type cellinfotype
	terrid As terrids     'The terrain id
	hasmonster As boolean 'Current cell has a monster.
	hasitem As boolean    'Current cell has an item.
	visible As boolean    'Player can see cell.
	seen As boolean       'Player has seen cell.
End Type

'Map cell array type.
Type maptype
	levelinfo As levelinfotype
	lmap(1 To mapw, 1 To maph) As cellinfotype
End Type

'Player character type. Add player info here.
Type playertype
   pcoord As mcoord  'current x,y position
   currhp As Integer 'current hp.
   maxhp As Integer  'max hp.
End Type

'---------------------------------------------------------------------
'Program Working vars.
'---------------------------------------------------------------------
'Map generation vars.
Dim Shared rooms(1 To nroommax) As roomtype    'Room array.
Dim Shared grid(1 To gw, 1 To gh) As celltype 'Grid of cells.
Dim Shared as Integer numrooms                'Number of rooms in map.
'Level and player vars.
Dim Shared level As maptype      'Current level info.
Dim Shared player As playertype  'Player character info.
'Direction matrix. Used in iterating through tiles based on dirction.
Dim Shared dirmatrix(north To nwest) As mcoord = {(0, -1), (1, -1), (1, 0), (1, 1), (0, 1), (-1, 1), (-1, 0), (-1, -1)}
Dim As String ch 'Used with inkey for key codes. 
Dim As boolean isdead = FALSE, didwin = FALSE, done = FALSE
Dim As Integer xx, yy 'Player move working vars.
Dim mmenu As mainmenuid 'Main menu return variable.
