'===========================================================================================
'Name: Roguelike Engine
'Author: Richard D. Clark
'Version: 0.1
'Desc: This is a basic, working roguelike engine that includes a dungeon generator, moveable 
'      character and main display. This template can be used to create any type of roguelike game. 
'      To be useful though, the base will need to be expanded with a stat system, inventory and enemies. 
'License: GPL 3.0
' This program is free software; you can redistribute it and/or modify it but WITHOUT ANY WARRANTY; 
' without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'===========================================================================================
#Include "colors.bi"
#Include "rldata.bi"
#Include "rlutils.bi"
#Include "rlmap.bi"
#Include "rlmenus.bi"


'Initilize program.
Sub InitProgram
	'Init the level info.
	level.levelinfo.mlevel = 1
	player.maxhp = 100
	player.currhp = player.maxhp
End Sub

'Redraws the map area.
Sub DrawMapDisplay
	Dim As Integer x, y
	Dim As UInteger clr
	
	DrawMap
End Sub

'Draws message area
Sub DrawMessageArea
	Dim As Integer x, y, i
	Dim As UInteger clr, bcolor
	
	'Draw messages here.
			
	'Draw border around message area.
	Line (0, (vh * twh) - 1) - (sw - 1, (vh * twh) - 1), fbYellow 
End Sub

'Draws the status area.
Sub DrawStatusArea
	Dim As Integer x, y, row, col, hcnt
	Dim As UInteger clr
	Dim As Single pct
	Dim As String txt
			
	col = vw + 2
	row = 2
	'Print the current level.
	txt = "Level: " & level.levelinfo.mlevel
	PutText txt, row, col, fbWhite
	
	'Draw the player info here.
	If player.currhp > 74 Then
		clr = fbGreen
	ElseIf (player.currhp > 24) And (player.currhp < 75) Then
		clr = fbYellow
	Else
		clr = fbRed
	EndIf
	row += 2
	hcnt = 15
	txt = "Health: " & String(hcnt, Chr(176))
	PutText txt, row, col, fbWhite
	pct = player.currhp / player.maxhp
	hcnt *= pct
	txt = "Health: " & String(hcnt, Chr(219))
	PutText txt, row, col, clr
	 
	'Draw border around status area.
	Line ((col - 2) * twh, 0)-((col - 2) * twh, (vh * twh) - 1), fbYellow
End Sub

'Draws the main game screen.
Sub DrawMainScreen
	ScreenLock
	Cls
	'Draw the map.
	DrawMapDisplay
	'DrawMessage area.
	DrawMessageArea
	'Draw status area
	DrawStatusArea
	ScreenUnLock
End Sub

'Moves player icon on screen.
Sub Move (newx As Integer, newy As Integer)
	Dim txt As String
	
	'Check for monster location.
	If level.lmap(newx, newy).hasmonster = TRUE Then
		'Do combat here.
	'Check for blocking tile.
	ElseIf BlockingTile(newx, newy) = FALSE Then
		player.pcoord.x = newx
		player.pcoord.y = newy
	ElseIf (level.lmap(newx, newy).terrid = tsup) Or (level.lmap(newx, newy).terrid = tsdn) Then
		player.pcoord.x = newx
		player.pcoord.y = newy
	'Check for closed door.
	ElseIf level.lmap(newx, newy).terrid = tdoorclosed Then
		level.lmap(newx, newy).terrid = tdooropen
		player.pcoord.x = newx
		player.pcoord.y = newy
	End If
	'Check for an item.
	If level.lmap(newx, newy).hasitem = TRUE Then
		'Do item description.
	End If
	DrawMainScreen
	'Clear key buffer.
	Do
		Sleep 1
	Loop Until InKey = ""
End Sub

'---------------------------------------------------------------------
'Main Program Code
'---------------------------------------------------------------------
Randomize Timer
'Set up screen.
ScreenRes sw, sh, 32
'Text width and height.
Width tcols, trows
'Window title.
WindowTitle "Rougelike Engine (ver. " & lbversion & ")"

'Display the main menu.
Do
	mmenu = MainMenu
	If mmenu = mNewGame Then
		'Generate new charavcter here.
		done = TRUE
	End If
	If mmenu = mLoadGame Then
		'Load gme here.
		done = TRUE		
	EndIf
	If mmenu = mCredits Then
		'Display credits here.
		done = TRUE
	EndIf
	If mmenu = mGameInfo Then
		'Show help screen here.
		done = TRUE
	EndIf
	If mmenu = mQuit Then
		done = TRUE
	EndIf
	Sleep 1
Loop Until done = TRUE

'Starting a new game.
If mmenu = mNewGame Then
	'Reset the done flag.
	done = FALSE
	'Initialize the program.
	InitProgram
	'Build the first level of dungeon
	GenerateDungeonLevel
	'Draw the main screen.
	DrawMainScreen
	'Get user input.
	Do
		'Get input
		ch = InKey
		If ch <> "" Then
			'Move character. Can use arrows or numpad with numpad on.
			If (ch = key_lt) Or (ch = "4") Then
				xx = player.pcoord.x - 1
				yy = player.pcoord.y
				Move xx, yy
			EndIf
			If (ch = key_rt) Or (ch = "6") Then
				xx = player.pcoord.x + 1
				yy = player.pcoord.y
				Move xx, yy
			EndIf
			If (ch = key_up) Or (ch = "8") Then
				xx = player.pcoord.x
				yy = player.pcoord.y - 1
				Move xx, yy
			EndIf
			If (ch = key_dn) Or (ch = "2") Then
				xx = player.pcoord.x
				yy = player.pcoord.y + 1
				Move xx, yy
			EndIf
			If ch = "7" Then
				xx = player.pcoord.x - 1
				yy = player.pcoord.y - 1
				Move xx, yy
			EndIf
			If ch = "9" Then
				xx = player.pcoord.x + 1
				yy = player.pcoord.y - 1
				Move xx, yy
			EndIf
			If ch = "3" Then
				xx = player.pcoord.x + 1
				yy = player.pcoord.y + 1
				Move xx, yy
			EndIf
			If ch = "1" Then
				xx = player.pcoord.x - 1
				yy = player.pcoord.y + 1
				Move xx, yy
			EndIf
			'Go up the stairs.
			If ch = "<" Then
				'Check to see if on stairs.
				If level.lmap(player.pcoord.x, player.pcoord.y).terrid = tsup Then
					If level.levelinfo.mlevel > 1 Then
						'Set level info
						level.levelinfo.mlevel -= 1
						GenerateDungeonLevel
						DrawMainScreen
					EndIf
				EndIf
			EndIf
			'Go down the stairs.
			If ch = ">" Then
				'Check to see if on stairs.
				If level.lmap(player.pcoord.x, player.pcoord.y).terrid = tsdn Then
					If level.levelinfo.mlevel < maxlevel Then
						'Set level info
						level.levelinfo.mlevel += 1
						GenerateDungeonLevel
						DrawMainScreen
					EndIf
				EndIf
			EndIf
			'Handle the function keys.
			If ch = key_F1 Then
			EndIf
			If ch = key_F2 Then
			EndIf
			If ch = key_F3 Then
			EndIf
			If ch = key_F4 Then
			EndIf
			If ch = key_F5 Then
			EndIf
			If ch = key_F6 Then
			EndIf
			If ch = key_F7 Then
			EndIf
			If ch = key_F8 Then
			EndIf
			'Close door.
			If (ch = "c") Or (ch = "C") Then
				DoCloseDoor
				DrawMapDisplay
			EndIf
			'Quit game.		
			If (ch = key_close) Or (ch = key_esc) Then
				'Ask for save here.
				done = TRUE
			EndIf
		End If
		'Move monsters here.
		'Check for dead player character.
		If player.currhp <= 0 Then
			done = TRUE
		EndIf
	
		Sleep 1		
	Loop Until done = TRUE
End If
