'===========================================================================================
'Module: rlmap.bi
'Author: Richard D. Clark
'Version: 0.1
'Desc: These are the map related functions used in the game.
'===========================================================================================

'Closes an open door if next to it.
Sub DoCloseDoor
	Dim As Integer i, x, y
	
	'Check each direction.
	x = player.pcoord.x + dirmatrix(north).x
	y = player.pcoord.y + dirmatrix(north).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If
	
	x = player.pcoord.x + dirmatrix(east).x
	y = player.pcoord.y + dirmatrix(east).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If

	x = player.pcoord.x + dirmatrix(south).x
	y = player.pcoord.y + dirmatrix(south).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If
	
	x = player.pcoord.x + dirmatrix(west).x
	y = player.pcoord.y + dirmatrix(west).y
	If level.lmap(x, y).hasmonster = FALSE Then
		If level.lmap(x, y).terrid = tdooropen Then 
			level.lmap(x, y).terrid = tdoorclosed
			Exit Sub
		EndIf
	End If
	
End Sub

'Returns True if current tile is blocking tile.
Function BlockingTile(tx As Integer, ty As Integer) As boolean
    if level.lmap(tx, ty).terrid = twall or _
       level.lmap(tx, ty).terrid = tdoorclosed or _
       level.lmap(tx, ty).hasmonster = TRUE Then
        return True
    else
        Return False
    end if
end function

'Bresenhams line algo
Function LineOfSight(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As boolean
    Dim As Integer i, deltax, deltay, numtiles
    Dim As Integer d, dinc1, dinc2
    Dim As Integer x, xinc1, xinc2
    Dim As Integer y, yinc1, yinc2
    Dim isseen As boolean = True
    
    deltax = Abs(x2 - x1)
    deltay = Abs(y2 - y1)

    If deltax >= deltay Then
        numtiles = deltax + 1
        d = (2 * deltay) - deltax
        dinc1 = deltay Shl 1
        dinc2 = (deltay - deltax) Shl 1
        xinc1 = 1
        xinc2 = 1
        yinc1 = 0
        yinc2 = 1
    Else
        numtiles = deltay + 1
        d = (2 * deltax) - deltay
        dinc1 = deltax Shl 1
        dinc2 = (deltax - deltay) Shl 1
        xinc1 = 0
        xinc2 = 1
        yinc1 = 1
        yinc2 = 1
    End If

    If x1 > x2 Then
        xinc1 = - xinc1
        xinc2 = - xinc2
    End If
    
    If y1 > y2 Then
        yinc1 = - yinc1
        yinc2 = - yinc2
    End If

    x = x1
    y = y1
    
    For i = 2 To numtiles
      'PSet (x, y), pcolor
      If BlockingTile(x, y) Then
        isseen = False
        Exit For
      End If
      If d < 0 Then
          d = d + dinc1
          x = x + xinc1
          y = y + yinc1
      Else
          d = d + dinc2
          x = x + xinc2
          y = y + yinc2
        End If
    Next
    
    Return isseen
End Function

'Determines if player can see object.
Function PlayerCanSee(tx As Integer, ty As Integer) As Integer
   Dim As Integer ret = FALSE
   Dim As Integer dist
        
	dist = CalcDist(player.pcoord.x, tx, player.pcoord.y, ty)
	If dist <= vh Then
   	ret = LineOfSight(player.pcoord.x, tx, player.pcoord.y, ty)
	End If
    
   Return ret
End Function

'Caclulate los with post processing
sub CalcLOS
	Dim as integer i, j, x, y
	Dim As Integer x1, x2, y1, y2
	
	'Clear the vismap
	For i = 1 To mapw
   	For j = 1 To maph
   		level.lmap(i, j).visible = FALSE
   	Next
	Next
	'Only check within viewport
	x1 = player.pcoord.x - vw
	If x1 < 1 Then x1 = 1
	y1 = player.pcoord.y - vh
	If y1 < 1 Then y1 = 1
	
	x2 = player.pcoord.x + vw
	If x2 > mapw - 1 Then x2 = mapw - 1
	y2 = player.pcoord.y + vh
	If y2 > maph - 1 Then y2 = maph - 1
	'iterate through vision area
	For i = x1 To x2
		For j = y1 To y2
	   	'Don't recalc seen tiles
	      If level.lmap(i, j).visible = False Then
	         If PlayerCanSee(i, j) Then
	         	level.lmap(i, j).visible = TRUE
	         	level.lmap(i, j).seen = TRUE
	         End If
	      End If
	  Next
	Next
	'Post process the map to remove artifacts.
	For i = x1 To x2
		For j = y1 To y2
			If (BlockingTile(i, j) = TRUE) And (level.lmap(i, j).visible = FALSE) Then
				x = i
				y = j - 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 
				
				x = i
				y = j + 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i + 1
				y = j
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i - 1
				y = j
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i - 1
				y = j - 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i + 1
				y = j - 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i + 1
				y = j + 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf 

				x = i - 1
				y = j + 1
				If (x > 0) And (x < mapw + 1) Then
					If (y > 0) And (y < maph + 1) Then
						If (level.lmap(x, y).terrid = tfloor) And (level.lmap(x, y).visible = TRUE) Then
							level.lmap(i, j).visible = TRUE
							level.lmap(i, j).seen = TRUE
						EndIf
					EndIf
				EndIf
				
			EndIf 
		Next
	Next
End sub

'Return ascii symbol for tile
Function GetMapSymbol(tile As terrids) As String
	Dim As String ret
	
   Select Case tile
   	Case twall
   		ret = Chr(219)
   	Case tfloor
   		ret = Chr(249)
   	Case tsup
   		ret = "<"
   	Case tsdn
   		ret = ">"
   	Case tdooropen
   		ret = "'"
   	Case tdoorclosed
   		ret = "\"
   	Case Else
            'PrintMessage "Unknown tile: " + Str$(tile)
            ret = "?"
   End Select
   
   Return ret
End Function

'Returns the color for object
Function GetMapSymbolColor(tile As Integer) As UInteger
	Dim ret As UInteger
	
   Select Case tile
   	Case twall
   		ret = fbGrey
   	Case tfloor
   		ret = fbWhite
   	Case tsup
   		ret = fbYellow
   	Case tsdn
   		ret = fbYellow
   	Case tdooropen
   		ret = fbTan
   	Case tdoorclosed
   		ret = fbTan
   	Case Else
         ret = fbWhite
   End Select
   
   Return ret
End Function

'ascii drawing rouine
Sub DrawMap
   Dim As Integer i, j, w = vw, h = vh, x, y, px, py
   'Dim As Integer miid, tid, monid, dist
   Dim As UInteger tilecolor, bcolor
   Dim As String mtile
   Dim As terrids tile
   
	CalcLOS
	'get the view coords
	i = player.pcoord.x - (w / 2)
	j = player.pcoord.y - (h / 2)
	If i < 1 Then i = 1
	If j < 1 Then j = 1
	If i + w > mapw Then i = mapw - w
	If j + h > mapw Then j = mapw - h
	 For x = 1 To w
	     For y = 1 To h
	     		tilecolor = fbBlack 
	     		PutText Chr(219), y, x, tilecolor
     			'Get tile id
     			tile = level.lmap(i + x, j + y).terrid
        		'Get the tile symbol
         	mtile = GetMapSymbol(tile)
         	'Get the tile color
         	tilecolor = GetMapSymbolColor(tile)
	     		'Print the tile.
	         If level.lmap(i + x, j + y).visible = True Then
		         'Print the item marker.
		         If level.lmap(i + x, j + y).hasitem = True Then
		         	'Item info here.
		         EndIf
	            PutText mtile, y, x, tilecolor
	            
		         'If the current location has a monster print that monster.
		         If level.lmap(i + x, j + y).hasmonster = TRUE Then
		         	'Put monster info here.
		         EndIf
	         Else
	         	'Not in los.
	         	If level.lmap(i + x, j + y).seen = TRUE Then
	         		If level.lmap(i + x, j + y).hasitem = True Then
	         			'Put seen item marker such as a ?.
	         		Else
	            		PutText mtile, y, x, fbSlateGreyDark
	         		End If
	         	End If
	         End If
	     Next 
	 Next
   'Draw the player
	px = player.pcoord.x - i
	py = player.pcoord.y - j
	If player.currhp > 74 Then
		PutText Chr(219), py, px, fbBlack
		PutText "@", py, px, fbGreen
	ElseIf (player.currhp > 24) And (player.currhp < 75) Then
		PutText Chr(219), py, px, fbBlack
		PutText "@", py, px, fbYellow
	Else
		PutText Chr(219), py, px, fbBlack
		PutText "@", py, px, fbRed
	EndIf

End Sub

'Init the grid and room arrays
Sub InitGrid
   Dim As Integer i, j, x, y, gx = 1, gy = 1
	
	'Clear room array.		
   For i = 1 To nroommax
   	rooms(i).roomdim.rwidth = 0
   	rooms(i).roomdim.rheight = 0
   	rooms(i).roomdim.rcoord.x = 0
   	rooms(i).roomdim.rcoord.y = 0
   	rooms(i).tl.x = 0
   	rooms(i).tl.y = 0
   	rooms(i).br.x = 0
   	rooms(i).br.y = 0
   Next 
   'How many rooms
   numrooms = RandomRange(nroommin, nroommax)
   'Build some rooms
   For i = 1 To numrooms
   	rooms(i).roomdim.rwidth = RandomRange(roommin, roommax)
    	rooms(i).roomdim.rheight = RandomRange(roommin, roommax)
   Next
    'Clear the grid array
   For i = 1 To gw 
   	For j = 1 To gh
    		grid(i, j).cellcoord.x = gx
    		grid(i, j).cellcoord.y = gy
     		grid(i, j).Room = emptycell
     		gy += csize
   	Next
   	gy = 1
   	gx += csize
   Next
	'Add rooms to the grid
   For i = 1 To numrooms
   	'Find an empty spot in the grid
   	Do
   		x = RandomRange(2, gw - 1)
   		y = RandomRange(2, gh - 1)
   	Loop Until grid(x, y).Room = emptycell
   	'Room center
   	rooms(i).roomdim.rcoord.x = grid(x, y).cellcoord.x + (rooms(i).roomdim.rwidth \ 2)   
   	rooms(i).roomdim.rcoord.y = grid(x, y).cellcoord.y + (rooms(i).roomdim.rheight \ 2)
		'Set the room rect
		rooms(i).tl.x = grid(x, y).cellcoord.x 
		rooms(i).tl.y = grid(x, y).cellcoord.y 
		rooms(i).br.x = grid(x, y).cellcoord.x + rooms(i).roomdim.rwidth + 1
		rooms(i).br.y = grid(x, y).cellcoord.y + rooms(i).roomdim.rheight + 1
   	'Save the room index
   	grid(x, y).Room = i
   Next
	'Save the room index
	grid(x, y).Room = i
   
End Sub 

'Connect all the rooms.
Sub ConnectRooms( r1 As Integer, r2 As Integer, secret As Integer = FALSE)
	Dim As Integer idx, x, y
	Dim As mcoord currcell, lastcell
	Dim As Integer wflag
	
	currcell = rooms(r1).roomdim.rcoord
	lastcell = rooms(r2).roomdim.rcoord
		
	x = currcell.x
	If x < lastcell.x Then
		wflag = FALSE
		Do
			x += 1
			If level.lmap(x, currcell.y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, currcell.y).terrid = tfloor) And (wflag = TRUE) Then
				Exit Sub
			EndIf
			level.lmap(x, currcell.y).terrid = tfloor
		Loop Until x = lastcell.x
	End If
	
	If x > lastcell.x Then
		wflag = FALSE
		Do
			x -= 1
			If level.lmap(x, currcell.y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, currcell.y).terrid = tfloor) And (wflag = TRUE) Then 
				Exit Sub
			EndIf
			level.lmap(x, currcell.y).terrid = tfloor
		Loop Until x = lastcell.x
	EndIf
	
	y = currcell.y
	If y < lastcell.y Then
		wflag = FALSE
		Do
			y += 1
			If level.lmap(x, y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, y).terrid = tfloor) And (wflag = TRUE) Then 
				Exit Sub
			EndIf
			level.lmap(x, y).terrid = tfloor
		Loop Until y = lastcell.y
	EndIf
	
	If y > lastcell.y Then
		Do
			y -= 1
			If level.lmap(x, y).terrid = twall Then wflag = TRUE
			If (level.lmap(x, y).terrid = tfloor) And (wflag = TRUE) Then 
				Exit Sub
			EndIf
			level.lmap(x, y).terrid = tfloor
		Loop Until y = lastcell.y
	EndIf
		 
End Sub

'Add doors to a particualr room.
Sub AddDoorsToRoom(i As Integer)
	Dim As Integer row, col, dd1, dd2
	
	'Iterate along top room.
	For col = rooms(i).tl.x To rooms(i).br.x
		dd1 = rooms(i).tl.y
		dd2 = rooms(i).br.y
		'If a floor space in the wall-
		If (level.lmap(col, dd1).terrid = tfloor) Or (level.lmap(col, dd1).terrid = tdoorclosed) Then
			'Add door.
			level.lmap(col, dd1).terrid = tdoorclosed
		EndIf
		'Iterate along bottom of room.
		If (level.lmap(col, dd2).terrid = tfloor) Or (level.lmap(col, dd2).terrid = tdoorclosed) Then
			level.lmap(col, dd2).terrid = tdoorclosed
		End If
	Next
	'Iterate along left side of room.
	For row = rooms(i).tl.y To rooms(i).br.y
		dd1 = rooms(i).tl.x
		dd2 = rooms(i).br.x
		If (level.lmap(dd1, row).terrid = tfloor) Or (level.lmap(dd1, row).terrid = tdoorclosed) Then
			level.lmap(dd1, row).terrid = tdoorclosed
		End If
		'Iterate along right side of room.
		If (level.lmap(dd2, row).terrid = tfloor) Or (level.lmap(dd2, row).terrid = tdoorclosed) Then
			level.lmap(dd2, row).terrid = tdoorclosed
		EndIf
	Next
	
End Sub

'Adds doors to rooms.
Sub AddDoors
	Dim As Integer i
	
	For i = 1 To numrooms
		AddDoorsToRoom i
	Next
End Sub

'Transfer grid data to map array.
Sub DrawMapToArray
	Dim As Integer i, x, y, pr, rr, rl, ru, kr
	
	'Draw the first room to map array
		For x = rooms(1).tl.x + 1 To rooms(1).br.x - 1
			For y = rooms(1).tl.y + 1 To rooms(1).br.y - 1
				level.lmap(x, y).terrid = tfloor
			Next
		Next
	'Draw the rest of the rooms to the map array and connect them.
	For i = 2 To numrooms
		For x = rooms(i).tl.x + 1 To rooms(i).br.x - 1
			For y = rooms(i).tl.y + 1 To rooms(i).br.y - 1
				level.lmap(x, y).terrid = tfloor
			Next
		Next
		ConnectRooms i, i - 1
	Next
	'Add doors to selected rooms.
	AddDoors
	'Set up player location.
	x = rooms(1).roomdim.rcoord.x + (rooms(1).roomdim.rwidth \ 2) 
	y = rooms(1).roomdim.rcoord.y + (rooms(1).roomdim.rheight \ 2)
	player.pcoord.x = x - 1
	player.pcoord.y = y - 1
	'Set up the stairs up.
	level.lmap(player.pcoord.x, player.pcoord.y).terrid = tsup
	'Set up stairs down.
	x = rooms(numrooms).roomdim.rcoord.x + (rooms(numrooms).roomdim.rwidth \ 2) 
	y = rooms(numrooms).roomdim.rcoord.y + (rooms(numrooms).roomdim.rheight \ 2)
	level.lmap(x - 1, y - 1).terrid = tsdn
End Sub

'Generate a new dungeon level.
Sub GenerateDungeonLevel
	Dim As Integer x, y

	'Clear level
	For x = 1 To mapw
		For y = 1 To maph
			'Set to wall tile
			level.lmap(x, y).terrid = twall
			level.lmap(x, y).visible = FALSE
			level.lmap(x, y).seen = FALSE
			level.lmap(x, y).hasmonster = FALSE
			level.lmap(x, y).hasitem = FALSE
		Next
	Next
	InitGrid
	DrawMapToArray
End Sub

