'===========================================================================================
'Module: rlmenus.bi
'Author: Richard D. Clark
'Version: 0.1
'Desc: These are the menu related functions used in the game.
'===========================================================================================

'Draws the main menu items.
Sub DrawMainMenuItems (sel As mainmenuid, txt() As String)
	Dim As string tt
	Dim As Integer mrow = 2, irow = trows - 10
	
	ScreenLock
	Color , fbBlack
	Cls
	tt = "RL Engine Main Menu"
	CenterText mrow, tt, fbWhite
	mrow += 4
	If sel = mNewGame Then
		CenterText mrow, txt(mNewgame), fbBlack, fbWhite
		tt = "Starts a new game with a new character."
		CenterText irow, tt, fbYellow, fbBlack
	Else
		CenterText mrow, txt(mNewgame), fbWhite, fbBlack
	End If
	mrow += 2
	If sel = mLoadGame Then
		CenterText mrow, txt(mLoadGame), fbBlack, fbWhite
		tt = "Loads a previously saved game."
		CenterText irow, tt, fbYellow, fbBlack
	Else
		CenterText mrow, txt(mLoadGame), fbWhite, fbBlack	
	EndIf
	mrow += 2
	If sel = mGameInfo Then
		CenterText mrow, txt(mGameInfo), fbBlack, fbWhite
		tt = "Game information and help."
		CenterText irow, tt, fbYellow, fbBlack
	Else
		CenterText mrow, txt(mGameInfo), fbWhite, fbBlack	
	EndIf
	mrow += 2
	If sel = mCredits Then
		CenterText mrow, txt(mCredits), fbBlack, fbWhite
		tt = "Displays the credits screen."
		CenterText irow, tt, fbYellow, fbBlack
	Else
		CenterText mrow, txt(mCredits), fbWhite, fbBlack	
	EndIf
	mrow += 2
	If sel = mQuit Then
		CenterText mrow, txt(mQuit), fbBlack, fbWhite
		tt = "Quits the game and returns to the OS."
		CenterText irow, tt, fbYellow, fbBlack
	Else
		CenterText mrow, txt(mQuit), fbWhite, fbBlack
	EndIf
	CenterText trows - 1, "[Up] [Down] [Enter] to Select", fbWhite		
	ScreenUnLock
	
End Sub

'Returns main menu item id based on menu count.
Function GetMainMenuItem (m As Integer) As mainmenuid
	If m = 1 Then Return mNewGame
	If m = 2 Then Return mLoadGame
	If m = 3 Then Return mGameInfo
	If m = 4 Then Return mCredits
	If m = 5 Then Return mQuit
End Function

'Get the main menu selection
Function MainMenu() As mainmenuid
	Dim As mainmenuid ret = mNewGame
	Dim As Integer mcnt = 1
	Dim As integer done = FALSE
	Dim As String ch, menutxt(mNewGame To mQuit)

	'Menu array.	
	menutxt(mNewGame) =  " New Game  "
	menutxt(mLoadGame) = " Load Game "
	menutxt(mGameInfo) = " Game Info "
	menutxt(mCredits) =  "  Credits  "
	menutxt(mQuit) =     "   Quit    "

	DrawMainMenuItems ret, menutxt()
	
	Do
		ch = InKey
		If ch = key_up Then
			mcnt -= 1
			If mcnt < 1 Then mcnt = NumMainMenuItems
			ret = GetMainMenuItem(mcnt)
			DrawMainMenuItems ret, menutxt()
		EndIf
		If ch = key_dn Then
			mcnt += 1
			If mcnt > NumMainMenuItems Then mcnt = 1
			ret = GetMainMenuItem(mcnt)
			DrawMainMenuItems ret, menutxt()
		EndIf
		If ch = key_enter Then
			done = TRUE
		EndIf
		If ch = key_close Then
			done = TRUE
			ret = mClose
		EndIf
		Sleep 10	
	Loop Until done = TRUE
	Do: Loop While InKey <> ""
	Return ret
End Function
