'===========================================================================================
'Module: rlutils.bi
'Author: Richard D. Clark
'Version: 0.1
'Desc: These are the utility functions used in the game.
'===========================================================================================

'Pixel types used in alphablend. 
Type Pixel_Color
    B As UByte
    G As UByte
    R As UByte
    A As UByte
End Type

Union Pixel
    Channel As Pixel_Color
    Value   As UInteger
End Union

'Returns an alpha blended color.
Function AlphaBlend(Alpha As Integer, fcolor As UInteger, bcolor As UInteger) As UInteger
    Dim As Integer invalpha, r, g, b
    Dim As Pixel fc, bc
    
    If Alpha > 255 Then Alpha = 255
    If Alpha < 0 Then Alpha = 0    
    invalpha = 255 - Alpha
    fc.value = fcolor
    bc.value = bcolor
    r = ((fc.channel.r * Alpha) + (bc.channel.r * invalpha)) Shr 8
    g = ((fc.channel.g * Alpha) + (bc.channel.g * invalpha)) Shr 8
    b = ((fc.channel.b * Alpha) + (bc.channel.b * invalpha)) Shr 8
    
    Return RGB(r, g, b)    
End Function

'Returns a random number within range.
Function RandomRange(lowerbound As Integer, upperbound As Integer) As Integer
	Return Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
End Function

'Returns fast distance calc between two points.
Function CalcDist(x1 As Integer, x2 As Integer, y1 As Integer, y2 As Integer) As Integer
    Dim As Integer xdiff, ydiff
    Dim dist As Integer
   
    xdiff = Abs(x1 - x2)
    ydiff = Abs(y1 - y2)
    dist =  (xdiff + ydiff + imax(xdiff, ydiff)) Shr 1
    Return dist
End Function

'Writes text at specified row and column.
Sub PutText(txt As String, row As Integer, col As Integer, fcolor As UInteger = fbWhite)
	Dim As Integer x, y
	
	x = (col - 1) * twh
	y = (row - 1) * twh
	Draw String (x, y), txt, fcolor
End Sub

'Centers text on the screen.
Sub CenterText (row As Integer, txt As String, fclr As UInteger, bclr As UInteger = fbBlack)
	Dim As Integer col
	
	Color , fbBlack	
	Locate row, 1
	Print Space(tcols - 1);
	
	col = (tcols \ 2) - (Len(txt) \ 2)
	Color fclr, bclr
	Locate row, col
	Print txt; 
End Sub

