/'****************************************************************************
*
* Name: vec.bas
*
* Synopsis: 2D Vector object
*
* Description: This implements a 2D vector as an object along with useful operators.
*
* Copyright 2006, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
*****************************************************************************'/

Namespace vector

'2D Vector type.
Type vec
	Private:
	_x As Integer
	_y As Integer
	Public:
	Declare Constructor ()
	Declare Constructor (x As Integer, y As Integer)
	Declare Property vx (x As Integer)
	Declare Property vx () As Integer
	Declare Property vy (y As Integer)
	Declare Property vy () As Integer
	Declare Operator Let (rhs As vec)
	Declare Operator += (rhs As vec)
	Declare Operator += (rhs As Integer)
	Declare Operator -= (rhs As vec)
	Declare Operator -= (rhs As Integer)
	Declare Operator *= (rhs As Double)
	Declare Sub ClearVec()
	Declare Function Dist (v As vec) As Integer
End Type

'Empty constructor. Used when part of another object.
Constructor vec ()
	_x = 0
	_y = 0
End Constructor

'Initialzed vector.
Constructor vec (x As Integer, y As Integer)
	_x = x
	_y = y
End Constructor

'Properties to set and return the x and y components.
Property vec.vx (x As Integer)
	_x = x
End Property

Property vec.vx () As Integer
	Return _x
End Property

Property vec.vy (y As Integer)
	_y = y
End Property

Property vec.vy () As Integer
	Return _y
End Property

'Assignment operator.
Operator vec.Let (rhs As vec)
	_x = rhs.vx
	_y = rhs.vy
End Operator

'Translation operators. These operate on both components.
Operator vec.+= (rhs As vec)
	_x += rhs.vx
	_y += rhs.vy
End Operator

Operator vec.+= (rhs As Integer)
	_x += rhs
	_y += rhs
End Operator

Operator vec.-= (rhs As vec)
	_x -= rhs.vx
	_y -= rhs.vy
End Operator

Operator vec.-= (rhs As Integer)
	_x -= rhs
	_y -= rhs
End Operator

'Scaling operator.
Operator vec.*= (rhs As Double)
	_x *= rhs
	_y *= rhs 
End Operator

'Translation operators.
Operator + (lhs As vec, rhs As vec) As vec
	Dim tmp As vec
	
	tmp.vx = lhs.vx + rhs.vx
	tmp.vy = lhs.vy + rhs.vy
	
	Return tmp
End Operator

Operator - (lhs As vec, rhs As vec) As vec
	Dim tmp As vec
	
	tmp.vx = lhs.vx - rhs.vx
	tmp.vy = lhs.vy - rhs.vy
	
	Return tmp
End Operator

'Scale operator.
Operator * (lhs As vec, rhs As Double) As vec
	Dim tmp As vec
	
	tmp.vx = lhs.vx * rhs
	tmp.vy = lhs.vy * rhs
	
	Return tmp
End Operator

'Sets vector to 0.
Sub vec.Clearvec ()
	_x = 0
	_y = 0
End Sub

Function vec.Dist (v As vec) As Integer
	'Return Abs(_x - v.vx) + Abs(_y - v.vy)
	Return Int(Sqr((_x - v.vx)^2 + (_y - v.vy)^2))	
End function

End Namespace
