/'****************************************************************************
*
* Name: simdata2.bi
*
* Synopsis: Data declarations for Simtron2 virtual machine.
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
* Command List
*
* MEM# = memory location 0 to 999
* # = memory or label number
* 
* ' Comment to end of line. 
* SET MEM# VALUE
* SETC MEM# CHAR
* RAND MEM1, UPPERLIMIT
* READ MEM#
* READC MEM#
* WRITE MEM#
* WRITELN
* WRITEASC MEM# 
* MOVE MEM# DEST
* STORE MEM# MEM#
* LOAD MEM# MEM#
* ADD MEM1  + MEM2  = MEM3
* SUB MEM1 - MEM2 = MEM3
* DIV MEM1 / MEM2 = MEM3
* MUL MEM1 * MEM2 = MEM3
* MOD MEM1 MOD MEM2 = MEM3
* INC MEM#
* DEC MEM#
* LABEL #
* CMP MEM1 MEM2
* BRA LABEL#
* BRN LABEL#
* BRZ LABEL#
* BRR MEM#
* LBR MEM1 MEM2 LABEL#
* PAUSE
* DUMP
* MMAX MEM1
* SCR COLS# ROWS#
* LOC ROW# COL#
* CLS
* CLR FORE# [BACK#]
* CLRM MEM# [MEM#]
* IKEY MEM1 MEM2 MEM3
* GKEY MEM1 MEM2 MEM3
* HALT
*****************************************************************************'/
#Ifndef FALSE 
   Const FALSE = 0
   Const TRUE = Not FALSE
#EndIf
Const simver = "2.1.2"
Const memmax = 63999
'Command token list.
Enum cmdlist
   cmdSet = 1    'Set a memory location to a value.
   cmdSetC       'Set a memory location to ascii code of char.
   cmdRead       'Read a value from the keyboard.
   cmdReadC      'Read a character from the keyboard and store ascii code.
   cmdWrite      'Write a value to the screen.
   cmdWriteLn    'Write a CR + LF to screen.
   cmdWriteAsc   'Write ascii codes of value in memory location.
   cmdMove       'Move value of mem1 to mem2. 
   cmdStore      'Move value of mem1 to destination contained in mem2. 
   cmdLoad       'Move contents pointed to in mem2 to mem1. 
   cmdAdd        'Add mem1 to mem2. Leave result in dest.
   cmdSub        'Subtract mem2 from mem1. Leave result in dest.
   cmdDivide     'Divide memory location to accumulator. Leave result in acc.
   cmdMultiply   'Multiply mem1 by mem2. Leave result in dest.
   cmdMod        'Modulus division (i.e., remainder) of mem1 and mem2. Leave result in dest.
   cmdInc        'Increment memory location by 1.
   cmdDec        'Decrement memory location by 1.
   cmdLabel      'Branch target label.
   cmdCmp        'Compare two memory locations and set z register: mem1 < mem2 z= -1, mem1 = mem2 z = 0, mem1 > mem2 z = 1
   cmdBranch     'Branch to label.
   cmdBranchNeg  'Branch if accumulator is negative.
   cmdBranchZero 'Branch if accumulator is zero.
   cmdBranchRel  'Branch to label number contained in memory location.
   cmdLoopBranch 'Compares two memory locations and branch to label if mem1 is less than mem2.
   cmdPause      'Pauses program.
   cmdDump       'Dumps memory to screen.
   cmdMemMax     'Set memory location to last memory location in memory store.
   cmdScr        'Sets the window size.
   cmdLoc        'Set cursor to row, col.
   cmdCls        'Clear screen.
   cmdClr        'Sets text color, foreground, background.
   cmdClrM       'Sets text color, foreground, background from memory loc.
   cmdRand       'Generates a random integer from 0 to #.
   cmdIKey       'Returns key press data; does not wait for key.
   cmdGKey       'Return key press data; waits for a key.
   cmdHalt       'Stops execution.
End Enum

'Command type.
Type cmdtype
   progline As String  'Program line for error messages.
   linecnt As Integer   'Source line.
   opcode As cmdlist   'The opcode to perforam.
   p1 As Integer       'Opcode parm 1.
   p2 As Integer       'Opcode parm 2.
   p3 As Integer       'Opcode parm 2.
   target As Integer   'Program line number for branch opcode.
End Type

'Location type.
Type labelloc
   id As Integer     'The id of the label.
   lineno As Integer 'The program line of label.
End Type

'Program store.
Dim Shared program() As cmdtype
'Accumulator.
Dim Shared zreg As Integer
'Tokens list.
Dim Shared tokens() As String
'Command string list.
Dim Shared cmdstrings(cmdSet To cmdHalt) As String
'Set up the program store.
ReDim program(0 To 0) As cmdtype
'Memory map. Keeps track of used memory registers. Used in dump instruction.
ReDim Shared memmap(0 To 0) As Integer
'Keeps track of label numbers. Used to detect a duplicate label id.
ReDim Shared labels(0 To 0) As labelloc
'Memory store.
Dim Shared memory (0 To memmax) As Integer
'File handle.
Dim Shared As Integer fhandle
'Program pointer.
Dim As Integer progptr = 1
'Screen row and columns.
Dim Shared As Integer srow = 25, scol = 80
'Working vars.
Dim As Integer done = FALSE, ret
