/'****************************************************************************
*
* Name: simparse2.bi
*
* Synopsis: Parse routines for Simtron2 Virtual Machine.
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*****************************************************************************'/

'This loads all the opcodes into the opcode parse array.
Sub LoadOpcodes()
   cmdstrings(cmdSet) = "SET"
   cmdstrings(cmdSetC) = "SETC"
   cmdstrings(cmdRead) = "READ"
   cmdstrings(cmdReadC) = "READC"
   cmdstrings(cmdWrite) = "WRITE"
   cmdstrings(cmdWriteLn) = "WRITELN"
   cmdstrings(cmdWriteAsc) = "WRITEASC"
   cmdstrings(cmdMove) = "MOVE"
   cmdstrings(cmdStore) = "STORE"
   cmdstrings(cmdLoad) = "LOAD"
   cmdstrings(cmdAdd) = "ADD"
   cmdstrings(cmdSub) = "SUB"
   cmdstrings(cmdDivide) = "DIV"
   cmdstrings(cmdMultiply) = "MUL"
   cmdstrings(cmdMod) = "MOD"
   cmdstrings(cmdInc) = "INC"
   cmdstrings(cmdDec) = "DEC"
   cmdstrings(cmdLabel) = "LABEL"
   cmdstrings(cmdCmp) = "CMP"
   cmdstrings(cmdBranch) = "BRA"
   cmdstrings(cmdBranchNeg) = "BRN"
   cmdstrings(cmdBranchZero) = "BRZ"
   cmdstrings(cmdBranchRel) = "BRR"
   cmdstrings(cmdLoopBranch) = "LBR"
   cmdstrings(cmdPause) = "PAUSE"
   cmdstrings(cmdDump) = "DUMP"
   cmdstrings(cmdMemMax) = "MMAX"
   cmdstrings(cmdScr) = "SCR"
   cmdstrings(cmdLoc) = "LOC"
   cmdstrings(cmdCls) = "CLS"
   cmdstrings(cmdClr) = "CLR"
   cmdstrings(cmdClrM) = "CLRM"
   cmdstrings(cmdRand) = "RAND"
   cmdstrings(cmdIKey) = "IKEY"
   cmdstrings(cmdGKey) = "GKEY"
   cmdstrings(cmdHalt) = "HALT"
End Sub

'Searches memory map for memory location. If not found it adds it.
sub AddMemToMap(mem As Integer)
   Dim As Integer found = FALSE, cnt
   
   cnt = UBound(memmap)
   For i As Integer = 1 To cnt
      If memmap(i) = mem Then
         found = TRUE
         Exit For
      EndIf
   Next
   'If not found add it.
   If found = FALSE Then
      cnt += 1
      ReDim Preserve memmap(0 To cnt)
      memmap(cnt) = mem
   EndIf
End Sub

'Strip any quotes in token.
Function StripQuotes(s As String) As String
   Dim As String rets, ch, qt = Chr(34)
   Dim As Integer i
   
   For i = 1 To Len(s) 
      ch = Mid(s, i, 1)
      If ch <> qt Then
         rets &= ch
      EndIf
   Next
   
   Return rets
End Function

'Get tokens from line. Returns number of tokens found.
Function GetTokens(ln As String) As Integer
   Dim As Integer idx, tokcnt, lnlen
   Dim As String tmpln = ln, tmptok, ch, delim
   
   'Set delimiter tokens.
   delim = Chr(32) & Chr(9)
   'Reset token list.
   ReDim tokens(0 To 0)
   'Trim any spaces or tabs.
   tmpln = Trim(tmpln, Any delim)
   'Look for a space or tab
   idx = InStr(tmpln, Any delim)
   Do While idx > 0
      'Get next token.
      tmptok = ""
      tokcnt += 1
      ReDim Preserve tokens(0 To tokcnt)
      tmptok = Left(tmpln, idx - 1)
      tmptok = Trim(tmptok, Any delim)
      tmptok = StripQuotes(tmptok)
      tokens(tokcnt) = tmptok
      tmpln = Mid(tmpln, idx + 1)
      tmpln = Trim(tmpln, Any delim)
      idx = InStr(tmpln, Any delim)
   Loop
   'See if we have any tokens left.
   If Len(tmpln) > 0 Then
      tokcnt += 1
      ReDim Preserve tokens(0 To tokcnt)
      tmpln = StripQuotes(tmpln)
      tokens(tokcnt) = tmpln
   EndIf

   Return tokcnt
End Function

'Attmepts to opne the file passed on the command line.
Function simOpenFile() As Integer
   Dim As String fname
   Dim As Integer ret = TRUE, idx
   
   'Print program version.
   Cls
   Print "Simtron2 Virtual Machine v." & simver
   Print

   'Get the command line.
   fname = Command(1)
   'Make sure we have something.
   If Len(fname) = 0 Then
      ret = FALSE
      Print "Useage: simtron2 progfile.sim"
      Print
      Print "Press any key to exit."
      Sleep
   Else
      'See if the file name has an extension.
      idx = InStr(fname, ".")
      If idx = 0 Then
         fname &= ".sim"
      EndIf
      'Make sure the file exists.
      If Len(Dir(fname)) = 0 Then
         ret = FALSE
         Print "File " & fname & " not found."
         Print
         Print "Press any key to exit."
         Sleep
      Else
         'Try and open the file.
         fhandle = FreeFile
         If Open(fname, For Input As #fhandle) <> 0 Then
            ret = FALSE
            Print "Could not open file " & fname & " for reading."
            Print
            Print "Press any key to exit."
            Sleep
         EndIf
      EndIf
   EndIf
   
   Return ret
End Function

'Returns prog line of label id.
Function GetLabelTarget (lid As Integer) As Integer
   Dim As Integer ret = 0
   
   For i As Integer = 1 To UBound(program)
      If program(i).opcode = cmdLabel Then
         If program(i).p1 = lid Then
            ret = i
            Exit For
         EndIf
      EndIf
   Next
   
   Return ret
End Function


'Resolve the label references.
Function ResolveLabels() As Integer
   Dim As Integer ret = TRUE, i, lblid
   
   'Make sure we have a program.
   If UBound(program) = 0 Then
      ret = FALSE
      Print "Nothing to run."
      Print
      Print "Press any key to exit."
      Sleep
   Else
      'For any branching statement, resolve the label references.
      For i = 1 To UBound(program)
         If (program(i).opcode = cmdBranch) Or (program(i).opcode = cmdBranchNeg) Or (program(i).opcode = cmdBranchZero) Or (program(i).opcode = cmdLoopBranch) Then
            If program(i).opcode = cmdLoopBranch Then
               lblid = GetLabelTarget(program(i).p3)
            Else
               lblid = GetLabelTarget(program(i).p1)
            EndIf
            'Did we find the label?
            If lblid = 0 Then
               ret = FALSE
               Print "Unknown label reference in line " & program(i).linecnt & ": " & program(i).progline & "."
               Print
               Print "Press any key to exit."
               Sleep
               Exit For
            Else
               'Set the target for the branch.
               program(i).target = lblid
            EndIf
         EndIf
      Next
   EndIf
   
   Return ret
End Function

'Check for duplicate label. If label is not found, it is added to list.
Function LabelIsDuplicate(lbl As Integer, progline As Integer) As Integer
   Dim As Integer ret = FALSE, idx
   
   'Get the current upperbond.
   idx = UBound(labels)
   'Look For the label id.
   For i As Integer = 1 To idx
      If labels(i).id = lbl Then
         ret = TRUE
      EndIf
   Next
   'If label id not found add it to list.
   If ret = FALSE Then
      idx+= 1
      ReDim Preserve labels(0 To idx)
      labels(idx).id = lbl
      labels(idx).lineno = progline
   EndIf
   
   Return ret
End Function



'Parse the file and build the program array.
Function ParseFile() As Integer
   Dim As Integer ret = simOpenFile()
   Dim As String lne, wlne, op, delim
   Dim As Integer idx, i, found, prog, tcnt, lnecnt, pv
   
   If ret = TRUE Then
      delim = Chr(32) & Chr(9)
      'Load up all the opcodces.
      LoadOpcodes()
      'If we get here the file was opened successfully.
      Do While Not EOF(fhandle)
         Line Input #fhandle, lne
         lnecnt += 1
         lne = Trim(lne, Any delim)
         If Len(lne) > 0 Then
            'Clear work line.
            wlne = ""
            'Look for comment and trim it off.
            For i As Integer = 1 To Len(lne)
               Dim As String ch = Mid(lne, i, 1)
               If ch = "'" Then
                  Exit For
               Else
                  wlne &= ch
               EndIf
            Next
            'Trim any excess spaces.
            wlne = Trim(wlne, Any delim)
            If Len(wlne) > 0 Then
               'Get the line tokens.
               tcnt = GetTokens(wlne)
               If tcnt > 0 Then
                  'Get the opcode.
                  op = UCase(tokens(1))
                  'Look for opcode in list.
                  found = FALSE
                  For i As Integer = cmdSet To cmdHalt
                     'Found 
                     If cmdstrings(i) = op Then
                        found = TRUE
                        idx = i
                        Exit For
                     EndIf
                  Next
                  'If found process the opcode.
                  If found = TRUE Then
                     'Increment the program store.
                     prog += 1
                     ReDim Preserve program(0 To prog)
                     'Save the program line.
                     program(prog).progline = lne
                     program(prog).linecnt = lnecnt
                     Select Case idx
                        Case cmdSet, cmdSetC
                           'Make sure we have the correct number of parms. 
                           If tcnt < 3 Then
                              Print "Expected memory location and value in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              If idx = cmdSetC Then
                                 tokens(3) = StripQuotes(tokens(3))
                                 program(prog).p2 = Asc(tokens(3))
                              Else
                                 program(prog).p2 = Val(tokens(3))
                              EndIf
                           EndIf
                        Case cmdRead, cmdReadC
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected memory location in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdWrite, cmdWriteAsc
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected memory location in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdWriteLn
                           'Load the values into the program array.
                           program(prog).opcode = idx
                        Case cmdMove, cmdStore, cmdLoad
                           'Make sure we have the correct number of parms. 
                           If tcnt < 3 Then
                              Print "Expected memory locations in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory locations.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(3))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p2 = pv
                                 AddMemToMap program(prog).p2
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdAdd, cmdSub, cmdDivide, cmdMultiply, cmdMod
                           'Make sure we have the correct number of parms. 
                           If tcnt < 4 Then
                              Print "Expected memory locations in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory locations.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(3))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p2 = pv
                                 AddMemToMap program(prog).p2
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(4))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p3 = pv
                                 AddMemToMap program(prog).p3
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdInc, cmdDec
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected memory location in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           End If
                        Case cmdLabel
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected label id in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Check for duplicate label id.
                              pv = Val(tokens(2))
                              If LabelIsDuplicate(pv, prog) = FALSE Then
                                 program(prog).p1 = pv
                              Else
                                 Print "Duplicate label id in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                              EndIf
                           EndIf
                        Case cmdCmp
                           'Make sure we have the correct number of parms. 
                           If tcnt < 3 Then
                              Print "Expected memory locations in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(3))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p2 = pv
                                 AddMemToMap program(prog).p2
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           End If
                        Case cmdBranch, cmdBranchNeg, cmdBranchZero
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected label id in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              pv = Val(tokens(2))
                              program(prog).p1 = pv
                           EndIf
                        Case cmdBranchRel
                           If tcnt < 2 Then
                              Print "Expected memory location in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdLoopBranch
                           If tcnt < 4 Then
                              Print "Expected memory location and label in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(3))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p2 = pv
                                 AddMemToMap program(prog).p2
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              'Get the label id.
                              pv = Val(tokens(4))
                              program(prog).p3 = pv
                           EndIf
                        Case cmdPause
                           'Load the values into the program array.
                           program(prog).opcode = idx
                        Case cmdDump
                           'Load the values into the program array.
                           program(prog).opcode = idx
                        Case cmdMemMax
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected memory location in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdScr
                           'Make sure we have the correct number of parms. 
                           If tcnt < 3 Then
                              Print "Expected rows and columns in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              pv = Val(tokens(2))
                              program(prog).p1 = pv
                              pv = Val(tokens(3))
                              program(prog).p2 = pv
                           EndIf
                        Case cmdLoc
                           'Make sure we have the correct number of parms. 
                           If tcnt < 3 Then
                              Print "Expected row and column in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then
                                 program(prog).p1 = pv
                              Else
                                 Print "Invalid memory location in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              EndIf
                              pv = Val(tokens(3))
                              If (pv >= 0) And (pv <= memmax) Then
                                 program(prog).p2 = pv
                              Else
                                 Print "Invalid memory location in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              EndIf
                           EndIf
                        Case cmdClr
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected color number in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              pv = Val(tokens(2))
                              'Validate the color number.
                              If (pv >= 0) And (pv <= 15) Then  
                                 program(prog).p1 = pv
                              Else
                                 Print "Invalid color number in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              'Check to see if we have a background color.
                              If tcnt = 3 Then
                                 'Validate the color number.
                                 pv = Val(tokens(3))
                                 If (pv >= 0) And (pv <= 15) Then  
                                    program(prog).p2 = pv
                                 Else
                                    Print "Invalid color number in line " & lnecnt & ": " & lne & "."
                                    Print
                                    Print "Press any key to exit."
                                    Sleep
                                    ret = FALSE
                                    Exit Do
                                 End If
                              Else
                                 'No background color.
                                 program(prog).p2 = -1
                              EndIf
                           EndIf
                        Case cmdClrM
                           'Make sure we have the correct number of parms. 
                           If tcnt < 2 Then
                              Print "Expected color number in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              pv = Val(tokens(2))
                              'Validate the color number.
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                              Else
                                 Print "Invalid mem location in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              'Check to see if we have a background color.
                              If tcnt = 3 Then
                                 'Validate the color number.
                                 pv = Val(tokens(3))
                                 If (pv >= 0) And (pv <= memmax) Then  
                                    program(prog).p2 = pv
                                 Else
                                    Print "Invalid memory location in line " & lnecnt & ": " & lne & "."
                                    Print
                                    Print "Press any key to exit."
                                    Sleep
                                    ret = FALSE
                                    Exit Do
                                 End If
                              Else
                                 'No background color.
                                 program(prog).p2 = -1
                              EndIf
                           EndIf
                        Case cmdRand
                           'Generates a random integer from 0 to limit.
                           'Make sure we have the correct number of parms. 
                           If tcnt < 3 Then
                              Print "Expected memory location and value in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              program(prog).p2 = Val(tokens(3))
                           EndIf
                        Case cmdCls
                           'Load the values into the program array.
                           program(prog).opcode = idx
                        Case cmdIKey, cmdGKey
                           'Make sure we have the correct number of parms. 
                           If tcnt < 4 Then
                              Print "Expected memory locations and value in line " & lnecnt & ": " & lne & "."
                              Print
                              Print "Press any key to exit."
                              Sleep
                              ret = FALSE
                              Exit Do
                           Else
                              'Load the values into the program array.
                              program(prog).opcode = idx
                              'Validate the memory location.
                              pv = Val(tokens(2))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p1 = pv
                                 AddMemToMap program(prog).p1
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(3))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p2 = pv
                                 AddMemToMap program(prog).p2
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                              pv = Val(tokens(4))
                              If (pv >= 0) And (pv <= memmax) Then  
                                 program(prog).p3 = pv
                                 AddMemToMap program(prog).p3
                              Else
                                 Print "Invalid memory address in line " & lnecnt & ": " & lne & "."
                                 Print
                                 Print "Press any key to exit."
                                 Sleep
                                 ret = FALSE
                                 Exit Do
                              End If
                           EndIf
                        Case cmdHalt
                           'Load the values into the program array.
                           program(prog).opcode = idx
                     End Select
                  Else
                     'Opcode not found.
                     Print "Expected opcode in line " & lnecnt & ": " & lne & "."
                     Print
                     Print "Press any key to exit."
                     Sleep
                     Close
                     End
                  EndIf
               Else
                  Print "Expected opcode in line " & lnecnt & ": " & lne & "."
                  Print
                  Print "Press any key to exit."
                  Sleep
                  Close
                  End
               EndIf
            End If
         End If
      Loop
      Close
   EndIf
   
   'If all is ok, reesolve labels.
   If ret = TRUE Then
      ret = ResolveLabels()
   EndIf
   
   Return ret
End Function
