/'****************************************************************************
*
* Name: simtron2.bas
*
* Synopsis: A small virtual machine for the SAL (2) language.
*
* Description: Simtron is an extended version of the virtual machine presented
*              in C++ How to Program by Deitel & Deitel, Prentice Hall Publishing. 
*              The Simtron uses a language called Simple Assembler Language. 
*              This version adds several new commands to the commands listed in the 
*              book. See the manual simtron.html for detailed information.
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*****************************************************************************'/
#Include "simdata2.bi"
#Include "simparse2.bi"

'Set the console to 50 lines.
Width scol, srow
Randomize Timer

'Returns a random number within range.
Function RandomRange(lowerbound As Integer, upperbound As Integer) As Integer
	Return Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
End Function

'Parse the file.
ret = ParseFile()
'Make sure we have something to run.
If ret = TRUE Then
   'Run the program.
   Do
      'Run each command.
      Select Case program(progptr).opcode
         Case cmdSet, cmdSetC
            'Set the memory to value stored in program.
            memory(program(progptr).p1) = program(progptr).p2
            progptr += 1
         Case cmdRand
            'Set the memory to value stored in program.
            memory(program(progptr).p1) = RandomRange(0, program(progptr).p2)
            progptr += 1
         Case cmdRead
            'Get value from user and store into memory location.
            Dim s As String
            Input "# ",s 
            Print 
            'Check to see if character was entered.
            If Mid(s, 1, 1) = Chr(39) Then
               memory(program(progptr).p1) = Asc(Mid(s, 2, 1))
            Else
               memory(program(progptr).p1) = ValInt(s)
            EndIf
            progptr += 1
         Case cmdReadC
            'Get value from user and store into memory location.
            Dim s As String
            Input "$ ",s 
            Print 
            'Get the ascii code of entered character.
            memory(program(progptr).p1) = Asc(s)
            progptr += 1
         Case cmdWrite
            'Print memory value.
            Print memory(program(progptr).p1);
            progptr += 1
         Case cmdWriteLn
            Print
            progptr += 1
         Case cmdWriteAsc
            'Print memory value as ascii string.
            Print Chr(memory(program(progptr).p1));
            progptr += 1
         Case cmdMove
            'Move value of memory location 1 to memory location 2.
            memory(program(progptr).p2) = memory(program(progptr).p1)
            progptr += 1
         Case cmdStore
            Dim As Integer addr = memory(program(progptr).p2)
            If (addr >= 0) And (addr <= memmax) Then
               memory(addr) = memory(program(progptr).p1)
               AddMemToMap addr
            Else
               Print "Invalid memory address in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
               Print
               Print "Press any key to exit."
               Sleep
               done = TRUE
            EndIf
            progptr += 1
         Case cmdLoad
            Dim As Integer addr = memory(program(progptr).p2)
            If (addr >= 0) And (addr <= memmax) Then
               memory(program(progptr).p1) = memory(addr) 
               AddMemToMap addr
            Else
               Print "Invalid memory address in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
               Print
               Print "Press any key to exit."
               Sleep
               done = TRUE
            EndIf
            progptr += 1
         Case cmdAdd
            'Add memory location 1 and memory location 2 and put result in memory location 3.
            memory(program(progptr).p3) = memory(program(progptr).p1) + memory(program(progptr).p2)
            progptr += 1
         Case cmdSub
            'Subtract memory location 1 and memory location 2 and put result in memory location 3.
            memory(program(progptr).p3) = memory(program(progptr).p1) - memory(program(progptr).p2)
            progptr += 1
         Case cmdDivide
            'Check for divide by zero.
            If memory(program(progptr).p2) = 0 Then
               Print "Divide by 0 in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
               Print
               Print "Press any key to exit."
               Sleep
               done = TRUE
            Else
               'Divide memory location 1 by memory location 2 and put result in memory location 3.
               memory(program(progptr).p3) = memory(program(progptr).p1) \ memory(program(progptr).p2)
            EndIf
            progptr += 1
         Case cmdMultiply
            'Multiply memory location 1 and memory location 2 and put result in memory location 3.
            memory(program(progptr).p3) = memory(program(progptr).p1) * memory(program(progptr).p2)
            progptr += 1
         Case cmdMod
            'Mod memory location 1 and memory location 2 and put result in memory location 3.
            memory(program(progptr).p3) = memory(program(progptr).p1) Mod memory(program(progptr).p2)
            progptr += 1
         Case cmdInc
            'Increment memory location by 1.
            memory(program(progptr).p1) = memory(program(progptr).p1) + 1
            progptr += 1
         Case cmdDec
            'Decrement memory location by 1.
            memory(program(progptr).p1) = memory(program(progptr).p1) - 1
            progptr += 1
         Case cmdLabel
            'Skip over labels.
            progptr += 1
         Case cmdCmp
            'Compare two mmeory locations and set z register.
            If memory(program(progptr).p1) < memory(program(progptr).p2) Then
               zreg = -1
            ElseIf memory(program(progptr).p1) > memory(program(progptr).p2) Then
               zreg = 1
            Else
               zreg = 0
            EndIf
            progptr += 1
         Case cmdBranch
            'Set progptr to target value.
            progptr = program(progptr).target
         Case cmdBranchNeg
            'If acc is negative then set progptr to label, else inc progptr.
            If zreg < 0 Then
               progptr = program(progptr).target
            Else
               progptr += 1
            EndIf
         Case cmdBranchZero
            'If acc is zero then set progptr to label, else inc progptr.
            If zreg = 0 Then
               progptr = program(progptr).target
            Else
               progptr += 1
            EndIf
         Case cmdBranchRel
            'Branch based on label id found in memory location.
            Dim As Integer brtarget = GetLabelTarget(memory(program(progptr).p1))
            If brtarget = 0 Then
               Print "Invalid label id in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
               Print
               Print "Press any key to exit."
               Sleep
               done = TRUE
            Else
               progptr = brtarget
            EndIf
         Case cmdLoopBranch
            'If memory location 1 is less than memory location 2, branch to label.
            If memory(program(progptr).p1) < memory(program(progptr).p2) Then
               progptr = program(progptr).target
            Else
               progptr += 1
            EndIf
         Case cmdPause
            Sleep
            progptr += 1
         Case cmdDump
            'Dumps memory to screen.
            Print
            Print "Z Register: " & zreg
            Print "Instruction Pointer: " & progptr
            Print
            Print "Memory"
            Print "------"
            Print
            For i As Integer = 1 To UBound(memmap)
               Print memmap(i) & ": " & memory(memmap(i))
            Next
            progptr += 1
         Case cmdMemMax
            memory(program(progptr).p1) = memmax
            progptr += 1
         Case cmdLoc
            'Need to validate the row column.
            If (memory(program(progptr).p1) >= 1) And (memory(program(progptr).p1) <= srow) Then
               If (memory(program(progptr).p2) >= 1) And (memory(program(progptr).p2) <= scol) Then
                  Locate memory(program(progptr).p1), memory(program(progptr).p2)
               Else
                  Print "Invalid column in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
                  Print
                  Print "Press any key to exit."
                  Sleep
                  done = TRUE
               EndIf
            Else
               Print "Invalid row in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
               Print
               Print "Press any key to exit."
               Sleep
               done = TRUE
            EndIf
            progptr += 1
         Case cmdScr
            'Set the window to the new size.
            scol = program(progptr).p1
            srow = program(progptr).p2
            Width scol, srow
            progptr += 1
         Case cmdCls 
            'Clear screen.
            Cls
            progptr += 1
         Case cmdClr
            'Set color.
            If program(progptr).p2 = -1 Then
               Color program(progptr).p1
            Else
               Color program(progptr).p1, program(progptr).p2
            EndIf
            progptr += 1
         Case cmdClrM
            Dim As Integer clrnum, clrnum2
            'Set color.
            If program(progptr).p2 = -1 Then
               clrnum = memory(program(progptr).p1)
               If (clrnum >= 0) And (clrnum <= 15) Then
                  Color clrnum
               Else
                  Print "Invalid color number in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
                  Print
                  Print "Press any key to exit."
                  Sleep
                  done = TRUE
               End If
            Else
               clrnum = memory(program(progptr).p1)
               clrnum2 = memory(program(progptr).p2)
               If (clrnum >= 0) And (clrnum <= 15) Then
                  If (clrnum2 >= 0) And (clrnum2 <= 15) Then   
                     Color memory(program(progptr).p1), memory(program(progptr).p2)
                     Else
                     Print "Invalid color number in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
                     Print
                     Print "Press any key to exit."
                     Sleep
                     done = TRUE
                  End If
               Else
                  Print "Invalid color number in line " & program(progptr).linecnt & ": " & program(progptr).progline & "."
                  Print
                  Print "Press any key to exit."
                  Sleep
                  done = TRUE
               EndIf
            EndIf
            progptr += 1
         Case cmdIKey 'Does not wait for key press.
            Dim As String s = InKey
            Dim As Integer i = Len(s)
            If i = 2 Then
               'Two key codes are waiting: extended in first memory location, code in second. 
               memory(program(progptr).p1) = 2
               memory(program(progptr).p2) = Asc(Mid(s, 1, 1))
               memory(program(progptr).p3) = Asc(Mid(s, 2, 1))
            ElseIf i = 1 Then
               'One key code is waiting: code in first memory location.
               memory(program(progptr).p1) = 1
               memory(program(progptr).p2) = Asc(Mid(s, 1, 1))
               memory(program(progptr).p3) = 0
            Else
               'No key code is waiting.
               memory(program(progptr).p1) = 0
               memory(program(progptr).p2) = 0
               memory(program(progptr).p3) = 0
            EndIf
            progptr += 1
         Case cmdGKey 'Waits for key press.
            Dim As Integer i = GetKey
            If i > 255 Then
               'Two key codes are waiting: extended in first memory location, code in second. 
               memory(program(progptr).p1) = 2
               memory(program(progptr).p2) = (i And &hff)
               memory(program(progptr).p3) = (i Shr 8)
            Else
               'One key code is waiting: code in first memory location.
               memory(program(progptr).p1) = 1
               memory(program(progptr).p2) = i
               memory(program(progptr).p3) = 0
            EndIf
            progptr += 1
         Case cmdHalt 
            'Halt program.
            done = TRUE
      End Select
      'Check to see if we are at the end of the program.
      If progptr > UBound(program) Then
         done = TRUE
      EndIf
   Loop Until done = TRUE
End If
