Option Explicit

#define starsupper 200
#define shipdodge 500
#define lasermax 1000
#define shieldmax 100

Const fbWhite = Rgb(255, 255, 255)
Const fbBlack = Rgb(0, 0, 0)
Const fbGreen = Rgb(0, 255, 0)
Const fbRed = Rgb(255, 0, 0)
Const fbYellow = Rgb(255, 255, 0)
Const fbMarsYellow = Rgb (227, 112, 026)

Type startype
    dist As Integer
    row As Integer
    col As Integer
End Type

Type shiptype
    dist As Integer
    row As Integer
    col As Integer
    dodge As Integer
    sclr As Integer
    shp As String
    power As Integer
    sdirx As Integer
    sdiry As Integer
End Type

Dim Shared stars(1 To starsupper) As startype
Dim Shared cursor(0 To 15, 0 To 7) As Integer
Dim Shared ship(1 To 5) As shiptype
Dim Shared As Integer score, shield = shieldmax, laser = lasermax
Dim t As Single


Function GetRandom(lowerbound As Integer, upperbound As Integer) As Integer
   GetRandom = Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
End Function 

cursordata:
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,16777215,0,0,0,16777215,0,16777215,0,0,0,16777215,0,0
Data 0,0,0,16777215,1,16777215,1,16777215,1,16777215,1,16777215,0,16777215,0,0
Data 0,0,1,16777215,1,16777215,0,16777215,0,16777215,1,16777215,1,16777215,0,0
Data 0,0,1,16777215,0,0,1,16777215,1,16777215,0,0,1,16777215,0,0
Data 0,0,1,16777215,0,16777215,1,16777215,1,16777215,0,16777215,1,16777215,0,0
Data 0,0,1,16777215,1,16777215,0,16777215,0,16777215,1,16777215,1,16777215,0,0
Data 0,0,0,16777215,1,16777215,1,16777215,1,16777215,1,16777215,0,16777215,0,0
Data 0,0,0,16777215,0,0,0,16777215,0,16777215,0,0,0,16777215,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0
Data 0,0,0,0,0,0,0,16777215,0,16777215,0,0,0,0,0,0

Sub InitGlyph
    Dim As Integer i, j, pcolor, pixel

    Restore cursordata

    For i = 0 To 15
        For j = 0 To 7
            Read pixel, pcolor
            cursor(i, j) = pixel
        Next
    Next
    
End Sub

Sub InitStars
    Dim As Integer i, j, row, col
    
    For i = 1 To starsupper
        stars(i).row = GetRandom(1, 30)
        stars(i).col = GetRandom(1, 80)
        stars(i).dist = GetRandom(1, 255)
    Next
    
End Sub

Sub ResetShip(idx As Integer)
    ship(idx).row = 15
    ship(idx).col = GetRandom(10, 70)
    ship(idx).dist = 255
    ship(idx).dodge = GetRandom(1, shipdodge)
    ship(idx).sclr = Rgb(GetRandom(100, 250), GetRandom(100, 250), GetRandom(100, 250))
    ship(idx).power = GetRandom(1, 10)
    ship(idx).shp = "@"
    ship(idx).sdirx = GetRandom(-1, 1)
    ship(idx).sdiry = GetRandom(-1, 1)
End Sub

Sub InitShips
    Dim i As Integer
    
    For i = 1 To Ubound(ship)
        ResetShip i
    Next
        
End Sub

Sub PrintGlyph(x As Integer, y As Integer, cl As Integer)
    Dim As Integer i, j, pcolor, pixel


    For i = 0 To 15
        For j = 0 To 7
            If cursor(i, j) = 1 Then
                Pset (x + j, y + i), cl
             End If
        Next
    Next
End Sub

Sub MoveStars
    Dim As Integer i, row, col
    
    For i = 1 To starsupper
        If stars(i).row < 15 Then
            stars(i).row += 1
        Elseif stars(i).row > 15 Then
            stars(i).row -= 1
        Else
            stars(i).dist = 0
        End If
        
        If stars(i).col < 40 Then
            stars(i).col += 1
        Elseif  stars(i).col > 40 Then
            stars(i).col -= 1
        Else
            stars(i).dist = 0
        End If
        
        stars(i).dist -= 10
        
        If stars(i).dist < 1 Then
            stars(i).dist = 255
            If GetRandom(1, 10) < 6 Then
                stars(i).row = GetRandom(1, 30)
                If GetRandom(1, 10) < 6 Then
                    stars(i).col = 1
                Else
                    stars(i).col = 80
                End If
            Else
                stars(i).col = GetRandom(1, 80)
                If GetRandom(1, 10) < 6 Then
                    stars(i).row = 1
                Else
                    stars(i).row = 30
                End If
            End If
        End If
    Next
        
End Sub

Sub MoveShips
    Dim i As Integer
        
    For i = 1 To Ubound(ship)
        ship(i).dist -= 1
        If ship(i).dist < 50 Then
            ship(i).shp = "|---@---|"
        Elseif (ship(i).dist > 49) And (ship(i).dist < 100) Then
            ship(i).shp = "|--@--|"
        Elseif (ship(i).dist > 99) And (ship(i).dist < 150) Then
            ship(i).shp = "--@--"
        Elseif (ship(i).dist > 149) And (ship(i).dist < 200) Then
            ship(i).shp = "-@-"
        Elseif ship(i).dist > 200 Then
            ship(i).shp = "@"
        End If
        If ship(i).dist < 11 Then
            shield -= ship(i).power
            Color , fbRed
            Cls
            Screensync
            Screencopy
            ResetShip i
        End If
        If GetRandom(1, shipdodge) <= ship(i).dodge Then
            ship(i).row += ship(i).sdiry
            If ship(i).row < 2 Then 
                ship(i).row = 2
                ship(i).sdiry = ship(i).sdiry * -1
            End If
            If ship(i).row > 29 Then 
                ship(i).row = 29
                ship(i).sdiry = ship(i).sdiry * -1
            End If
        End If 
        If GetRandom(1, shipdodge) <= ship(i).dodge Then
            ship(i).col += ship(i).sdirx
            If ship(i).col < 1 Then 
                ship(i).col = 1
                ship(i).sdirx = ship(i).sdirx * -1
            End If
            If ship(i).col > 70 Then 
                ship(i).col = 70
                ship(i).sdirx = ship(i).sdirx * -1
            End If
        End If 
    Next
    
End Sub

Function GetShipIndex(mx As Integer, my As Integer) As Integer
    Dim As Integer i, sx1, sy1, sx2, sy2, ret = -1
    Dim As Integer mmx, mmy
    
    mmx = mx + 4
    mmy = my + 8
    For i = 1 To Ubound(ship)
        sy1 = (ship(i).row - 1) * 16
        sy2 = sy1 + 16
        sx1 = (ship(i).col - 1) * 8
        sx2 = sx1 + (Len(ship(i).shp) * 8)
        If (mmx >= sx1) And (mmx <= sx2) Then
            If (mmy >= sy1) And (mmy <= sy2) Then
                ret = i
                Exit For
            End If
        End If 
    Next
    Return ret
End Function

Sub DestroyShip(idx As Integer)
    Dim nb As Integer
    
    score = score + (ship(idx).power * 10)   
    Color fbMarsYellow, fbBlack
    Locate ship(idx).row, ship(idx).col
    Print String(Len(ship(idx).shp), 15);
    Sleep 10, 1
    ResetShip idx
End Sub

Sub PrintStars
    Dim As Integer i
    
    For i = 1 To starsupper
        Locate stars(i).row, stars(i).col
        Color Rgb(stars(i).dist, stars(i).dist, stars(i).dist), fbBlack
        Print ".";
    Next
End Sub

Sub PrintDisplay
    Dim As Integer i, row, col, shipidx
    Dim As Integer mx, my, mw, mb
    Dim As String myscore    

    Color , fbBlack
    Cls
    PrintStars
    For i = 1 To Ubound(ship)
        Locate ship(i).row, ship(i).col
        Color ship(i).sclr, fbBlack
        Print ship(i).shp
    Next
    Getmouse mx, my, mw, mb
    If (mx > -1) And (my > -1) Then
        If laser < 10 Then
            PrintGlyph mx, my, fbRed
        Else
            shipidx = GetShipIndex(mx, my)
            If shipidx = -1 Then
                PrintGlyph mx, my, fbYellow
            Else
                PrintGlyph mx, my, fbGreen
            End If
            If mb And 1 Then
                If laser > 10 Then
                    Line (320, 480)-(mx + 4, my + 8), fbRed
                    If shipidx <> -1 Then
                        DestroyShip shipidx
                    End If
                    laser -= 10
                End If
            End If
        End If
        laser += 1
        If laser > lasermax Then laser = lasermax
    End If
    Locate 1, 1
    Color fbWhite, fbBlack
    Print "Laser:";laser;" Shield:";shield
    myscore = "Score: " & score
    Locate 1, 80 - Len(myscore) - 1
    Print myscore;
    Screensync
    Screencopy 
End Sub

Function PrintTitle() As Integer
    Dim As Integer ln
    
    Color fbWhite, fbBlack    
    ln = 11
    Locate ln, 16
    Print " _____     _ _"                                   
    ln += 1
    Locate ln, 16
    Print "|_   _|   (_) |"                                  
    ln += 1
    Locate ln, 16
    Print "  | | __ _ _| | __ _ _   _ _ __  _ __   ___ _ __" 
    ln += 1
    Locate ln, 16
    Print "  | |/ _` | | |/ _` | | | | '_ \| '_ \ / _ \ '__|"
    ln += 1
    Locate ln, 16
    Print "  | | (_| | | | (_| | |_| | | | | | | |  __/ |"   
    ln += 1
    Locate ln, 16
    Print "  \_/\__,_|_|_|\__, |\__,_|_| |_|_| |_|\___|_|"   
    ln += 1
    Locate ln, 16
    Print "                __/ |"                            
    ln += 1
    Locate ln, 16
    Print "               |___/"
    
    Return ln                             
End Function

Sub Title
    Dim t As Single
    Dim ln As Integer
    
    Do
        t = Timer
        Color , fbBlack
        Cls
        MoveStars
        PrintStars
        ln = PrintTitle
        ln += 2
        Locate ln, 29
        Print "Press Any Key to Start"
        Screensync
        Screencopy
        Do
            Sleep 1
        Loop Until Timer > (t + .08)
                    
    Loop Until Inkey<>""

End Sub

Function EndTitle() As Integer
    Dim As String key, mess
    Dim t As Single
    Dim ln As Integer
    
    Do
        key = Inkey
        t = Timer
        Color , fbBlack
        Cls
        MoveStars
        PrintStars
        ln = PrintTitle
        ln += 2
        mess = "Game Over" 
        Locate ln, 40 - (Len(mess) \ 2)
        Print mess
        ln += 1
        mess = "Score: " & score
        Locate ln, 40 - (Len(mess) \ 2) 
        Print mess
        ln += 1
        mess = "Play Again (Y/N)"
        Locate ln, 40 - (Len(mess) \ 2)
        Print mess
        Screensync
        Screencopy
        Do
            Sleep 1
        Loop Until Timer > (t + .08)
                    
    Loop Until key <> ""
    If Ucase(key) = "Y" Then
        Return 1
    Else
        Return 0
    End If
End Function

Randomize Timer
Screen 18, 32, 2
Screenset 1, 0
Locate ,,0
Setmouse ,,0

InitGlyph 
InitStars
InitShips
Title
doagain:
Do
    t = Timer
    MoveStars
    MoveShips
    PrintDisplay
    Do
        Sleep 1
    Loop Until Timer > (t + .08)
    If shield <= 0 Then Exit Do
Loop Until Inkey = Chr(27)
If EndTitle Then
    InitShips
    score = 0
    laser = lasermax
    shield = shieldmax 
    Goto doagain
End If
Setmouse ,,1
End
