/'****************************************************************************
*
* Name: common.bi
*
* Synopsis: Common routines for the game Yablon.
*           
*
* Description: This file contains common routines used in the game Yablon.
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
*****************************************************************************'/

'Define True/False values.
#Ifndef FALSE
	#Define FALSE 0
   #Define TRUE (Not FALSE)
#EndIf

'Create a NULL value.
#Ifndef NULL
    #Define NULL 0
#EndIf

#Define tturn1 0
#Define tturn2 1
#Define tpayoff 3
#Define tpair 4

'menu ids.
Enum mmenuid
   mNewGame = 1
   mHighScores
   mInstructions
   mCredits
   mExit
End Enum

Const yabver = "0.1.1"
Const bitsh = 15
Const bitsw = 6
Const scrw = 640
Const scrh = 480
Const txtlen = 90

'key consts
Const xk = Chr(255)
Const key_up = xk + "H"
Const key_dn = xk + "P"
Const key_F1 = xk + Chr(59)
Const key_F2 = xk + Chr(60)
Const key_F5 = xk + Chr(63)
Const key_F6 = xk + Chr(64)
const key_close = xk + "k"
Const key_esc = Chr(27)
Const key_enter = Chr(13)

'Used to sort the high scores.
Type sc
   score As Integer
   idx As Integer
End Type

'Returns the center column of the passed text.
Function CenterText (txt As String) As Integer
	Return (scrw / 2) - ((Len(txt) * bitsw) / 2)
End Function

'' A function that creates an image buffer with the same
'' dimensions as a BMP image, and loads a file into it.
'' Code by counting_pine
Function bmp_load( ByRef filename As String ) As Any Ptr
	Dim As Integer filenum, bmpwidth, bmpheight
  	Dim As Any Ptr img

   '' open BMP file
   filenum = FreeFile()
   If Open( filename For Binary Access Read As #filenum ) <> 0 Then 
   	Return NULL
   Else
   	'' retrieve BMP dimensions
      Get #filenum, 19, bmpwidth
      Get #filenum, 23, bmpheight
    	Close #filenum
   	'' create image with BMP dimensions
   	img = ImageCreate( bmpwidth, Abs(bmpheight) )
   	If img = NULL Then 
   		Return NULL
   	Else
   		'' load BMP file into image buffer
   		If BLoad( filename, img ) <> 0 Then 
    			ImageDestroy( img )
    			Return NULL
    		Else
    			Return img
    		EndIf
   	EndIf
   EndIf

End Function

'Returns a random number within range.
Function Rand(lowerbound As Integer, upperbound As Integer) As Integer
	Return Int((upperbound - lowerbound + 1) * Rnd + lowerbound)
End Function

'Wraps text to length.
Function WordWrap(ByRef InS As String, sLen As Integer) As String
    Dim As Integer i = sLen, sl, backflag = FALSE
    Dim As String sret, ch
    
    sl = Len(InS)
    If sl <= sLen Then
        sret = InS
        InS = ""
    Else
        Do
            ch = Mid(InS, i, 1)
            If ch = Chr(32) Then
                Exit Do
            End If
            If BackFlag = FALSE Then
                If i + 1 <= sl Then
                    i+= 1
                End If
                BackFlag = TRUE
            Else
                i -= 1
            End If
        Loop Until i = 0 Or ch = Chr(32)
        If i > 0 Then
            sret = Mid(InS, 1, i)
            InS = Mid(InS, i + 1)
        Else
            sret = ""
        End If 
    End If
    Return sret
End Function
