/'****************************************************************************
*
* Name: fontbj.bi
*
* Synopsis: Font object file.
*           
*
* Description: The font object handles the displaying of fonts in the drawstring
*              format. Fonts can come in two colors, a forecolor and backcolor               
*              to add shading to the font.
*               
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
*****************************************************************************'/

Namespace font

Const fntBLACK = RGB(0, 0, 0)
Const fntWHITE = RGB(255, 255, 255)


'Font object.
Type fntobj
	Private:
	_fntb As Any Ptr
	_fntw As Any Ptr
	Declare Function _LoadFont (fontw As String, fontb As String) As Integer
	Declare Sub _ClearFont ()
	Public:
	Declare Constructor ()
	Declare Destructor ()
	Declare Function LoadFont (fontw As String, fontb As String) As Integer
	Declare Sub DrawString (x As Integer, y As Integer, txt As String, wonly As Integer = FALSE, bonly As Integer = FALSE)
	Declare Sub ClearFont ()
End Type

function fntobj._LoadFont (fontw As String, fontb As String) As Integer
   Dim ret As Integer = TRUE
   
	_fntw = bmp_load(fontw)
	_fntb = bmp_load(fontb)
	If _fntw = NULL Then
	   ret = FALSE
	EndIf
	If _fntb = NULL Then
	   ret = FALSE
	EndIf
	
	Return ret
End Function

Sub fntobj._ClearFont ()
	If _fntw <> NULL Then
		ImageDestroy _fntw
	End If
	If _fntb <> NULL Then
		ImageDestroy _fntb
	End If
End Sub

Constructor fntobj ()
	_fntb = NULL
	_fntw = NULL
End Constructor

Destructor fntobj ()
   _ClearFont
End Destructor

function fntobj.LoadFont (fontw As String, fontb As String) As Integer
   Dim ret As Integer

	ret = _LoadFont(fontw, fontb)
	
	Return ret
End Function

Sub fntobj.DrawString (x As Integer, y As Integer, txt As String, wonly As Integer = FALSE, bonly As Integer = FALSE)
	If (_fntb = NULL) Or (_fntw = NULL) Then
	   If wonly = FALSE Then
		   Draw String (x, y), txt, fntBLACK
	   End If
	   If bonly = FALSE Then
		   Draw String (x - 1, y - 1), txt, fntWHITE
	   End If
	Else
	   If wonly = FALSE Then
		   Draw String (x, y), txt,, _fntb
	   End if
	   If bonly = FALSE Then
		   Draw String (x - 1, y - 1), txt,, _fntw
	   End If
	End If	
End Sub

Sub fntobj.ClearFont ()
   _ClearFont   
End Sub

End Namespace
