/'****************************************************************************
*
* Name: yablon.bas
*
* Synopsis: Yablon is an Acey-Duecy card game In FreeBasic.
*           
*
* Description: Yablon is an old name for the well-known casino game Acey-Duecy.
*              The game uses the card graphics posted by D.J. Peters on the 
*              FreeBasic forum (http://www.freebasic.net/forum/viewtopic.php?t=14993)
*              and card backs from http://www.jfitz.com/cards/. 
*
* Copyright 2010, Richard D. Clark
*
*                          The Wide Open License (WOL)
*
* Permission to use, copy, modify, distribute and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice and this license appear in all source copies. 
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
* ANY KIND. See http://www.dspguru.com/wol.htm for more information.
*
*****************************************************************************'/
#Include "fbgfx.bi"
#Include "common.bi"
#Include "cardobj.bi"
#Include "fontobj.bi"
#Include "stringlist.bi"

Dim Shared pcards As cards.cardobj
Dim Shared fnt As font.fntobj
Dim Shared hiscore As strlist.stringlist
Dim Shared As Any Ptr chip5, chip10, backg
Dim Shared mitems(mNewGame To mExit) As String
Dim Shared As Integer money, score, bet1, bet2, payout, ispair
Dim Shared As Integer maxturns, maxbet, maxpayout, maxpairs, maxpairwin
Dim Shared deck(1 To 52) As cards.cardid
Dim Shared As cards.cardid crd1, crd2, crd3
Dim As Integer ret
Dim mmid As mmenuid

Randomize Timer
ScreenRes scrw, scrh, 32
WindowTitle "Yablon v." & yabver 

'Load up all the graphic files.
Function LoadGraphics () As Integer
   Dim As Integer ret
   
   #ifdef __FB_WIN32__   
   'Load the font.
   ret = fnt.LoadFont("gfx/bitswhite.bmp", "gfx/bitsblack.bmp")
   If ret = TRUE Then
   #EndIf
      'Load the cards.   
      ret = pcards.LoadCards("gfx/cards.bmp", "gfx/backs.bmp")
      If ret = TRUE Then
         backg = bmp_load("gfx/background.bmp")
      End If
      If backg = NULL Then
         ret = FALSE
      EndIf
   #ifdef __FB_WIN32__
   End If
   #EndIf
   
   Return ret
End Function

Sub CleanUp
   If backg <> NULL Then
      ImageDestroy backg
   EndIf
End Sub

'Draw main menu.
Sub DrawMainMenu (m As mmenuid)
   Dim As String txt
   Dim As Integer x, y
   
   ScreenLock
  'Put the background.
   Put (0, 0), backg, PSet
   'Draw some cards.
   pcards.DrawCardFront 10, 10, cards.cardid.cClubAce 
   pcards.DrawCardFront scrw - pcards.CardWidth - 10, 10, cards.cardid.cDiamAce
   pcards.DrawCardFront 10, scrh - pcards.CardHeight - 10, cards.cardid.cHearAce 
   pcards.DrawCardFront scrw - pcards.CardWidth - 10, scrh - pcards.CardHeight - 10, cards.cardid.cSpadAce
   'Draw the title.
   txt = "Yablon Main Menu"
   x = CenterText(txt)
   y = bitsh + 1
   fnt.DrawString x, y, txt
   y = bitsh * 6
   For i As Integer = mNewgame To mExit
      x = CenterText(mitems(i))
      If m = i Then
         fnt.DrawString x, y, mitems(i)
      Else
         fnt.DrawString x, y, mitems(i), FALSE, TRUE
      EndIf
      y = y + (bitsh * 2)
   Next
   
   ScreenUnLock
End Sub

'Show the menu and return the id.
Function ShowMenu () As mmenuid
   Dim mm As mmenuid = mNewGame
   Dim As String ch
   
   Do: Loop Until InKey = ""
   DrawMainMenu mm   
   Do
      ch = InKey
      If ch <> "" Then
         If ch = key_up Then
            mm -= 1
            If mm < mNewGame Then
               mm = mExit
            EndIf
         EndIf
         If ch = key_dn Then
            mm += 1
            If mm > mExit Then
               mm = mNewGame
            EndIf
         EndIf
         DrawMainMenu mm
      End If
      Sleep 1
   Loop Until ch = key_enter

   Return mm
End Function

'Display the high scores.
Sub ShowHighScores ()
   Dim As Integer ret, i, x, y
   Dim As String txt, ptxt, hscore
   
   ret = hiscore.LoadFromFile ("yscore.dat")
	If score > 0 Then
	   hscore = "Score: " & score & " Money: " & money & " Turns: " & maxturns & " Max bet: " & maxbet
	   hscore &= " Max Payout: " & maxpayout & " Num pairs: " & maxpairs & "  Won Pairs: " & maxpairwin
		If ret = FALSE Then
			ret = hiscore.Add(hscore)
		Else
			ret = hiscore.Add(hscore)
			hiscore.SortAscending = TRUE
			hiscore.Sort
			If hiscore.Count > 10 Then
				ret = hiscore.DeleteItem(hiscore.Count - 1)
			EndIf
		EndIf
		ret = hiscore.SaveToFile("yscore.dat")
	End If
	
   ScreenLock
   Put (0, 0), backg, PSet
   txt = "High Scores"
   x = CenterText(txt)
   y = bitsh + 1
   fnt.DrawString x, y, txt
   If hiscore.Count > 0 Then
      y += bitsh * 2
      x = bitsw
      For i = 0 To hiscore.Count - 1
         txt = hiscore.Strings(i)
         Do While Len(txt) > 0     
   	      ptxt = WordWrap(txt, txtlen)
            fnt.DrawString x, y, ptxt
            y += bitsh + 1
         Loop
      Next
   End If
   ScreenUnLock
   Sleep
End Sub

'Display the instructions and rules.
Sub ShowInstructions ()
   Dim As String txt, ptxt
   Dim As Integer x, y
   
   ScreenLock
   Put (0, 0), backg, PSet
   txt = "Yablon Instructions"
   x = CenterText(txt)
   y = bitsh + 1
   fnt.DrawString x, y, txt
   x = bitsw
   y += bitsh * 2
   txt = "Yablon, also known as Ace-Duece, In Between or Between the Sheets, is a banking game "
   txt &= "in which two cards are dealt face up, and the player bets on whether a third card will rank "
   txt &= "between the first two cards. "
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   y += bitsh + 1
   txt = "The player first places a bet and then two cards are dealt face up on the table. The "
   txt &= "player then decides whether or not to raise the bet. A third card is dealt and if the value of "
   txt &= "the card falls between the values of the other two cards, the player is a winner. Original bets "
   txt &= "are payed out at even money, and raise bets are payed out according to a scale, where the closer "
   txt &= "the two cards are together, the better the payout. The maximum bet is $100."
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   y += bitsh + 1
   txt = "The cards rank from Ace to King with the Ace being low and the King being high. The suit is not a "
   txt &="factor in the game, only the rank of the card. For example, a Two would fall between an Ace and a "
   txt &= "Three, and would be considered a winning hand."
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   txt = "Payouts"
   x = CenterText(txt)
   y += bitsh + 1
   fnt.DrawString x, y, txt
   y += bitsh * 2
   txt = "1 card spread pays 5:1"
   x = CenterText(txt)
   fnt.DrawString x, y, txt
   y += bitsh + 1
   txt = "2 card spread pays 4:1"
   x = CenterText(txt)
   fnt.DrawString x, y, txt
   y += bitsh + 1
   txt = "3 card spread pays 2:1"
   x = CenterText(txt)
   fnt.DrawString x, y, txt
   y += bitsh + 1
   txt = "4 to 11 card spread pays even money"
   x = CenterText(txt)
   fnt.DrawString x, y, txt
   y += bitsh * 2
   x = bitsw
   txt = "When a pair is showing, a third card is dealt immediately. If the result is a three of a kind, "
   txt &= "the player is payed 11:1 on the original bet. There are no raise bets with a pair."    
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   y += bitsh + 1
   txt = "The game is over when the player runs out of money. Each winning hand's payout is added to the score. "
   txt &= "Any money left at the end of play is tallied, but not added to the score."
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   
   ScreenUnLock
   Sleep   
End Sub

'Display the credits.
Sub ShowCredits ()
   Dim As String txt, ptxt
   Dim As Integer x, y
   
   ScreenLock
   Put (0, 0), backg, PSet
   txt = "Credits"
   x = CenterText(txt)
   y = bitsh + 1
   fnt.DrawString x, y, txt
   y += bitsh * 2
   x = bitsw
   txt = "Playing card graphics are from D.J. Peters and were posted on the FreeBasic Forum. The card backs "
   txt &= "are from http://www.jfitz.com/cards/. The program font is Bitstream Vera Sans from "
   txt &= "http://www.gnome.org/fonts/. All other graphics are original work. "
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   y += bitsh * 2
   txt = "Yablon rules are from http://www.casino-info.com/ with minor adjustments to the card rank values."
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   y += bitsh * 2
   txt = "Yablon uses some code posted on the FreeBasic form. See source code for attribution. Yablon is "
   txt & = "Copyright (c) 2010, Richard D. Clark and is released under the Wide-Open License. "
   txt &= "See http://www.dspguru.com/wol.htm for details."
   Do While Len(txt) > 0     
   	ptxt = WordWrap(txt, txtlen)
      fnt.DrawString x, y, ptxt
      y += bitsh + 1
   Loop
   ScreenUnLock
   Sleep   
End Sub

'Loads and shuffles the deck.
Sub InitDeck ()
   Dim As Integer ii, l, b
      
   For i As cards.cardid = cards.cardid.cClubAce To cards.cardid.cSpadKing
      deck(i) = i
   Next
   'Shuffle the deck.
   l = LBound(deck)
   b = UBound(deck)
   For i As integer = l To b 
      ii = Rand(l, b)
      Swap deck(i), deck(ii)
   Next
End Sub

'Returns the next card from the deck.
Function GetNextCard () As cards.cardid
   Static idx As Integer = 1
   Dim ret As cards.cardid
   
   If idx > UBound(deck) Then
      InitDeck
      idx = 1
   EndIf
   ret = deck(idx)
   idx += 1
   
   Return ret
End Function

'Draw the main screen.
Sub DrawMainScreen (turn As Integer = 0)
   Dim As String txt
   Dim As Integer x, y, cx, cy, cx1, cx2, cx3, tx, ty
   Dim As Integer c1, c3, sp
   
   ScreenLock
   Put (0, 0), backg, PSet
   txt = "Yablon"
   x = CenterText(txt)
   y = bitsh + 1
   fnt.DrawString x, y, txt
   y = bitsh * 4
   'Draw the cards and place holders.
   cx = 160
   cy = 130
   pcards.DrawCardBack cx, cy, cards.cardback.bRed
   'First card.
   cx1 = cx + pcards.CardWidth + 10
   pcards.DrawPlaceholder cx1, cy
   'Second card.
   cx2 = cx1 + pcards.CardWidth + 10
   pcards.DrawPlaceholder cx2, cy
   'Third card.
   cx3 = cx2 + pcards.CardWidth + 10
   pcards.DrawPlaceholder cx3, cy
  'Draw the information bar.
   txt = "Score: " & score
   txt &= "  Bank: $" & money
   txt &= "  Bet #1: $" & bet1
   txt &= "  Bet #2: $" & bet2
   tx = CenterText(txt)
   ty = scrh - (bitsh * 2)
   fnt.DrawString tx, ty, txt
   'Draw the command bar.
   If turn < tpayoff Then
      txt = "F1: Bet 5   F2: Bet 10   F5: Remove 5   F6: Remove 10"
      tx = CenterText(txt)
      ty = cy + pcards.CardHeight + 70
      fnt.DrawString tx, ty, txt
      txt = "Enter: Finish Bet   ESC: Exit Game"
      tx = CenterText(txt)
      ty += 30
      fnt.DrawString tx, ty, txt
   Else
      txt = "Press Enter to Continue."
      tx = CenterText(txt)
      ty = cy + pcards.CardHeight + 70
      fnt.DrawString tx, ty, txt
   End If
   'Show pair.
   If turn = tpair Then
      txt = "Pair showing. Third card will be dealt."
      x = CenterText(txt)
      fnt.DrawString x, y, txt
   EndIf
   'Place first bet.
   If turn = tturn1 Then
      txt = "Place first bet."
      x = CenterText(txt)
      fnt.DrawString x, y, txt
   EndIf
   'Place second bet.
   If turn = tturn2 Then
      txt = "Place second bet or pass (press enter)."
      x = CenterText(txt)
      fnt.DrawString x, y, txt
      'Get the spread.
      c1 = pcards.CValue(crd1)
      c3 = pcards.CValue(crd3)
      sp = Abs(c1 - c3) - 1
      If sp > 0 Then
         txt = "Spread: " & sp
         y += bitsh + 1
         x = CenterText(txt)
         fnt.DrawString x, y, txt
      End If
   EndIf
   'Show payout.
   If turn = tpayoff Then
      txt = "Payout is $" & payout 
      x = CenterText(txt)
      fnt.DrawString x, y, txt
   EndIf
   'Draw current cards.
   If crd1 <> cards.cardid.cNone Then
      pcards.DrawCardFront cx1, cy, crd1
   EndIf
   If crd2 <> cards.cardid.cNone Then
      pcards.DrawCardFront cx2, cy, crd2
   EndIf
   If crd3 <> cards.cardid.cNone Then
      pcards.DrawCardFront cx3, cy, crd3
   EndIf
   
   ScreenUnLock
End Sub

'Deals out cards.
Sub DealCards (crd As Integer = 0)
   Dim As Integer c1, c3, sp, done = FALSE

   ispair = FALSE
   If crd = 0 Then
      crd1 = cards.cardid.cNone
      crd2 = cards.cardid.cNone
      crd3 = cards.cardid.cNone
   EndIf
   If crd = 1 Then
      crd2 = GetNextCard()
   EndIf
   If crd = 2 Then
      'Sequential cards are a push.
      'Pairs go through.
      Do
         crd1 = GetNextCard()
         crd3 = GetNextCard()
         'Check the card values.
         c1 = pcards.CValue(crd1)
         c3 = pcards.CValue(crd3)
         If c1 = c3 Then
            maxpairs += 1
            ispair = TRUE
            done = TRUE
         Else
            'Check the spread.
            sp = Abs(c1 - c3) - 1
            If sp > 0 Then
               done = TRUE
            EndIf
         EndIf
      Loop Until done
   EndIf
End Sub

'Initialzes the game.
Sub InitGame ()
   InitDeck
   money = 1000
   score = 0
   payout = 0
   bet1 = 0
   bet2 = 0
   maxturns = 0 
   maxbet = 0 
   maxpayout = 0
   maxpairs = 0 
   maxpairwin = 0
End Sub

'Determines payout.
Sub CalcPayout ()
   Dim As Integer c1, c2, c3, sp
   
   'Get the card values.
   c1 = pcards.CValue(crd1)
   c2 = pcards.CValue(crd2)
   c3 = pcards.CValue(crd3)
   'Make c1 lower of two.
   If c1 > c3 Then
      Swap c1, c3
   EndIf
   'Check for three of a kind.
   If (c2 = c1) And (c2 = c3) Then
      payout = (11 * bet1)
      money += payout
      maxpairwin += 1
   Else      
      'Check to see if card2 in-between other cards.
      If (c2 > c1) And (c2 < c3) Then
         'Calculate the spread.
         sp = (c3 - c1) - 1
         If sp = 1 Then
            payout = (5 * bet2) + bet1
            money += payout 
         EndIf
         If sp = 2 Then
            payout = (4 * bet2) + bet1
            money += payout 
         EndIf
         If sp = 3 Then
            payout = (2 * bet2) + bet1
            money += payout 
         EndIf
         If (sp > 3) And (sp < 12) Then
            payout = bet2 + bet1
            money += payout 
         EndIf
      EndIf
   End If
   score += payout
   If payout > maxpayout Then
      maxpayout = payout
   EndIf
   If (bet1 + bet2) > maxbet Then
      maxbet = bet1 + bet2
   EndIf
End Sub

'Get the first bet.
Function DoFirstTurn() As Integer
   Dim As Integer ret = FALSE, done = FALSE, bet
   Dim As String ch
   
   Do
      ch = InKey
      If ch <> "" Then
         If ch = key_F1 Then
            If money >= 5 Then
               bet = bet1 + 5
               If bet <= 100 Then
                  bet1 += 5
                  money -= 5
                  DrawMainScreen tturn1
               End If
            EndIf
         EndIf
         If ch = key_F2 Then
            If money >= 10 Then
               bet = bet1 + 10
               If bet <= 100 Then
                  bet1 += 10
                  money -= 10
                  DrawMainScreen tturn1
               EndIf
            End If
         EndIf
         If ch = key_F5 Then
            If bet1 >= 5 Then
               bet1 -= 5
               money += 5
               DrawMainScreen tturn1
            EndIf
         EndIf
         If ch = key_F6 Then
            If bet1 >= 10 Then
               bet1 -= 10
               money += 10
               DrawMainScreen tturn1
            EndIf
         EndIf
         If ch = key_enter Then
            'Must have first bet.
            If bet1 > 0 Then
               DealCards 2
               DrawMainScreen tturn2
               done = TRUE
            End If
         EndIf
         If ch = key_close Then
            done = TRUE
            ret = TRUE
         EndIf
         If ch = key_esc Then
            done = TRUE
            ret = TRUE
         EndIf
      EndIf
      Sleep 1      
   Loop Until done = TRUE
   
   Return ret      
End Function

'Get the second bet and do payoff.
Function DoSecondTurn() As Integer
   Dim As Integer ret = FALSE, done = FALSE, bet
   Dim As String ch
   
   Do
      ch = InKey
      'Check for a pair.
      If ispair = TRUE Then
         'Show pair on screen.
         DrawMainScreen tpair
         Sleep
         Do: Loop Until InKey = ""
         'Deal third card, calc payoff.
         DealCards 1
         CalcPayout
         DrawMainScreen tpayoff
         Sleep
         Do: Loop Until InKey = ""
         bet1 = 0
         bet2 = 0   
         payout = 0
         DealCards
         DrawMainScreen tturn1
         done = TRUE
      Else
         'Get second bet and calc payoff.
         If ch = key_F1 Then
            If money >= 5 Then
               bet = bet2 + 5
               If bet <= 100 Then
                  bet2 += 5
                  money -= 5
                  DrawMainScreen tturn2
               End If
            EndIf
         EndIf
         If ch = key_F2 Then
            If money >= 10 Then
               bet = bet2 + 10
               If bet <= 100 Then
                  bet2 += 10
                  money -= 10
                  DrawMainScreen tturn2
               End If
            EndIf
         EndIf
         If ch = key_F5 Then
            If bet2 >= 5 Then
               bet2 -= 5
               money += 5
               DrawMainScreen tturn2
            EndIf
         EndIf
         If ch = key_F6 Then
            If bet2 >= 10 Then
               bet2 -= 10
               money += 10
               DrawMainScreen tturn2
            EndIf
         EndIf
         If ch = key_enter Then
            DealCards 1
            CalcPayout
            DrawMainScreen tpayoff
            Sleep
            Do: Loop Until InKey = ""
            bet1 = 0
            bet2 = 0   
            payout = 0
            DealCards
            DrawMainScreen tturn1
            done = TRUE
         EndIf
         If ch = key_close Then
            done = TRUE
            ret = TRUE
         EndIf
         If ch = key_esc Then
            done = TRUE
            ret = TRUE
         EndIf
      EndIf
      Sleep 1
   Loop Until done = TRUE
   
   Return ret      
End Function

'Main game loop.
Sub Dogame ()
   Dim As Integer done = FALSE
   
   DealCards
   DrawMainScreen tturn1
   Do
      done = DoFirstTurn()
      If done = FALSE Then
         done = DoSecondTurn()
         If money <= 0 Then
            done = TRUE
         EndIf
      End If
      maxturns += 1
      Sleep 1
   Loop Until done = TRUE 
End Sub

'Load all the graphic files.
ret = LoadGraphics ()

'Make sure the cards and graphics loaded.
If ret = TRUE Then
   'Load the menu items.
   mitems(mNewGame)      = "New Game" 
   mitems(mHighScores)   = "High Scores"
   mitems(mInstructions) = "Instructions" 
   mitems(mCredits)      = "Credits" 
   mitems(mExit)         = "Exit"
   Do
      'Display the main menu.
      mmid = ShowMenu ()
      'Show the high scores.
      If mmid = mHighScores Then
         ShowHighScores
      EndIf
      'Display the instructions.
      If mmid = mInstructions Then
         ShowInstructions
      EndIf
      'Display the credits.
      If mmid = mCredits Then
         ShowCredits
      EndIf
      'Game loop.
      If mmid = mNewgame Then
         InitGame
         Dogame
         ShowHighScores
      EndIf
   Loop Until mmid = mExit
End If
CleanUp



